(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 13.2' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[    358929,       8234]
NotebookOptionsPosition[    339483,       7911]
NotebookOutlinePosition[    339886,       7927]
CellTagsIndexPosition[    339843,       7924]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell["A block of code I put at the top of all of my notebooks", "Section",
 CellChangeTimes->{{3.889216740839618*^9, 3.8892167435353436`*^9}, {
  3.889465052799235*^9, 3.889465053607467*^9}, {3.889465160494475*^9, 
  3.889465169623303*^9}},ExpressionUUID->"ece40f48-955f-47ee-90f3-\
9470b66cfeb8"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"Notation`AutoLoadNotationPalette", "=", "False"}], ";"}], " ", 
  RowBox[{"(*", 
   RowBox[{
    RowBox[{"Kevin", " ", "suggested", " ", "I", " ", "add", " ", 
     RowBox[{"this", ".", " ", "It"}], " ", "prevents", " ", "the", " ", 
     "notation", " ", "palette", " ", "from", " ", "appearing"}], ",", " ", 
    RowBox[{"since", " ", "I", " ", 
     RowBox[{"don", "'"}], "t", " ", "usually", " ", "need", " ", 
     RowBox[{"that", "."}]}]}], "*)"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"SetDirectory", "[", 
    RowBox[{"NotebookDirectory", "[", "]"}], "]"}], ";"}], 
  "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{
   "makes", " ", "it", " ", "easy", " ", "to", " ", "import", " ", "files", 
    " ", "from", " ", "the", " ", "same", " ", "folder"}], "*)"}], 
  "\n"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Internal`AddHandler", "[", 
   RowBox[{"\"\<Message\>\"", ",", " ", 
    RowBox[{
     RowBox[{"If", "[", 
      RowBox[{
       RowBox[{"Last", "[", "#", "]"}], ",", " ", 
       RowBox[{"Abort", "[", "]"}]}], "]"}], " ", "&"}]}], "]"}], 
  "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{
    RowBox[{"Kevin", "'"}], "s", " ", "recently", " ", "suggested", " ", 
    "line", " ", "of", " ", "code", " ", "that", " ", "aborts", " ", "cells", 
    " ", "once", " ", "they", " ", "encounter", " ", "an", " ", "error"}], 
   "*)"}], "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"mu", "=", "\"\<\[Micro]\>\""}], 
  " "}], "\n", "\"\<\[Micro]\>\""}], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.815082599678366*^9, 3.815082599699355*^9}, {
  3.88773361665403*^9, 3.887733616888214*^9}, {3.889465179446721*^9, 
  3.889465274023178*^9}, {3.912628833788912*^9, 3.9126288943210807`*^9}},
 CellLabel->"In[1]:=",ExpressionUUID->"c2ab329e-e807-4f13-b606-835b629b7ac9"],

Cell[BoxData["\<\"\[Micro]\"\>"], "Output",
 CellChangeTimes->{3.924369332468221*^9, 3.9358469136747503`*^9, 
  3.936127798532404*^9},
 CellLabel->"Out[4]=",ExpressionUUID->"014d385c-cd3c-4741-8296-9ce67eed13fd"],

Cell[BoxData["\<\"\[Micro]\"\>"], "Output",
 CellChangeTimes->{3.924369332468221*^9, 3.9358469136747503`*^9, 
  3.936127798534397*^9},
 CellLabel->"Out[5]=",ExpressionUUID->"51127a0c-26e3-1c4d-ab80-03fcdeab9a18"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["\<\
A generally useful function that I think Mathematica should have built-in\
\>", "Section",
 CellChangeTimes->{{3.888407998949379*^9, 3.888407999986985*^9}, {
  3.889465842406252*^9, 3.88946584342177*^9}, {3.889465894741094*^9, 
  3.889465915613636*^9}},ExpressionUUID->"0a9bea59-79d3-4a6a-8cf8-\
3bb90b06c8b9"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{
   "This", " ", "sorts", " ", "a", " ", "mathematica", " ", "table", " ", 
    "by", " ", "one", " ", "of", " ", "its", " ", "columns"}], "*)"}], "\n", 
  RowBox[{
   RowBox[{"sortByCol", "[", 
    RowBox[{"table_", ",", "column_"}], "]"}], ":=", 
   RowBox[{"Sort", "[", 
    RowBox[{"table", ",", 
     RowBox[{
      RowBox[{
       RowBox[{"#1", "[", 
        RowBox[{"[", "column", "]"}], "]"}], "<", 
       RowBox[{"#2", "[", 
        RowBox[{"[", "column", "]"}], "]"}]}], "&"}]}], "]"}]}]}]], "Code",
 InitializationCell->True,
 CellChangeTimes->{{3.758165753416667*^9, 3.7581658311367188`*^9}, {
  3.758165870828273*^9, 3.75816588135988*^9}, {3.7581659348979864`*^9, 
  3.758166016277817*^9}, {3.758166270209676*^9, 3.758166270325641*^9}, {
  3.7583967429659305`*^9, 3.758396747292307*^9}, {3.888424563212118*^9, 
  3.8884246331455264`*^9}, {3.888424667588341*^9, 3.888424793117124*^9}, {
  3.8884867170581417`*^9, 3.88848677713634*^9}, {3.889465925476554*^9, 
  3.889465962350173*^9}},
 FontFamily->"Consolas",
 FontSize->13,
 FontWeight->"Bold",
 CellLabel->"In[6]:=",ExpressionUUID->"5fb56a93-f9e1-4b58-bb61-efe1c638abda"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{
   "This", " ", "sorts", " ", "a", " ", "mathematica", " ", "table", " ", 
    "by", " ", "one", " ", "of", " ", "its", " ", "columns", " ", 
    "alphabetically"}], "*)"}], "\n", 
  RowBox[{
   RowBox[{"sortByColABC", "[", 
    RowBox[{"table_", ",", "column_"}], "]"}], ":=", 
   RowBox[{"Sort", "[", 
    RowBox[{"table", ",", 
     RowBox[{
      RowBox[{"AlphabeticOrder", "[", 
       RowBox[{
        RowBox[{"#1", "[", 
         RowBox[{"[", "column", "]"}], "]"}], ",", 
        RowBox[{"#2", "[", 
         RowBox[{"[", "column", "]"}], "]"}]}], "]"}], "&"}]}], 
    "]"}]}]}]], "Code",
 InitializationCell->True,
 CellChangeTimes->{{3.758165753416667*^9, 3.7581658311367188`*^9}, {
  3.758165870828273*^9, 3.75816588135988*^9}, {3.7581659348979864`*^9, 
  3.758166016277817*^9}, {3.758166270209676*^9, 3.758166270325641*^9}, {
  3.7583967429659305`*^9, 3.758396747292307*^9}, {3.888424563212118*^9, 
  3.8884246331455264`*^9}, {3.888424667588341*^9, 3.888424793117124*^9}, {
  3.8884867170581417`*^9, 3.88848677713634*^9}, {3.889465925476554*^9, 
  3.889465962350173*^9}, {3.900441518207163*^9, 3.9004415785270414`*^9}},
 FontFamily->"Consolas",
 FontSize->13,
 FontWeight->"Bold",
 CellLabel->"In[7]:=",ExpressionUUID->"65f439cf-e12b-4f42-8769-59bb4ebb6cb1"]
}, Closed]],

Cell[CellGroupData[{

Cell["Protocols", "Section",
 CellChangeTimes->{{3.889216740839618*^9, 3.8892167435353436`*^9}, {
  3.889465052799235*^9, 3.889465053607467*^9}, {3.889465390157878*^9, 
  3.8894653912704735`*^9}},ExpressionUUID->"8a16aae6-f49f-4bf9-b248-\
1c1e6ac475af"],

Cell[CellGroupData[{

Cell["RoundToPipet", "Subsection",
 CellChangeTimes->{{3.889465508246925*^9, 3.8894655130458794`*^9}, {
  3.935689874000389*^9, 
  3.935689876187853*^9}},ExpressionUUID->"30ce7645-a04f-ed4d-97d3-\
2c424db8b4e5"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{
    RowBox[{"Lulu", "'"}], "s", " ", "RoundToPipet", " ", "used", " ", "in", 
    " ", 
    RowBox[{"BECS196a", ".", " ", "Assumes"}], " ", "there", " ", "is", " ", 
    "not", " ", "a", " ", "100", "uL", " ", "pipet", " ", "available"}], 
   "*)"}], "\n", 
  RowBox[{
   RowBox[{"RoundToPipetBECS196a", "[", "vol_", "]"}], ":=", 
   RowBox[{"Which", "[", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"vol", "\[LessEqual]", "2"}], ",", 
     RowBox[{
      RowBox[{"Round", "[", 
       RowBox[{
        RowBox[{"vol", "/", "2"}], ",", "0.001"}], "]"}], "*", "2"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"vol", "\[LessEqual]", "20"}], ",", 
     RowBox[{
      RowBox[{"Round", "[", 
       RowBox[{
        RowBox[{"vol", "/", "2"}], ",", "0.01"}], "]"}], "*", "2"}], ",", 
     "\n", 
     RowBox[{"vol", "\[LessEqual]", "200"}], ",", 
     RowBox[{
      RowBox[{"Round", "[", 
       RowBox[{
        RowBox[{"vol", "/", "2"}], ",", "0.1"}], "]"}], "*", "2"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"vol", "\[LessEqual]", "5000"}], ",", 
     RowBox[{"Round", "[", 
      RowBox[{"vol", ",", "1"}], "]"}]}], "]"}]}]}]], "Code",
 InitializationCell->True,
 CellChangeTimes->{{3.758165753416667*^9, 3.7581658311367188`*^9}, {
  3.758165870828273*^9, 3.75816588135988*^9}, {3.7581659348979864`*^9, 
  3.758166016277817*^9}, {3.758166270209676*^9, 3.758166270325641*^9}, {
  3.758396742965932*^9, 3.758396747292307*^9}, {3.935689726907572*^9, 
  3.93568973428249*^9}, {3.93568988108419*^9, 3.935689908976555*^9}, {
  3.9356899580710106`*^9, 3.935690002571783*^9}},
 FontFamily->"Consolas",
 FontSize->13,
 FontWeight->"Bold",
 CellLabel->"In[8]:=",ExpressionUUID->"68c09fbf-c325-4d43-9508-455cf09718ba"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{
   "Fixed", " ", "RoundToPipet", " ", "to", " ", "use", " ", "in", " ", 
    RowBox[{"lab", ".", " ", "Thanks"}], " ", "to", " ", "Tanvi", " ", 
    "Ganapathy", " ", "for", " ", "noticing", " ", 
    RowBox[{"this", "!"}]}], "*)"}], "\n", 
  RowBox[{
   RowBox[{"RoundToPipet", "[", "vol_", "]"}], ":=", 
   RowBox[{"Which", "[", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"vol", "\[LessEqual]", "2"}], ",", 
     RowBox[{
      RowBox[{"Round", "[", 
       RowBox[{
        RowBox[{"vol", "/", "2"}], ",", "0.001"}], "]"}], "*", "2"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"vol", "\[LessEqual]", "20"}], ",", 
     RowBox[{
      RowBox[{"Round", "[", 
       RowBox[{
        RowBox[{"vol", "/", "2"}], ",", "0.01"}], "]"}], "*", "2"}], ",", 
     "\n", 
     RowBox[{"vol", "\[LessEqual]", "100"}], ",", 
     RowBox[{"Round", "[", 
      RowBox[{"vol", ",", "0.1"}], "]"}], ",", "\[IndentingNewLine]", 
     RowBox[{"vol", "\[LessEqual]", "200"}], ",", 
     RowBox[{
      RowBox[{"Round", "[", 
       RowBox[{
        RowBox[{"vol", "/", "2"}], ",", "0.1"}], "]"}], "*", "2"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"vol", "\[LessEqual]", "5000"}], ",", 
     RowBox[{"Round", "[", 
      RowBox[{"vol", ",", "1"}], "]"}]}], "]"}]}]}]], "Code",
 InitializationCell->True,
 CellChangeTimes->{{3.758165753416667*^9, 3.7581658311367188`*^9}, {
  3.758165870828273*^9, 3.75816588135988*^9}, {3.7581659348979864`*^9, 
  3.758166016277817*^9}, {3.758166270209676*^9, 3.758166270325641*^9}, {
  3.758396742965932*^9, 3.758396747292307*^9}, {3.935689726907572*^9, 
  3.93568973428249*^9}, {3.935689916523844*^9, 3.935689967430242*^9}, {
  3.935690011390137*^9, 3.9356900419440536`*^9}},
 FontFamily->"Consolas",
 FontSize->13,
 FontWeight->"Bold",
 CellLabel->"In[9]:=",ExpressionUUID->"c5815f88-e0eb-1141-935c-1006228999df"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Tween-20 \[OpenCurlyDoubleQuote]fixers\[CloseCurlyDoubleQuote]", \
"Subsection",
 CellChangeTimes->{{3.889465508246925*^9, 
  3.8894655130458803`*^9}},ExpressionUUID->"a826c335-5bbe-4387-9ae1-\
f5f85437684c"],

Cell[CellGroupData[{

Cell["\<\
These \[OpenCurlyDoubleQuote]fixer\[CloseCurlyDoubleQuote] functions take \
dilution, annealing, and master mix protocols generated by Lulu\
\[CloseCurlyQuote]s functions and modify them slightly to account for the use \
of Tween-20.\
\>", "Item",
 CellChangeTimes->{{3.889465403789998*^9, 3.88946548342943*^9}, {
  3.889465519901231*^9, 3.889465532854659*^9}, {3.8894656185504665`*^9, 
  3.8894656201902742`*^9}},ExpressionUUID->"573f50af-f317-4d43-98db-\
4b2c5f310e12"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{
   "This", " ", "one", " ", "is", " ", "designed", " ", "for", " ", 
    "dilution", " ", "and", " ", "annealing", " ", "only"}], "*)"}], "\n", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"Options", "[", "tw20fixer", "]"}], "=", 
     RowBox[{"{", 
      RowBox[{"tween20row", "\[Rule]", "0"}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"tw20fixer", "[", 
     RowBox[{"step_", ",", 
      RowBox[{"OptionsPattern", "[", "]"}]}], "]"}], ":=", 
    "\[IndentingNewLine]", 
    RowBox[{"Module", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"tempList", ",", "fixList"}], "}"}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"tempList", "=", 
        RowBox[{"step", "[", 
         RowBox[{"[", "1", "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"tempList", "[", 
         RowBox[{"[", 
          RowBox[{"1", ",", "2"}], "]"}], "]"}], "=", "\"\<Conc.\>\""}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{"fixList", "=", 
        RowBox[{"tempList", "[", 
         RowBox[{"[", 
          RowBox[{
           RowBox[{
            RowBox[{
             RowBox[{
              RowBox[{"Last", "[", 
               RowBox[{"Position", "[", 
                RowBox[{
                 RowBox[{"tempList", "[", 
                  RowBox[{"[", 
                   RowBox[{
                    RowBox[{";;", 
                    RowBox[{"-", "2"}]}], ",", "2"}], "]"}], "]"}], ",", 
                 "\"\<\>\""}], "]"}], "]"}], "[", 
              RowBox[{"[", "1", "]"}], "]"}], "+", "1"}], ";;", 
            RowBox[{"-", "2"}]}], ",", "2"}], "]"}], "]"}]}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"tempList", "[", 
         RowBox[{"[", 
          RowBox[{
           RowBox[{
            RowBox[{
             RowBox[{
              RowBox[{"Last", "[", 
               RowBox[{"Position", "[", 
                RowBox[{
                 RowBox[{"tempList", "[", 
                  RowBox[{"[", 
                   RowBox[{
                    RowBox[{";;", 
                    RowBox[{"-", "2"}]}], ",", "2"}], "]"}], "]"}], ",", 
                 "\"\<\>\""}], "]"}], "]"}], "[", 
              RowBox[{"[", "1", "]"}], "]"}], "+", "1"}], ";;", 
            RowBox[{"-", "2"}]}], ",", "2"}], "]"}], "]"}], "=", 
        RowBox[{"Table", "[", 
         RowBox[{
          RowBox[{"If", "[", 
           RowBox[{
            RowBox[{"i", "==", 
             RowBox[{"OptionValue", "[", "tween20row", "]"}]}], ",", 
            RowBox[{
             RowBox[{"ToString", "[", 
              RowBox[{"fixList", "[", 
               RowBox[{"[", "i", "]"}], "]"}], "]"}], "<>", "\"\<x\>\""}], 
            ",", 
            RowBox[{
             RowBox[{"ToString", "[", 
              RowBox[{"NumberForm", "[", 
               RowBox[{
                RowBox[{"fixList", "[", 
                 RowBox[{"[", "i", "]"}], "]"}], ",", "4"}], "]"}], "]"}], 
             "<>", "\"\< \[Micro]M\>\""}]}], "]"}], ",", 
          "\[IndentingNewLine]", 
          RowBox[{"{", 
           RowBox[{"i", ",", 
            RowBox[{"Length", "[", "fixList", "]"}]}], "}"}]}], "]"}]}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{"Join", "[", 
        RowBox[{
         RowBox[{"TextGrid", "[", "tempList", "]"}], ",", 
         RowBox[{"step", "[", 
          RowBox[{"[", 
           RowBox[{"2", ";;"}], "]"}], "]"}]}], "]"}]}]}], "\n", 
     "]"}]}]}]}]], "Code",
 InitializationCell->True,
 CellChangeTimes->{{3.758137825646428*^9, 3.7581378538420796`*^9}, {
   3.758137912183409*^9, 3.758137953844639*^9}, {3.7581381089088225`*^9, 
   3.758138124711552*^9}, {3.758138155795578*^9, 3.758138342863103*^9}, {
   3.758144460628516*^9, 3.758144462276403*^9}, {3.758144681452623*^9, 
   3.758144778998341*^9}, {3.758144830890038*^9, 3.7581449411754856`*^9}, {
   3.758144986706295*^9, 3.758145012640795*^9}, {3.758145067519507*^9, 
   3.758145070462113*^9}, {3.7581451080599785`*^9, 3.758145402418579*^9}, {
   3.758145456662733*^9, 3.758145466796671*^9}, {3.758145554796203*^9, 
   3.758145768510884*^9}, {3.758145835493224*^9, 3.758145938230661*^9}, {
   3.758146058715652*^9, 3.758146077504889*^9}, {3.758146110645656*^9, 
   3.758146230322136*^9}, {3.758146262095904*^9, 3.758146287590119*^9}, {
   3.7581463438336024`*^9, 3.7581463504804916`*^9}, {3.758158553494012*^9, 
   3.758158598572602*^9}, {3.758158638187195*^9, 3.758158732198707*^9}, {
   3.758160529581983*^9, 3.75816053661633*^9}, {3.7581609384396105`*^9, 
   3.75816095121295*^9}, {3.758161005148469*^9, 3.758161052381777*^9}, {
   3.758161097272941*^9, 3.758161097651809*^9}, {3.7581611967237673`*^9, 
   3.758161202046685*^9}, {3.7581614820096245`*^9, 3.758161511937072*^9}, {
   3.7581618907265615`*^9, 3.758161891481211*^9}, {3.758162265245167*^9, 
   3.758162429189843*^9}, {3.758162561800975*^9, 3.758162664922377*^9}, {
   3.758162698231366*^9, 3.758162703352637*^9}, {3.758162736706277*^9, 
   3.758162897071453*^9}, {3.75816304939701*^9, 3.758163051168043*^9}, {
   3.758220156482116*^9, 3.758220196378119*^9}, 3.758221657329023*^9, {
   3.758229557642907*^9, 3.758229575112616*^9}, {3.758229748455784*^9, 
   3.7582297673809576`*^9}, {3.7582298257022552`*^9, 3.758229826467941*^9}, {
   3.758229861519169*^9, 3.7582299545842905`*^9}, {3.758229985954976*^9, 
   3.7582300226547*^9}, 3.828203652251727*^9, {3.850516839853183*^9, 
   3.850516840468108*^9}, {3.887659374646811*^9, 3.8876593971027174`*^9}, {
   3.887660408606713*^9, 3.887660419049813*^9}, {3.887660469652848*^9, 
   3.8876605771677685`*^9}, {3.887824923626604*^9, 3.887824928211342*^9}, {
   3.887825119111846*^9, 3.887825147082996*^9}, {3.887826190212339*^9, 
   3.887826192897633*^9}, {3.889465623459816*^9, 3.889465633935583*^9}},
 FontFamily->"Consolas",
 FontSize->13,
 FontWeight->"Bold",
 CellLabel->"In[10]:=",ExpressionUUID->"0ee6b9a6-74c7-4f5f-845c-d52e6215fb79"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"volume", "=", "100"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"dilute", "=", 
   RowBox[{"{", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"\"\<1:100 tw20:1x1x\>\"", ",", "100", ",", "1"}], "}"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"{", 
      RowBox[{"\"\<ds_NS_ATTO532 + tw20\>\"", ",", "5", ",", ".075"}], 
      "}"}]}], "\[IndentingNewLine]", "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"step3", "[", "1", "]"}], "=", 
  RowBox[{"tw20fixer", "[", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Dilute", "[", 
     RowBox[{"dilute", ",", "volume", ",", 
      RowBox[{"Detailed", "\[Rule]", "False"}], ",", 
      RowBox[{"StrandForm", "\[Rule]", "\"\<ds\>\""}]}], "]"}], ",", 
    "\[IndentingNewLine]", 
    RowBox[{"tween20row", "->", "1"}]}], "]"}]}]}], "Input",
 CellChangeTimes->{{3.7581383519210577`*^9, 3.758138365087669*^9}, {
   3.758138421972631*^9, 3.758138458494304*^9}, {3.758144640291236*^9, 
   3.758144677267056*^9}, {3.7581450878637714`*^9, 3.758145088182493*^9}, {
   3.7581621361243477`*^9, 3.758162136330942*^9}, {3.758162916048702*^9, 
   3.758162939801607*^9}, {3.758163001403411*^9, 3.758163002051878*^9}, {
   3.7581631106199546`*^9, 3.7581631235705347`*^9}, {3.75816335157658*^9, 
   3.758163366798649*^9}, {3.7581638434089336`*^9, 3.758163885249323*^9}, {
   3.772921731046179*^9, 3.772921762082611*^9}, {3.7729219525442715`*^9, 
   3.772921953776592*^9}, {3.7729220195100183`*^9, 3.772922055178544*^9}, {
   3.772922110173753*^9, 3.772922173527481*^9}, 3.7729246150511694`*^9, 
   3.772924706091136*^9, {3.779574309427428*^9, 3.779574316290487*^9}, 
   3.7795746230545535`*^9, {3.7795750087874207`*^9, 3.779575035935748*^9}, {
   3.7795766095632963`*^9, 3.779576610758606*^9}, {3.7795767129747148`*^9, 
   3.779576715106503*^9}, {3.7819877717338743`*^9, 3.781987866018653*^9}, {
   3.781990953478853*^9, 3.781991003886821*^9}, 3.78199566330191*^9, {
   3.7819985782427597`*^9, 3.781998603569629*^9}, {3.781998927317541*^9, 
   3.781999005603068*^9}, {3.781999041220385*^9, 3.781999110768229*^9}, {
   3.78560827227256*^9, 3.7856083129767604`*^9}, {3.785608410891939*^9, 
   3.785608445961857*^9}, {3.7856090372104053`*^9, 3.785609048213865*^9}, {
   3.785610345605743*^9, 3.78561035455167*^9}, {3.785610400847374*^9, 
   3.7856104009653053`*^9}, 3.785610487432907*^9, {3.785610570821191*^9, 
   3.785610578960161*^9}, {3.785610928638017*^9, 3.78561095715207*^9}, {
   3.785611171912294*^9, 3.7856111799485717`*^9}, {3.785623433103546*^9, 
   3.785623476107887*^9}, {3.7856235200320177`*^9, 3.7856235430219936`*^9}, {
   3.785623668474419*^9, 3.785623840693098*^9}, {3.785624221559183*^9, 
   3.785624280099887*^9}, {3.785624443124299*^9, 3.7856244497812786`*^9}, {
   3.7856246812164974`*^9, 3.785624705733576*^9}, {3.7857165451783752`*^9, 
   3.7857165782723303`*^9}, {3.785716791419263*^9, 3.785716848691844*^9}, {
   3.7884841289634256`*^9, 3.788484157935116*^9}, {3.788484203538827*^9, 
   3.788484251147502*^9}, {3.788484290271343*^9, 3.788484310779481*^9}, {
   3.789839033078313*^9, 3.789839066350301*^9}, {3.789839218973988*^9, 
   3.789839222465055*^9}, {3.789839550604729*^9, 3.789839559076761*^9}, {
   3.789840180219336*^9, 3.789840185570382*^9}, 3.789840249499923*^9, {
   3.7898409087610044`*^9, 3.78984095631785*^9}, {3.7898410276722116`*^9, 
   3.789841077286061*^9}, {3.789841119493724*^9, 3.7898411227414675`*^9}, {
   3.789842175439259*^9, 3.7898421759179854`*^9}, {3.7904572330020647`*^9, 
   3.790457233506774*^9}, {3.790457322951396*^9, 3.790457323531063*^9}, {
   3.790457555112909*^9, 3.790457555299801*^9}, {3.790457718863064*^9, 
   3.7904577265096345`*^9}, {3.790457758550213*^9, 3.7904577933422194`*^9}, 
   3.7924495059555273`*^9, {3.8105916357845044`*^9, 3.81059166149145*^9}, {
   3.81116315627317*^9, 3.811163157949651*^9}, {3.812925589687284*^9, 
   3.8129256246618385`*^9}, {3.8129258238506103`*^9, 3.812925830728222*^9}, {
   3.8130889781614447`*^9, 3.813088994005149*^9}, {3.813089038138145*^9, 
   3.813089039798421*^9}, {3.813092446413688*^9, 3.813092448892329*^9}, {
   3.8141939685613832`*^9, 3.814194015049949*^9}, {3.814194062184141*^9, 
   3.814194093289145*^9}, {3.814195311071409*^9, 3.8141953280721617`*^9}, {
   3.814196844829958*^9, 3.8141970752798877`*^9}, {3.814298665533497*^9, 
   3.814298725144079*^9}, {3.814802932821034*^9, 3.814803010498905*^9}, {
   3.814803124060303*^9, 3.814803124508325*^9}, {3.81489999127813*^9, 
   3.814899996905958*^9}, 3.815404928047578*^9, {3.815407438842252*^9, 
   3.8154074566667137`*^9}, {3.8154111775911427`*^9, 3.815411181486781*^9}, {
   3.815411211743915*^9, 3.815411229429171*^9}, {3.815411403503518*^9, 
   3.8154114064238186`*^9}, {3.815411474569274*^9, 3.81541152829084*^9}, {
   3.8154116029927077`*^9, 3.8154116061924257`*^9}, {3.8154116489685235`*^9, 
   3.815411651559085*^9}, {3.81541174027281*^9, 3.815411749296831*^9}, {
   3.8154117940971336`*^9, 3.815411796424507*^9}, {3.815411864257127*^9, 
   3.815411910714528*^9}, {3.815412018313276*^9, 3.815412019168705*^9}, {
   3.815412634330262*^9, 3.8154126583213835`*^9}, {3.8154127275301175`*^9, 
   3.815412744098688*^9}, {3.8394197909514165`*^9, 3.839419861950676*^9}, {
   3.839427057273093*^9, 3.8394270576636934`*^9}, {3.839598520512124*^9, 
   3.839598566228878*^9}, 3.839598745054049*^9, {3.839598791589449*^9, 
   3.839598820501132*^9}, 3.8395995310212603`*^9, 3.8396024503117843`*^9, {
   3.840382435503076*^9, 3.8403824419685645`*^9}, 3.8403826056406507`*^9, {
   3.840820660273511*^9, 3.8408206814844756`*^9}, {3.8408216614791355`*^9, 
   3.8408217094697065`*^9}, {3.840821756138236*^9, 3.840821762647195*^9}, 
   3.840821796696235*^9, {3.8416012014732533`*^9, 3.8416012376622095`*^9}, 
   3.8416770020472145`*^9, 3.841684012966519*^9, {3.842618856891288*^9, 
   3.842618878969818*^9}, {3.8426189974187536`*^9, 3.842619053795145*^9}, 
   3.842619115217287*^9, 3.8428887145808206`*^9, 3.8428891429235435`*^9, 
   3.8437482569410205`*^9, 3.843748386963147*^9, {3.844353275518691*^9, 
   3.844353295002845*^9}, {3.846285264244522*^9, 3.846285264940296*^9}, {
   3.8462853632458973`*^9, 3.846285421414618*^9}, 3.846285586658688*^9, 
   3.846286030461997*^9, {3.84633223719346*^9, 3.8463322761925836`*^9}, 
   3.846332398959625*^9, {3.846863982363276*^9, 3.8468640435745087`*^9}, {
   3.8607586964265037`*^9, 3.860758697138793*^9}, {3.860763636036413*^9, 
   3.860763640387326*^9}, {3.861733837656307*^9, 3.8617338402713184`*^9}, 
   3.861733888789778*^9, {3.873995476287822*^9, 3.873995550432909*^9}, {
   3.873997221232993*^9, 3.873997221352814*^9}, {3.873997261951968*^9, 
   3.873997295027814*^9}, 3.873997349596678*^9, 3.873997536363335*^9, 
   3.8741531843405943`*^9, {3.874154630960103*^9, 3.874154652063835*^9}, {
   3.874154711243784*^9, 3.87415471173296*^9}, 3.874154774452851*^9, {
   3.874154830727339*^9, 3.874154830852636*^9}, 3.8741548788097706`*^9, 
   3.8741549934375677`*^9, 3.874263489069142*^9, {3.874693916490527*^9, 
   3.874693952740455*^9}, {3.874694023113165*^9, 3.8746940262397633`*^9}, {
   3.8746943989387994`*^9, 3.874694444343599*^9}, {3.874694484624583*^9, 
   3.8746945283145947`*^9}, {3.874694561832472*^9, 3.874694562146199*^9}, {
   3.874778333655243*^9, 3.8747783624067497`*^9}, {3.875268638405132*^9, 
   3.875268644615415*^9}, 3.875269977720329*^9, {3.875270029210743*^9, 
   3.875270032211097*^9}, {3.8752741540103145`*^9, 3.875274174946559*^9}, 
   3.875274411336403*^9, 3.8752745319954443`*^9, {3.8752745847278566`*^9, 
   3.875274605195095*^9}, {3.876589837253355*^9, 3.87658985303408*^9}, 
   3.876671772106908*^9, 3.8791078047683306`*^9, {3.887658782499086*^9, 
   3.887658873956455*^9}, {3.887658922661704*^9, 3.8876589248698044`*^9}, {
   3.887660703837455*^9, 3.8876607090745726`*^9}, {3.887824347286295*^9, 
   3.8878243714635897`*^9}, 3.887824501032691*^9, 3.8878251787287025`*^9},
 CellLabel->"In[67]:=",ExpressionUUID->"4d1b2512-31cd-4ced-8d2b-b381db598d32"],

Cell[BoxData[
 TagBox[GridBox[{
    {Cell["Name",ExpressionUUID->"8fe6079d-fa53-4ff8-a909-1375514c32b0"], 
     Cell["Conc.",ExpressionUUID->"6824f5dc-db1e-4b56-ade8-83a7ef3e792b"], 
     Cell["Vol. (uL)",ExpressionUUID->"89541631-0940-44b9-8d70-207330f10338"]},
    {Cell["1xTE/Mg2+",ExpressionUUID->"70e1e951-b9b5-4e8d-b98e-f876412fe57a"],
      Cell["",ExpressionUUID->"ab76d0b8-94c8-466f-8a3f-9ded42cf3de9"], 
     "97.60000000000001`"},
    {Cell[
     "1:100 tw20:1x1x",ExpressionUUID->
      "15930de1-c263-49c5-b53b-9b6a0058e476"], Cell[
     "100.x",ExpressionUUID->"15face4b-b96c-4ad7-8103-cab612da61c3"], "1.`"},
    {Cell[
     "ds_NS_ATTO532 + tw20",ExpressionUUID->
      "c59cada0-f6ef-4fdb-8423-ab81930e6c09"], Cell[
     "5. \[Micro]M",ExpressionUUID->"f9ff081e-317d-4c22-b936-7eed18d43786"], 
     "1.5`"},
    {Cell["",
      FontWeight->Bold,ExpressionUUID->
      "c49b9458-db34-4550-879a-1c212f2ecae1"], Cell[BoxData["0.075`"],
      FontWeight->Bold,ExpressionUUID->
      "a97d9d4d-a939-4cc4-b3aa-d0d63032a7d9"], Cell[BoxData["100"],
      FontWeight->Bold,ExpressionUUID->"054f8a35-36c6-4027-9cd7-a05bbe9a7bff"]}
   },
   AutoDelete->False,
   BaseStyle->12,
   GridBoxAlignment->{"Columns" -> {Left, Right, Right, Right, Right}},
   GridBoxBackground->{
    "Columns" -> {{None}}, "RowsIndexed" -> {-1 -> GrayLevel[0.85]}},
   GridBoxFrame->{"Columns" -> {{True}}, "Rows" -> {{True}}},
   GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
  "TextGrid"]], "Output",
 CellChangeTimes->{
  3.888080495444537*^9, 3.8881698036349435`*^9, 3.888170199177788*^9, 
   3.888763365250818*^9, {3.888763990681098*^9, 3.888764011852089*^9}, 
   3.8887642946288*^9, 3.8887650853916764`*^9, 3.888765174286624*^9, 
   3.888765791724346*^9, 3.888765887199598*^9, 3.888766301816243*^9, 
   3.888940552324258*^9, 3.889118182437888*^9, 3.889119217002586*^9, 
   3.889119268843503*^9, 3.889119398338088*^9, 3.8892035545977497`*^9, 
   3.8892052239585676`*^9, {3.889205376406181*^9, 3.889205403040983*^9}, 
   3.88920555040716*^9, 3.889284322890277*^9, 3.8892902595062494`*^9},
 CellLabel->"Out[69]=",ExpressionUUID->"f28a7272-d765-4c12-a897-86882d2d463c"]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{
   "This", " ", "one", " ", "is", " ", "designed", " ", "for", " ", "master", 
    " ", "mixes", " ", "only"}], "*)"}], "\n", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"Options", "[", "tw20fixerMM", "]"}], "=", 
     RowBox[{"{", 
      RowBox[{"tween20row", "\[Rule]", "0"}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"tw20fixerMM", "[", 
     RowBox[{"step_", ",", 
      RowBox[{"OptionsPattern", "[", "]"}]}], "]"}], ":=", 
    "\[IndentingNewLine]", 
    RowBox[{"Module", "[", 
     RowBox[{
      RowBox[{"{", "tempMasterMix", "}"}], ",", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"tempMasterMix", "=", "step"}], ";", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"tempMasterMix", "[", 
         RowBox[{"[", 
          RowBox[{"1", ",", "1", ",", "1"}], "]"}], "]"}], "=", 
        RowBox[{"tw20fixer", "[", 
         RowBox[{
          RowBox[{"step", "[", 
           RowBox[{"[", 
            RowBox[{"1", ",", "1", ",", "1"}], "]"}], "]"}], ",", 
          RowBox[{"tween20row", "->", 
           RowBox[{"OptionValue", "[", "tween20row", "]"}]}]}], "]"}]}], ";", 
       "\[IndentingNewLine]", "tempMasterMix"}]}], "\n", "]"}]}]}]}]], "Code",
 InitializationCell->True,
 CellChangeTimes->{{3.758137825646428*^9, 3.7581378538420796`*^9}, {
   3.758137912183409*^9, 3.758137953844639*^9}, {3.7581381089088225`*^9, 
   3.758138124711552*^9}, {3.758138155795578*^9, 3.758138342863103*^9}, {
   3.758144460628516*^9, 3.758144462276403*^9}, {3.758144681452623*^9, 
   3.758144778998341*^9}, {3.758144830890038*^9, 3.7581449411754856`*^9}, {
   3.758144986706295*^9, 3.758145012640795*^9}, {3.758145067519507*^9, 
   3.758145070462113*^9}, {3.7581451080599785`*^9, 3.758145402418579*^9}, {
   3.758145456662733*^9, 3.758145466796671*^9}, {3.758145554796203*^9, 
   3.758145768510884*^9}, {3.758145835493224*^9, 3.758145938230661*^9}, {
   3.758146058715652*^9, 3.758146077504889*^9}, {3.758146110645656*^9, 
   3.758146230322136*^9}, {3.758146262095904*^9, 3.758146287590119*^9}, {
   3.7581463438336024`*^9, 3.7581463504804916`*^9}, {3.758158553494012*^9, 
   3.758158598572602*^9}, {3.758158638187195*^9, 3.758158732198707*^9}, {
   3.758160529581983*^9, 3.75816053661633*^9}, {3.7581609384396105`*^9, 
   3.75816095121295*^9}, {3.758161005148469*^9, 3.758161052381777*^9}, {
   3.758161097272941*^9, 3.758161097651809*^9}, {3.7581611967237673`*^9, 
   3.758161202046685*^9}, {3.7581614820096245`*^9, 3.758161511937072*^9}, {
   3.7581618907265615`*^9, 3.758161891481211*^9}, {3.758162265245167*^9, 
   3.758162429189843*^9}, {3.758162561800975*^9, 3.758162664922377*^9}, {
   3.758162698231366*^9, 3.758162703352637*^9}, {3.758162736706277*^9, 
   3.758162897071453*^9}, {3.75816304939701*^9, 3.758163051168043*^9}, {
   3.758220156482116*^9, 3.758220196378119*^9}, 3.758221657329023*^9, {
   3.758229557642907*^9, 3.758229575112616*^9}, {3.758229748455784*^9, 
   3.7582297673809576`*^9}, {3.7582298257022552`*^9, 3.758229826467941*^9}, {
   3.758229861519169*^9, 3.7582299545842905`*^9}, {3.758229985954976*^9, 
   3.7582300226547*^9}, 3.828203652251727*^9, {3.850516839853183*^9, 
   3.850516840468108*^9}, {3.887659374646811*^9, 3.8876593971027174`*^9}, {
   3.887660408606713*^9, 3.887660419049813*^9}, {3.887660469652848*^9, 
   3.8876605771677685`*^9}, {3.887824923626604*^9, 3.887824928211342*^9}, {
   3.887825119111846*^9, 3.887825147082996*^9}, {3.887826190212339*^9, 
   3.887826192897633*^9}, {3.887826447671789*^9, 3.887826462871*^9}, {
   3.887826502949524*^9, 3.887826575525565*^9}, {3.889465637988271*^9, 
   3.8894656435661*^9}},
 FontFamily->"Consolas",
 FontSize->13,
 FontWeight->"Bold",
 CellLabel->"In[12]:=",ExpressionUUID->"8bd5fc50-dcd4-40ec-a340-0fda945aa2b9"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"sample", "=", 
   RowBox[{"{", 
    RowBox[{"\"\<0\>\"", ",", "\"\<.5x\>\"", ",", "\"\<1x\>\""}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"species", "=", 
   RowBox[{"{", "\[IndentingNewLine]", 
    RowBox[{"(*", " ", 
     RowBox[{"name", ",", " ", 
      RowBox[{"stock", " ", "concentration"}], ",", " ", 
      RowBox[{"target", " ", "concentration"}], ",", " ", 
      RowBox[{"double", " ", "or", " ", "single", " ", "stranded", " ", 
       RowBox[{"(", 
        RowBox[{"ds", " ", 
         RowBox[{"vs", ".", " ", "ss"}]}], ")"}]}]}], " ", "*)"}], 
    "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"\"\<1:100 Tween 20\>\"", ",", "100", ",", 
       RowBox[{"1", "*", "1000"}], ",", "\"\<ss\>\""}], "}"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"{", 
      RowBox[{"\"\<revRep6\>\"", ",", "3", ",", "150", ",", "\"\<ds\>\""}], 
      "}"}], ",", "\[IndentingNewLine]", 
     RowBox[{"{", 
      RowBox[{"\"\<#203 revRep6 trigger\>\"", ",", ".045", ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", 
         RowBox[{".5", "*", "oneX"}], ",", "oneX"}], "}"}], ",", 
       "\"\<ss\>\""}], "}"}]}], "\[IndentingNewLine]", "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"volume", "=", "30"}], ";"}], "  ", 
  RowBox[{"(*", 
   RowBox[{"reaction", " ", "volume", " ", "is", " ", "30", " ", "uL"}], 
   "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{"step4caliRev6", "=", 
  RowBox[{"tw20fixerMM", "[", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"MasterMix", "[", 
     RowBox[{"sample", ",", "species", ",", "volume", ",", 
      RowBox[{"ExcessRatio", "\[Rule]", "1.1"}], ",", 
      RowBox[{"Use20T", "\[Rule]", "False"}], ",", " ", 
      RowBox[{"fontsize", "->", "protocolfontsize"}]}], "]"}], ",", 
    "\[IndentingNewLine]", 
    RowBox[{"tween20row", "->", "1"}]}], "]"}]}]}], "Input",
 CellChangeTimes->{{3.7581383519210577`*^9, 3.758138365087669*^9}, {
   3.758138421972631*^9, 3.758138458494304*^9}, {3.758144640291236*^9, 
   3.758144677267056*^9}, {3.7581450878637714`*^9, 3.758145088182493*^9}, {
   3.7581621361243477`*^9, 3.758162136330942*^9}, {3.758162916048702*^9, 
   3.758162939801607*^9}, {3.758163001403411*^9, 3.758163002051878*^9}, {
   3.7581631106199546`*^9, 3.7581631235705347`*^9}, {3.75816335157658*^9, 
   3.758163366798649*^9}, {3.7581638434089336`*^9, 3.758163885249323*^9}, {
   3.7581649692790194`*^9, 3.758165147856312*^9}, {3.7581663467911787`*^9, 
   3.7581663469228077`*^9}, {3.758218879766942*^9, 3.7582189355186386`*^9}, {
   3.7582190027645955`*^9, 3.75821901827048*^9}, {3.75911032600027*^9, 
   3.759110353048799*^9}, {3.772922244019763*^9, 3.7729222530402184`*^9}, 
   3.772922449768782*^9, {3.772922793095768*^9, 3.772922817926565*^9}, 
   3.7729230998612833`*^9, {3.772923133877429*^9, 3.772923135317606*^9}, {
   3.772923189830805*^9, 3.772923189891769*^9}, {3.772927277545689*^9, 
   3.772927277980815*^9}, 3.772990669229526*^9, {3.775499287810588*^9, 
   3.7754993000115414`*^9}, 3.779574396018151*^9, 3.779574512209363*^9, {
   3.779574603786654*^9, 3.779574611666114*^9}, {3.779574768664647*^9, 
   3.779574768912504*^9}, {3.7795748074401655`*^9, 3.779574887225892*^9}, {
   3.779574958752686*^9, 3.779574959975981*^9}, 3.779574992335864*^9, {
   3.77957511490328*^9, 3.779575173063092*^9}, {3.7795757462773*^9, 
   3.7795758198534517`*^9}, {3.7795758503718824`*^9, 3.779575862966646*^9}, {
   3.779576082221242*^9, 3.7795760849156737`*^9}, {3.7795766296037393`*^9, 
   3.7795766398908134`*^9}, {3.779576698108281*^9, 3.7795767068352475`*^9}, {
   3.781988666567103*^9, 3.781988727194015*^9}, {3.781988764250435*^9, 
   3.7819887739285865`*^9}, {3.78198883061414*^9, 3.7819888373237147`*^9}, {
   3.7819888827690206`*^9, 3.781988890699135*^9}, {3.781988922417639*^9, 
   3.781989046182341*^9}, {3.781989100679748*^9, 3.781989152964702*^9}, {
   3.78198924494236*^9, 3.781989245070287*^9}, 3.78198940826907*^9, {
   3.781989531767216*^9, 3.781989535340111*^9}, {3.78198962079816*^9, 
   3.781989663574781*^9}, {3.781989695250273*^9, 3.781989722022221*^9}, {
   3.7819897609344397`*^9, 3.7819897693520193`*^9}, {3.781989838008834*^9, 
   3.781989868924368*^9}, {3.781990275915388*^9, 3.781990353316495*^9}, {
   3.781991043247638*^9, 3.781991044980098*^9}, {3.7819910891745615`*^9, 
   3.781991090048109*^9}, {3.78199165168982*^9, 3.781991675614729*^9}, {
   3.781991801701049*^9, 3.7819918022764277`*^9}, {3.7819939461352882`*^9, 
   3.781993951677256*^9}, {3.781994410238758*^9, 3.78199445265825*^9}, {
   3.7819944855707755`*^9, 3.7819945407884207`*^9}, {3.7819946987851577`*^9, 
   3.78199471151998*^9}, {3.781994752099273*^9, 3.7819948476516895`*^9}, {
   3.781994921268811*^9, 3.781994925162245*^9}, {3.78199548378056*^9, 
   3.781995507273361*^9}, {3.781995721974357*^9, 3.781995741050391*^9}, {
   3.78199592865594*^9, 3.7819959791934013`*^9}, {3.7819960305138826`*^9, 
   3.781996040568529*^9}, {3.781996081785563*^9, 3.781996140973349*^9}, {
   3.781996224224291*^9, 3.781996276146389*^9}, {3.781996344015809*^9, 
   3.781996413921465*^9}, {3.781996615795501*^9, 3.781996708883931*^9}, {
   3.781996820000957*^9, 3.7819968490397654`*^9}, {3.781997138823625*^9, 
   3.781997206139955*^9}, {3.78199735260435*^9, 3.7819974225544534`*^9}, {
   3.781997453888664*^9, 3.781997460575272*^9}, {3.781997586371273*^9, 
   3.78199759312602*^9}, {3.7819980091114597`*^9, 3.781998017409698*^9}, {
   3.781998365104763*^9, 3.781998404064622*^9}, {3.7819984510487857`*^9, 
   3.781998457759616*^9}, {3.781998675846987*^9, 3.781998731723897*^9}, {
   3.7856011396108704`*^9, 3.785601140596284*^9}, {3.785601371546773*^9, 
   3.785601380285087*^9}, {3.78560240990234*^9, 3.7856024413753977`*^9}, {
   3.78560250224867*^9, 3.785602554378089*^9}, {3.7856026251864104`*^9, 
   3.78560263875226*^9}, {3.785602674113824*^9, 3.785602707666252*^9}, {
   3.7856071883651695`*^9, 3.785607203446666*^9}, {3.785607317035762*^9, 
   3.785607427887139*^9}, {3.785607528210874*^9, 3.7856075434360557`*^9}, {
   3.785607914851416*^9, 3.78560795638114*^9}, {3.785607988085196*^9, 
   3.785608227551489*^9}, {3.785608476418649*^9, 3.7856085040868*^9}, {
   3.785608703781984*^9, 3.785608736658616*^9}, {3.785609073986234*^9, 
   3.7856090768724384`*^9}, {3.7856092954947023`*^9, 3.785609339213186*^9}, {
   3.785609637712125*^9, 3.785609654420883*^9}, {3.7856097233583965`*^9, 
   3.785609723753022*^9}, {3.7856107944264016`*^9, 3.7856108040383883`*^9}, {
   3.785611188580622*^9, 3.785611196200537*^9}, {3.785611231016341*^9, 
   3.785611235133857*^9}, 3.785624394894497*^9, {3.7884840335092077`*^9, 
   3.78848403367676*^9}, {3.789839430361121*^9, 3.789839481362758*^9}, {
   3.789839594781576*^9, 3.7898396590338545`*^9}, {3.7898399622821655`*^9, 
   3.789840012715892*^9}, {3.789840058950874*^9, 3.78984008411738*^9}, {
   3.7898401240816393`*^9, 3.789840142239506*^9}, {3.789840411709587*^9, 
   3.78984045208176*^9}, {3.789840571043967*^9, 3.789840592257767*^9}, {
   3.7898423700383997`*^9, 3.789842395556787*^9}, {3.7898471711674857`*^9, 
   3.789847201674443*^9}, {3.789847321303094*^9, 3.789847337555459*^9}, {
   3.7898565235843678`*^9, 3.789856545566325*^9}, 3.7904494421534786`*^9, {
   3.790457196537035*^9, 3.790457196674918*^9}, {3.790457501119943*^9, 
   3.790457501389763*^9}, {3.790457565811745*^9, 3.790457566143535*^9}, {
   3.7904576788730445`*^9, 3.790457710566834*^9}, {3.79244885747376*^9, 
   3.792448857603711*^9}, {3.792448888048272*^9, 3.7924488887928824`*^9}, {
   3.7924490251444573`*^9, 3.7924490363348875`*^9}, {3.792449093134455*^9, 
   3.792449118608268*^9}, {3.792449177391697*^9, 3.792449198621427*^9}, 
   3.792449252969366*^9, {3.792449389968002*^9, 3.792449390134924*^9}, {
   3.792449473082608*^9, 3.792449486357449*^9}, {3.792520810537199*^9, 
   3.79252082236186*^9}, {3.7925208647265167`*^9, 3.7925208878151298`*^9}, {
   3.792520942103492*^9, 3.792520944082374*^9}, {3.7925209874828978`*^9, 
   3.792520992367843*^9}, {3.792521032403004*^9, 3.792521093443662*^9}, {
   3.7925211249788*^9, 3.79252112912323*^9}, {3.792521159149299*^9, 
   3.79252116237366*^9}, {3.7925211969425716`*^9, 3.792521230630985*^9}, {
   3.810590017372964*^9, 3.810590026927491*^9}, {3.8105900696039186`*^9, 
   3.8105900711341105`*^9}, {3.81065641036312*^9, 3.810656410832864*^9}, {
   3.81065661116322*^9, 3.810656614761552*^9}, {3.810656695273186*^9, 
   3.810656702080977*^9}, {3.810656773040165*^9, 3.810656779328345*^9}, {
   3.8111630501776485`*^9, 3.811163050530706*^9}, {3.811185429698805*^9, 
   3.811185438024068*^9}, {3.811185493657934*^9, 3.811185511769337*^9}, {
   3.8111855682294*^9, 3.811185570255949*^9}, {3.811186743677898*^9, 
   3.811186770254913*^9}, {3.8111878389972415`*^9, 3.811187958178733*^9}, {
   3.811189146980557*^9, 3.811189159629702*^9}, {3.811189289813187*^9, 
   3.811189291653286*^9}, {3.812924076699025*^9, 3.8129241014408307`*^9}, {
   3.8129258483311586`*^9, 3.8129258594873347`*^9}, {3.812925928732197*^9, 
   3.8129259785049577`*^9}, {3.814193909633214*^9, 3.814193918442858*^9}, {
   3.814194318736905*^9, 3.8141943290822663`*^9}, {3.814195234080331*^9, 
   3.814195241507408*^9}, {3.814197594252032*^9, 3.81419765063684*^9}, {
   3.8148031471199007`*^9, 3.814803174069934*^9}, {3.8154049746410437`*^9, 
   3.815405018563816*^9}, {3.815405050090311*^9, 3.81540521578261*^9}, {
   3.815406366574954*^9, 3.815406461851605*^9}, {3.8154069720066547`*^9, 
   3.815407022763578*^9}, {3.8154072989018555`*^9, 3.815407346200657*^9}, 
   3.81541255328237*^9, {3.815412606507254*^9, 3.815412616014717*^9}, {
   3.815412674293559*^9, 3.815412675446389*^9}, {3.815412844893166*^9, 
   3.815412857783533*^9}, {3.815412914811202*^9, 3.8154129667237196`*^9}, {
   3.82491200646782*^9, 3.824912057290182*^9}, {3.83941918914711*^9, 
   3.839419193549427*^9}, {3.839419223574766*^9, 3.8394192311191792`*^9}, {
   3.839419296358264*^9, 3.839419296979891*^9}, {3.8394194858784676`*^9, 
   3.839419492510898*^9}, {3.839419641192494*^9, 3.839419649206146*^9}, {
   3.83941969079906*^9, 3.8394197103983154`*^9}, {3.839419749718774*^9, 
   3.839419752014676*^9}, {3.839423144481277*^9, 3.8394231964491796`*^9}, {
   3.839423317265374*^9, 3.8394234249841604`*^9}, {3.8394268918316383`*^9, 
   3.839426892191022*^9}, {3.839426979672826*^9, 3.839426982904006*^9}, 
   3.839427017979289*^9, 3.839427138304633*^9, {3.8394272046201*^9, 
   3.839427209783992*^9}, {3.8395970169024973`*^9, 3.8395970540166454`*^9}, 
   3.8395970925684676`*^9, {3.839597129474143*^9, 3.8395972060331135`*^9}, {
   3.839597633878543*^9, 3.839597636079647*^9}, {3.839597960318727*^9, 
   3.839597983520855*^9}, {3.839598152618863*^9, 3.839598197603304*^9}, {
   3.839598441708917*^9, 3.839598473830043*^9}, 3.8395985737657337`*^9, {
   3.8395986201087523`*^9, 3.83959862757307*^9}, {3.839598829046555*^9, 
   3.839598829117125*^9}, {3.8395992732504067`*^9, 3.839599327724462*^9}, {
   3.839599420651768*^9, 3.839599461539318*^9}, {3.839599852187683*^9, 
   3.83959994066738*^9}, {3.839600004819265*^9, 3.8396001507866526`*^9}, 
   3.839600268803598*^9, {3.8396003806047173`*^9, 3.839600393771018*^9}, {
   3.839864902893069*^9, 3.839864909049992*^9}, {3.839865268428925*^9, 
   3.8398652859342394`*^9}, {3.840376230304745*^9, 3.8403762321492243`*^9}, 
   3.840376320130122*^9, {3.840380715854023*^9, 3.8403807494289317`*^9}, {
   3.840380875227605*^9, 3.840380879861991*^9}, {3.840381349113929*^9, 
   3.840381383349818*^9}, {3.840381606695598*^9, 3.840381655521961*^9}, {
   3.8403820448457346`*^9, 3.840382045509379*^9}, {3.8403820911350594`*^9, 
   3.840382140830117*^9}, {3.840804782618749*^9, 3.8408048038896427`*^9}, {
   3.8408056383918686`*^9, 3.8408056409496937`*^9}, 3.840805695112214*^9, {
   3.841590690870983*^9, 3.8415906990475883`*^9}, {3.841590921839835*^9, 
   3.841591006560044*^9}, {3.841591118935315*^9, 3.8415911192858105`*^9}, 
   3.841595405232405*^9, {3.84159575371653*^9, 3.841595755884509*^9}, {
   3.841600823948225*^9, 3.841600942420199*^9}, {3.841601111911231*^9, 
   3.841601118911217*^9}, {3.841601170694704*^9, 3.841601174567506*^9}, {
   3.8416018695714455`*^9, 3.841601915546186*^9}, {3.842620386676222*^9, 
   3.8426203941498876`*^9}, {3.842620604612168*^9, 3.842620607828558*^9}, 
   3.842621607785749*^9, {3.8432502238395357`*^9, 3.843250234966539*^9}, {
   3.8432502734201107`*^9, 3.843250281837111*^9}, {3.843747566924639*^9, 
   3.8437475673325233`*^9}, {3.843914632625514*^9, 3.843914672253647*^9}, {
   3.8446125378185935`*^9, 3.844612571554162*^9}, 3.844615956515939*^9, {
   3.859661719651887*^9, 3.8596617274193034`*^9}, 3.859901208479786*^9, {
   3.873995205846573*^9, 3.873995211687973*^9}, {3.873995256592619*^9, 
   3.873995260584319*^9}, {3.87399647801697*^9, 3.873996484903615*^9}, {
   3.8739965237446575`*^9, 3.873996542790166*^9}, {3.873996582201118*^9, 
   3.873996634216862*^9}, {3.8739966736059484`*^9, 3.87399670451987*^9}, {
   3.873996825778102*^9, 3.8739968632934217`*^9}, {3.8739971421468096`*^9, 
   3.873997157023103*^9}, {3.874153062194755*^9, 3.8741530803976126`*^9}, {
   3.875276739862181*^9, 3.8752767650131*^9}, {3.876590091654834*^9, 
   3.876590100003627*^9}, {3.887825042063333*^9, 3.887825060413967*^9}, 
   3.887825191299095*^9, {3.887826602817134*^9, 3.887826615696887*^9}},
 CellLabel->"In[82]:=",ExpressionUUID->"0f95397c-34ee-423d-86ea-addc57f072f1"],

Cell[BoxData[
 TagBox[GridBox[{
    {
     TagBox[GridBox[{
        {Cell["Name",ExpressionUUID->"9d05ed11-e9f5-4fa6-9425-e68f17b463e4"], 
         Cell["Conc.",ExpressionUUID->"3a35f828-9302-4d79-b52d-342e7f809825"],
          Cell["Vol. (uL)",ExpressionUUID->
          "72b0b149-a29a-42be-861a-989124b4ead9"]},
        {Cell[
         "1\[Times]TE",ExpressionUUID->
          "2edca201-3b9d-4e2a-93e2-20fb37ea6772"], Cell[
         "",ExpressionUUID->"2ed42f60-f51d-4e8f-a682-208eff7caa07"], "77.`"},
        {Cell[
         "1\[Times]TE/10\[Times]Mg2+",ExpressionUUID->
          "9457054f-596b-4623-af48-e29553aeb369"], Cell[
         "",ExpressionUUID->"771bda89-a9ec-4dde-8a1b-a3ff90285756"], "9.4`"},
        {Cell[
         "1:100 Tween 20",ExpressionUUID->
          "2a2a3e5b-e5f0-4bfb-830e-79e77bfb91bf"], Cell[
         "100.x",ExpressionUUID->"2e771823-8713-406e-a92a-b72ef72729da"], 
         "0.99`"},
        {Cell[
         "revRep6",ExpressionUUID->"501907c9-2827-41c9-836b-11f86b8f1c2c"], 
         Cell["3. \[Micro]M",ExpressionUUID->
          "9f17d9a0-bbfa-495f-b7a9-972f0f37f4e3"], "4.96`"},
        {Cell["Master mix",
          FontWeight->Bold,ExpressionUUID->
          "6eed9754-e7e4-495f-a255-d9238146542b"], Cell[
         "",ExpressionUUID->"77a96980-4c2a-4291-a308-9b41f572ea67"], "92.35`"}
       },
       AutoDelete->False,
       BaseStyle->12,
       GridBoxAlignment->{"Columns" -> {Left, Right, Right, Right}},
       GridBoxBackground->{
        "Columns" -> {{None}}, "RowsIndexed" -> {-1 -> GrayLevel[0.85]}},
       GridBoxFrame->{"Columns" -> {{True}}, "Rows" -> {{True}}},
       GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
      "TextGrid"]},
    {
     TagBox[GridBox[{
        {Cell["Name",ExpressionUUID->"d0bfae0d-9f65-4b71-ae1d-be3ecac84f05"], 
         Cell["Conc. (uM)",ExpressionUUID->
          "52249ef0-903a-4afc-915c-e2c97fc482ad"], Cell[
         "Vol. (uL)",ExpressionUUID->"f69c5cd9-1816-42a7-8e72-3f9d445c13a4"], 
         Cell["Vol. (uL)",ExpressionUUID->
          "6945bfd1-3459-4541-b2e0-0c370832e632"], Cell[
         "Vol. (uL)",ExpressionUUID->"d290bbd7-132b-418f-8411-adfabbe387db"]},
        {Cell[
         "Master mix",ExpressionUUID->"068e83bc-df7f-438a-89a3-41b4c5903d7f"],
          Cell["",ExpressionUUID->"644f9f64-16fa-4d92-9454-53d179f89889"], 
         "28.`", "28.`", "28.`"},
        {Cell[
         "1\[Times]TE",ExpressionUUID->
          "0b0f1190-eed4-471d-82f0-4275a75099e8"], Cell[
         "",ExpressionUUID->"77bc3781-f05e-4def-9704-3db246ff50e9"], "2.`", 
         "1.`", "0.`"},
        {Cell[
         "#203 revRep6 trigger",ExpressionUUID->
          "3c707384-bfde-49fa-b9e4-60b66f7757d0"], "0.045`", "0.`", "1.`", 
         "2.`"},
        {Cell["",ExpressionUUID->"3a537e7b-1cfc-4d2f-9028-d2b25717980d"], 
         Cell["",ExpressionUUID->"c9efd5aa-4107-4c83-8156-b5fdc2d6cc70"], 
         Cell["0",
          FontWeight->Bold,ExpressionUUID->
          "c59093ba-7d0e-42e8-9692-1989bf833362"], Cell[".5x",
          FontWeight->Bold,ExpressionUUID->
          "a815d067-1ef0-4b6c-8e34-2219d319676d"], Cell["1x",
          FontWeight->Bold,ExpressionUUID->
          "c6709560-79e6-4c6e-a48e-0cff9051cfaf"]}
       },
       AutoDelete->False,
       BaseStyle->12,
       GridBoxAlignment->{"Columns" -> {Left, Right, Right, Right, Right}},
       GridBoxBackground->{
        "Columns" -> {{None}}, "RowsIndexed" -> {-1 -> GrayLevel[0.85]}},
       GridBoxFrame->{"Columns" -> {{True}}, "Rows" -> {{True}}},
       GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
      "TextGrid"]}
   },
   AutoDelete->False,
   GridBoxAlignment->{"Columns" -> {{Left}}},
   GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
  "Grid"]], "Output",
 CellChangeTimes->{{3.84160189190765*^9, 3.841601916008347*^9}, 
   3.841678681283416*^9, 3.8416840408291807`*^9, 3.8425609906907*^9, 
   3.8426235481332884`*^9, 3.842628100963009*^9, 3.842628596606021*^9, 
   3.842628693693583*^9, 3.84296599610159*^9, 3.84325056177198*^9, 
   3.8432508818681774`*^9, 3.8437467063531017`*^9, 3.8437475723184857`*^9, 
   3.84374780394324*^9, 3.8437479288128834`*^9, 3.84374842940285*^9, 
   3.8438306714350805`*^9, 3.843853502199108*^9, 3.843855486540454*^9, 
   3.843855622517455*^9, 3.8439194597090397`*^9, 3.843927161782015*^9, 
   3.844615138806984*^9, 3.84461589951477*^9, 3.844616019932134*^9, 
   3.844616585293852*^9, 3.844971521499838*^9, 3.844971745930001*^9, 
   3.844972121098365*^9, 3.8451346446923037`*^9, 3.8451350554325256`*^9, 
   3.8451352306212673`*^9, 3.845137554374115*^9, 3.8452168496140146`*^9, 
   3.846277363413174*^9, 3.846283258480547*^9, 3.846284433025113*^9, 
   3.846285567031109*^9, 3.8462856924864798`*^9, 3.846286229425259*^9, 
   3.846287531641568*^9, 3.8463324099272823`*^9, 3.846784513273247*^9, 
   3.8468632622027693`*^9, 3.846863923242368*^9, 3.8468640618608627`*^9, 
   3.8599010855650387`*^9, 3.85990113708414*^9, 3.8599012092856307`*^9, 
   3.8599167182190857`*^9, 3.860082722832737*^9, 3.860082986851139*^9, 
   3.860758754706516*^9, 3.860760067064068*^9, 3.8607636634054947`*^9, 
   3.870375986321884*^9, 3.870376063081212*^9, {3.873996585555322*^9, 
   3.873996594139891*^9}, 3.873996642455905*^9, {3.873996840694783*^9, 
   3.8739968643502183`*^9}, {3.873997142887582*^9, 3.873997157506892*^9}, 
   3.873997746111067*^9, 3.87399778689877*^9, 3.8739979186096554`*^9, 
   3.874083182461852*^9, 3.8741542125446234`*^9, 3.874155108569055*^9, 
   3.874155193122925*^9, 3.87415551671303*^9, 3.874155672568412*^9, 
   3.874168902168753*^9, 3.874263543922653*^9, 3.874267349860223*^9, 
   3.874267429891801*^9, 3.8742677052746463`*^9, 3.8742687519451027`*^9, 
   3.8746940629073753`*^9, 3.874773268331106*^9, 3.874773804539771*^9, 
   3.874773908913514*^9, 3.874773956561524*^9, 3.8747782498749294`*^9, 
   3.874778392599651*^9, 3.874867962706622*^9, 3.875272904635025*^9, 
   3.875274674050976*^9, 3.875275713053868*^9, 3.875276051008934*^9, {
   3.875276751893173*^9, 3.875276771760944*^9}, 3.87527698639592*^9, 
   3.875454933498366*^9, 3.875455034656952*^9, 3.875455956820658*^9, 
   3.875457348261771*^9, 3.875457504872012*^9, 3.8754577375972357`*^9, 
   3.875458969590915*^9, 3.875462636265529*^9, 3.87546286185688*^9, {
   3.875462933049761*^9, 3.8754629608419933`*^9}, 3.875557891151963*^9, 
   3.876581373495892*^9, 3.876582101348032*^9, 3.8765833732054863`*^9, 
   3.876589868988931*^9, 3.87659012515543*^9, 3.876671808347561*^9, 
   3.876687474920142*^9, 3.876750582312319*^9, 3.8767705712140584`*^9, 
   3.8791063885346713`*^9, 3.879107566271962*^9, 3.8791078352952323`*^9, 
   3.8791078933851748`*^9, 3.879108001969125*^9, 3.879108085408321*^9, 
   3.879109241390757*^9, 3.8791938832125115`*^9, 3.879256870604365*^9, 
   3.879362620788902*^9, 3.8803927653346796`*^9, 3.8814185720617476`*^9, 
   3.881436142959347*^9, 3.88211474842424*^9, 3.882128984264477*^9, 
   3.88212905465643*^9, 3.882992241316588*^9, 3.883247924212945*^9, 
   3.884031014300666*^9, 3.884543898124715*^9, 3.886706064768993*^9, {
   3.8867100624406085`*^9, 3.8867100913719406`*^9}, 3.886710132510781*^9, 
   3.8868860516948724`*^9, 3.8869644011020336`*^9, 3.887310179640547*^9, 
   3.8873111472437396`*^9, 3.8874054954212523`*^9, 3.8874765505685115`*^9, 
   3.8878242738950076`*^9, 3.887825061470278*^9, 3.887826207837945*^9, 
   3.887826603426258*^9, 3.887826748596946*^9, 3.8878269047562194`*^9, 
   3.888080495554521*^9, 3.888169803974826*^9, 3.888170199479005*^9, 
   3.888763365677678*^9, {3.888763991091998*^9, 3.888764012283209*^9}, 
   3.8887642950047936`*^9, 3.8887650858370132`*^9, 3.888765174587295*^9, 
   3.888765792048479*^9, 3.888765887671007*^9, 3.8887663021319256`*^9, 
   3.888940552408229*^9, 3.889118182631197*^9, 3.889119217206985*^9, 
   3.88911926905456*^9, 3.8891193986781783`*^9, 3.889203555047853*^9, 
   3.8892052240625353`*^9, {3.889205376679031*^9, 3.889205403289324*^9}, 
   3.889205550638729*^9, 3.889284323218329*^9, 3.8892902595687575`*^9},
 CellLabel->"Out[85]=",ExpressionUUID->"535272c1-effd-4c18-b250-a575bb92190a"]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["Plotting", "Section",
 CellChangeTimes->{{3.889216740839618*^9, 3.8892167435353436`*^9}, {
  3.889465052799235*^9, 
  3.889465053607467*^9}},ExpressionUUID->"c439379f-067a-49f8-bbc1-\
fce1c87a5254"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{"Colors", " ", "in", " ", "Mathematica", " ", 
    RowBox[{"aren", "'"}], "t", " ", "always", " ", "easy", " ", "to", " ", 
    "quickly", " ", "export", " ", "for", " ", "use", " ", "in", " ", "other",
     " ", 
    RowBox[{"software", ".", " ", "This"}], " ", "function", " ", "makes", 
    " ", "it", " ", "easier", " ", "to", " ", 
    RowBox[{"copy", "/", "paste"}], " ", "them", " ", "into", " ", "Inkscape",
     " ", "or", " ", 
    RowBox[{"Office", "."}]}], "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"colorToHexString", "[", "color_", "]"}], ":=", 
   "\[IndentingNewLine]", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", "colorList", "}"}], ",", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"colorList", "=", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"color", "[", 
           RowBox[{"[", "1", "]"}], "]"}], ",", 
          RowBox[{"color", "[", 
           RowBox[{"[", "2", "]"}], "]"}], ",", 
          RowBox[{"color", "[", 
           RowBox[{"[", "3", "]"}], "]"}]}], "}"}], "*", "255"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"\"\<#\>\"", "<>", 
       RowBox[{"StringJoin", "[", 
        RowBox[{"Table", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"IntegerString", "[", 
            RowBox[{
             RowBox[{"Round", "[", "i", "]"}], ",", "16", ",", "2"}], "]"}], "//",
            "ToUpperCase"}], "\[IndentingNewLine]", ",", 
          RowBox[{"{", 
           RowBox[{"i", ",", "colorList"}], "}"}]}], "]"}], "]"}]}]}]}], 
    "\[IndentingNewLine]", "]"}]}]}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.815082599678366*^9, 3.815082599699355*^9}, {
  3.88773361665403*^9, 3.887733616888214*^9}, {3.8892167181281166`*^9, 
  3.889216727591629*^9}, {3.889216759223498*^9, 3.889216791673253*^9}, {
  3.8892168439605026`*^9, 3.889216852271913*^9}, {3.889216884885835*^9, 
  3.889216970367776*^9}, {3.889217679175754*^9, 3.889217783958377*^9}, {
  3.889384014344054*^9, 3.889384014416273*^9}, {3.889465284774717*^9, 
  3.889465340191871*^9}},
 CellLabel->"In[14]:=",ExpressionUUID->"04e67471-2be8-4690-a4ee-c9ea38a1761b"],

Cell[CellGroupData[{

Cell["\<\
Convert the first 16 colors generated in fluoroPlot to hex strings for use in \
other software:\
\>", "Item",
 CellChangeTimes->{{3.88946508669496*^9, 
  3.889465118600224*^9}},ExpressionUUID->"e2ed1d67-5dd2-4ce2-a994-\
20df87efa9bf"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"colorList", "=", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"ColorData", "[", 
      RowBox[{"97", ",", "\"\<ColorList\>\""}], "]"}], "[", 
     RowBox[{"[", 
      RowBox[{
       RowBox[{"Mod", "[", 
        RowBox[{
         RowBox[{"i", "-", "1"}], ",", "15"}], "]"}], "+", "1"}], "]"}], 
     "]"}], "\[IndentingNewLine]", ",", 
    RowBox[{"{", 
     RowBox[{"i", ",", "16"}], "}"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.889383639825579*^9, 3.889383641744309*^9}},
 CellLabel->
  "In[266]:=",ExpressionUUID->"b5152b60-3f1a-4b1e-be49-62313cde631a"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TemplateBox[<|"color" -> RGBColor[0.368417, 0.506779, 0.709798]|>,
    "RGBColorSwatchTemplate"], ",", 
   TemplateBox[<|"color" -> RGBColor[0.880722, 0.611041, 0.142051]|>,
    "RGBColorSwatchTemplate"], ",", 
   TemplateBox[<|"color" -> RGBColor[0.560181, 0.691569, 0.194885]|>,
    "RGBColorSwatchTemplate"], ",", 
   TemplateBox[<|"color" -> RGBColor[0.922526, 0.385626, 0.209179]|>,
    "RGBColorSwatchTemplate"], ",", 
   TemplateBox[<|"color" -> RGBColor[0.528488, 0.470624, 0.701351]|>,
    "RGBColorSwatchTemplate"], ",", 
   TemplateBox[<|"color" -> RGBColor[0.772079, 0.431554, 0.102387]|>,
    "RGBColorSwatchTemplate"], ",", 
   TemplateBox[<|"color" -> RGBColor[0.363898, 0.618501, 0.782349]|>,
    "RGBColorSwatchTemplate"], ",", 
   TemplateBox[<|"color" -> RGBColor[1, 0.75, 0]|>,
    "RGBColorSwatchTemplate"], ",", 
   TemplateBox[<|"color" -> RGBColor[0.647624, 0.37816, 0.614037]|>,
    "RGBColorSwatchTemplate"], ",", 
   TemplateBox[<|"color" -> RGBColor[0.571589, 0.586483, 0.]|>,
    "RGBColorSwatchTemplate"], ",", 
   TemplateBox[<|"color" -> RGBColor[0.915, 0.3325, 0.2125]|>,
    "RGBColorSwatchTemplate"], ",", 
   TemplateBox[<|
    "color" -> RGBColor[0.40082222609352647`, 0.5220066643438841, 0.85]|>,
    "RGBColorSwatchTemplate"], ",", 
   TemplateBox[<|
    "color" -> RGBColor[
      0.9728288904374106, 0.621644452187053, 0.07336199581899142]|>,
    "RGBColorSwatchTemplate"], ",", 
   TemplateBox[<|
    "color" -> RGBColor[0.736782672705901, 0.358, 0.5030266573755369]|>,
    "RGBColorSwatchTemplate"], ",", 
   TemplateBox[<|
    "color" -> RGBColor[0.28026441037696703`, 0.715, 0.4292089322474965]|>,
    "RGBColorSwatchTemplate"], ",", 
   TemplateBox[<|"color" -> RGBColor[0.368417, 0.506779, 0.709798]|>,
    "RGBColorSwatchTemplate"]}], "}"}]], "Output",
 CellChangeTimes->{3.8892172141108985`*^9, 3.8893836099833*^9, 
  3.889383642874528*^9},
 CellLabel->
  "Out[266]=",ExpressionUUID->"880e0c45-e247-4be1-ac7b-b328edefe8d2"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Map", "[", 
  RowBox[{"colorToHexString", ",", "colorList"}], "]"}]], "Input",
 CellChangeTimes->{{3.889383621914959*^9, 3.88938364746439*^9}},
 CellLabel->
  "In[277]:=",ExpressionUUID->"0dd06e87-670c-4ab7-8ed0-1d055b2f8105"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"#5E81B5\"\>", ",", "\<\"#E19C24\"\>", ",", "\<\"#8FB032\"\>", 
   ",", "\<\"#EB6235\"\>", ",", "\<\"#8778B3\"\>", ",", "\<\"#C56E1A\"\>", 
   ",", "\<\"#5D9EC7\"\>", ",", "\<\"#FFBF00\"\>", ",", "\<\"#A5609D\"\>", 
   ",", "\<\"#929600\"\>", ",", "\<\"#E95536\"\>", ",", "\<\"#6685D9\"\>", 
   ",", "\<\"#F89F13\"\>", ",", "\<\"#BC5B80\"\>", ",", "\<\"#47B66D\"\>", 
   ",", "\<\"#5E81B5\"\>"}], "}"}]], "Output",
 CellChangeTimes->{3.889383647732428*^9, 3.889384017846502*^9},
 CellLabel->
  "Out[277]=",ExpressionUUID->"ca5ac353-8a8b-48a8-875c-ab44ab432b8a"]
}, Open  ]]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["Plate Functions", "Section",
 CellChangeTimes->{{3.888407998949379*^9, 3.888407999986985*^9}, {
  3.889465842406252*^9, 3.88946584342177*^9}, {3.88946599991776*^9, 
  3.889466000373375*^9}},ExpressionUUID->"cf545185-d947-4099-b228-\
6b815151aadd"],

Cell["\<\
Some functions may take in well names like \[OpenCurlyDoubleQuote]A2\
\[CloseCurlyDoubleQuote] and some may take in names like \
\[OpenCurlyDoubleQuote]A02\[CloseCurlyDoubleQuote]. These two functions allow \
easy switching back and forth between the naming conventions:\
\>", "Text",
 CellChangeTimes->{{3.888424975209552*^9, 3.8884250000651336`*^9}, {
  3.8894661518453484`*^9, 
  3.889466156413907*^9}},ExpressionUUID->"93894566-9390-4167-b5f8-\
1d0a35a76a65"],

Cell[BoxData[
 RowBox[{
  RowBox[{"wellsAddZeros", "[", "wellsList_", "]"}], ":=", 
  RowBox[{"Table", "[", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"If", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"StringLength", "[", 
        RowBox[{"wellsList", "[", 
         RowBox[{"[", "i", "]"}], "]"}], "]"}], "==", "3"}], ",", 
      RowBox[{"wellsList", "[", 
       RowBox[{"[", "i", "]"}], "]"}], ",", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"StringTake", "[", 
        RowBox[{
         RowBox[{"wellsList", "[", 
          RowBox[{"[", "i", "]"}], "]"}], ",", 
         RowBox[{"{", "1", "}"}]}], "]"}], "<>", "\"\<0\>\"", "<>", 
       RowBox[{"StringTake", "[", 
        RowBox[{
         RowBox[{"wellsList", "[", 
          RowBox[{"[", "i", "]"}], "]"}], ",", 
         RowBox[{"{", "2", "}"}]}], "]"}]}]}], "]"}], "\[IndentingNewLine]", 
    ",", 
    RowBox[{"{", 
     RowBox[{"i", ",", 
      RowBox[{"Length", "[", "wellsList", "]"}]}], "}"}]}], "]"}]}]], "Code",
 InitializationCell->True,
 CellChangeTimes->{{3.758165753416667*^9, 3.7581658311367188`*^9}, {
   3.758165870828273*^9, 3.75816588135988*^9}, {3.7581659348979864`*^9, 
   3.758166016277817*^9}, {3.758166270209676*^9, 3.758166270325641*^9}, {
   3.7583967429659305`*^9, 3.758396747292307*^9}, {3.888424563212118*^9, 
   3.8884246331455264`*^9}, 3.888424667588341*^9, {3.888424925398015*^9, 
   3.888424930997512*^9}},
 FontFamily->"Consolas",
 FontSize->13,
 FontWeight->"Bold",
 CellLabel->"In[15]:=",ExpressionUUID->"4460f267-6800-4e2f-beec-4edd56c77d92"],

Cell[BoxData[
 RowBox[{
  RowBox[{"wellsRemoveZeros", "[", "wellsList_", "]"}], ":=", 
  RowBox[{"Table", "[", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"If", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"StringTake", "[", 
        RowBox[{
         RowBox[{"wellsList", "[", 
          RowBox[{"[", "i", "]"}], "]"}], ",", 
         RowBox[{"{", "2", "}"}]}], "]"}], "!=", "\"\<0\>\""}], ",", 
      RowBox[{"wellsList", "[", 
       RowBox[{"[", "i", "]"}], "]"}], ",", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"StringTake", "[", 
        RowBox[{
         RowBox[{"wellsList", "[", 
          RowBox[{"[", "i", "]"}], "]"}], ",", 
         RowBox[{"{", "1", "}"}]}], "]"}], "<>", 
       RowBox[{"StringTake", "[", 
        RowBox[{
         RowBox[{"wellsList", "[", 
          RowBox[{"[", "i", "]"}], "]"}], ",", 
         RowBox[{"{", "3", "}"}]}], "]"}]}]}], "]"}], "\[IndentingNewLine]", 
    ",", 
    RowBox[{"{", 
     RowBox[{"i", ",", 
      RowBox[{"Length", "[", "wellsList", "]"}]}], "}"}]}], "]"}]}]], "Code",
 InitializationCell->True,
 CellChangeTimes->{{3.758165753416667*^9, 3.7581658311367188`*^9}, {
  3.758165870828273*^9, 3.75816588135988*^9}, {3.7581659348979864`*^9, 
  3.758166016277817*^9}, {3.758166270209676*^9, 3.758166270325641*^9}, {
  3.7583967429659305`*^9, 3.758396747292307*^9}, {3.888424563212118*^9, 
  3.8884246331455264`*^9}, {3.888424667588341*^9, 3.888424793117124*^9}},
 FontFamily->"Consolas",
 FontSize->13,
 FontWeight->"Bold",
 CellLabel->"In[16]:=",ExpressionUUID->"8ec7e1f2-789c-4af8-8143-164887f04488"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{
    RowBox[{
    "Maybe", " ", "Kevin", " ", "made", " ", "the", " ", "original", " ", 
     "version", " ", "of", " ", "this", " ", 
     RowBox[{
      RowBox[{"function", "?", " ", "I"}], "'"}], "m", " ", "not", " ", 
     "sure"}], ",", " ", 
    RowBox[{
     RowBox[{"but", " ", "I", " ", "got", " ", "PlotPlate", " ", "from", " ", 
      RowBox[{"him", ".", " ", "\n", 
       RowBox[{"It", "'"}]}], "s", " ", "a", " ", "function", " ", "for", " ",
       "plotting", " ", "96"}], "-", 
     RowBox[{"well", " ", 
      RowBox[{"plates", ".", "\n", "I"}], " ", 
      RowBox[{"don", "'"}], "t", " ", "remember", " ", "what", " ", "issue", 
      " ", "the", " ", "original", " ", "version", " ", "caused", " ", 
      "me"}]}], ",", " ", 
    RowBox[{
    "but", " ", "I", " ", "made", " ", "this", " ", "\"\<fixed\>\"", " ", 
     RowBox[{"version", "."}]}]}], "*)"}], "\n", "\n", 
  RowBox[{
   RowBox[{
    RowBox[{"PlotPlateSRD", "[", 
     RowBox[{"sampleWells_", ",", "PlateName_", ",", 
      RowBox[{"emptyWells_", ":", 
       RowBox[{"{", "}"}]}], ",", 
      RowBox[{"color_", ":", 
       RowBox[{"{", 
        RowBox[{"Lighter", "[", 
         RowBox[{"Gray", ",", "0.4"}], "]"}], "}"}]}]}], "]"}], ":=", 
    RowBox[{"Module", "[", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"sample", ",", " ", 
        RowBox[{"width", "=", "127.8"}], ",", " ", 
        RowBox[{"length", "=", "85.5"}], ",", " ", 
        RowBox[{"xA1", "=", "14.4"}], ",", " ", 
        RowBox[{"yA1", "=", "11.2"}], ",", " ", 
        RowBox[{"d", "=", "9"}], ",", " ", "well", ",", " ", "x", ",", " ", 
        "y", ",", " ", "error"}], "}"}], ",", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"sample", "=", 
        RowBox[{"Join", "[", 
         RowBox[{"sampleWells", ",", "emptyWells"}], "]"}]}], ";", "\n", 
       RowBox[{"Labeled", "[", 
        RowBox[{
         RowBox[{"Graphics", "[", "\n", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{
               RowBox[{"EdgeForm", "[", 
                RowBox[{"AbsoluteThickness", "[", "2", "]"}], "]"}], ",", 
               "White", ",", 
               RowBox[{"Rectangle", "[", 
                RowBox[{
                 RowBox[{"{", 
                  RowBox[{"0", ",", "0"}], "}"}], ",", 
                 RowBox[{"{", 
                  RowBox[{
                   RowBox[{"width", "-", 
                    RowBox[{"d", "/", "2"}]}], ",", 
                   RowBox[{
                    RowBox[{"-", "length"}], "+", 
                    RowBox[{"d", "/", "2"}]}]}], "}"}]}], "]"}]}], "}"}], ",",
              "\n", 
             RowBox[{"Table", "[", 
              RowBox[{
               RowBox[{"Text", "[", 
                RowBox[{
                 RowBox[{"Style", "[", 
                  RowBox[{
                   RowBox[{"x", "+", "1"}], ",", "16", ",", "Bold"}], "]"}], 
                 ",", 
                 RowBox[{"{", 
                  RowBox[{
                   RowBox[{"xA1", "+", 
                    RowBox[{"x", "*", "d"}]}], ",", 
                   RowBox[{
                    RowBox[{"-", "yA1"}], "/", "3"}]}], "}"}]}], "]"}], ",", 
               RowBox[{"{", 
                RowBox[{"x", ",", "0", ",", "11"}], "}"}]}], "]"}], ",", "\n", 
             RowBox[{"Table", "[", 
              RowBox[{
               RowBox[{"Text", "[", 
                RowBox[{
                 RowBox[{"Style", "[", 
                  RowBox[{
                   RowBox[{"FromCharacterCode", "[", 
                    RowBox[{"65", "+", "y"}], "]"}], ",", "20", ",", "Bold"}],
                   "]"}], ",", 
                 RowBox[{"{", 
                  RowBox[{
                   RowBox[{"xA1", "/", "2.5"}], ",", 
                   RowBox[{
                    RowBox[{"-", "yA1"}], "-", 
                    RowBox[{"y", "*", "d"}]}]}], "}"}]}], "]"}], ",", 
               RowBox[{"{", 
                RowBox[{"y", ",", "0", ",", "7"}], "}"}]}], "]"}], ",", "\n", 
             RowBox[{"Table", "[", 
              RowBox[{
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"EdgeForm", "[", 
                  RowBox[{"AbsoluteThickness", "[", "2", "]"}], "]"}], ",", 
                 "White", ",", 
                 RowBox[{"Disk", "[", 
                  RowBox[{
                   RowBox[{"{", 
                    RowBox[{
                    RowBox[{"xA1", "+", 
                    RowBox[{"x", "*", "d"}]}], ",", 
                    RowBox[{
                    RowBox[{"-", "yA1"}], "-", 
                    RowBox[{"y", "*", "d"}]}]}], "}"}], ",", 
                   RowBox[{
                    RowBox[{"d", "/", "2"}], "-", "0.4"}]}], "]"}]}], "}"}], 
               ",", 
               RowBox[{"{", 
                RowBox[{"x", ",", "0", ",", "11"}], "}"}], ",", 
               RowBox[{"{", 
                RowBox[{"y", ",", "0", ",", "7"}], "}"}]}], "]"}], ",", "\n", 
             RowBox[{"Table", "[", 
              RowBox[{
               RowBox[{"If", "[", 
                RowBox[{
                 RowBox[{
                  RowBox[{"sample", "[", 
                   RowBox[{"[", "i", "]"}], "]"}], "\[NotEqual]", 
                  "\"\<\>\""}], ",", "\n", 
                 RowBox[{
                  RowBox[{"well", "=", 
                   RowBox[{"ToCharacterCode", "[", 
                    RowBox[{"sample", "[", 
                    RowBox[{"[", "i", "]"}], "]"}], "]"}]}], ";", "\n", 
                  RowBox[{"error", "=", "0"}], ";", "\n", 
                  RowBox[{"If", "[", 
                   RowBox[{
                    RowBox[{
                    RowBox[{
                    RowBox[{"well", "[", 
                    RowBox[{"[", "1", "]"}], "]"}], "<", "65"}], " ", "||", 
                    " ", 
                    RowBox[{
                    RowBox[{"well", "[", 
                    RowBox[{"[", "1", "]"}], "]"}], ">", "72"}]}], ",", " ", 
                    RowBox[{"error", "=", "1"}], ",", " ", 
                    RowBox[{"y", "=", 
                    RowBox[{
                    RowBox[{"well", "[", 
                    RowBox[{"[", "1", "]"}], "]"}], "-", "65"}]}]}], "]"}], 
                  ";", "\n", 
                  RowBox[{"Which", "[", "\n", "\t", 
                   RowBox[{
                    RowBox[{
                    RowBox[{
                    RowBox[{"Length", "[", "well", "]"}], "<", "2"}], " ", "||",
                     " ", 
                    RowBox[{
                    RowBox[{"Length", "[", "well", "]"}], ">", "3"}]}], ",", 
                    " ", 
                    RowBox[{"error", "=", "1"}], ",", "\n", "\t", 
                    RowBox[{
                    RowBox[{"Length", "[", "well", "]"}], "\[Equal]", "2"}], 
                    ",", " ", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    RowBox[{"well", "[", 
                    RowBox[{"[", "2", "]"}], "]"}], "<", "49"}], " ", "||", 
                    " ", 
                    RowBox[{
                    RowBox[{"well", "[", 
                    RowBox[{"[", "2", "]"}], "]"}], ">", "57"}]}], ",", " ", 
                    RowBox[{"error", "=", "1"}], ",", " ", 
                    RowBox[{"x", "=", 
                    RowBox[{
                    RowBox[{"well", "[", 
                    RowBox[{"[", "2", "]"}], "]"}], "-", "49"}]}]}], "]"}], 
                    ",", "\n", "\t", 
                    RowBox[{
                    RowBox[{"Length", "[", "well", "]"}], "\[Equal]", "3"}], 
                    ",", " ", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    RowBox[{"well", "[", 
                    RowBox[{"[", "2", "]"}], "]"}], "!=", "49"}], " ", "||", 
                    " ", 
                    RowBox[{
                    RowBox[{"well", "[", 
                    RowBox[{"[", "3", "]"}], "]"}], "<", "48"}], " ", "||", 
                    " ", 
                    RowBox[{
                    RowBox[{"well", "[", 
                    RowBox[{"[", "3", "]"}], "]"}], ">", "50"}]}], ",", " ", 
                    RowBox[{"error", "=", "1"}], ",", " ", 
                    RowBox[{"x", "=", 
                    RowBox[{"10", "+", 
                    RowBox[{"well", "[", 
                    RowBox[{"[", "3", "]"}], "]"}], "-", "49"}]}]}], "]"}]}], 
                   "\n", "]"}], ";", "\n", 
                  RowBox[{"If", "[", 
                   RowBox[{
                    RowBox[{"error", "\[Equal]", "1"}], ",", "\n", 
                    RowBox[{"Print", "[", 
                    RowBox[{
                    RowBox[{"sample", "[", 
                    RowBox[{"[", "i", "]"}], "]"}], "<>", 
                    "\"\< is an incorrect well position\>\""}], "]"}], ",", 
                    "\n", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"MemberQ", "[", 
                    RowBox[{"emptyWells", ",", 
                    RowBox[{"sample", "[", 
                    RowBox[{"[", "i", "]"}], "]"}]}], "]"}], ",", "\n", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"EdgeForm", "[", 
                    RowBox[{"AbsoluteThickness", "[", "2", "]"}], "]"}], ",", 
                    "White", ",", 
                    RowBox[{"Disk", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"xA1", "+", 
                    RowBox[{"x", "*", "d"}]}], ",", 
                    RowBox[{
                    RowBox[{"-", "yA1"}], "-", 
                    RowBox[{"y", "*", "d"}]}]}], "}"}], ",", 
                    RowBox[{
                    RowBox[{"d", "/", "2"}], "-", "0.4"}]}], "]"}], ",", 
                    "Black", ",", 
                    RowBox[{"Line", "[", 
                    RowBox[{"CirclePoints", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"xA1", "+", 
                    RowBox[{"x", "*", "d"}]}], ",", 
                    RowBox[{
                    RowBox[{"-", "yA1"}], "-", 
                    RowBox[{"y", "*", "d"}]}]}], "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"d", "/", "2"}], "-", "0.4"}], ",", 
                    RowBox[{"45", "Degree"}]}], "}"}], ",", "2"}], "]"}], 
                    "]"}], ",", "Black", ",", 
                    RowBox[{"Line", "[", 
                    RowBox[{"CirclePoints", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"xA1", "+", 
                    RowBox[{"x", "*", "d"}]}], ",", 
                    RowBox[{
                    RowBox[{"-", "yA1"}], "-", 
                    RowBox[{"y", "*", "d"}]}]}], "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"d", "/", "2"}], "-", "0.4"}], ",", 
                    RowBox[{
                    RowBox[{"-", "45"}], "Degree"}]}], "}"}], ",", "2"}], 
                    "]"}], "]"}]}], "}"}], ",", "\n", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"EdgeForm", "[", 
                    RowBox[{"AbsoluteThickness", "[", "2", "]"}], "]"}], ",", 
                    RowBox[{"color", "[", 
                    RowBox[{"[", 
                    RowBox[{"Min", "[", 
                    RowBox[{"i", ",", 
                    RowBox[{"Length", "[", "color", "]"}]}], "]"}], "]"}], 
                    "]"}], ",", 
                    RowBox[{"Disk", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"xA1", "+", 
                    RowBox[{"x", "*", "d"}]}], ",", 
                    RowBox[{
                    RowBox[{"-", "yA1"}], "-", 
                    RowBox[{"y", "*", "d"}]}]}], "}"}], ",", 
                    RowBox[{
                    RowBox[{"d", "/", "2"}], "-", "0.4"}]}], "]"}]}], "}"}]}],
                     "]"}]}], "]"}]}]}], "]"}], ",", "\n", 
               RowBox[{"{", 
                RowBox[{"i", ",", "1", ",", 
                 RowBox[{"Length", "[", "sample", "]"}]}], "}"}]}], "]"}]}], 
            "\[IndentingNewLine]", "}"}], ",", 
           RowBox[{"ImageSize", "\[Rule]", "440"}]}], "]"}], ",", 
         "\[IndentingNewLine]", "PlateName", ",", "Top", ",", 
         RowBox[{"LabelStyle", "->", 
          RowBox[{"Directive", "[", 
           RowBox[{
            RowBox[{"FontSize", "\[Rule]", "20"}], ",", 
            RowBox[{"FontFamily", "->", "\"\<Calibri\>\""}]}], "]"}]}]}], 
        "]"}]}]}], "\[IndentingNewLine]", "]"}]}], ";"}]}]], "Code",
 CellChangeTimes->{{3.696441255882972*^9, 3.696441285593966*^9}, {
   3.696441365167041*^9, 3.696441379528578*^9}, {3.696441413896541*^9, 
   3.696441477851045*^9}, {3.6964420785894957`*^9, 3.696442168979971*^9}, {
   3.696442208208474*^9, 3.696442215830648*^9}, {3.6964423655030327`*^9, 
   3.696442570082333*^9}, {3.696442763932192*^9, 3.69644295919395*^9}, {
   3.696443004091007*^9, 3.696443181789799*^9}, {3.696443272789884*^9, 
   3.696443332498728*^9}, {3.6964433932373133`*^9, 3.6964434179877925`*^9}, {
   3.696443469993218*^9, 3.696443478227181*^9}, {3.696443511972018*^9, 
   3.696443514517985*^9}, {3.696443582215925*^9, 3.6964436586558933`*^9}, {
   3.696443714246931*^9, 3.696443717222455*^9}, {3.696443764434248*^9, 
   3.6964439925915174`*^9}, 3.6964441147078137`*^9, {3.6964442196961193`*^9, 
   3.696444219895238*^9}, {3.696444295907024*^9, 3.696444313797587*^9}, 
   3.696444793338313*^9, {3.696446029375081*^9, 3.696446074266387*^9}, {
   3.696449993175017*^9, 3.696450019089143*^9}, 3.696450398342276*^9, 
   3.696450430403634*^9, {3.6964514788178835`*^9, 3.6964514984154797`*^9}, {
   3.696451638239537*^9, 3.69645165904838*^9}, {3.696451705812063*^9, 
   3.696451765998638*^9}, 3.696452035610381*^9, {3.696452081238796*^9, 
   3.696452082099382*^9}, 3.6964521420667334`*^9, 3.696616179744767*^9, {
   3.696616391050361*^9, 3.696616391480069*^9}, {3.696624519752405*^9, 
   3.696624524546701*^9}, {3.6966246349029474`*^9, 3.6966246545312366`*^9}, {
   3.728009635540294*^9, 3.728009639166884*^9}, {3.728009692141391*^9, 
   3.728009747917929*^9}, {3.7280098377195253`*^9, 3.7280099359601283`*^9}, {
   3.728009978022894*^9, 3.728009979886222*^9}, {3.7280100430634656`*^9, 
   3.728010084020426*^9}, {3.728010130626422*^9, 3.728010131633153*^9}, {
   3.728010200867206*^9, 3.728010201094355*^9}, {3.728010232870867*^9, 
   3.728010254541227*^9}, {3.728010301726623*^9, 3.728010307843954*^9}, {
   3.728010344492929*^9, 3.728010524210224*^9}, {3.728010730345255*^9, 
   3.728010792526314*^9}, {3.85284057820333*^9, 3.852840587430147*^9}, {
   3.85284070405337*^9, 3.852840704557595*^9}, {3.886549256137385*^9, 
   3.886549256428759*^9}, {3.8865493107854347`*^9, 3.886549344996472*^9}, {
   3.886549443937169*^9, 3.886549446241942*^9}, {3.8894660113463306`*^9, 
   3.889466070169299*^9}, {3.889466107692549*^9, 3.889466115651866*^9}},
 FontFamily->"Consolas",
 FontSize->13,
 FontWeight->"Bold",
 CellLabel->"In[17]:=",ExpressionUUID->"1a13e859-87f0-417e-b16a-f3bfc09d9c93"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{
    RowBox[{
    "Same", " ", "as", " ", "above", " ", "but", " ", "for", " ", "plotting", 
     " ", "384"}], "-", 
    RowBox[{"well", " ", 
     RowBox[{"plates", "."}]}]}], "*)"}], "\n", "\n", 
  RowBox[{
   RowBox[{
    RowBox[{"PlotPlateSRD384", "[", 
     RowBox[{"sampleWells_", ",", "PlateName_", ",", 
      RowBox[{"emptyWells_", ":", 
       RowBox[{"{", "}"}]}], ",", 
      RowBox[{"color_", ":", 
       RowBox[{"{", 
        RowBox[{"Lighter", "[", 
         RowBox[{"Gray", ",", "0.4"}], "]"}], "}"}]}]}], "]"}], ":=", 
    RowBox[{"Module", "[", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"sample", ",", " ", 
        RowBox[{"width", "=", "127.8"}], ",", " ", 
        RowBox[{"length", "=", "85.5"}], ",", " ", 
        RowBox[{"xA1", "=", "14.4"}], ",", " ", 
        RowBox[{"yA1", "=", "11.2"}], ",", " ", 
        RowBox[{"d", "=", "9"}], ",", " ", "well", ",", " ", "x", ",", " ", 
        "y", ",", " ", "error"}], "}"}], ",", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"sample", "=", 
        RowBox[{"Join", "[", 
         RowBox[{"sampleWells", ",", "emptyWells"}], "]"}]}], ";", "\n", 
       RowBox[{"Labeled", "[", 
        RowBox[{
         RowBox[{"Graphics", "[", "\n", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{
               RowBox[{"EdgeForm", "[", 
                RowBox[{"AbsoluteThickness", "[", "2", "]"}], "]"}], ",", 
               "White", ",", 
               RowBox[{"Rectangle", "[", 
                RowBox[{
                 RowBox[{"{", 
                  RowBox[{"0", ",", "0"}], "}"}], ",", 
                 RowBox[{"{", 
                  RowBox[{
                   RowBox[{"width", "+", 
                    RowBox[{"d", "*", "12"}], "-", 
                    RowBox[{"d", "/", "2"}], "-", 
                    RowBox[{"d", "/", "4"}]}], ",", 
                   RowBox[{
                    RowBox[{"-", "length"}], "-", 
                    RowBox[{"d", "*", "8"}], "+", 
                    RowBox[{"d", "/", "2"}]}]}], "}"}]}], "]"}]}], "}"}], ",",
              "\n", 
             RowBox[{"Table", "[", 
              RowBox[{
               RowBox[{"Text", "[", 
                RowBox[{
                 RowBox[{"Style", "[", 
                  RowBox[{
                   RowBox[{"x", "+", "1"}], ",", "11", ",", "Bold"}], "]"}], 
                 ",", 
                 RowBox[{"{", 
                  RowBox[{
                   RowBox[{"xA1", "+", 
                    RowBox[{"x", "*", "d"}]}], ",", 
                   RowBox[{
                    RowBox[{"-", "yA1"}], "/", "3"}]}], "}"}]}], "]"}], ",", 
               RowBox[{"{", 
                RowBox[{"x", ",", "0", ",", "23"}], "}"}]}], "]"}], ",", "\n", 
             RowBox[{"Table", "[", 
              RowBox[{
               RowBox[{"Text", "[", 
                RowBox[{
                 RowBox[{"Style", "[", 
                  RowBox[{
                   RowBox[{"FromCharacterCode", "[", 
                    RowBox[{"65", "+", "y"}], "]"}], ",", "20", ",", "Bold"}],
                   "]"}], ",", 
                 RowBox[{"{", 
                  RowBox[{
                   RowBox[{"xA1", "/", "2.5"}], ",", 
                   RowBox[{
                    RowBox[{"-", "yA1"}], "-", 
                    RowBox[{"y", "*", "d"}]}]}], "}"}]}], "]"}], ",", 
               RowBox[{"{", 
                RowBox[{"y", ",", "0", ",", "15"}], "}"}]}], "]"}], ",", "\n", 
             RowBox[{"Table", "[", 
              RowBox[{
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"EdgeForm", "[", 
                  RowBox[{"AbsoluteThickness", "[", "2", "]"}], "]"}], ",", 
                 "White", ",", 
                 RowBox[{"Disk", "[", 
                  RowBox[{
                   RowBox[{"{", 
                    RowBox[{
                    RowBox[{"xA1", "+", 
                    RowBox[{"x", "*", "d"}]}], ",", 
                    RowBox[{
                    RowBox[{"-", "yA1"}], "-", 
                    RowBox[{"y", "*", "d"}]}]}], "}"}], ",", 
                   RowBox[{
                    RowBox[{"d", "/", "2"}], "-", "0.4"}]}], "]"}]}], "}"}], 
               ",", 
               RowBox[{"{", 
                RowBox[{"x", ",", "0", ",", "23"}], "}"}], ",", 
               RowBox[{"{", 
                RowBox[{"y", ",", "0", ",", "15"}], "}"}]}], "]"}], ",", "\n", 
             RowBox[{"Table", "[", 
              RowBox[{
               RowBox[{"If", "[", 
                RowBox[{
                 RowBox[{
                  RowBox[{"sample", "[", 
                   RowBox[{"[", "i", "]"}], "]"}], "\[NotEqual]", 
                  "\"\<\>\""}], ",", "\n", 
                 RowBox[{
                  RowBox[{"well", "=", 
                   RowBox[{"ToCharacterCode", "[", 
                    RowBox[{"sample", "[", 
                    RowBox[{"[", "i", "]"}], "]"}], "]"}]}], ";", "\n", 
                  RowBox[{"error", "=", "0"}], ";", "\n", 
                  RowBox[{"If", "[", 
                   RowBox[{
                    RowBox[{
                    RowBox[{
                    RowBox[{"well", "[", 
                    RowBox[{"[", "1", "]"}], "]"}], "<", "65"}], " ", "||", 
                    " ", 
                    RowBox[{
                    RowBox[{"well", "[", 
                    RowBox[{"[", "1", "]"}], "]"}], ">", "80"}]}], ",", " ", 
                    RowBox[{"error", "=", "1"}], ",", " ", 
                    RowBox[{"y", "=", 
                    RowBox[{
                    RowBox[{"well", "[", 
                    RowBox[{"[", "1", "]"}], "]"}], "-", "65"}]}]}], "]"}], 
                  ";", "\n", 
                  RowBox[{"Which", "[", "\n", "\t", 
                   RowBox[{
                    RowBox[{
                    RowBox[{
                    RowBox[{"Length", "[", "well", "]"}], "<", "2"}], " ", "||",
                     " ", 
                    RowBox[{
                    RowBox[{"Length", "[", "well", "]"}], ">", "3"}]}], ",", 
                    " ", 
                    RowBox[{"error", "=", "1"}], ",", "\n", "\t", 
                    RowBox[{
                    RowBox[{"Length", "[", "well", "]"}], "\[Equal]", "2"}], 
                    ",", " ", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    RowBox[{"well", "[", 
                    RowBox[{"[", "2", "]"}], "]"}], "<", "49"}], " ", "||", 
                    " ", 
                    RowBox[{
                    RowBox[{"well", "[", 
                    RowBox[{"[", "2", "]"}], "]"}], ">", "57"}]}], ",", " ", 
                    RowBox[{"error", "=", "1"}], ",", " ", 
                    RowBox[{"x", "=", 
                    RowBox[{
                    RowBox[{"well", "[", 
                    RowBox[{"[", "2", "]"}], "]"}], "-", "49"}]}]}], "]"}], 
                    ",", "\n", "\t", 
                    RowBox[{
                    RowBox[{"Length", "[", "well", "]"}], "\[Equal]", "3"}], 
                    ",", " ", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"!", 
                    RowBox[{"ContainsAll", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"49", ",", "50"}], "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"well", "[", 
                    RowBox[{"[", "2", "]"}], "]"}], "}"}]}], "]"}]}], " ", "||",
                     " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"well", "[", 
                    RowBox[{"[", "2", "]"}], "]"}], "==", "50"}], " ", "&&", 
                    " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"well", "[", 
                    RowBox[{"[", "3", "]"}], "]"}], "<", "48"}], " ", "||", 
                    " ", 
                    RowBox[{
                    RowBox[{"well", "[", 
                    RowBox[{"[", "3", "]"}], "]"}], ">", "52"}]}], ")"}]}], 
                    ")"}]}], ",", " ", 
                    RowBox[{"error", "=", "1"}], ",", " ", 
                    RowBox[{"x", "=", 
                    RowBox[{
                    RowBox[{"10", "*", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"well", "[", 
                    RowBox[{"[", "2", "]"}], "]"}], "-", "48"}], ")"}]}], "+", 
                    RowBox[{"well", "[", 
                    RowBox[{"[", "3", "]"}], "]"}], "-", "49"}]}]}], "]"}]}], 
                   "\n", "]"}], ";", "\n", 
                  RowBox[{"If", "[", 
                   RowBox[{
                    RowBox[{"error", "\[Equal]", "1"}], ",", "\n", 
                    RowBox[{"Print", "[", 
                    RowBox[{
                    RowBox[{"sample", "[", 
                    RowBox[{"[", "i", "]"}], "]"}], "<>", 
                    "\"\< is an incorrect well position\>\""}], "]"}], ",", 
                    "\n", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"MemberQ", "[", 
                    RowBox[{"emptyWells", ",", 
                    RowBox[{"sample", "[", 
                    RowBox[{"[", "i", "]"}], "]"}]}], "]"}], ",", "\n", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"EdgeForm", "[", 
                    RowBox[{"AbsoluteThickness", "[", "2", "]"}], "]"}], ",", 
                    "White", ",", 
                    RowBox[{"Disk", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"xA1", "+", 
                    RowBox[{"x", "*", "d"}]}], ",", 
                    RowBox[{
                    RowBox[{"-", "yA1"}], "-", 
                    RowBox[{"y", "*", "d"}]}]}], "}"}], ",", 
                    RowBox[{
                    RowBox[{"d", "/", "2"}], "-", "0.4"}]}], "]"}], ",", 
                    "Black", ",", 
                    RowBox[{"Line", "[", 
                    RowBox[{"CirclePoints", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"xA1", "+", 
                    RowBox[{"x", "*", "d"}]}], ",", 
                    RowBox[{
                    RowBox[{"-", "yA1"}], "-", 
                    RowBox[{"y", "*", "d"}]}]}], "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"d", "/", "2"}], "-", "0.4"}], ",", 
                    RowBox[{"45", "Degree"}]}], "}"}], ",", "2"}], "]"}], 
                    "]"}], ",", "Black", ",", 
                    RowBox[{"Line", "[", 
                    RowBox[{"CirclePoints", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"xA1", "+", 
                    RowBox[{"x", "*", "d"}]}], ",", 
                    RowBox[{
                    RowBox[{"-", "yA1"}], "-", 
                    RowBox[{"y", "*", "d"}]}]}], "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"d", "/", "2"}], "-", "0.4"}], ",", 
                    RowBox[{
                    RowBox[{"-", "45"}], "Degree"}]}], "}"}], ",", "2"}], 
                    "]"}], "]"}]}], "}"}], ",", "\n", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"EdgeForm", "[", 
                    RowBox[{"AbsoluteThickness", "[", "2", "]"}], "]"}], ",", 
                    RowBox[{"color", "[", 
                    RowBox[{"[", 
                    RowBox[{"Min", "[", 
                    RowBox[{"i", ",", 
                    RowBox[{"Length", "[", "color", "]"}]}], "]"}], "]"}], 
                    "]"}], ",", 
                    RowBox[{"Disk", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"xA1", "+", 
                    RowBox[{"x", "*", "d"}]}], ",", 
                    RowBox[{
                    RowBox[{"-", "yA1"}], "-", 
                    RowBox[{"y", "*", "d"}]}]}], "}"}], ",", 
                    RowBox[{
                    RowBox[{"d", "/", "2"}], "-", "0.4"}]}], "]"}]}], "}"}]}],
                     "]"}]}], "]"}]}]}], "]"}], ",", "\n", 
               RowBox[{"{", 
                RowBox[{"i", ",", "1", ",", 
                 RowBox[{"Length", "[", "sample", "]"}]}], "}"}]}], "]"}]}], 
            "\[IndentingNewLine]", "}"}], ",", 
           RowBox[{"ImageSize", "\[Rule]", "440"}]}], "]"}], ",", 
         "\[IndentingNewLine]", "PlateName", ",", "Top", ",", 
         RowBox[{"LabelStyle", "->", 
          RowBox[{"Directive", "[", 
           RowBox[{
            RowBox[{"FontSize", "\[Rule]", "20"}], ",", 
            RowBox[{"FontFamily", "->", "\"\<Calibri\>\""}]}], "]"}]}]}], 
        "]"}]}]}], "\[IndentingNewLine]", "]"}]}], ";"}]}]], "Code",
 CellChangeTimes->{{3.696441255882972*^9, 3.696441285593966*^9}, {
   3.696441365167041*^9, 3.696441379528578*^9}, {3.696441413896541*^9, 
   3.696441477851045*^9}, {3.6964420785894957`*^9, 3.696442168979971*^9}, {
   3.696442208208474*^9, 3.696442215830648*^9}, {3.6964423655030327`*^9, 
   3.696442570082333*^9}, {3.696442763932192*^9, 3.69644295919395*^9}, {
   3.696443004091007*^9, 3.696443181789799*^9}, {3.696443272789884*^9, 
   3.696443332498728*^9}, {3.6964433932373133`*^9, 3.6964434179877925`*^9}, {
   3.696443469993218*^9, 3.696443478227181*^9}, {3.696443511972018*^9, 
   3.696443514517985*^9}, {3.696443582215925*^9, 3.6964436586558933`*^9}, {
   3.696443714246931*^9, 3.696443717222455*^9}, {3.696443764434248*^9, 
   3.6964439925915174`*^9}, 3.6964441147078137`*^9, {3.6964442196961193`*^9, 
   3.696444219895238*^9}, {3.696444295907024*^9, 3.696444313797587*^9}, 
   3.696444793338313*^9, {3.696446029375081*^9, 3.696446074266387*^9}, {
   3.696449993175017*^9, 3.696450019089143*^9}, 3.696450398342276*^9, 
   3.696450430403634*^9, {3.6964514788178835`*^9, 3.6964514984154797`*^9}, {
   3.696451638239537*^9, 3.69645165904838*^9}, {3.696451705812063*^9, 
   3.696451765998638*^9}, 3.696452035610381*^9, {3.696452081238796*^9, 
   3.696452082099382*^9}, 3.6964521420667334`*^9, 3.696616179744767*^9, {
   3.696616391050361*^9, 3.696616391480069*^9}, {3.696624519752405*^9, 
   3.696624524546701*^9}, {3.6966246349029474`*^9, 3.6966246545312366`*^9}, {
   3.728009635540294*^9, 3.728009639166884*^9}, {3.728009692141391*^9, 
   3.728009747917929*^9}, {3.7280098377195253`*^9, 3.7280099359601283`*^9}, {
   3.728009978022894*^9, 3.728009979886222*^9}, {3.7280100430634656`*^9, 
   3.728010084020426*^9}, {3.728010130626422*^9, 3.728010131633153*^9}, {
   3.728010200867206*^9, 3.728010201094355*^9}, {3.728010232870867*^9, 
   3.728010254541227*^9}, {3.728010301726623*^9, 3.728010307843954*^9}, {
   3.728010344492929*^9, 3.728010524210224*^9}, {3.728010730345255*^9, 
   3.728010792526314*^9}, {3.85284057820333*^9, 3.852840587430147*^9}, {
   3.85284070405337*^9, 3.852840704557595*^9}, {3.886549256137385*^9, 
   3.886549256428759*^9}, {3.8865493107854347`*^9, 3.886549344996472*^9}, {
   3.886549443937169*^9, 3.886549446241942*^9}, {3.8883507131893272`*^9, 
   3.888350718932019*^9}, {3.8883509484102497`*^9, 3.888350948537642*^9}, {
   3.8883511797533684`*^9, 3.888351233622883*^9}, {3.888351267434784*^9, 
   3.888351278693835*^9}, {3.88835160211441*^9, 3.888351603778996*^9}, {
   3.8883516903007526`*^9, 3.88835171258673*^9}, 3.888351763091068*^9, {
   3.888351902057639*^9, 3.888351937747017*^9}, {3.8883519683637466`*^9, 
   3.888351980975726*^9}, {3.888352013465191*^9, 3.8883520380436277`*^9}, {
   3.888352081886105*^9, 3.888352104019774*^9}, {3.889466094835112*^9, 
   3.8894661297531977`*^9}},
 FontFamily->"Consolas",
 FontSize->13,
 FontWeight->"Bold",
 CellLabel->"In[18]:=",ExpressionUUID->"ee221cf4-5f65-4417-8577-92d48a22d195"],

Cell[BoxData[
 RowBox[{
  RowBox[{"leftoversXferWells", "=", 
   RowBox[{"{", 
    RowBox[{
    "\"\<J7\>\"", ",", "\"\<B10\>\"", ",", "\"\<I10\>\"", ",", "\"\<G10\>\"", 
     ",", "\"\<I17\>\"", ",", "\"\<F1\>\"", ",", "\"\<D10\>\"", ",", 
     "\"\<B5\>\"", ",", "\"\<I16\>\"", ",", "\"\<I6\>\"", ",", "\"\<K3\>\"", 
     ",", "\"\<C8\>\"", ",", "\"\<E2\>\"", ",", "\"\<H10\>\"", ",", 
     "\"\<E1\>\"", ",", "\"\<D2\>\"", ",", "\"\<J5\>\"", ",", "\"\<C2\>\"", 
     ",", "\"\<J3\>\"", ",", "\"\<C10\>\"", ",", "\"\<G3\>\"", ",", 
     "\"\<E10\>\"", ",", "\"\<C1\>\"", ",", "\"\<K1\>\"", ",", "\"\<E3\>\"", 
     ",", "\"\<E17\>\"", ",", "\"\<G8\>\"", ",", "\"\<G4\>\"", ",", 
     "\"\<G6\>\"", ",", "\"\<C4\>\"", ",", "\"\<C3\>\"", ",", "\"\<D9\>\"", 
     ",", "\"\<C15\>\"", ",", "\"\<B2\>\"", ",", "\"\<G5\>\"", ",", 
     "\"\<G14\>\"", ",", "\"\<F23\>\"", ",", "\"\<E16\>\"", ",", "\"\<B7\>\"",
      ",", "\"\<B3\>\"", ",", "\"\<I4\>\"", ",", "\"\<J9\>\"", ",", 
     "\"\<J6\>\"", ",", "\"\<H5\>\"", ",", "\"\<I3\>\"", ",", "\"\<H2\>\"", 
     ",", "\"\<J10\>\"", ",", "\"\<C9\>\"", ",", "\"\<H4\>\"", ",", 
     "\"\<I7\>\"", ",", "\"\<H7\>\"", ",", "\"\<G7\>\"", ",", "\"\<I5\>\"", 
     ",", "\"\<C17\>\"", ",", "\"\<C6\>\"", ",", "\"\<C5\>\"", ",", 
     "\"\<A2\>\"", ",", "\"\<A23\>\"", ",", "\"\<J8\>\"", ",", "\"\<I13\>\"", 
     ",", "\"\<K2\>\"", ",", "\"\<H3\>\"", ",", "\"\<I2\>\"", ",", 
     "\"\<E14\>\"", ",", "\"\<I8\>\"", ",", "\"\<I1\>\"", ",", "\"\<E9\>\"", 
     ",", "\"\<H19\>\"", ",", "\"\<B4\>\"", ",", "\"\<K13\>\"", ",", 
     "\"\<J4\>\"", ",", "\"\<E5\>\"", ",", "\"\<F10\>\"", ",", "\"\<D3\>\"", 
     ",", "\"\<C16\>\"", ",", "\"\<G9\>\"", ",", "\"\<H11\>\"", ",", 
     "\"\<A13\>\"", ",", "\"\<E7\>\"", ",", "\"\<H13\>\"", ",", "\"\<H6\>\"", 
     ",", "\"\<G17\>\""}], "}"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.8883504863352757`*^9, 3.888350490321374*^9}, {
  3.8883505554290695`*^9, 3.888350568860965*^9}, {3.8883524705441246`*^9, 
  3.888352475414475*^9}, {3.889467007546766*^9, 
  3.8894670136931567`*^9}},ExpressionUUID->"feaa2ab5-97eb-47e0-ab3a-\
da681cb6b6bb"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"leftoversXfer", "=", 
  RowBox[{"PlotPlateSRD384", "[", 
   RowBox[{"leftoversXferWells", ",", "\"\<Leftovers transfer\>\"", ",", 
    RowBox[{"{", "}"}], ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"ColorData", "[", "\"\<Pastel\>\"", "]"}], "[", 
      RowBox[{"1", "/", "6"}], "]"}], "}"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.8883504441798487`*^9, 3.8883504955646963`*^9}, {
   3.8883505295326447`*^9, 3.888350537617196*^9}, 3.888350581427419*^9, {
   3.888351298392391*^9, 3.888351298627008*^9}, 3.88835176830558*^9, 
   3.8883524824671936`*^9},
 CellLabel->
  "In[417]:=",ExpressionUUID->"dfef0933-1d6e-4410-b53d-d431f28e03c9"],

Cell[BoxData[
 TemplateBox[{
   GraphicsBox[{{
      EdgeForm[
       AbsoluteThickness[2]], 
      GrayLevel[1], 
      RectangleBox[{0, 0}, {229.05, -153.}]}, {
      InsetBox[
       FormBox[
        StyleBox["1", 11, Bold, StripOnInput -> False], TraditionalForm], {
       14.4, -3.733333333333333}], 
      InsetBox[
       FormBox[
        StyleBox["2", 11, Bold, StripOnInput -> False], TraditionalForm], {
       23.4, -3.733333333333333}], 
      InsetBox[
       FormBox[
        StyleBox["3", 11, Bold, StripOnInput -> False], TraditionalForm], {
       32.4, -3.733333333333333}], 
      InsetBox[
       FormBox[
        StyleBox["4", 11, Bold, StripOnInput -> False], TraditionalForm], {
       41.4, -3.733333333333333}], 
      InsetBox[
       FormBox[
        StyleBox["5", 11, Bold, StripOnInput -> False], TraditionalForm], {
       50.4, -3.733333333333333}], 
      InsetBox[
       FormBox[
        StyleBox["6", 11, Bold, StripOnInput -> False], TraditionalForm], {
       59.4, -3.733333333333333}], 
      InsetBox[
       FormBox[
        StyleBox["7", 11, Bold, StripOnInput -> False], TraditionalForm], {
       68.4, -3.733333333333333}], 
      InsetBox[
       FormBox[
        StyleBox["8", 11, Bold, StripOnInput -> False], TraditionalForm], {
       77.4, -3.733333333333333}], 
      InsetBox[
       FormBox[
        StyleBox["9", 11, Bold, StripOnInput -> False], TraditionalForm], {
       86.4, -3.733333333333333}], 
      InsetBox[
       FormBox[
        StyleBox["10", 11, Bold, StripOnInput -> False], TraditionalForm], {
       95.4, -3.733333333333333}], 
      InsetBox[
       FormBox[
        StyleBox["11", 11, Bold, StripOnInput -> False], TraditionalForm], {
       104.4, -3.733333333333333}], 
      InsetBox[
       FormBox[
        StyleBox["12", 11, Bold, StripOnInput -> False], TraditionalForm], {
       113.4, -3.733333333333333}], 
      InsetBox[
       FormBox[
        StyleBox["13", 11, Bold, StripOnInput -> False], TraditionalForm], {
       122.4, -3.733333333333333}], 
      InsetBox[
       FormBox[
        StyleBox["14", 11, Bold, StripOnInput -> False], TraditionalForm], {
       131.4, -3.733333333333333}], 
      InsetBox[
       FormBox[
        StyleBox["15", 11, Bold, StripOnInput -> False], TraditionalForm], {
       140.4, -3.733333333333333}], 
      InsetBox[
       FormBox[
        StyleBox["16", 11, Bold, StripOnInput -> False], TraditionalForm], {
       149.4, -3.733333333333333}], 
      InsetBox[
       FormBox[
        StyleBox["17", 11, Bold, StripOnInput -> False], TraditionalForm], {
       158.4, -3.733333333333333}], 
      InsetBox[
       FormBox[
        StyleBox["18", 11, Bold, StripOnInput -> False], TraditionalForm], {
       167.4, -3.733333333333333}], 
      InsetBox[
       FormBox[
        StyleBox["19", 11, Bold, StripOnInput -> False], TraditionalForm], {
       176.4, -3.733333333333333}], 
      InsetBox[
       FormBox[
        StyleBox["20", 11, Bold, StripOnInput -> False], TraditionalForm], {
       185.4, -3.733333333333333}], 
      InsetBox[
       FormBox[
        StyleBox["21", 11, Bold, StripOnInput -> False], TraditionalForm], {
       194.4, -3.733333333333333}], 
      InsetBox[
       FormBox[
        StyleBox["22", 11, Bold, StripOnInput -> False], TraditionalForm], {
       203.4, -3.733333333333333}], 
      InsetBox[
       FormBox[
        StyleBox["23", 11, Bold, StripOnInput -> False], TraditionalForm], {
       212.4, -3.733333333333333}], 
      InsetBox[
       FormBox[
        StyleBox["24", 11, Bold, StripOnInput -> False], TraditionalForm], {
       221.4, -3.733333333333333}]}, {
      InsetBox[
       FormBox[
        StyleBox["\"A\"", 20, Bold, StripOnInput -> False], 
        TraditionalForm], {5.760000000000001, -11.2}], 
      InsetBox[
       FormBox[
        StyleBox["\"B\"", 20, Bold, StripOnInput -> False], 
        TraditionalForm], {5.760000000000001, -20.2}], 
      InsetBox[
       FormBox[
        StyleBox["\"C\"", 20, Bold, StripOnInput -> False], 
        TraditionalForm], {5.760000000000001, -29.2}], 
      InsetBox[
       FormBox[
        StyleBox["\"D\"", 20, Bold, StripOnInput -> False], 
        TraditionalForm], {5.760000000000001, -38.2}], 
      InsetBox[
       FormBox[
        StyleBox["\"E\"", 20, Bold, StripOnInput -> False], 
        TraditionalForm], {5.760000000000001, -47.2}], 
      InsetBox[
       FormBox[
        StyleBox["\"F\"", 20, Bold, StripOnInput -> False], 
        TraditionalForm], {5.760000000000001, -56.2}], 
      InsetBox[
       FormBox[
        StyleBox["\"G\"", 20, Bold, StripOnInput -> False], 
        TraditionalForm], {5.760000000000001, -65.2}], 
      InsetBox[
       FormBox[
        StyleBox["\"H\"", 20, Bold, StripOnInput -> False], 
        TraditionalForm], {5.760000000000001, -74.2}], 
      InsetBox[
       FormBox[
        StyleBox["\"I\"", 20, Bold, StripOnInput -> False], 
        TraditionalForm], {5.760000000000001, -83.2}], 
      InsetBox[
       FormBox[
        StyleBox["\"J\"", 20, Bold, StripOnInput -> False], 
        TraditionalForm], {5.760000000000001, -92.2}], 
      InsetBox[
       FormBox[
        StyleBox["\"K\"", 20, Bold, StripOnInput -> False], 
        TraditionalForm], {5.760000000000001, -101.2}], 
      InsetBox[
       FormBox[
        StyleBox["\"L\"", 20, Bold, StripOnInput -> False], 
        TraditionalForm], {5.760000000000001, -110.2}], 
      InsetBox[
       FormBox[
        StyleBox["\"M\"", 20, Bold, StripOnInput -> False], 
        TraditionalForm], {5.760000000000001, -119.2}], 
      InsetBox[
       FormBox[
        StyleBox["\"N\"", 20, Bold, StripOnInput -> False], 
        TraditionalForm], {5.760000000000001, -128.2}], 
      InsetBox[
       FormBox[
        StyleBox["\"O\"", 20, Bold, StripOnInput -> False], 
        TraditionalForm], {5.760000000000001, -137.2}], 
      InsetBox[
       FormBox[
        StyleBox["\"P\"", 20, Bold, StripOnInput -> False], 
        TraditionalForm], {5.760000000000001, -146.2}]}, {{{
        EdgeForm[
         AbsoluteThickness[2]], 
        GrayLevel[1], 
        DiskBox[{14.4, -11.2}, 4.1]}, {
        EdgeForm[
         AbsoluteThickness[2]], 
        GrayLevel[1], 
        DiskBox[{14.4, -20.2}, 4.1]}, {
        EdgeForm[
         AbsoluteThickness[2]], 
        GrayLevel[1], 
        DiskBox[{14.4, -29.2}, 4.1]}, {
        EdgeForm[
         AbsoluteThickness[2]], 
        GrayLevel[1], 
        DiskBox[{14.4, -38.2}, 4.1]}, {
        EdgeForm[
         AbsoluteThickness[2]], 
        GrayLevel[1], 
        DiskBox[{14.4, -47.2}, 4.1]}, {
        EdgeForm[
         AbsoluteThickness[2]], 
        GrayLevel[1], 
        DiskBox[{14.4, -56.2}, 4.1]}, {
        EdgeForm[
         AbsoluteThickness[2]], 
        GrayLevel[1], 
        DiskBox[{14.4, -65.2}, 4.1]}, {
        EdgeForm[
         AbsoluteThickness[2]], 
        GrayLevel[1], 
        DiskBox[{14.4, -74.2}, 4.1]}, {
        EdgeForm[
         AbsoluteThickness[2]], 
        GrayLevel[1], 
        DiskBox[{14.4, -83.2}, 4.1]}, {
        EdgeForm[
         AbsoluteThickness[2]], 
        GrayLevel[1], 
        DiskBox[{14.4, -92.2}, 4.1]}, {
        EdgeForm[
         AbsoluteThickness[2]], 
        GrayLevel[1], 
        DiskBox[{14.4, -101.2}, 4.1]}, {
        EdgeForm[
         AbsoluteThickness[2]], 
        GrayLevel[1], 
        DiskBox[{14.4, -110.2}, 4.1]}, {
        EdgeForm[
         AbsoluteThickness[2]], 
        GrayLevel[1], 
        DiskBox[{14.4, -119.2}, 4.1]}, {
        EdgeForm[
         AbsoluteThickness[2]], 
        GrayLevel[1], 
        DiskBox[{14.4, -128.2}, 4.1]}, {
        EdgeForm[
         AbsoluteThickness[2]], 
        GrayLevel[1], 
        DiskBox[{14.4, -137.2}, 4.1]}, {
        EdgeForm[
         AbsoluteThickness[2]], 
        GrayLevel[1], 
        DiskBox[{14.4, -146.2}, 4.1]}}, {{
        EdgeForm[
         AbsoluteThickness[2]], 
        GrayLevel[1], 
        DiskBox[{23.4, -11.2}, 4.1]}, {
        EdgeForm[
         AbsoluteThickness[2]], 
        GrayLevel[1], 
        DiskBox[{23.4, -20.2}, 4.1]}, {
        EdgeForm[
         AbsoluteThickness[2]], 
        GrayLevel[1], 
        DiskBox[{23.4, -29.2}, 4.1]}, {
        EdgeForm[
         AbsoluteThickness[2]], 
        GrayLevel[1], 
        DiskBox[{23.4, -38.2}, 4.1]}, {
        EdgeForm[
         AbsoluteThickness[2]], 
        GrayLevel[1], 
        DiskBox[{23.4, -47.2}, 4.1]}, {
        EdgeForm[
         AbsoluteThickness[2]], 
        GrayLevel[1], 
        DiskBox[{23.4, -56.2}, 4.1]}, {
        EdgeForm[
         AbsoluteThickness[2]], 
        GrayLevel[1], 
        DiskBox[{23.4, -65.2}, 4.1]}, {
        EdgeForm[
         AbsoluteThickness[2]], 
        GrayLevel[1], 
        DiskBox[{23.4, -74.2}, 4.1]}, {
        EdgeForm[
         AbsoluteThickness[2]], 
        GrayLevel[1], 
        DiskBox[{23.4, -83.2}, 4.1]}, {
        EdgeForm[
         AbsoluteThickness[2]], 
        GrayLevel[1], 
        DiskBox[{23.4, -92.2}, 4.1]}, {
        EdgeForm[
         AbsoluteThickness[2]], 
        GrayLevel[1], 
        DiskBox[{23.4, -101.2}, 4.1]}, {
        EdgeForm[
         AbsoluteThickness[2]], 
        GrayLevel[1], 
        DiskBox[{23.4, -110.2}, 4.1]}, {
        EdgeForm[
         AbsoluteThickness[2]], 
        GrayLevel[1], 
        DiskBox[{23.4, -119.2}, 4.1]}, {
        EdgeForm[
         AbsoluteThickness[2]], 
        GrayLevel[1], 
        DiskBox[{23.4, -128.2}, 4.1]}, {
        EdgeForm[
         AbsoluteThickness[2]], 
        GrayLevel[1], 
        DiskBox[{23.4, -137.2}, 4.1]}, {
        EdgeForm[
         AbsoluteThickness[2]], 
        GrayLevel[1], 
        DiskBox[{23.4, -146.2}, 4.1]}}, {{
        EdgeForm[
         AbsoluteThickness[2]], 
        GrayLevel[1], 
        DiskBox[{32.4, -11.2}, 4.1]}, {
        EdgeForm[
         AbsoluteThickness[2]], 
        GrayLevel[1], 
        DiskBox[{32.4, -20.2}, 4.1]}, {
        EdgeForm[
         AbsoluteThickness[2]], 
        GrayLevel[1], 
        DiskBox[{32.4, -29.2}, 4.1]}, {
        EdgeForm[
         AbsoluteThickness[2]], 
        GrayLevel[1], 
        DiskBox[{32.4, -38.2}, 4.1]}, {
        EdgeForm[
         AbsoluteThickness[2]], 
        GrayLevel[1], 
        DiskBox[{32.4, -47.2}, 4.1]}, {
        EdgeForm[
         AbsoluteThickness[2]], 
        GrayLevel[1], 
        DiskBox[{32.4, -56.2}, 4.1]}, {
        EdgeForm[
         AbsoluteThickness[2]], 
        GrayLevel[1], 
        DiskBox[{32.4, -65.2}, 4.1]}, {
        EdgeForm[
         AbsoluteThickness[2]], 
        GrayLevel[1], 
        DiskBox[{32.4, -74.2}, 4.1]}, {
        EdgeForm[
         AbsoluteThickness[2]], 
        GrayLevel[1], 
        DiskBox[{32.4, -83.2}, 4.1]}, {
        EdgeForm[
         AbsoluteThickness[2]], 
        GrayLevel[1], 
        DiskBox[{32.4, -92.2}, 4.1]}, {
        EdgeForm[
         AbsoluteThickness[2]], 
        GrayLevel[1], 
        DiskBox[{32.4, -101.2}, 4.1]}, {
        EdgeForm[
         AbsoluteThickness[2]], 
        GrayLevel[1], 
        DiskBox[{32.4, -110.2}, 4.1]}, {
        EdgeForm[
         AbsoluteThickness[2]], 
        GrayLevel[1], 
        DiskBox[{32.4, -119.2}, 4.1]}, {
        EdgeForm[
         AbsoluteThickness[2]], 
        GrayLevel[1], 
        DiskBox[{32.4, -128.2}, 4.1]}, {
        EdgeForm[
         AbsoluteThickness[2]], 
        GrayLevel[1], 
        DiskBox[{32.4, -137.2}, 4.1]}, {
        EdgeForm[
         AbsoluteThickness[2]], 
        GrayLevel[1], 
        DiskBox[{32.4, -146.2}, 4.1]}}, {{
        EdgeForm[
         AbsoluteThickness[2]], 
        GrayLevel[1], 
        DiskBox[{41.4, -11.2}, 4.1]}, {
        EdgeForm[
         AbsoluteThickness[2]], 
        GrayLevel[1], 
        DiskBox[{41.4, -20.2}, 4.1]}, {
        EdgeForm[
         AbsoluteThickness[2]], 
        GrayLevel[1], 
        DiskBox[{41.4, -29.2}, 4.1]}, {
        EdgeForm[
         AbsoluteThickness[2]], 
        GrayLevel[1], 
        DiskBox[{41.4, -38.2}, 4.1]}, {
        EdgeForm[
         AbsoluteThickness[2]], 
        GrayLevel[1], 
        DiskBox[{41.4, -47.2}, 4.1]}, {
        EdgeForm[
         AbsoluteThickness[2]], 
        GrayLevel[1], 
        DiskBox[{41.4, -56.2}, 4.1]}, {
        EdgeForm[
         AbsoluteThickness[2]], 
        GrayLevel[1], 
        DiskBox[{41.4, -65.2}, 4.1]}, {
        EdgeForm[
         AbsoluteThickness[2]], 
        GrayLevel[1], 
        DiskBox[{41.4, -74.2}, 4.1]}, {
        EdgeForm[
         AbsoluteThickness[2]], 
        GrayLevel[1], 
        DiskBox[{41.4, -83.2}, 4.1]}, {
        EdgeForm[
         AbsoluteThickness[2]], 
        GrayLevel[1], 
        DiskBox[{41.4, -92.2}, 4.1]}, {
        EdgeForm[
         AbsoluteThickness[2]], 
        GrayLevel[1], 
        DiskBox[{41.4, -101.2}, 4.1]}, {
        EdgeForm[
         AbsoluteThickness[2]], 
        GrayLevel[1], 
        DiskBox[{41.4, -110.2}, 4.1]}, {
        EdgeForm[
         AbsoluteThickness[2]], 
        GrayLevel[1], 
        DiskBox[{41.4, -119.2}, 4.1]}, {
        EdgeForm[
         AbsoluteThickness[2]], 
        GrayLevel[1], 
        DiskBox[{41.4, -128.2}, 4.1]}, {
        EdgeForm[
         AbsoluteThickness[2]], 
        GrayLevel[1], 
        DiskBox[{41.4, -137.2}, 4.1]}, {
        EdgeForm[
         AbsoluteThickness[2]], 
        GrayLevel[1], 
        DiskBox[{41.4, -146.2}, 4.1]}}, {{
        EdgeForm[
         AbsoluteThickness[2]], 
        GrayLevel[1], 
        DiskBox[{50.4, -11.2}, 4.1]}, {
        EdgeForm[
         AbsoluteThickness[2]], 
        GrayLevel[1], 
        DiskBox[{50.4, -20.2}, 4.1]}, {
        EdgeForm[
         AbsoluteThickness[2]], 
        GrayLevel[1], 
        DiskBox[{50.4, -29.2}, 4.1]}, {
        EdgeForm[
         AbsoluteThickness[2]], 
        GrayLevel[1], 
        DiskBox[{50.4, -38.2}, 4.1]}, {
        EdgeForm[
         AbsoluteThickness[2]], 
        GrayLevel[1], 
        DiskBox[{50.4, -47.2}, 4.1]}, {
        EdgeForm[
         AbsoluteThickness[2]], 
        GrayLevel[1], 
        DiskBox[{50.4, -56.2}, 4.1]}, {
        EdgeForm[
         AbsoluteThickness[2]], 
        GrayLevel[1], 
        DiskBox[{50.4, -65.2}, 4.1]}, {
        EdgeForm[
         AbsoluteThickness[2]], 
        GrayLevel[1], 
        DiskBox[{50.4, -74.2}, 4.1]}, {
        EdgeForm[
         AbsoluteThickness[2]], 
        GrayLevel[1], 
        DiskBox[{50.4, -83.2}, 4.1]}, {
        EdgeForm[
         AbsoluteThickness[2]], 
        GrayLevel[1], 
        DiskBox[{50.4, -92.2}, 4.1]}, {
        EdgeForm[
         AbsoluteThickness[2]], 
        GrayLevel[1], 
        DiskBox[{50.4, -101.2}, 4.1]}, {
        EdgeForm[
         AbsoluteThickness[2]], 
        GrayLevel[1], 
        DiskBox[{50.4, -110.2}, 4.1]}, {
        EdgeForm[
         AbsoluteThickness[2]], 
        GrayLevel[1], 
        DiskBox[{50.4, -119.2}, 4.1]}, {
        EdgeForm[
         AbsoluteThickness[2]], 
        GrayLevel[1], 
        DiskBox[{50.4, -128.2}, 4.1]}, {
        EdgeForm[
         AbsoluteThickness[2]], 
        GrayLevel[1], 
        DiskBox[{50.4, -137.2}, 4.1]}, {
        EdgeForm[
         AbsoluteThickness[2]], 
        GrayLevel[1], 
        DiskBox[{50.4, -146.2}, 4.1]}}, {{
        EdgeForm[
         AbsoluteThickness[2]], 
        GrayLevel[1], 
        DiskBox[{59.4, -11.2}, 4.1]}, {
        EdgeForm[
         AbsoluteThickness[2]], 
        GrayLevel[1], 
        DiskBox[{59.4, -20.2}, 4.1]}, {
        EdgeForm[
         AbsoluteThickness[2]], 
        GrayLevel[1], 
        DiskBox[{59.4, -29.2}, 4.1]}, {
        EdgeForm[
         AbsoluteThickness[2]], 
        GrayLevel[1], 
        DiskBox[{59.4, -38.2}, 4.1]}, {
        EdgeForm[
         AbsoluteThickness[2]], 
        GrayLevel[1], 
        DiskBox[{59.4, -47.2}, 4.1]}, {
        EdgeForm[
         AbsoluteThickness[2]], 
        GrayLevel[1], 
        DiskBox[{59.4, -56.2}, 4.1]}, {
        EdgeForm[
         AbsoluteThickness[2]], 
        GrayLevel[1], 
        DiskBox[{59.4, -65.2}, 4.1]}, {
        EdgeForm[
         AbsoluteThickness[2]], 
        GrayLevel[1], 
        DiskBox[{59.4, -74.2}, 4.1]}, {
        EdgeForm[
         AbsoluteThickness[2]], 
        GrayLevel[1], 
        DiskBox[{59.4, -83.2}, 4.1]}, {
        EdgeForm[
         AbsoluteThickness[2]], 
        GrayLevel[1], 
        DiskBox[{59.4, -92.2}, 4.1]}, {
        EdgeForm[
         AbsoluteThickness[2]], 
        GrayLevel[1], 
        DiskBox[{59.4, -101.2}, 4.1]}, {
        EdgeForm[
         AbsoluteThickness[2]], 
        GrayLevel[1], 
        DiskBox[{59.4, -110.2}, 4.1]}, {
        EdgeForm[
         AbsoluteThickness[2]], 
        GrayLevel[1], 
        DiskBox[{59.4, -119.2}, 4.1]}, {
        EdgeForm[
         AbsoluteThickness[2]], 
        GrayLevel[1], 
        DiskBox[{59.4, -128.2}, 4.1]}, {
        EdgeForm[
         AbsoluteThickness[2]], 
        GrayLevel[1], 
        DiskBox[{59.4, -137.2}, 4.1]}, {
        EdgeForm[
         AbsoluteThickness[2]], 
        GrayLevel[1], 
        DiskBox[{59.4, -146.2}, 4.1]}}, {{
        EdgeForm[
         AbsoluteThickness[2]], 
        GrayLevel[1], 
        DiskBox[{68.4, -11.2}, 4.1]}, {
        EdgeForm[
         AbsoluteThickness[2]], 
        GrayLevel[1], 
        DiskBox[{68.4, -20.2}, 4.1]}, {
        EdgeForm[
         AbsoluteThickness[2]], 
        GrayLevel[1], 
        DiskBox[{68.4, -29.2}, 4.1]}, {
        EdgeForm[
         AbsoluteThickness[2]], 
        GrayLevel[1], 
        DiskBox[{68.4, -38.2}, 4.1]}, {
        EdgeForm[
         AbsoluteThickness[2]], 
        GrayLevel[1], 
        DiskBox[{68.4, -47.2}, 4.1]}, {
        EdgeForm[
         AbsoluteThickness[2]], 
        GrayLevel[1], 
        DiskBox[{68.4, -56.2}, 4.1]}, {
        EdgeForm[
         AbsoluteThickness[2]], 
        GrayLevel[1], 
        DiskBox[{68.4, -65.2}, 4.1]}, {
        EdgeForm[
         AbsoluteThickness[2]], 
        GrayLevel[1], 
        DiskBox[{68.4, -74.2}, 4.1]}, {
        EdgeForm[
         AbsoluteThickness[2]], 
        GrayLevel[1], 
        DiskBox[{68.4, -83.2}, 4.1]}, {
        EdgeForm[
         AbsoluteThickness[2]], 
        GrayLevel[1], 
        DiskBox[{68.4, -92.2}, 4.1]}, {
        EdgeForm[
         AbsoluteThickness[2]], 
        GrayLevel[1], 
        DiskBox[{68.4, -101.2}, 4.1]}, {
        EdgeForm[
         AbsoluteThickness[2]], 
        GrayLevel[1], 
        DiskBox[{68.4, -110.2}, 4.1]}, {
        EdgeForm[
         AbsoluteThickness[2]], 
        GrayLevel[1], 
        DiskBox[{68.4, -119.2}, 4.1]}, {
        EdgeForm[
         AbsoluteThickness[2]], 
        GrayLevel[1], 
        DiskBox[{68.4, -128.2}, 4.1]}, {
        EdgeForm[
         AbsoluteThickness[2]], 
        GrayLevel[1], 
        DiskBox[{68.4, -137.2}, 4.1]}, {
        EdgeForm[
         AbsoluteThickness[2]], 
        GrayLevel[1], 
        DiskBox[{68.4, -146.2}, 4.1]}}, {{
        EdgeForm[
         AbsoluteThickness[2]], 
        GrayLevel[1], 
        DiskBox[{77.4, -11.2}, 4.1]}, {
        EdgeForm[
         AbsoluteThickness[2]], 
        GrayLevel[1], 
        DiskBox[{77.4, -20.2}, 4.1]}, {
        EdgeForm[
         AbsoluteThickness[2]], 
        GrayLevel[1], 
        DiskBox[{77.4, -29.2}, 4.1]}, {
        EdgeForm[
         AbsoluteThickness[2]], 
        GrayLevel[1], 
        DiskBox[{77.4, -38.2}, 4.1]}, {
        EdgeForm[
         AbsoluteThickness[2]], 
        GrayLevel[1], 
        DiskBox[{77.4, -47.2}, 4.1]}, {
        EdgeForm[
         AbsoluteThickness[2]], 
        GrayLevel[1], 
        DiskBox[{77.4, -56.2}, 4.1]}, {
        EdgeForm[
         AbsoluteThickness[2]], 
        GrayLevel[1], 
        DiskBox[{77.4, -65.2}, 4.1]}, {
        EdgeForm[
         AbsoluteThickness[2]], 
        GrayLevel[1], 
        DiskBox[{77.4, -74.2}, 4.1]}, {
        EdgeForm[
         AbsoluteThickness[2]], 
        GrayLevel[1], 
        DiskBox[{77.4, -83.2}, 4.1]}, {
        EdgeForm[
         AbsoluteThickness[2]], 
        GrayLevel[1], 
        DiskBox[{77.4, -92.2}, 4.1]}, {
        EdgeForm[
         AbsoluteThickness[2]], 
        GrayLevel[1], 
        DiskBox[{77.4, -101.2}, 4.1]}, {
        EdgeForm[
         AbsoluteThickness[2]], 
        GrayLevel[1], 
        DiskBox[{77.4, -110.2}, 4.1]}, {
        EdgeForm[
         AbsoluteThickness[2]], 
        GrayLevel[1], 
        DiskBox[{77.4, -119.2}, 4.1]}, {
        EdgeForm[
         AbsoluteThickness[2]], 
        GrayLevel[1], 
        DiskBox[{77.4, -128.2}, 4.1]}, {
        EdgeForm[
         AbsoluteThickness[2]], 
        GrayLevel[1], 
        DiskBox[{77.4, -137.2}, 4.1]}, {
        EdgeForm[
         AbsoluteThickness[2]], 
        GrayLevel[1], 
        DiskBox[{77.4, -146.2}, 4.1]}}, {{
        EdgeForm[
         AbsoluteThickness[2]], 
        GrayLevel[1], 
        DiskBox[{86.4, -11.2}, 4.1]}, {
        EdgeForm[
         AbsoluteThickness[2]], 
        GrayLevel[1], 
        DiskBox[{86.4, -20.2}, 4.1]}, {
        EdgeForm[
         AbsoluteThickness[2]], 
        GrayLevel[1], 
        DiskBox[{86.4, -29.2}, 4.1]}, {
        EdgeForm[
         AbsoluteThickness[2]], 
        GrayLevel[1], 
        DiskBox[{86.4, -38.2}, 4.1]}, {
        EdgeForm[
         AbsoluteThickness[2]], 
        GrayLevel[1], 
        DiskBox[{86.4, -47.2}, 4.1]}, {
        EdgeForm[
         AbsoluteThickness[2]], 
        GrayLevel[1], 
        DiskBox[{86.4, -56.2}, 4.1]}, {
        EdgeForm[
         AbsoluteThickness[2]], 
        GrayLevel[1], 
        DiskBox[{86.4, -65.2}, 4.1]}, {
        EdgeForm[
         AbsoluteThickness[2]], 
        GrayLevel[1], 
        DiskBox[{86.4, -74.2}, 4.1]}, {
        EdgeForm[
         AbsoluteThickness[2]], 
        GrayLevel[1], 
        DiskBox[{86.4, -83.2}, 4.1]}, {
        EdgeForm[
         AbsoluteThickness[2]], 
        GrayLevel[1], 
        DiskBox[{86.4, -92.2}, 4.1]}, {
        EdgeForm[
         AbsoluteThickness[2]], 
        GrayLevel[1], 
        DiskBox[{86.4, -101.2}, 4.1]}, {
        EdgeForm[
         AbsoluteThickness[2]], 
        GrayLevel[1], 
        DiskBox[{86.4, -110.2}, 4.1]}, {
        EdgeForm[
         AbsoluteThickness[2]], 
        GrayLevel[1], 
        DiskBox[{86.4, -119.2}, 4.1]}, {
        EdgeForm[
         AbsoluteThickness[2]], 
        GrayLevel[1], 
        DiskBox[{86.4, -128.2}, 4.1]}, {
        EdgeForm[
         AbsoluteThickness[2]], 
        GrayLevel[1], 
        DiskBox[{86.4, -137.2}, 4.1]}, {
        EdgeForm[
         AbsoluteThickness[2]], 
        GrayLevel[1], 
        DiskBox[{86.4, -146.2}, 4.1]}}, {{
        EdgeForm[
         AbsoluteThickness[2]], 
        GrayLevel[1], 
        DiskBox[{95.4, -11.2}, 4.1]}, {
        EdgeForm[
         AbsoluteThickness[2]], 
        GrayLevel[1], 
        DiskBox[{95.4, -20.2}, 4.1]}, {
        EdgeForm[
         AbsoluteThickness[2]], 
        GrayLevel[1], 
        DiskBox[{95.4, -29.2}, 4.1]}, {
        EdgeForm[
         AbsoluteThickness[2]], 
        GrayLevel[1], 
        DiskBox[{95.4, -38.2}, 4.1]}, {
        EdgeForm[
         AbsoluteThickness[2]], 
        GrayLevel[1], 
        DiskBox[{95.4, -47.2}, 4.1]}, {
        EdgeForm[
         AbsoluteThickness[2]], 
        GrayLevel[1], 
        DiskBox[{95.4, -56.2}, 4.1]}, {
        EdgeForm[
         AbsoluteThickness[2]], 
        GrayLevel[1], 
        DiskBox[{95.4, -65.2}, 4.1]}, {
        EdgeForm[
         AbsoluteThickness[2]], 
        GrayLevel[1], 
        DiskBox[{95.4, -74.2}, 4.1]}, {
        EdgeForm[
         AbsoluteThickness[2]], 
        GrayLevel[1], 
        DiskBox[{95.4, -83.2}, 4.1]}, {
        EdgeForm[
         AbsoluteThickness[2]], 
        GrayLevel[1], 
        DiskBox[{95.4, -92.2}, 4.1]}, {
        EdgeForm[
         AbsoluteThickness[2]], 
        GrayLevel[1], 
        DiskBox[{95.4, -101.2}, 4.1]}, {
        EdgeForm[
         AbsoluteThickness[2]], 
        GrayLevel[1], 
        DiskBox[{95.4, -110.2}, 4.1]}, {
        EdgeForm[
         AbsoluteThickness[2]], 
        GrayLevel[1], 
        DiskBox[{95.4, -119.2}, 4.1]}, {
        EdgeForm[
         AbsoluteThickness[2]], 
        GrayLevel[1], 
        DiskBox[{95.4, -128.2}, 4.1]}, {
        EdgeForm[
         AbsoluteThickness[2]], 
        GrayLevel[1], 
        DiskBox[{95.4, -137.2}, 4.1]}, {
        EdgeForm[
         AbsoluteThickness[2]], 
        GrayLevel[1], 
        DiskBox[{95.4, -146.2}, 4.1]}}, {{
        EdgeForm[
         AbsoluteThickness[2]], 
        GrayLevel[1], 
        DiskBox[{104.4, -11.2}, 4.1]}, {
        EdgeForm[
         AbsoluteThickness[2]], 
        GrayLevel[1], 
        DiskBox[{104.4, -20.2}, 4.1]}, {
        EdgeForm[
         AbsoluteThickness[2]], 
        GrayLevel[1], 
        DiskBox[{104.4, -29.2}, 4.1]}, {
        EdgeForm[
         AbsoluteThickness[2]], 
        GrayLevel[1], 
        DiskBox[{104.4, -38.2}, 4.1]}, {
        EdgeForm[
         AbsoluteThickness[2]], 
        GrayLevel[1], 
        DiskBox[{104.4, -47.2}, 4.1]}, {
        EdgeForm[
         AbsoluteThickness[2]], 
        GrayLevel[1], 
        DiskBox[{104.4, -56.2}, 4.1]}, {
        EdgeForm[
         AbsoluteThickness[2]], 
        GrayLevel[1], 
        DiskBox[{104.4, -65.2}, 4.1]}, {
        EdgeForm[
         AbsoluteThickness[2]], 
        GrayLevel[1], 
        DiskBox[{104.4, -74.2}, 4.1]}, {
        EdgeForm[
         AbsoluteThickness[2]], 
        GrayLevel[1], 
        DiskBox[{104.4, -83.2}, 4.1]}, {
        EdgeForm[
         AbsoluteThickness[2]], 
        GrayLevel[1], 
        DiskBox[{104.4, -92.2}, 4.1]}, {
        EdgeForm[
         AbsoluteThickness[2]], 
        GrayLevel[1], 
        DiskBox[{104.4, -101.2}, 4.1]}, {
        EdgeForm[
         AbsoluteThickness[2]], 
        GrayLevel[1], 
        DiskBox[{104.4, -110.2}, 4.1]}, {
        EdgeForm[
         AbsoluteThickness[2]], 
        GrayLevel[1], 
        DiskBox[{104.4, -119.2}, 4.1]}, {
        EdgeForm[
         AbsoluteThickness[2]], 
        GrayLevel[1], 
        DiskBox[{104.4, -128.2}, 4.1]}, {
        EdgeForm[
         AbsoluteThickness[2]], 
        GrayLevel[1], 
        DiskBox[{104.4, -137.2}, 4.1]}, {
        EdgeForm[
         AbsoluteThickness[2]], 
        GrayLevel[1], 
        DiskBox[{104.4, -146.2}, 4.1]}}, {{
        EdgeForm[
         AbsoluteThickness[2]], 
        GrayLevel[1], 
        DiskBox[{113.4, -11.2}, 4.1]}, {
        EdgeForm[
         AbsoluteThickness[2]], 
        GrayLevel[1], 
        DiskBox[{113.4, -20.2}, 4.1]}, {
        EdgeForm[
         AbsoluteThickness[2]], 
        GrayLevel[1], 
        DiskBox[{113.4, -29.2}, 4.1]}, {
        EdgeForm[
         AbsoluteThickness[2]], 
        GrayLevel[1], 
        DiskBox[{113.4, -38.2}, 4.1]}, {
        EdgeForm[
         AbsoluteThickness[2]], 
        GrayLevel[1], 
        DiskBox[{113.4, -47.2}, 4.1]}, {
        EdgeForm[
         AbsoluteThickness[2]], 
        GrayLevel[1], 
        DiskBox[{113.4, -56.2}, 4.1]}, {
        EdgeForm[
         AbsoluteThickness[2]], 
        GrayLevel[1], 
        DiskBox[{113.4, -65.2}, 4.1]}, {
        EdgeForm[
         AbsoluteThickness[2]], 
        GrayLevel[1], 
        DiskBox[{113.4, -74.2}, 4.1]}, {
        EdgeForm[
         AbsoluteThickness[2]], 
        GrayLevel[1], 
        DiskBox[{113.4, -83.2}, 4.1]}, {
        EdgeForm[
         AbsoluteThickness[2]], 
        GrayLevel[1], 
        DiskBox[{113.4, -92.2}, 4.1]}, {
        EdgeForm[
         AbsoluteThickness[2]], 
        GrayLevel[1], 
        DiskBox[{113.4, -101.2}, 4.1]}, {
        EdgeForm[
         AbsoluteThickness[2]], 
        GrayLevel[1], 
        DiskBox[{113.4, -110.2}, 4.1]}, {
        EdgeForm[
         AbsoluteThickness[2]], 
        GrayLevel[1], 
        DiskBox[{113.4, -119.2}, 4.1]}, {
        EdgeForm[
         AbsoluteThickness[2]], 
        GrayLevel[1], 
        DiskBox[{113.4, -128.2}, 4.1]}, {
        EdgeForm[
         AbsoluteThickness[2]], 
        GrayLevel[1], 
        DiskBox[{113.4, -137.2}, 4.1]}, {
        EdgeForm[
         AbsoluteThickness[2]], 
        GrayLevel[1], 
        DiskBox[{113.4, -146.2}, 4.1]}}, {{
        EdgeForm[
         AbsoluteThickness[2]], 
        GrayLevel[1], 
        DiskBox[{122.4, -11.2}, 4.1]}, {
        EdgeForm[
         AbsoluteThickness[2]], 
        GrayLevel[1], 
        DiskBox[{122.4, -20.2}, 4.1]}, {
        EdgeForm[
         AbsoluteThickness[2]], 
        GrayLevel[1], 
        DiskBox[{122.4, -29.2}, 4.1]}, {
        EdgeForm[
         AbsoluteThickness[2]], 
        GrayLevel[1], 
        DiskBox[{122.4, -38.2}, 4.1]}, {
        EdgeForm[
         AbsoluteThickness[2]], 
        GrayLevel[1], 
        DiskBox[{122.4, -47.2}, 4.1]}, {
        EdgeForm[
         AbsoluteThickness[2]], 
        GrayLevel[1], 
        DiskBox[{122.4, -56.2}, 4.1]}, {
        EdgeForm[
         AbsoluteThickness[2]], 
        GrayLevel[1], 
        DiskBox[{122.4, -65.2}, 4.1]}, {
        EdgeForm[
         AbsoluteThickness[2]], 
        GrayLevel[1], 
        DiskBox[{122.4, -74.2}, 4.1]}, {
        EdgeForm[
         AbsoluteThickness[2]], 
        GrayLevel[1], 
        DiskBox[{122.4, -83.2}, 4.1]}, {
        EdgeForm[
         AbsoluteThickness[2]], 
        GrayLevel[1], 
        DiskBox[{122.4, -92.2}, 4.1]}, {
        EdgeForm[
         AbsoluteThickness[2]], 
        GrayLevel[1], 
        DiskBox[{122.4, -101.2}, 4.1]}, {
        EdgeForm[
         AbsoluteThickness[2]], 
        GrayLevel[1], 
        DiskBox[{122.4, -110.2}, 4.1]}, {
        EdgeForm[
         AbsoluteThickness[2]], 
        GrayLevel[1], 
        DiskBox[{122.4, -119.2}, 4.1]}, {
        EdgeForm[
         AbsoluteThickness[2]], 
        GrayLevel[1], 
        DiskBox[{122.4, -128.2}, 4.1]}, {
        EdgeForm[
         AbsoluteThickness[2]], 
        GrayLevel[1], 
        DiskBox[{122.4, -137.2}, 4.1]}, {
        EdgeForm[
         AbsoluteThickness[2]], 
        GrayLevel[1], 
        DiskBox[{122.4, -146.2}, 4.1]}}, {{
        EdgeForm[
         AbsoluteThickness[2]], 
        GrayLevel[1], 
        DiskBox[{131.4, -11.2}, 4.1]}, {
        EdgeForm[
         AbsoluteThickness[2]], 
        GrayLevel[1], 
        DiskBox[{131.4, -20.2}, 4.1]}, {
        EdgeForm[
         AbsoluteThickness[2]], 
        GrayLevel[1], 
        DiskBox[{131.4, -29.2}, 4.1]}, {
        EdgeForm[
         AbsoluteThickness[2]], 
        GrayLevel[1], 
        DiskBox[{131.4, -38.2}, 4.1]}, {
        EdgeForm[
         AbsoluteThickness[2]], 
        GrayLevel[1], 
        DiskBox[{131.4, -47.2}, 4.1]}, {
        EdgeForm[
         AbsoluteThickness[2]], 
        GrayLevel[1], 
        DiskBox[{131.4, -56.2}, 4.1]}, {
        EdgeForm[
         AbsoluteThickness[2]], 
        GrayLevel[1], 
        DiskBox[{131.4, -65.2}, 4.1]}, {
        EdgeForm[
         AbsoluteThickness[2]], 
        GrayLevel[1], 
        DiskBox[{131.4, -74.2}, 4.1]}, {
        EdgeForm[
         AbsoluteThickness[2]], 
        GrayLevel[1], 
        DiskBox[{131.4, -83.2}, 4.1]}, {
        EdgeForm[
         AbsoluteThickness[2]], 
        GrayLevel[1], 
        DiskBox[{131.4, -92.2}, 4.1]}, {
        EdgeForm[
         AbsoluteThickness[2]], 
        GrayLevel[1], 
        DiskBox[{131.4, -101.2}, 4.1]}, {
        EdgeForm[
         AbsoluteThickness[2]], 
        GrayLevel[1], 
        DiskBox[{131.4, -110.2}, 4.1]}, {
        EdgeForm[
         AbsoluteThickness[2]], 
        GrayLevel[1], 
        DiskBox[{131.4, -119.2}, 4.1]}, {
        EdgeForm[
         AbsoluteThickness[2]], 
        GrayLevel[1], 
        DiskBox[{131.4, -128.2}, 4.1]}, {
        EdgeForm[
         AbsoluteThickness[2]], 
        GrayLevel[1], 
        DiskBox[{131.4, -137.2}, 4.1]}, {
        EdgeForm[
         AbsoluteThickness[2]], 
        GrayLevel[1], 
        DiskBox[{131.4, -146.2}, 4.1]}}, {{
        EdgeForm[
         AbsoluteThickness[2]], 
        GrayLevel[1], 
        DiskBox[{140.4, -11.2}, 4.1]}, {
        EdgeForm[
         AbsoluteThickness[2]], 
        GrayLevel[1], 
        DiskBox[{140.4, -20.2}, 4.1]}, {
        EdgeForm[
         AbsoluteThickness[2]], 
        GrayLevel[1], 
        DiskBox[{140.4, -29.2}, 4.1]}, {
        EdgeForm[
         AbsoluteThickness[2]], 
        GrayLevel[1], 
        DiskBox[{140.4, -38.2}, 4.1]}, {
        EdgeForm[
         AbsoluteThickness[2]], 
        GrayLevel[1], 
        DiskBox[{140.4, -47.2}, 4.1]}, {
        EdgeForm[
         AbsoluteThickness[2]], 
        GrayLevel[1], 
        DiskBox[{140.4, -56.2}, 4.1]}, {
        EdgeForm[
         AbsoluteThickness[2]], 
        GrayLevel[1], 
        DiskBox[{140.4, -65.2}, 4.1]}, {
        EdgeForm[
         AbsoluteThickness[2]], 
        GrayLevel[1], 
        DiskBox[{140.4, -74.2}, 4.1]}, {
        EdgeForm[
         AbsoluteThickness[2]], 
        GrayLevel[1], 
        DiskBox[{140.4, -83.2}, 4.1]}, {
        EdgeForm[
         AbsoluteThickness[2]], 
        GrayLevel[1], 
        DiskBox[{140.4, -92.2}, 4.1]}, {
        EdgeForm[
         AbsoluteThickness[2]], 
        GrayLevel[1], 
        DiskBox[{140.4, -101.2}, 4.1]}, {
        EdgeForm[
         AbsoluteThickness[2]], 
        GrayLevel[1], 
        DiskBox[{140.4, -110.2}, 4.1]}, {
        EdgeForm[
         AbsoluteThickness[2]], 
        GrayLevel[1], 
        DiskBox[{140.4, -119.2}, 4.1]}, {
        EdgeForm[
         AbsoluteThickness[2]], 
        GrayLevel[1], 
        DiskBox[{140.4, -128.2}, 4.1]}, {
        EdgeForm[
         AbsoluteThickness[2]], 
        GrayLevel[1], 
        DiskBox[{140.4, -137.2}, 4.1]}, {
        EdgeForm[
         AbsoluteThickness[2]], 
        GrayLevel[1], 
        DiskBox[{140.4, -146.2}, 4.1]}}, {{
        EdgeForm[
         AbsoluteThickness[2]], 
        GrayLevel[1], 
        DiskBox[{149.4, -11.2}, 4.1]}, {
        EdgeForm[
         AbsoluteThickness[2]], 
        GrayLevel[1], 
        DiskBox[{149.4, -20.2}, 4.1]}, {
        EdgeForm[
         AbsoluteThickness[2]], 
        GrayLevel[1], 
        DiskBox[{149.4, -29.2}, 4.1]}, {
        EdgeForm[
         AbsoluteThickness[2]], 
        GrayLevel[1], 
        DiskBox[{149.4, -38.2}, 4.1]}, {
        EdgeForm[
         AbsoluteThickness[2]], 
        GrayLevel[1], 
        DiskBox[{149.4, -47.2}, 4.1]}, {
        EdgeForm[
         AbsoluteThickness[2]], 
        GrayLevel[1], 
        DiskBox[{149.4, -56.2}, 4.1]}, {
        EdgeForm[
         AbsoluteThickness[2]], 
        GrayLevel[1], 
        DiskBox[{149.4, -65.2}, 4.1]}, {
        EdgeForm[
         AbsoluteThickness[2]], 
        GrayLevel[1], 
        DiskBox[{149.4, -74.2}, 4.1]}, {
        EdgeForm[
         AbsoluteThickness[2]], 
        GrayLevel[1], 
        DiskBox[{149.4, -83.2}, 4.1]}, {
        EdgeForm[
         AbsoluteThickness[2]], 
        GrayLevel[1], 
        DiskBox[{149.4, -92.2}, 4.1]}, {
        EdgeForm[
         AbsoluteThickness[2]], 
        GrayLevel[1], 
        DiskBox[{149.4, -101.2}, 4.1]}, {
        EdgeForm[
         AbsoluteThickness[2]], 
        GrayLevel[1], 
        DiskBox[{149.4, -110.2}, 4.1]}, {
        EdgeForm[
         AbsoluteThickness[2]], 
        GrayLevel[1], 
        DiskBox[{149.4, -119.2}, 4.1]}, {
        EdgeForm[
         AbsoluteThickness[2]], 
        GrayLevel[1], 
        DiskBox[{149.4, -128.2}, 4.1]}, {
        EdgeForm[
         AbsoluteThickness[2]], 
        GrayLevel[1], 
        DiskBox[{149.4, -137.2}, 4.1]}, {
        EdgeForm[
         AbsoluteThickness[2]], 
        GrayLevel[1], 
        DiskBox[{149.4, -146.2}, 4.1]}}, {{
        EdgeForm[
         AbsoluteThickness[2]], 
        GrayLevel[1], 
        DiskBox[{158.4, -11.2}, 4.1]}, {
        EdgeForm[
         AbsoluteThickness[2]], 
        GrayLevel[1], 
        DiskBox[{158.4, -20.2}, 4.1]}, {
        EdgeForm[
         AbsoluteThickness[2]], 
        GrayLevel[1], 
        DiskBox[{158.4, -29.2}, 4.1]}, {
        EdgeForm[
         AbsoluteThickness[2]], 
        GrayLevel[1], 
        DiskBox[{158.4, -38.2}, 4.1]}, {
        EdgeForm[
         AbsoluteThickness[2]], 
        GrayLevel[1], 
        DiskBox[{158.4, -47.2}, 4.1]}, {
        EdgeForm[
         AbsoluteThickness[2]], 
        GrayLevel[1], 
        DiskBox[{158.4, -56.2}, 4.1]}, {
        EdgeForm[
         AbsoluteThickness[2]], 
        GrayLevel[1], 
        DiskBox[{158.4, -65.2}, 4.1]}, {
        EdgeForm[
         AbsoluteThickness[2]], 
        GrayLevel[1], 
        DiskBox[{158.4, -74.2}, 4.1]}, {
        EdgeForm[
         AbsoluteThickness[2]], 
        GrayLevel[1], 
        DiskBox[{158.4, -83.2}, 4.1]}, {
        EdgeForm[
         AbsoluteThickness[2]], 
        GrayLevel[1], 
        DiskBox[{158.4, -92.2}, 4.1]}, {
        EdgeForm[
         AbsoluteThickness[2]], 
        GrayLevel[1], 
        DiskBox[{158.4, -101.2}, 4.1]}, {
        EdgeForm[
         AbsoluteThickness[2]], 
        GrayLevel[1], 
        DiskBox[{158.4, -110.2}, 4.1]}, {
        EdgeForm[
         AbsoluteThickness[2]], 
        GrayLevel[1], 
        DiskBox[{158.4, -119.2}, 4.1]}, {
        EdgeForm[
         AbsoluteThickness[2]], 
        GrayLevel[1], 
        DiskBox[{158.4, -128.2}, 4.1]}, {
        EdgeForm[
         AbsoluteThickness[2]], 
        GrayLevel[1], 
        DiskBox[{158.4, -137.2}, 4.1]}, {
        EdgeForm[
         AbsoluteThickness[2]], 
        GrayLevel[1], 
        DiskBox[{158.4, -146.2}, 4.1]}}, {{
        EdgeForm[
         AbsoluteThickness[2]], 
        GrayLevel[1], 
        DiskBox[{167.4, -11.2}, 4.1]}, {
        EdgeForm[
         AbsoluteThickness[2]], 
        GrayLevel[1], 
        DiskBox[{167.4, -20.2}, 4.1]}, {
        EdgeForm[
         AbsoluteThickness[2]], 
        GrayLevel[1], 
        DiskBox[{167.4, -29.2}, 4.1]}, {
        EdgeForm[
         AbsoluteThickness[2]], 
        GrayLevel[1], 
        DiskBox[{167.4, -38.2}, 4.1]}, {
        EdgeForm[
         AbsoluteThickness[2]], 
        GrayLevel[1], 
        DiskBox[{167.4, -47.2}, 4.1]}, {
        EdgeForm[
         AbsoluteThickness[2]], 
        GrayLevel[1], 
        DiskBox[{167.4, -56.2}, 4.1]}, {
        EdgeForm[
         AbsoluteThickness[2]], 
        GrayLevel[1], 
        DiskBox[{167.4, -65.2}, 4.1]}, {
        EdgeForm[
         AbsoluteThickness[2]], 
        GrayLevel[1], 
        DiskBox[{167.4, -74.2}, 4.1]}, {
        EdgeForm[
         AbsoluteThickness[2]], 
        GrayLevel[1], 
        DiskBox[{167.4, -83.2}, 4.1]}, {
        EdgeForm[
         AbsoluteThickness[2]], 
        GrayLevel[1], 
        DiskBox[{167.4, -92.2}, 4.1]}, {
        EdgeForm[
         AbsoluteThickness[2]], 
        GrayLevel[1], 
        DiskBox[{167.4, -101.2}, 4.1]}, {
        EdgeForm[
         AbsoluteThickness[2]], 
        GrayLevel[1], 
        DiskBox[{167.4, -110.2}, 4.1]}, {
        EdgeForm[
         AbsoluteThickness[2]], 
        GrayLevel[1], 
        DiskBox[{167.4, -119.2}, 4.1]}, {
        EdgeForm[
         AbsoluteThickness[2]], 
        GrayLevel[1], 
        DiskBox[{167.4, -128.2}, 4.1]}, {
        EdgeForm[
         AbsoluteThickness[2]], 
        GrayLevel[1], 
        DiskBox[{167.4, -137.2}, 4.1]}, {
        EdgeForm[
         AbsoluteThickness[2]], 
        GrayLevel[1], 
        DiskBox[{167.4, -146.2}, 4.1]}}, {{
        EdgeForm[
         AbsoluteThickness[2]], 
        GrayLevel[1], 
        DiskBox[{176.4, -11.2}, 4.1]}, {
        EdgeForm[
         AbsoluteThickness[2]], 
        GrayLevel[1], 
        DiskBox[{176.4, -20.2}, 4.1]}, {
        EdgeForm[
         AbsoluteThickness[2]], 
        GrayLevel[1], 
        DiskBox[{176.4, -29.2}, 4.1]}, {
        EdgeForm[
         AbsoluteThickness[2]], 
        GrayLevel[1], 
        DiskBox[{176.4, -38.2}, 4.1]}, {
        EdgeForm[
         AbsoluteThickness[2]], 
        GrayLevel[1], 
        DiskBox[{176.4, -47.2}, 4.1]}, {
        EdgeForm[
         AbsoluteThickness[2]], 
        GrayLevel[1], 
        DiskBox[{176.4, -56.2}, 4.1]}, {
        EdgeForm[
         AbsoluteThickness[2]], 
        GrayLevel[1], 
        DiskBox[{176.4, -65.2}, 4.1]}, {
        EdgeForm[
         AbsoluteThickness[2]], 
        GrayLevel[1], 
        DiskBox[{176.4, -74.2}, 4.1]}, {
        EdgeForm[
         AbsoluteThickness[2]], 
        GrayLevel[1], 
        DiskBox[{176.4, -83.2}, 4.1]}, {
        EdgeForm[
         AbsoluteThickness[2]], 
        GrayLevel[1], 
        DiskBox[{176.4, -92.2}, 4.1]}, {
        EdgeForm[
         AbsoluteThickness[2]], 
        GrayLevel[1], 
        DiskBox[{176.4, -101.2}, 4.1]}, {
        EdgeForm[
         AbsoluteThickness[2]], 
        GrayLevel[1], 
        DiskBox[{176.4, -110.2}, 4.1]}, {
        EdgeForm[
         AbsoluteThickness[2]], 
        GrayLevel[1], 
        DiskBox[{176.4, -119.2}, 4.1]}, {
        EdgeForm[
         AbsoluteThickness[2]], 
        GrayLevel[1], 
        DiskBox[{176.4, -128.2}, 4.1]}, {
        EdgeForm[
         AbsoluteThickness[2]], 
        GrayLevel[1], 
        DiskBox[{176.4, -137.2}, 4.1]}, {
        EdgeForm[
         AbsoluteThickness[2]], 
        GrayLevel[1], 
        DiskBox[{176.4, -146.2}, 4.1]}}, {{
        EdgeForm[
         AbsoluteThickness[2]], 
        GrayLevel[1], 
        DiskBox[{185.4, -11.2}, 4.1]}, {
        EdgeForm[
         AbsoluteThickness[2]], 
        GrayLevel[1], 
        DiskBox[{185.4, -20.2}, 4.1]}, {
        EdgeForm[
         AbsoluteThickness[2]], 
        GrayLevel[1], 
        DiskBox[{185.4, -29.2}, 4.1]}, {
        EdgeForm[
         AbsoluteThickness[2]], 
        GrayLevel[1], 
        DiskBox[{185.4, -38.2}, 4.1]}, {
        EdgeForm[
         AbsoluteThickness[2]], 
        GrayLevel[1], 
        DiskBox[{185.4, -47.2}, 4.1]}, {
        EdgeForm[
         AbsoluteThickness[2]], 
        GrayLevel[1], 
        DiskBox[{185.4, -56.2}, 4.1]}, {
        EdgeForm[
         AbsoluteThickness[2]], 
        GrayLevel[1], 
        DiskBox[{185.4, -65.2}, 4.1]}, {
        EdgeForm[
         AbsoluteThickness[2]], 
        GrayLevel[1], 
        DiskBox[{185.4, -74.2}, 4.1]}, {
        EdgeForm[
         AbsoluteThickness[2]], 
        GrayLevel[1], 
        DiskBox[{185.4, -83.2}, 4.1]}, {
        EdgeForm[
         AbsoluteThickness[2]], 
        GrayLevel[1], 
        DiskBox[{185.4, -92.2}, 4.1]}, {
        EdgeForm[
         AbsoluteThickness[2]], 
        GrayLevel[1], 
        DiskBox[{185.4, -101.2}, 4.1]}, {
        EdgeForm[
         AbsoluteThickness[2]], 
        GrayLevel[1], 
        DiskBox[{185.4, -110.2}, 4.1]}, {
        EdgeForm[
         AbsoluteThickness[2]], 
        GrayLevel[1], 
        DiskBox[{185.4, -119.2}, 4.1]}, {
        EdgeForm[
         AbsoluteThickness[2]], 
        GrayLevel[1], 
        DiskBox[{185.4, -128.2}, 4.1]}, {
        EdgeForm[
         AbsoluteThickness[2]], 
        GrayLevel[1], 
        DiskBox[{185.4, -137.2}, 4.1]}, {
        EdgeForm[
         AbsoluteThickness[2]], 
        GrayLevel[1], 
        DiskBox[{185.4, -146.2}, 4.1]}}, {{
        EdgeForm[
         AbsoluteThickness[2]], 
        GrayLevel[1], 
        DiskBox[{194.4, -11.2}, 4.1]}, {
        EdgeForm[
         AbsoluteThickness[2]], 
        GrayLevel[1], 
        DiskBox[{194.4, -20.2}, 4.1]}, {
        EdgeForm[
         AbsoluteThickness[2]], 
        GrayLevel[1], 
        DiskBox[{194.4, -29.2}, 4.1]}, {
        EdgeForm[
         AbsoluteThickness[2]], 
        GrayLevel[1], 
        DiskBox[{194.4, -38.2}, 4.1]}, {
        EdgeForm[
         AbsoluteThickness[2]], 
        GrayLevel[1], 
        DiskBox[{194.4, -47.2}, 4.1]}, {
        EdgeForm[
         AbsoluteThickness[2]], 
        GrayLevel[1], 
        DiskBox[{194.4, -56.2}, 4.1]}, {
        EdgeForm[
         AbsoluteThickness[2]], 
        GrayLevel[1], 
        DiskBox[{194.4, -65.2}, 4.1]}, {
        EdgeForm[
         AbsoluteThickness[2]], 
        GrayLevel[1], 
        DiskBox[{194.4, -74.2}, 4.1]}, {
        EdgeForm[
         AbsoluteThickness[2]], 
        GrayLevel[1], 
        DiskBox[{194.4, -83.2}, 4.1]}, {
        EdgeForm[
         AbsoluteThickness[2]], 
        GrayLevel[1], 
        DiskBox[{194.4, -92.2}, 4.1]}, {
        EdgeForm[
         AbsoluteThickness[2]], 
        GrayLevel[1], 
        DiskBox[{194.4, -101.2}, 4.1]}, {
        EdgeForm[
         AbsoluteThickness[2]], 
        GrayLevel[1], 
        DiskBox[{194.4, -110.2}, 4.1]}, {
        EdgeForm[
         AbsoluteThickness[2]], 
        GrayLevel[1], 
        DiskBox[{194.4, -119.2}, 4.1]}, {
        EdgeForm[
         AbsoluteThickness[2]], 
        GrayLevel[1], 
        DiskBox[{194.4, -128.2}, 4.1]}, {
        EdgeForm[
         AbsoluteThickness[2]], 
        GrayLevel[1], 
        DiskBox[{194.4, -137.2}, 4.1]}, {
        EdgeForm[
         AbsoluteThickness[2]], 
        GrayLevel[1], 
        DiskBox[{194.4, -146.2}, 4.1]}}, {{
        EdgeForm[
         AbsoluteThickness[2]], 
        GrayLevel[1], 
        DiskBox[{203.4, -11.2}, 4.1]}, {
        EdgeForm[
         AbsoluteThickness[2]], 
        GrayLevel[1], 
        DiskBox[{203.4, -20.2}, 4.1]}, {
        EdgeForm[
         AbsoluteThickness[2]], 
        GrayLevel[1], 
        DiskBox[{203.4, -29.2}, 4.1]}, {
        EdgeForm[
         AbsoluteThickness[2]], 
        GrayLevel[1], 
        DiskBox[{203.4, -38.2}, 4.1]}, {
        EdgeForm[
         AbsoluteThickness[2]], 
        GrayLevel[1], 
        DiskBox[{203.4, -47.2}, 4.1]}, {
        EdgeForm[
         AbsoluteThickness[2]], 
        GrayLevel[1], 
        DiskBox[{203.4, -56.2}, 4.1]}, {
        EdgeForm[
         AbsoluteThickness[2]], 
        GrayLevel[1], 
        DiskBox[{203.4, -65.2}, 4.1]}, {
        EdgeForm[
         AbsoluteThickness[2]], 
        GrayLevel[1], 
        DiskBox[{203.4, -74.2}, 4.1]}, {
        EdgeForm[
         AbsoluteThickness[2]], 
        GrayLevel[1], 
        DiskBox[{203.4, -83.2}, 4.1]}, {
        EdgeForm[
         AbsoluteThickness[2]], 
        GrayLevel[1], 
        DiskBox[{203.4, -92.2}, 4.1]}, {
        EdgeForm[
         AbsoluteThickness[2]], 
        GrayLevel[1], 
        DiskBox[{203.4, -101.2}, 4.1]}, {
        EdgeForm[
         AbsoluteThickness[2]], 
        GrayLevel[1], 
        DiskBox[{203.4, -110.2}, 4.1]}, {
        EdgeForm[
         AbsoluteThickness[2]], 
        GrayLevel[1], 
        DiskBox[{203.4, -119.2}, 4.1]}, {
        EdgeForm[
         AbsoluteThickness[2]], 
        GrayLevel[1], 
        DiskBox[{203.4, -128.2}, 4.1]}, {
        EdgeForm[
         AbsoluteThickness[2]], 
        GrayLevel[1], 
        DiskBox[{203.4, -137.2}, 4.1]}, {
        EdgeForm[
         AbsoluteThickness[2]], 
        GrayLevel[1], 
        DiskBox[{203.4, -146.2}, 4.1]}}, {{
        EdgeForm[
         AbsoluteThickness[2]], 
        GrayLevel[1], 
        DiskBox[{212.4, -11.2}, 4.1]}, {
        EdgeForm[
         AbsoluteThickness[2]], 
        GrayLevel[1], 
        DiskBox[{212.4, -20.2}, 4.1]}, {
        EdgeForm[
         AbsoluteThickness[2]], 
        GrayLevel[1], 
        DiskBox[{212.4, -29.2}, 4.1]}, {
        EdgeForm[
         AbsoluteThickness[2]], 
        GrayLevel[1], 
        DiskBox[{212.4, -38.2}, 4.1]}, {
        EdgeForm[
         AbsoluteThickness[2]], 
        GrayLevel[1], 
        DiskBox[{212.4, -47.2}, 4.1]}, {
        EdgeForm[
         AbsoluteThickness[2]], 
        GrayLevel[1], 
        DiskBox[{212.4, -56.2}, 4.1]}, {
        EdgeForm[
         AbsoluteThickness[2]], 
        GrayLevel[1], 
        DiskBox[{212.4, -65.2}, 4.1]}, {
        EdgeForm[
         AbsoluteThickness[2]], 
        GrayLevel[1], 
        DiskBox[{212.4, -74.2}, 4.1]}, {
        EdgeForm[
         AbsoluteThickness[2]], 
        GrayLevel[1], 
        DiskBox[{212.4, -83.2}, 4.1]}, {
        EdgeForm[
         AbsoluteThickness[2]], 
        GrayLevel[1], 
        DiskBox[{212.4, -92.2}, 4.1]}, {
        EdgeForm[
         AbsoluteThickness[2]], 
        GrayLevel[1], 
        DiskBox[{212.4, -101.2}, 4.1]}, {
        EdgeForm[
         AbsoluteThickness[2]], 
        GrayLevel[1], 
        DiskBox[{212.4, -110.2}, 4.1]}, {
        EdgeForm[
         AbsoluteThickness[2]], 
        GrayLevel[1], 
        DiskBox[{212.4, -119.2}, 4.1]}, {
        EdgeForm[
         AbsoluteThickness[2]], 
        GrayLevel[1], 
        DiskBox[{212.4, -128.2}, 4.1]}, {
        EdgeForm[
         AbsoluteThickness[2]], 
        GrayLevel[1], 
        DiskBox[{212.4, -137.2}, 4.1]}, {
        EdgeForm[
         AbsoluteThickness[2]], 
        GrayLevel[1], 
        DiskBox[{212.4, -146.2}, 4.1]}}, {{
        EdgeForm[
         AbsoluteThickness[2]], 
        GrayLevel[1], 
        DiskBox[{221.4, -11.2}, 4.1]}, {
        EdgeForm[
         AbsoluteThickness[2]], 
        GrayLevel[1], 
        DiskBox[{221.4, -20.2}, 4.1]}, {
        EdgeForm[
         AbsoluteThickness[2]], 
        GrayLevel[1], 
        DiskBox[{221.4, -29.2}, 4.1]}, {
        EdgeForm[
         AbsoluteThickness[2]], 
        GrayLevel[1], 
        DiskBox[{221.4, -38.2}, 4.1]}, {
        EdgeForm[
         AbsoluteThickness[2]], 
        GrayLevel[1], 
        DiskBox[{221.4, -47.2}, 4.1]}, {
        EdgeForm[
         AbsoluteThickness[2]], 
        GrayLevel[1], 
        DiskBox[{221.4, -56.2}, 4.1]}, {
        EdgeForm[
         AbsoluteThickness[2]], 
        GrayLevel[1], 
        DiskBox[{221.4, -65.2}, 4.1]}, {
        EdgeForm[
         AbsoluteThickness[2]], 
        GrayLevel[1], 
        DiskBox[{221.4, -74.2}, 4.1]}, {
        EdgeForm[
         AbsoluteThickness[2]], 
        GrayLevel[1], 
        DiskBox[{221.4, -83.2}, 4.1]}, {
        EdgeForm[
         AbsoluteThickness[2]], 
        GrayLevel[1], 
        DiskBox[{221.4, -92.2}, 4.1]}, {
        EdgeForm[
         AbsoluteThickness[2]], 
        GrayLevel[1], 
        DiskBox[{221.4, -101.2}, 4.1]}, {
        EdgeForm[
         AbsoluteThickness[2]], 
        GrayLevel[1], 
        DiskBox[{221.4, -110.2}, 4.1]}, {
        EdgeForm[
         AbsoluteThickness[2]], 
        GrayLevel[1], 
        DiskBox[{221.4, -119.2}, 4.1]}, {
        EdgeForm[
         AbsoluteThickness[2]], 
        GrayLevel[1], 
        DiskBox[{221.4, -128.2}, 4.1]}, {
        EdgeForm[
         AbsoluteThickness[2]], 
        GrayLevel[1], 
        DiskBox[{221.4, -137.2}, 4.1]}, {
        EdgeForm[
         AbsoluteThickness[2]], 
        GrayLevel[1], 
        DiskBox[{221.4, -146.2}, 4.1]}}}, {{
       EdgeForm[
        AbsoluteThickness[2]], 
       RGBColor[0.8570441666666667, 0.6373188333333333, 0.8020406666666666], 
       DiskBox[{68.4, -92.2}, 4.1]}, {
       EdgeForm[
        AbsoluteThickness[2]], 
       RGBColor[0.8570441666666667, 0.6373188333333333, 0.8020406666666666], 
       DiskBox[{95.4, -20.2}, 4.1]}, {
       EdgeForm[
        AbsoluteThickness[2]], 
       RGBColor[0.8570441666666667, 0.6373188333333333, 0.8020406666666666], 
       DiskBox[{95.4, -83.2}, 4.1]}, {
       EdgeForm[
        AbsoluteThickness[2]], 
       RGBColor[0.8570441666666667, 0.6373188333333333, 0.8020406666666666], 
       DiskBox[{95.4, -65.2}, 4.1]}, {
       EdgeForm[
        AbsoluteThickness[2]], 
       RGBColor[0.8570441666666667, 0.6373188333333333, 0.8020406666666666], 
       DiskBox[{158.4, -83.2}, 4.1]}, {
       EdgeForm[
        AbsoluteThickness[2]], 
       RGBColor[0.8570441666666667, 0.6373188333333333, 0.8020406666666666], 
       DiskBox[{14.4, -56.2}, 4.1]}, {
       EdgeForm[
        AbsoluteThickness[2]], 
       RGBColor[0.8570441666666667, 0.6373188333333333, 0.8020406666666666], 
       DiskBox[{95.4, -38.2}, 4.1]}, {
       EdgeForm[
        AbsoluteThickness[2]], 
       RGBColor[0.8570441666666667, 0.6373188333333333, 0.8020406666666666], 
       DiskBox[{50.4, -20.2}, 4.1]}, {
       EdgeForm[
        AbsoluteThickness[2]], 
       RGBColor[0.8570441666666667, 0.6373188333333333, 0.8020406666666666], 
       DiskBox[{149.4, -83.2}, 4.1]}, {
       EdgeForm[
        AbsoluteThickness[2]], 
       RGBColor[0.8570441666666667, 0.6373188333333333, 0.8020406666666666], 
       DiskBox[{59.4, -83.2}, 4.1]}, {
       EdgeForm[
        AbsoluteThickness[2]], 
       RGBColor[0.8570441666666667, 0.6373188333333333, 0.8020406666666666], 
       DiskBox[{32.4, -101.2}, 4.1]}, {
       EdgeForm[
        AbsoluteThickness[2]], 
       RGBColor[0.8570441666666667, 0.6373188333333333, 0.8020406666666666], 
       DiskBox[{77.4, -29.2}, 4.1]}, {
       EdgeForm[
        AbsoluteThickness[2]], 
       RGBColor[0.8570441666666667, 0.6373188333333333, 0.8020406666666666], 
       DiskBox[{23.4, -47.2}, 4.1]}, {
       EdgeForm[
        AbsoluteThickness[2]], 
       RGBColor[0.8570441666666667, 0.6373188333333333, 0.8020406666666666], 
       DiskBox[{95.4, -74.2}, 4.1]}, {
       EdgeForm[
        AbsoluteThickness[2]], 
       RGBColor[0.8570441666666667, 0.6373188333333333, 0.8020406666666666], 
       DiskBox[{14.4, -47.2}, 4.1]}, {
       EdgeForm[
        AbsoluteThickness[2]], 
       RGBColor[0.8570441666666667, 0.6373188333333333, 0.8020406666666666], 
       DiskBox[{23.4, -38.2}, 4.1]}, {
       EdgeForm[
        AbsoluteThickness[2]], 
       RGBColor[0.8570441666666667, 0.6373188333333333, 0.8020406666666666], 
       DiskBox[{50.4, -92.2}, 4.1]}, {
       EdgeForm[
        AbsoluteThickness[2]], 
       RGBColor[0.8570441666666667, 0.6373188333333333, 0.8020406666666666], 
       DiskBox[{23.4, -29.2}, 4.1]}, {
       EdgeForm[
        AbsoluteThickness[2]], 
       RGBColor[0.8570441666666667, 0.6373188333333333, 0.8020406666666666], 
       DiskBox[{32.4, -92.2}, 4.1]}, {
       EdgeForm[
        AbsoluteThickness[2]], 
       RGBColor[0.8570441666666667, 0.6373188333333333, 0.8020406666666666], 
       DiskBox[{95.4, -29.2}, 4.1]}, {
       EdgeForm[
        AbsoluteThickness[2]], 
       RGBColor[0.8570441666666667, 0.6373188333333333, 0.8020406666666666], 
       DiskBox[{32.4, -65.2}, 4.1]}, {
       EdgeForm[
        AbsoluteThickness[2]], 
       RGBColor[0.8570441666666667, 0.6373188333333333, 0.8020406666666666], 
       DiskBox[{95.4, -47.2}, 4.1]}, {
       EdgeForm[
        AbsoluteThickness[2]], 
       RGBColor[0.8570441666666667, 0.6373188333333333, 0.8020406666666666], 
       DiskBox[{14.4, -29.2}, 4.1]}, {
       EdgeForm[
        AbsoluteThickness[2]], 
       RGBColor[0.8570441666666667, 0.6373188333333333, 0.8020406666666666], 
       DiskBox[{14.4, -101.2}, 4.1]}, {
       EdgeForm[
        AbsoluteThickness[2]], 
       RGBColor[0.8570441666666667, 0.6373188333333333, 0.8020406666666666], 
       DiskBox[{32.4, -47.2}, 4.1]}, {
       EdgeForm[
        AbsoluteThickness[2]], 
       RGBColor[0.8570441666666667, 0.6373188333333333, 0.8020406666666666], 
       DiskBox[{158.4, -47.2}, 4.1]}, {
       EdgeForm[
        AbsoluteThickness[2]], 
       RGBColor[0.8570441666666667, 0.6373188333333333, 0.8020406666666666], 
       DiskBox[{77.4, -65.2}, 4.1]}, {
       EdgeForm[
        AbsoluteThickness[2]], 
       RGBColor[0.8570441666666667, 0.6373188333333333, 0.8020406666666666], 
       DiskBox[{41.4, -65.2}, 4.1]}, {
       EdgeForm[
        AbsoluteThickness[2]], 
       RGBColor[0.8570441666666667, 0.6373188333333333, 0.8020406666666666], 
       DiskBox[{59.4, -65.2}, 4.1]}, {
       EdgeForm[
        AbsoluteThickness[2]], 
       RGBColor[0.8570441666666667, 0.6373188333333333, 0.8020406666666666], 
       DiskBox[{41.4, -29.2}, 4.1]}, {
       EdgeForm[
        AbsoluteThickness[2]], 
       RGBColor[0.8570441666666667, 0.6373188333333333, 0.8020406666666666], 
       DiskBox[{32.4, -29.2}, 4.1]}, {
       EdgeForm[
        AbsoluteThickness[2]], 
       RGBColor[0.8570441666666667, 0.6373188333333333, 0.8020406666666666], 
       DiskBox[{86.4, -38.2}, 4.1]}, {
       EdgeForm[
        AbsoluteThickness[2]], 
       RGBColor[0.8570441666666667, 0.6373188333333333, 0.8020406666666666], 
       DiskBox[{140.4, -29.2}, 4.1]}, {
       EdgeForm[
        AbsoluteThickness[2]], 
       RGBColor[0.8570441666666667, 0.6373188333333333, 0.8020406666666666], 
       DiskBox[{23.4, -20.2}, 4.1]}, {
       EdgeForm[
        AbsoluteThickness[2]], 
       RGBColor[0.8570441666666667, 0.6373188333333333, 0.8020406666666666], 
       DiskBox[{50.4, -65.2}, 4.1]}, {
       EdgeForm[
        AbsoluteThickness[2]], 
       RGBColor[0.8570441666666667, 0.6373188333333333, 0.8020406666666666], 
       DiskBox[{131.4, -65.2}, 4.1]}, {
       EdgeForm[
        AbsoluteThickness[2]], 
       RGBColor[0.8570441666666667, 0.6373188333333333, 0.8020406666666666], 
       DiskBox[{212.4, -56.2}, 4.1]}, {
       EdgeForm[
        AbsoluteThickness[2]], 
       RGBColor[0.8570441666666667, 0.6373188333333333, 0.8020406666666666], 
       DiskBox[{149.4, -47.2}, 4.1]}, {
       EdgeForm[
        AbsoluteThickness[2]], 
       RGBColor[0.8570441666666667, 0.6373188333333333, 0.8020406666666666], 
       DiskBox[{68.4, -20.2}, 4.1]}, {
       EdgeForm[
        AbsoluteThickness[2]], 
       RGBColor[0.8570441666666667, 0.6373188333333333, 0.8020406666666666], 
       DiskBox[{32.4, -20.2}, 4.1]}, {
       EdgeForm[
        AbsoluteThickness[2]], 
       RGBColor[0.8570441666666667, 0.6373188333333333, 0.8020406666666666], 
       DiskBox[{41.4, -83.2}, 4.1]}, {
       EdgeForm[
        AbsoluteThickness[2]], 
       RGBColor[0.8570441666666667, 0.6373188333333333, 0.8020406666666666], 
       DiskBox[{86.4, -92.2}, 4.1]}, {
       EdgeForm[
        AbsoluteThickness[2]], 
       RGBColor[0.8570441666666667, 0.6373188333333333, 0.8020406666666666], 
       DiskBox[{59.4, -92.2}, 4.1]}, {
       EdgeForm[
        AbsoluteThickness[2]], 
       RGBColor[0.8570441666666667, 0.6373188333333333, 0.8020406666666666], 
       DiskBox[{50.4, -74.2}, 4.1]}, {
       EdgeForm[
        AbsoluteThickness[2]], 
       RGBColor[0.8570441666666667, 0.6373188333333333, 0.8020406666666666], 
       DiskBox[{32.4, -83.2}, 4.1]}, {
       EdgeForm[
        AbsoluteThickness[2]], 
       RGBColor[0.8570441666666667, 0.6373188333333333, 0.8020406666666666], 
       DiskBox[{23.4, -74.2}, 4.1]}, {
       EdgeForm[
        AbsoluteThickness[2]], 
       RGBColor[0.8570441666666667, 0.6373188333333333, 0.8020406666666666], 
       DiskBox[{95.4, -92.2}, 4.1]}, {
       EdgeForm[
        AbsoluteThickness[2]], 
       RGBColor[0.8570441666666667, 0.6373188333333333, 0.8020406666666666], 
       DiskBox[{86.4, -29.2}, 4.1]}, {
       EdgeForm[
        AbsoluteThickness[2]], 
       RGBColor[0.8570441666666667, 0.6373188333333333, 0.8020406666666666], 
       DiskBox[{41.4, -74.2}, 4.1]}, {
       EdgeForm[
        AbsoluteThickness[2]], 
       RGBColor[0.8570441666666667, 0.6373188333333333, 0.8020406666666666], 
       DiskBox[{68.4, -83.2}, 4.1]}, {
       EdgeForm[
        AbsoluteThickness[2]], 
       RGBColor[0.8570441666666667, 0.6373188333333333, 0.8020406666666666], 
       DiskBox[{68.4, -74.2}, 4.1]}, {
       EdgeForm[
        AbsoluteThickness[2]], 
       RGBColor[0.8570441666666667, 0.6373188333333333, 0.8020406666666666], 
       DiskBox[{68.4, -65.2}, 4.1]}, {
       EdgeForm[
        AbsoluteThickness[2]], 
       RGBColor[0.8570441666666667, 0.6373188333333333, 0.8020406666666666], 
       DiskBox[{50.4, -83.2}, 4.1]}, {
       EdgeForm[
        AbsoluteThickness[2]], 
       RGBColor[0.8570441666666667, 0.6373188333333333, 0.8020406666666666], 
       DiskBox[{158.4, -29.2}, 4.1]}, {
       EdgeForm[
        AbsoluteThickness[2]], 
       RGBColor[0.8570441666666667, 0.6373188333333333, 0.8020406666666666], 
       DiskBox[{59.4, -29.2}, 4.1]}, {
       EdgeForm[
        AbsoluteThickness[2]], 
       RGBColor[0.8570441666666667, 0.6373188333333333, 0.8020406666666666], 
       DiskBox[{50.4, -29.2}, 4.1]}, {
       EdgeForm[
        AbsoluteThickness[2]], 
       RGBColor[0.8570441666666667, 0.6373188333333333, 0.8020406666666666], 
       DiskBox[{23.4, -11.2}, 4.1]}, {
       EdgeForm[
        AbsoluteThickness[2]], 
       RGBColor[0.8570441666666667, 0.6373188333333333, 0.8020406666666666], 
       DiskBox[{212.4, -11.2}, 4.1]}, {
       EdgeForm[
        AbsoluteThickness[2]], 
       RGBColor[0.8570441666666667, 0.6373188333333333, 0.8020406666666666], 
       DiskBox[{77.4, -92.2}, 4.1]}, {
       EdgeForm[
        AbsoluteThickness[2]], 
       RGBColor[0.8570441666666667, 0.6373188333333333, 0.8020406666666666], 
       DiskBox[{122.4, -83.2}, 4.1]}, {
       EdgeForm[
        AbsoluteThickness[2]], 
       RGBColor[0.8570441666666667, 0.6373188333333333, 0.8020406666666666], 
       DiskBox[{23.4, -101.2}, 4.1]}, {
       EdgeForm[
        AbsoluteThickness[2]], 
       RGBColor[0.8570441666666667, 0.6373188333333333, 0.8020406666666666], 
       DiskBox[{32.4, -74.2}, 4.1]}, {
       EdgeForm[
        AbsoluteThickness[2]], 
       RGBColor[0.8570441666666667, 0.6373188333333333, 0.8020406666666666], 
       DiskBox[{23.4, -83.2}, 4.1]}, {
       EdgeForm[
        AbsoluteThickness[2]], 
       RGBColor[0.8570441666666667, 0.6373188333333333, 0.8020406666666666], 
       DiskBox[{131.4, -47.2}, 4.1]}, {
       EdgeForm[
        AbsoluteThickness[2]], 
       RGBColor[0.8570441666666667, 0.6373188333333333, 0.8020406666666666], 
       DiskBox[{77.4, -83.2}, 4.1]}, {
       EdgeForm[
        AbsoluteThickness[2]], 
       RGBColor[0.8570441666666667, 0.6373188333333333, 0.8020406666666666], 
       DiskBox[{14.4, -83.2}, 4.1]}, {
       EdgeForm[
        AbsoluteThickness[2]], 
       RGBColor[0.8570441666666667, 0.6373188333333333, 0.8020406666666666], 
       DiskBox[{86.4, -47.2}, 4.1]}, {
       EdgeForm[
        AbsoluteThickness[2]], 
       RGBColor[0.8570441666666667, 0.6373188333333333, 0.8020406666666666], 
       DiskBox[{176.4, -74.2}, 4.1]}, {
       EdgeForm[
        AbsoluteThickness[2]], 
       RGBColor[0.8570441666666667, 0.6373188333333333, 0.8020406666666666], 
       DiskBox[{41.4, -20.2}, 4.1]}, {
       EdgeForm[
        AbsoluteThickness[2]], 
       RGBColor[0.8570441666666667, 0.6373188333333333, 0.8020406666666666], 
       DiskBox[{122.4, -101.2}, 4.1]}, {
       EdgeForm[
        AbsoluteThickness[2]], 
       RGBColor[0.8570441666666667, 0.6373188333333333, 0.8020406666666666], 
       DiskBox[{41.4, -92.2}, 4.1]}, {
       EdgeForm[
        AbsoluteThickness[2]], 
       RGBColor[0.8570441666666667, 0.6373188333333333, 0.8020406666666666], 
       DiskBox[{50.4, -47.2}, 4.1]}, {
       EdgeForm[
        AbsoluteThickness[2]], 
       RGBColor[0.8570441666666667, 0.6373188333333333, 0.8020406666666666], 
       DiskBox[{95.4, -56.2}, 4.1]}, {
       EdgeForm[
        AbsoluteThickness[2]], 
       RGBColor[0.8570441666666667, 0.6373188333333333, 0.8020406666666666], 
       DiskBox[{32.4, -38.2}, 4.1]}, {
       EdgeForm[
        AbsoluteThickness[2]], 
       RGBColor[0.8570441666666667, 0.6373188333333333, 0.8020406666666666], 
       DiskBox[{149.4, -29.2}, 4.1]}, {
       EdgeForm[
        AbsoluteThickness[2]], 
       RGBColor[0.8570441666666667, 0.6373188333333333, 0.8020406666666666], 
       DiskBox[{86.4, -65.2}, 4.1]}, {
       EdgeForm[
        AbsoluteThickness[2]], 
       RGBColor[0.8570441666666667, 0.6373188333333333, 0.8020406666666666], 
       DiskBox[{104.4, -74.2}, 4.1]}, {
       EdgeForm[
        AbsoluteThickness[2]], 
       RGBColor[0.8570441666666667, 0.6373188333333333, 0.8020406666666666], 
       DiskBox[{122.4, -11.2}, 4.1]}, {
       EdgeForm[
        AbsoluteThickness[2]], 
       RGBColor[0.8570441666666667, 0.6373188333333333, 0.8020406666666666], 
       DiskBox[{68.4, -47.2}, 4.1]}, {
       EdgeForm[
        AbsoluteThickness[2]], 
       RGBColor[0.8570441666666667, 0.6373188333333333, 0.8020406666666666], 
       DiskBox[{122.4, -74.2}, 4.1]}, {
       EdgeForm[
        AbsoluteThickness[2]], 
       RGBColor[0.8570441666666667, 0.6373188333333333, 0.8020406666666666], 
       DiskBox[{59.4, -74.2}, 4.1]}, {
       EdgeForm[
        AbsoluteThickness[2]], 
       RGBColor[0.8570441666666667, 0.6373188333333333, 0.8020406666666666], 
       DiskBox[{158.4, -65.2}, 4.1]}}}, ImageSize -> 440], 
   "\"Leftovers transfer\""},
  "Labeled",
  DisplayFunction->(GridBox[{{
      ItemBox[#2, BaseStyle -> 
       Directive[FontSize -> 20, FontFamily -> "Calibri"], DefaultBaseStyle -> 
       "LabeledLabel"]}, {
      TagBox[
       ItemBox[
        PaneBox[
         TagBox[#, "SkipImageSizeLevel"], Alignment -> {Center, Baseline}, 
         BaselinePosition -> Baseline], DefaultBaseStyle -> "Labeled"], 
       "SkipImageSizeLevel"]}}, 
    GridBoxAlignment -> {"Columns" -> {{Center}}, "Rows" -> {{Center}}}, 
    AutoDelete -> False, 
    GridBoxItemSize -> {"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
    BaselinePosition -> {2, 1}]& ),
  InterpretationFunction->(RowBox[{"Labeled", "[", 
     RowBox[{#, ",", #2, ",", "Top", ",", 
       RowBox[{"{", 
         RowBox[{"LabelStyle", "\[Rule]", 
           RowBox[{"Directive", "[", 
             RowBox[{
               RowBox[{"FontSize", "\[Rule]", "20"}], ",", 
               RowBox[{"FontFamily", "\[Rule]", "\"Calibri\""}]}], "]"}]}], 
         "}"}]}], "]"}]& )]], "Output",
 CellChangeTimes->{
  3.888351768557473*^9, {3.888351906327873*^9, 3.888351940037858*^9}, {
   3.888351970970425*^9, 3.888351983174168*^9}, {3.888352020227889*^9, 
   3.888352040069051*^9}, {3.888352085374139*^9, 3.888352106999402*^9}, 
   3.888352482938265*^9, 3.8884078934713154`*^9, 3.888421074835693*^9, 
   3.888437833506115*^9, 3.8884860880304885`*^9, 3.8884900810194435`*^9},
 CellLabel->
  "Out[417]=",ExpressionUUID->"ca1984f2-eab7-487a-9cd2-cf9854faf9dc"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["Echo Functions", "Section",
 CellChangeTimes->{{3.888407998949379*^9, 3.888407999986985*^9}, {
  3.889465842406252*^9, 3.88946584342177*^9}, {3.88946599991776*^9, 
  3.889466007029381*^9}},ExpressionUUID->"74d3c32d-f2a3-4c8a-ac1a-\
9d14e83a006f"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{
    RowBox[{"I", " ", "improved", " ", 
     RowBox[{"Kevin", "'"}], "s", " ", "original", " ", "version", " ", "of", 
     " ", "this", " ", 
     RowBox[{"function", ".", " ", "\[IndentingNewLine]", "This"}], " ", 
     "one", " ", "gets", " ", "rid", " ", "of", " ", "unneeded", " ", 
     "columns"}], ",", " ", 
    RowBox[{
    "and", " ", "makes", " ", "the", " ", "resulting", " ", "csv", " ", 
     "directly", " ", "compatible", " ", "with", " ", "the", " ", "echo", " ", 
     RowBox[{"software", "."}]}]}], "*)"}], "\[IndentingNewLine]", 
  "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"writeEchoScript", "[", 
    RowBox[{"transferRules_", ",", "saveName_"}], "]"}], ":=", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
      "echoHeader", ",", "sourcePlateName", ",", "sourcePlateType", ",", 
       "destinationPlateName", ",", "defaultTransferVol", ",", "fpath", ",", 
       "fname", ",", "filename", ",", "alphaNumeric", ",", "data", ",", 
       "strand2well", ",", "numPatterns", ",", "bitList", ",", "strandList", 
       ",", "sourceWellList", ",", "alphaDestinationWells", ",", "csv"}], 
      "}"}], ",", "\[IndentingNewLine]", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"echoHeader", "=", 
       RowBox[{"{", 
        RowBox[{
        "\"\<Source Plate Name\>\"", ",", "\"\<Source Plate Type\>\"", ",", 
         "\"\<Source Well\>\"", ",", "\"\<Destination Plate Name\>\"", ",", 
         "\"\<Destination Well\>\"", ",", "\"\<Transfer Volume\>\""}], 
        "}"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"sourcePlateName", "=", "\"\<Source[1]\>\""}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"sourcePlateType", "=", "\"\<384PP_AQ_BP\>\""}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"destinationPlateName", "=", "\"\<Destination[1]\>\""}], ";", 
      "\[IndentingNewLine]", "\[IndentingNewLine]", 
      RowBox[{"csv", "=", 
       RowBox[{"Prepend", "[", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"Table", "[", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"sourcePlateName", ",", "sourcePlateType", ",", 
             RowBox[{"transferRules", "[", 
              RowBox[{"[", 
               RowBox[{"i", ",", "1"}], "]"}], "]"}], ",", 
             "destinationPlateName", ",", 
             RowBox[{"transferRules", "[", 
              RowBox[{"[", 
               RowBox[{"i", ",", "2", ",", "1"}], "]"}], "]"}], ",", 
             RowBox[{"transferRules", "[", 
              RowBox[{"[", 
               RowBox[{"i", ",", "2", ",", "2"}], "]"}], "]"}]}], 
            RowBox[{"(*", " ", "nanoliters", " ", "*)"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"i", ",", 
             RowBox[{"Length", "[", "transferRules", "]"}]}], "}"}]}], "]"}], 
         ",", "\[IndentingNewLine]", "echoHeader"}], "]"}]}], ";", 
      "\[IndentingNewLine]", "\[IndentingNewLine]", 
      RowBox[{"csv", "//", 
       RowBox[{
        RowBox[{"Export", "[", 
         RowBox[{"saveName", ",", "#", ",", "\"\<csv\>\"", ",", 
          RowBox[{"\"\<TextDelimiters\>\"", "->", "\"\<\>\""}]}], "]"}], 
        "&"}]}]}]}], "\[IndentingNewLine]", "]"}]}]}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.710872363083065*^9, 3.7108725256944504`*^9}, {
   3.710874797942356*^9, 3.710874981296672*^9}, {3.710875014500101*^9, 
   3.710875035174824*^9}, {3.710875066362079*^9, 3.710875103271426*^9}, {
   3.710875273838566*^9, 3.7108752758453956`*^9}, {3.710875334374071*^9, 
   3.710875358144141*^9}, {3.710875513404114*^9, 3.710875552045564*^9}, {
   3.710875651109695*^9, 3.71087565432745*^9}, {3.7108781904041967`*^9, 
   3.7108782914321003`*^9}, {3.710878878903312*^9, 3.710878881585586*^9}, {
   3.7108791977509766`*^9, 3.710879203676013*^9}, 3.710879252212183*^9, {
   3.7108793019733706`*^9, 3.7108793558107057`*^9}, {3.71097057272508*^9, 
   3.710970572997198*^9}, {3.728057415179909*^9, 3.7280576535407753`*^9}, {
   3.728057847825856*^9, 3.72805784797199*^9}, {3.728057914068139*^9, 
   3.7280579175836477`*^9}, {3.7596162215007734`*^9, 3.759616221769641*^9}, {
   3.761265530215155*^9, 3.761265585878255*^9}, {3.8531795244123616`*^9, 
   3.85317952470944*^9}, {3.884881413097237*^9, 3.884881413565977*^9}, {
   3.8884923045162125`*^9, 3.888492308562436*^9}, {3.889466178455532*^9, 
   3.8894662163357377`*^9}, {3.8894668581106186`*^9, 3.889466858566747*^9}, {
   3.8894669496304865`*^9, 3.889466950070866*^9}},
 CellLabel->"In[19]:=",ExpressionUUID->"c9d52fa5-455e-4abe-b5c0-f71bdd9049b7"],

Cell["\<\
transferRules format:
{
{\[OpenCurlyDoubleQuote]Source well 1\[CloseCurlyDoubleQuote],{\
\[OpenCurlyDoubleQuote]destination well 1\[CloseCurlyDoubleQuote],volume \
(nM)}},
{\[OpenCurlyDoubleQuote]Source well 2\[CloseCurlyDoubleQuote],{\
\[OpenCurlyDoubleQuote]destination well 2\[CloseCurlyDoubleQuote],volume (nM)}}
}\
\>", "Text",
 CellChangeTimes->{{3.88946657018785*^9, 3.889466622675852*^9}, {
  3.889466692261485*^9, 
  3.889466703979705*^9}},ExpressionUUID->"62e2828d-d6d5-401d-a217-\
c8332c62f6bf"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{"example", " ", "use", " ", "of", " ", "writeEchoScript"}], "*)"}],
   "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"echoProtocol", "=", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"\"\<A5\>\"", ",", 
         RowBox[{"{", 
          RowBox[{"\"\<B08\>\"", ",", "325"}], "}"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"\"\<A06\>\"", ",", 
         RowBox[{"{", 
          RowBox[{"\"\<B3\>\"", ",", "3250"}], "}"}]}], "}"}]}], "}"}]}], 
    ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"protocolName", "=", "\"\<echo protocol.csv\>\""}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{"writeEchoScript", "[", 
    RowBox[{"echoProtocol", ",", "protocolName"}], "]"}]}]}]], "Input",
 CellChangeTimes->{{3.889466406344439*^9, 3.8894664166765633`*^9}, {
  3.889466485624545*^9, 3.889466566824723*^9}, {3.8894666355415063`*^9, 
  3.889466715741321*^9}, {3.889466757421361*^9, 3.8894667848247547`*^9}, {
  3.8894669314929457`*^9, 3.8894669329396577`*^9}},
 CellLabel->
  "In[368]:=",ExpressionUUID->"97f47666-8558-4e24-8403-8cfb730773ec"],

Cell[BoxData["\<\"echo protocol.csv\"\>"], "Output",
 CellChangeTimes->{3.8894667889430876`*^9, 3.889466861412477*^9, 
  3.889466933459479*^9},
 CellLabel->
  "Out[370]=",ExpressionUUID->"6b005b8a-fb00-4bdd-9139-edc60e8cb579"]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{
    RowBox[{"Inspired", " ", "by", " ", "RoundToPipet"}], ",", " ", 
    RowBox[{
     RowBox[{
     "I", " ", "made", " ", "this", " ", "function", " ", "that", " ", 
      "accounts", " ", "for", " ", "the", " ", 
      RowBox[{"echo", "'"}], "s", " ", "discrete", " ", "transfer", " ", 
      "volume", " ", "unit", " ", "of", " ", "25", " ", 
      RowBox[{"nM", ".", "\n", "It"}], " ", "yells", " ", "at", " ", "you", 
      " ", "if", " ", "your", " ", "code", " ", "would", " ", "produce", " ", 
      "ill"}], "-", 
     RowBox[{"advised", " ", "echo", " ", 
      RowBox[{"protocols", ".", "\n", "If"}], " ", "you", " ", "ask", " ", 
      "the", " ", "echo", " ", "to", " ", "transfer", " ", "volumes", " ", 
      "that", " ", "are", " ", "not", " ", "multiples", " ", "of", " ", "25", 
      " ", "nM"}]}], ",", " ", 
    RowBox[{
    "it", " ", "will", " ", "automatically", " ", "round", " ", "the", " ", 
     "transfers", " ", "anyway"}], ",", "\n", 
    RowBox[{
    "so", " ", "this", " ", "code", " ", "is", " ", "not", " ", "exactly", 
     " ", "needed", " ", "but", " ", "will", " ", "allow", " ", "you", " ", 
     "to", " ", "better", " ", "understand", " ", "what", " ", "is", " ", 
     "actually", " ", "going", " ", "to", " ", 
     RowBox[{"happen", "."}]}]}], "\n", "*)"}], "\n", 
  RowBox[{
   RowBox[{"RoundToEcho", "[", "vol_", "]"}], ":=", "\n", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", "roundedVol", "}"}], ",", "\n", 
     RowBox[{
      RowBox[{
       RowBox[{"RoundToEcho", "::", "small"}], "=", 
       "\"\<You probably shouldn't round volumes below 200 nL for the Echo. \
Make things bigger.\>\""}], ";", "\n", 
      RowBox[{
       RowBox[{"RoundToEcho", "::", "big"}], "=", 
       "\"\<Volumes above 5 uL! Just pipette it manually?\>\""}], ";", "\n", 
      RowBox[{"Which", "[", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{
         RowBox[{"vol", "<", "200"}], "&&", 
         RowBox[{
          RowBox[{"Mod", "[", 
           RowBox[{"vol", ",", "25"}], "]"}], "!=", "0"}]}], ",", 
        RowBox[{"Message", "[", 
         RowBox[{"RoundToEcho", "::", "small"}], "]"}], ",", 
        "\[IndentingNewLine]", 
        RowBox[{"vol", ">", "5000"}], ",", 
        RowBox[{"Message", "[", 
         RowBox[{"RoundToEcho", "::", "big"}], "]"}]}], "\n", "]"}], ";", 
      "\n", 
      RowBox[{"roundedVol", "=", 
       RowBox[{
        RowBox[{"Round", "[", 
         RowBox[{"vol", "/", "25"}], "]"}], "*", "25"}]}]}]}], 
    "]"}]}]}]], "Code",
 InitializationCell->True,
 CellChangeTimes->{{3.758165753416667*^9, 3.7581658311367188`*^9}, {
   3.758165870828273*^9, 3.75816588135988*^9}, {3.7581659348979864`*^9, 
   3.758166016277817*^9}, {3.758166270209676*^9, 3.758166270325641*^9}, {
   3.7583967429659305`*^9, 3.758396747292307*^9}, {3.885477513672936*^9, 
   3.885477514344414*^9}, {3.885477601112903*^9, 3.885477601328455*^9}, 
   3.8854777112186627`*^9, {3.8854777532401514`*^9, 3.8854778008960676`*^9}, {
   3.8854778494234457`*^9, 3.8854778994406824`*^9}, {3.885477939460566*^9, 
   3.885477944944611*^9}, 3.8854780300177*^9, {3.8854781051264734`*^9, 
   3.885478112264002*^9}, {3.885478502196675*^9, 3.885478592519719*^9}, {
   3.885478660369837*^9, 3.885478795365997*^9}, {3.885478843607794*^9, 
   3.885478857135285*^9}, {3.888488400172323*^9, 3.8884884009689627`*^9}, {
   3.888488567424321*^9, 3.8884885788733444`*^9}, {3.888488624663314*^9, 
   3.888488659880983*^9}, {3.8894662268230343`*^9, 3.889466344318492*^9}, {
   3.889467131327745*^9, 3.889467174980344*^9}},
 FontFamily->"Consolas",
 FontSize->13,
 FontWeight->"Bold",
 CellLabel->"In[20]:=",ExpressionUUID->"ef366b8b-f70a-46ba-bbe5-72af37f86340"]
}, Closed]],

Cell[CellGroupData[{

Cell["DNA", "Section",
 CellChangeTimes->{{3.9243690421600018`*^9, 
  3.924369043144348*^9}},ExpressionUUID->"ce2e8387-16d2-bd40-9014-\
84dbcc8d6114"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{"DNA", " ", "reverse", " ", "complement"}], "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"revComplement", "[", "sequenceString_", "]"}], ":=", 
   "\[IndentingNewLine]", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", "reverseComplement", "}"}], ",", "\[IndentingNewLine]", 
     RowBox[{"reverseComplement", "=", 
      RowBox[{
       RowBox[{"BioSequenceReverseComplement", "[", 
        RowBox[{"BioSequence", "[", 
         RowBox[{"\"\<DNA\>\"", ",", "sequenceString"}], "]"}], "]"}], "[", 
       RowBox[{"[", "2", "]"}], "]"}]}]}], "\[IndentingNewLine]", 
    "]"}]}]}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.815082599678366*^9, 3.815082599699355*^9}, {
  3.88773361665403*^9, 3.887733616888214*^9}, {3.8892167181281166`*^9, 
  3.889216727591629*^9}, {3.889216759223498*^9, 3.889216791673253*^9}, {
  3.8892168439605026`*^9, 3.889216852271913*^9}, {3.889216884885835*^9, 
  3.889216970367776*^9}, {3.889217679175754*^9, 3.889217783958377*^9}, {
  3.889384014344054*^9, 3.889384014416273*^9}, {3.889465284774717*^9, 
  3.889465340191871*^9}, {3.924369256479851*^9, 3.924369323140106*^9}},
 CellLabel->"In[21]:=",ExpressionUUID->"eb91e2f2-1612-f64f-b8ab-b666785e25c8"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"revComplement", "[", "\"\<GATACA\>\"", "]"}]], "Input",
 CellChangeTimes->{{3.9243693410622807`*^9, 3.9243693939111443`*^9}},
 CellLabel->
  "In[620]:=",ExpressionUUID->"19387961-9cf5-0148-93eb-c6873a326920"],

Cell[BoxData["\<\"TGTATC\"\>"], "Output",
 CellChangeTimes->{3.9243693488792896`*^9, 3.9243693943974934`*^9},
 CellLabel->
  "Out[620]=",ExpressionUUID->"25a3012b-467c-1b4c-9789-f7796df802d5"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["\<\
Code to investigate custom scaffolds based on Kishi et al 2017\
\>", "Section",
 CellChangeTimes->{{3.924369042160002*^9, 3.924369043144348*^9}, {
  3.935846860605377*^9, 3.935846865915739*^9}, {3.9361276687572823`*^9, 
  3.936127674834921*^9}},ExpressionUUID->"f2bcfabb-0e98-9342-996c-\
fb3b28684c03"],

Cell[BoxData[
 RowBox[{
  RowBox[{
  "kishiEtAl2017seq", "=", 
   "\"\<TGTTAGTAGTTGGATGTGTTTGGTGATAGGTATTAAAGTAAGGTATGGAGGAGATTTTGGTGGAATAAGT\
AGTAAGAAATGATTAGGTTTGAATGAGAGAATTGAAGAGGATGTTATAATGATAGTGAGGGATAAAATGTAATGTGAA\
TGGGTAGAAGATATGTATGTGGTATTGTAAAGGATTATGGAGTGGAATTAGATATGGTGTTAGAGTTTGTAATTTAGT\
AAAGGTGTTTAATTGAGGATGGTGATGAGGTAAATAGAGGGATGATAGGATATATAGTGAAGAGATTTATAGTGGAGT\
TGAAAAGTTTTGGAAAATTAGAGTGGTGGATAGATTAGATTAAGAGGAGGTTGGATAATGTAGGATAGGTGTTATATG\
GATAGTAAATTTGATAGAGTGTGGAATGAGGTTGTTTAGTTAGTTAAAAAGATGTTAATGAGTAATGTTGGTTGTATA\
TAAGGAAGAAGGTTGAATGGATGAAAAGGAGGAATAGTGATGTTTATTTGATGTTGGGTATTTATGATTAAGTTGAAG\
GAGTTTAATAGAATAGGAGTTAGTGGATGGGTATGTAGTGTGGTAAGAATATTGGAGGTGAGGAAGTTTGATATTTAG\
TTGATATGGAGAGTTTAGTATTAATGTGGAGTGATAGAAAATAGTTAATAGGGAGGGAGTTAAGTAAAGATGAGTTGA\
GATTTGATTGTTGTGTTTATGGTAGGTGATAAGTTATGGAAATAGATTGAGAATGGAAAGAAGTTATTAAGATAGTTA\
TGAGGAATGGAGTTTTTGAATTGGTGTAGTGATATTAGGTAGGTATGTGTGAAGAATGATTTGAAGTGTTAGTGAGTA\
AGAGTATGGATGGTTGTGAGAGTATTTAAGTTTGGATTGTAGAAGGTGATGTGTAATGGTAATGTATGGTGAAAGAAA\
TTAGGGATGTTGATGATTATGAGTGAATGAAGGTGGAAATTGGAGAAGATGTATTGGATAGGAGAGATTAGGATGATT\
GAGTAGGTTATTAGATGGTTATTGTTTATAAGAAGGAGAAAATGTTATTTTGGATGGATTAGTAATAGGAAGATAGGT\
TTTTATGGGTAAGAGAAATGGATTGGTTATAGGGAATTTGTAAAAAGTTGTAGGAGGAGTTGTTGAAGAAGAGAATGA\
ATAATTGTAAGTGGTTATGTTATGAATATATGGGTTTGTGGATTAAGGGATGGTATGGTATAGAGAAAGATATAGTTT\
ATGTTGGAATTGTGAGTATTAGGAGGTGTAGAGATTGGGAGTAATTGAAAATGGTTGATAAAAAGGTTGTAAATAAGA\
TAATGAAGATGGGTGAGAAGGTATTGAAATGAATGATGTGAAAATATGTTAGGGTGGTTGTTATAGAGTTATAAGG\>\
\""}], ";"}]], "Input",
 CellChangeTimes->{{3.7581383519210587`*^9, 3.758138365087669*^9}, {
   3.758138421972631*^9, 3.758138458494304*^9}, {3.758144640291236*^9, 
   3.758144677267056*^9}, {3.7581450878637714`*^9, 3.758145088182493*^9}, {
   3.7581621361243477`*^9, 3.758162136330942*^9}, {3.758162916048702*^9, 
   3.758162939801607*^9}, {3.758163001403411*^9, 3.758163002051878*^9}, {
   3.7581631106199546`*^9, 3.7581631235705347`*^9}, {3.75816335157658*^9, 
   3.758163366798649*^9}, {3.758163843408934*^9, 3.758163885249323*^9}, {
   3.772921731046179*^9, 3.772921762082611*^9}, {3.7729219525442715`*^9, 
   3.772921953776592*^9}, {3.7729220195100183`*^9, 3.772922055178544*^9}, {
   3.772922110173753*^9, 3.772922173527481*^9}, 3.7729246150511694`*^9, 
   3.772924706091136*^9, {3.779574309427428*^9, 3.779574316290487*^9}, 
   3.7795746230545535`*^9, {3.779575008787421*^9, 3.779575035935748*^9}, {
   3.7795766095632963`*^9, 3.779576610758606*^9}, {3.779576712974715*^9, 
   3.779576715106503*^9}, {3.781987771733875*^9, 3.781987866018653*^9}, {
   3.781990953478853*^9, 3.781991003886821*^9}, 3.78199566330191*^9, {
   3.7819985782427607`*^9, 3.781998603569629*^9}, {3.781998927317541*^9, 
   3.781999005603068*^9}, {3.781999041220385*^9, 3.781999110768229*^9}, {
   3.78560827227256*^9, 3.7856083129767604`*^9}, {3.785608410891939*^9, 
   3.785608445961857*^9}, {3.7856090372104053`*^9, 3.785609048213865*^9}, {
   3.785610345605743*^9, 3.78561035455167*^9}, {3.785610400847374*^9, 
   3.7856104009653053`*^9}, 3.785610487432907*^9, {3.785610570821191*^9, 
   3.785610578960161*^9}, {3.785610928638017*^9, 3.78561095715207*^9}, {
   3.785611171912294*^9, 3.7856111799485717`*^9}, {3.785623433103546*^9, 
   3.785623476107887*^9}, {3.7856235200320187`*^9, 3.785623543021994*^9}, {
   3.785623668474419*^9, 3.785623840693098*^9}, {3.785624221559183*^9, 
   3.785624280099887*^9}, {3.785624443124299*^9, 3.7856244497812786`*^9}, {
   3.7856246812164984`*^9, 3.785624705733576*^9}, {3.7857165451783757`*^9, 
   3.7857165782723317`*^9}, {3.785716791419263*^9, 3.785716848691844*^9}, {
   3.7884841289634256`*^9, 3.788484157935116*^9}, {3.788484203538827*^9, 
   3.788484251147502*^9}, {3.788484290271343*^9, 3.788484310779481*^9}, {
   3.789839033078313*^9, 3.789839066350301*^9}, {3.789839218973988*^9, 
   3.789839222465055*^9}, {3.789839550604729*^9, 3.789839559076761*^9}, {
   3.789840180219336*^9, 3.789840185570382*^9}, 3.789840249499923*^9, {
   3.7898409087610044`*^9, 3.78984095631785*^9}, {3.7898410276722116`*^9, 
   3.789841077286061*^9}, {3.789841119493724*^9, 3.7898411227414675`*^9}, {
   3.789842175439259*^9, 3.7898421759179854`*^9}, {3.7904572330020647`*^9, 
   3.790457233506774*^9}, {3.790457322951396*^9, 3.790457323531063*^9}, {
   3.790457555112909*^9, 3.790457555299801*^9}, {3.790457718863064*^9, 
   3.7904577265096345`*^9}, {3.790457758550213*^9, 3.7904577933422194`*^9}, 
   3.7924495059555273`*^9, {3.8105916357845044`*^9, 3.81059166149145*^9}, {
   3.81116315627317*^9, 3.811163157949651*^9}, {3.812925589687284*^9, 
   3.8129256246618376`*^9}, {3.81292582385061*^9, 3.812925830728222*^9}, {
   3.8130889781614447`*^9, 3.813088994005149*^9}, {3.813089038138145*^9, 
   3.813089039798421*^9}, {3.813092446413688*^9, 3.813092448892329*^9}, {
   3.8141939685613832`*^9, 3.814194015049949*^9}, {3.814194062184141*^9, 
   3.814194093289145*^9}, {3.814195311071409*^9, 3.8141953280721617`*^9}, {
   3.814196844829958*^9, 3.8141970752798877`*^9}, {3.814298665533497*^9, 
   3.814298725144079*^9}, {3.814802932821034*^9, 3.814803010498905*^9}, {
   3.814803124060303*^9, 3.814803124508325*^9}, {3.81489999127813*^9, 
   3.814899996905958*^9}, 3.815404928047578*^9, {3.815407438842252*^9, 
   3.8154074566667137`*^9}, {3.8154111775911427`*^9, 3.815411181486781*^9}, {
   3.815411211743915*^9, 3.815411229429171*^9}, {3.815411403503518*^9, 
   3.8154114064238176`*^9}, {3.815411474569274*^9, 3.81541152829084*^9}, {
   3.8154116029927077`*^9, 3.8154116061924257`*^9}, {3.8154116489685235`*^9, 
   3.815411651559085*^9}, {3.81541174027281*^9, 3.815411749296831*^9}, {
   3.8154117940971336`*^9, 3.815411796424507*^9}, {3.815411864257127*^9, 
   3.815411910714528*^9}, {3.815412018313276*^9, 3.815412019168705*^9}, {
   3.815412634330262*^9, 3.8154126583213835`*^9}, {3.8154127275301175`*^9, 
   3.815412744098688*^9}, {3.8394197909514165`*^9, 3.839419861950676*^9}, {
   3.839427057273093*^9, 3.8394270576636934`*^9}, {3.839598520512124*^9, 
   3.839598566228878*^9}, 3.839598745054049*^9, {3.839598791589449*^9, 
   3.839598820501132*^9}, 3.8395995310212603`*^9, 3.839602450311784*^9, {
   3.840382435503076*^9, 3.8403824419685645`*^9}, 3.8403826056406507`*^9, {
   3.840820660273511*^9, 3.8408206814844756`*^9}, {3.8408216614791355`*^9, 
   3.8408217094697065`*^9}, {3.840821756138236*^9, 3.840821762647195*^9}, 
   3.840821796696235*^9, {3.8416012014732533`*^9, 3.8416012376622095`*^9}, 
   3.8416770020472145`*^9, 3.841684012966519*^9, {3.842618856891288*^9, 
   3.842618878969818*^9}, {3.8426189974187527`*^9, 3.842619053795145*^9}, 
   3.842619115217287*^9, 3.8428887145808196`*^9, 3.8428891429235435`*^9, 
   3.8437482569410205`*^9, 3.843748386963147*^9, {3.844353275518691*^9, 
   3.844353295002845*^9}, {3.846285264244522*^9, 3.846285264940296*^9}, {
   3.846285363245897*^9, 3.846285421414618*^9}, 3.846285586658688*^9, 
   3.846286030461997*^9, {3.84633223719346*^9, 3.8463322761925836`*^9}, 
   3.846332398959625*^9, {3.846863982363276*^9, 3.8468640435745087`*^9}, {
   3.8607586964265037`*^9, 3.860758697138793*^9}, {3.860763636036413*^9, 
   3.860763640387326*^9}, {3.861733837656307*^9, 3.8617338402713194`*^9}, 
   3.861733888789778*^9, {3.873995476287822*^9, 3.873995550432909*^9}, {
   3.873997221232993*^9, 3.873997221352814*^9}, {3.873997261951968*^9, 
   3.873997295027814*^9}, 3.873997349596678*^9, 3.873997536363335*^9, 
   3.8741531843405943`*^9, {3.874154630960103*^9, 3.874154652063835*^9}, {
   3.874154711243784*^9, 3.87415471173296*^9}, 3.874154774452851*^9, {
   3.874154830727339*^9, 3.874154830852636*^9}, 3.8741548788097706`*^9, 
   3.8741549934375677`*^9, 3.874263489069142*^9, {3.874693916490527*^9, 
   3.874693952740455*^9}, {3.874694023113165*^9, 3.8746940262397633`*^9}, {
   3.8746943989387994`*^9, 3.874694444343599*^9}, {3.874694484624583*^9, 
   3.874694528314595*^9}, {3.874694561832472*^9, 3.874694562146199*^9}, {
   3.874778333655243*^9, 3.8747783624067497`*^9}, {3.875268638405132*^9, 
   3.875268644615415*^9}, 3.875269977720329*^9, {3.875270029210743*^9, 
   3.875270032211097*^9}, {3.8752741540103145`*^9, 3.875274174946559*^9}, 
   3.875274411336403*^9, 3.8752745319954443`*^9, {3.8752745847278566`*^9, 
   3.875274605195095*^9}, {3.876589837253355*^9, 3.87658985303408*^9}, 
   3.876671772106908*^9, 3.8791078047683306`*^9, {3.887658782499086*^9, 
   3.887658873956455*^9}, {3.887658922661704*^9, 3.8876589248698034`*^9}, {
   3.887660703837455*^9, 3.8876607090745726`*^9}, {3.887824347286295*^9, 
   3.8878243714635897`*^9}, 3.887824501032691*^9, 3.8878251787287025`*^9, {
   3.9358468840893726`*^9, 3.935846945175926*^9}},
 CellLabel->"In[23]:=",ExpressionUUID->"0e3a42cc-c5c2-0541-8848-d37091d22a6d"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StringLength", "[", "kishiEtAl2017seq", "]"}]], "Input",
 CellChangeTimes->{{3.935846953135256*^9, 3.9358469654465485`*^9}, {
  3.9358470136222897`*^9, 3.9358470142379417`*^9}},
 CellLabel->"In[25]:=",ExpressionUUID->"aa3d043f-f7f4-c448-9e6e-2f0c7d46204b"],

Cell[BoxData["1394"], "Output",
 CellChangeTimes->{3.935846966053932*^9, 3.9358470145529823`*^9},
 CellLabel->"Out[25]=",ExpressionUUID->"0430d1fd-f837-a54a-bf5b-31933111c0b4"]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"allRunsOf8", "=", 
   RowBox[{"Table", "[", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"StringTake", "[", 
      RowBox[{"kishiEtAl2017seq", ",", 
       RowBox[{"{", 
        RowBox[{"i", ",", 
         RowBox[{"i", "+", "7"}]}], "}"}]}], "]"}], "\[IndentingNewLine]", 
     ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", 
       RowBox[{
        RowBox[{"StringLength", "[", "kishiEtAl2017seq", "]"}], "-", "7"}]}], 
      "}"}]}], "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.935847117144964*^9, 3.9358472661092796`*^9}},
 CellLabel->"In[33]:=",ExpressionUUID->"a4d80476-a7f3-804b-9b0e-bcf568582930"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{
    RowBox[{
    "test", " ", "if", " ", "there", " ", "are", " ", "no", " ", "duplicated",
      " ", "runs", " ", "of", " ", "8.", " ", "If", " ", "true"}], ",", " ", 
    RowBox[{
    "then", " ", "no", " ", "run", " ", "of", " ", "8", " ", "or", " ", 
     "larger", " ", "is", " ", "duplicated", " ", "in", " ", "the", " ", 
     RowBox[{"scaffold", "."}]}]}], "*)"}], "\[IndentingNewLine]", 
  RowBox[{"DuplicateFreeQ", "[", "allRunsOf8", "]"}]}]], "Input",
 CellChangeTimes->{{3.935847307203356*^9, 
  3.9358473745417137`*^9}},ExpressionUUID->"f327b70d-cca5-f940-b095-\
f6351597d5a2"],

Cell[BoxData["True"], "Output",
 CellChangeTimes->{{3.935847315186388*^9, 3.9358473203530693`*^9}},
 CellLabel->"Out[35]=",ExpressionUUID->"c9e6381a-9d28-e14b-8218-839d5e5552c5"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"baseOptions", "=", 
  RowBox[{"{", 
   RowBox[{"\"\<A\>\"", ",", "\"\<T\>\"", ",", "\"\<G\>\""}], 
   "}"}]}]], "Input",
 CellChangeTimes->{{3.935847473849245*^9, 3.9358474886051083`*^9}},
 CellLabel->"In[36]:=",ExpressionUUID->"efb55aca-0f3b-9148-b8ea-9620dd428bc4"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"A\"\>", ",", "\<\"T\"\>", ",", "\<\"G\"\>"}], "}"}]], "Output",
 CellChangeTimes->{3.935847490262148*^9},
 CellLabel->"Out[36]=",ExpressionUUID->"feec4601-0c05-134c-af1f-60da335b6289"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"False", "||", "False"}]], "Input",
 CellChangeTimes->{{3.935850972727436*^9, 3.9358509849641933`*^9}},
 CellLabel->"In[54]:=",ExpressionUUID->"d414cc67-77c7-6949-8bec-b035ab384a3f"],

Cell[BoxData["False"], "Output",
 CellChangeTimes->{{3.935850976170576*^9, 3.935850985265585*^9}},
 CellLabel->"Out[54]=",ExpressionUUID->"e0ac13fb-8549-2147-99ff-cf62e70e1fb6"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StringTake", "[", 
  RowBox[{"kishiEtAl2017seq", ",", 
   RowBox[{"-", "6"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.9358510988514385`*^9, 3.935851115291706*^9}},
 CellLabel->"In[57]:=",ExpressionUUID->"ace0c477-f8d4-f741-be6c-dfeb34797736"],

Cell[BoxData["\<\"ATAAGG\"\>"], "Output",
 CellChangeTimes->{{3.935851099419142*^9, 3.935851115794937*^9}},
 CellLabel->"Out[57]=",ExpressionUUID->"8077c8cc-aceb-5647-9ebc-3dc3f48e84dd"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\"\<AAAAAA\>\"", "==", "\"\<AAAAAA\>\""}]], "Input",
 CellChangeTimes->{{3.935851131168049*^9, 3.9358511427001553`*^9}},
 CellLabel->"In[60]:=",ExpressionUUID->"b9dfe33c-f41e-964f-ba8a-c61615db06eb"],

Cell[BoxData["True"], "Output",
 CellChangeTimes->{{3.9358511377760067`*^9, 3.9358511434469185`*^9}},
 CellLabel->"Out[60]=",ExpressionUUID->"1fcf3d06-b597-5c4e-87c4-3f0013a6e90f"]
}, Open  ]],

Cell[BoxData[
 RowBox[{"(*", 
  RowBox[{
  "runs", " ", "of", " ", "G", " ", "longer", " ", "than", " ", "3", " ", 
   "are", " ", "not", " ", 
   RowBox[{"allowed", ".", " ", "Runs"}], " ", "of", " ", "A", " ", "or", " ",
    "T", " ", "longer", " ", "than", " ", "5", " ", "are", " ", "not", " ", 
   RowBox[{"allowed", "."}]}], "*)"}]], "Input",
 CellChangeTimes->{{3.9358503706563187`*^9, 
  3.9358503849313297`*^9}},ExpressionUUID->"16848f5a-7f7b-0d48-85bc-\
a1d5229db834"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"base", "=", "1"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"seqTest", "=", "kishiEtAl2017seq"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"While", "[", 
  RowBox[{
   RowBox[{"base", "<=", "3"}], ",", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"seqTemp", "=", 
     RowBox[{"seqTest", "<>", 
      RowBox[{"baseOptions", "[", 
       RowBox[{"[", "base", "]"}], "]"}]}]}], ";", "\[IndentingNewLine]", 
    RowBox[{"If", "[", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"base", "==", "1"}], "||", 
        RowBox[{"base", "==", "2"}]}], ")"}], ",", 
      RowBox[{"(*", 
       RowBox[{"if", " ", "trying", " ", "A", " ", "or", " ", "T"}], "*)"}], 
      "\[IndentingNewLine]", 
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           RowBox[{"StringTake", "[", 
            RowBox[{"seqTemp", ",", 
             RowBox[{"-", "6"}]}], "]"}], "==", "\"\<AAAAAA\>\""}], "||", 
          RowBox[{
           RowBox[{"StringTake", "[", 
            RowBox[{"seqTemp", ",", 
             RowBox[{"-", "6"}]}], "]"}], "==", "\"\<TTTTTT\>\""}]}], ")"}], 
        ",", 
        RowBox[{"(*", 
         RowBox[{
         "test", " ", "whether", " ", "a", " ", "run", " ", "of", " ", 
          "greater", " ", "than", " ", "5", " ", "As", " ", "or", " ", "Ts", 
          " ", "will", " ", "happen"}], "*)"}], "\[IndentingNewLine]", 
        RowBox[{"base", "++"}], 
        RowBox[{"(*", 
         RowBox[{
          RowBox[{"if", " ", "so"}], ",", " ", 
          RowBox[{
          "then", " ", "increment", " ", "base", " ", "and", " ", "try", " ", 
           "again"}]}], "*)"}], ",", "\[IndentingNewLine]", 
        RowBox[{"(*", 
         RowBox[{"otherwise", ",", " ", 
          RowBox[{
          "generate", " ", "a", " ", "list", " ", "of", " ", "all", " ", 
           "sequences", " ", "of", " ", "8"}]}], "*)"}], 
        "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"allRunsOf8test", "=", 
          RowBox[{"Table", "[", "\[IndentingNewLine]", 
           RowBox[{
            RowBox[{"StringTake", "[", 
             RowBox[{"seqTemp", ",", 
              RowBox[{"{", 
               RowBox[{"i", ",", 
                RowBox[{"i", "+", "7"}]}], "}"}]}], "]"}], 
            "\[IndentingNewLine]", ",", 
            RowBox[{"{", 
             RowBox[{"i", ",", 
              RowBox[{
               RowBox[{"StringLength", "[", "seqTemp", "]"}], "-", "7"}]}], 
             "}"}]}], "]"}]}], ";", "\[IndentingNewLine]", 
         RowBox[{"If", "[", 
          RowBox[{
           RowBox[{"DuplicateFreeQ", "[", "allRunsOf8test", "]"}], ",", 
           RowBox[{"(*", 
            RowBox[{
            "check", " ", "whether", " ", "a", " ", "sequence", " ", "of", 
             " ", "8", " ", "has", " ", "not", " ", "been", " ", 
             "duplicated"}], "*)"}], "\[IndentingNewLine]", 
           RowBox[{
            RowBox[{"seqTest", "=", "seqTemp"}], ";", "\[IndentingNewLine]", 
            RowBox[{"base", "=", "1"}]}], ",", 
           RowBox[{"(*", 
            RowBox[{
             RowBox[{"in", " ", "that", " ", "case"}], ",", " ", 
             RowBox[{"the", " ", "tests", " ", "have", " ", 
              RowBox[{"succeeded", "!"}], " ", "Add", " ", "the", " ", "base",
               " ", "to", " ", "seqTest", " ", "and", " ", "restore", " ", 
              "base", " ", "to", " ", "1"}]}], "*)"}], "\[IndentingNewLine]", 
           RowBox[{"base", "++"}]}], "]"}], ";"}]}], 
       RowBox[{"(*", 
        RowBox[{
         RowBox[{
         "sequence", " ", "of", " ", "8", " ", "has", " ", "been", " ", 
          "duplicated"}], ",", " ", 
         RowBox[{
         "so", " ", "increment", " ", "base", " ", "and", " ", "try", " ", 
          "again"}]}], "*)"}], "\[IndentingNewLine]", "]"}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"StringTake", "[", 
           RowBox[{"seqTemp", ",", 
            RowBox[{"-", "4"}]}], "]"}], "==", "\"\<GGGG\>\""}], ")"}], ",", 
        RowBox[{"(*", 
         RowBox[{
          RowBox[{"if", " ", "trying", " ", "G"}], ",", " ", 
          RowBox[{
          "test", " ", "whether", " ", "a", " ", "run", " ", "of", " ", 
           "greater", " ", "than", " ", "3", " ", "Gs", " ", "will", " ", 
           "happen"}]}], "*)"}], "\[IndentingNewLine]", 
        RowBox[{"base", "++"}], ",", 
        RowBox[{"(*", 
         RowBox[{
          RowBox[{"if", " ", "so"}], ",", " ", 
          RowBox[{
          "then", " ", "we", " ", "have", " ", "hit", " ", "the", " ", 
           "maximum", " ", "length", " ", "of", " ", "this", " ", 
           RowBox[{"scaffold", ".", " ", "Increment"}], " ", "base", " ", 
           "to", " ", "4", " ", "to", " ", "exit", " ", "the", " ", 
           "loop"}]}], "*)"}], "\[IndentingNewLine]", 
        RowBox[{"(*", 
         RowBox[{"otherwise", ",", " ", 
          RowBox[{
          "generate", " ", "a", " ", "list", " ", "of", " ", "all", " ", 
           "sequences", " ", "of", " ", "8"}]}], "*)"}], 
        "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"allRunsOf8test", "=", 
          RowBox[{"Table", "[", "\[IndentingNewLine]", 
           RowBox[{
            RowBox[{"StringTake", "[", 
             RowBox[{"seqTemp", ",", 
              RowBox[{"{", 
               RowBox[{"i", ",", 
                RowBox[{"i", "+", "7"}]}], "}"}]}], "]"}], 
            "\[IndentingNewLine]", ",", 
            RowBox[{"{", 
             RowBox[{"i", ",", 
              RowBox[{
               RowBox[{"StringLength", "[", "seqTemp", "]"}], "-", "7"}]}], 
             "}"}]}], "]"}]}], ";", "\[IndentingNewLine]", 
         RowBox[{"If", "[", 
          RowBox[{
           RowBox[{"DuplicateFreeQ", "[", "allRunsOf8test", "]"}], ",", 
           RowBox[{"(*", 
            RowBox[{
            "check", " ", "whether", " ", "a", " ", "sequence", " ", "of", 
             " ", "8", " ", "has", " ", "not", " ", "been", " ", 
             "duplicated"}], "*)"}], "\[IndentingNewLine]", 
           RowBox[{
            RowBox[{"seqTest", "=", "seqTemp"}], ";", "\[IndentingNewLine]", 
            RowBox[{"base", "=", "1"}]}], ",", 
           RowBox[{"(*", 
            RowBox[{
             RowBox[{"in", " ", "that", " ", "case"}], ",", " ", 
             RowBox[{"the", " ", "tests", " ", "have", " ", 
              RowBox[{"succeeded", "!"}], " ", "Add", " ", "the", " ", "base",
               " ", "to", " ", "seqTest", " ", "and", " ", "restore", " ", 
              "base", " ", "to", " ", "1"}]}], "*)"}], "\[IndentingNewLine]", 
           RowBox[{"base", "++"}]}], "]"}], ";"}]}], 
       RowBox[{"(*", 
        RowBox[{
         RowBox[{
         "sequence", " ", "of", " ", "8", " ", "has", " ", "been", " ", 
          "duplicated"}], ",", " ", 
         RowBox[{
         "so", " ", "increment", " ", "base", " ", "to", " ", "4", " ", "to", 
          " ", "exist", " ", "the", " ", "loop"}]}], "*)"}], 
       "\[IndentingNewLine]", "]"}]}], "\[IndentingNewLine]", "]"}]}]}], 
  "\[IndentingNewLine]", "]"}], "\[IndentingNewLine]", 
 RowBox[{"StringLength", "[", "seqTest", "]"}]}], "Input",
 CellChangeTimes->{{3.935850420516527*^9, 3.9358504210033636`*^9}, {
   3.935850470906772*^9, 3.9358504998200464`*^9}, {3.935850561090818*^9, 
   3.9358506013877983`*^9}, {3.9358506832747927`*^9, 3.935850719314949*^9}, {
   3.9358507813813934`*^9, 3.935850859044298*^9}, {3.9358509372225723`*^9, 
   3.9358510762364*^9}, 3.935851153554155*^9, {3.9358512519624214`*^9, 
   3.935851440541174*^9}, {3.935852471536253*^9, 3.935852823773958*^9}, {
   3.935852859131479*^9, 3.93585287806682*^9}, {3.935852910305431*^9, 
   3.935852934813767*^9}, 3.935852992132353*^9},
 CellLabel->
  "In[100]:=",ExpressionUUID->"6bff7f64-14f1-054d-ba46-e6066301ecad"],

Cell[BoxData["1428"], "Output",
 CellChangeTimes->{3.935852995254774*^9, 3.9358542334599953`*^9},
 CellLabel->
  "Out[103]=",ExpressionUUID->"4b7d2a9a-c489-f949-b049-9f782679ab97"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"tooManyAruns", "=", "seqTest"}]], "Input",
 CellChangeTimes->{{3.9358542401859818`*^9, 3.935854243897335*^9}},
 CellLabel->
  "In[105]:=",ExpressionUUID->"8be4534e-bf47-9e4b-b7eb-8335f368482b"],

Cell[BoxData["\<\"\
TGTTAGTAGTTGGATGTGTTTGGTGATAGGTATTAAAGTAAGGTATGGAGGAGATTTTGGTGGAATAAGTAGTAAGAA\
ATGATTAGGTTTGAATGAGAGAATTGAAGAGGATGTTATAATGATAGTGAGGGATAAAATGTAATGTGAATGGGTAGA\
AGATATGTATGTGGTATTGTAAAGGATTATGGAGTGGAATTAGATATGGTGTTAGAGTTTGTAATTTAGTAAAGGTGT\
TTAATTGAGGATGGTGATGAGGTAAATAGAGGGATGATAGGATATATAGTGAAGAGATTTATAGTGGAGTTGAAAAGT\
TTTGGAAAATTAGAGTGGTGGATAGATTAGATTAAGAGGAGGTTGGATAATGTAGGATAGGTGTTATATGGATAGTAA\
ATTTGATAGAGTGTGGAATGAGGTTGTTTAGTTAGTTAAAAAGATGTTAATGAGTAATGTTGGTTGTATATAAGGAAG\
AAGGTTGAATGGATGAAAAGGAGGAATAGTGATGTTTATTTGATGTTGGGTATTTATGATTAAGTTGAAGGAGTTTAA\
TAGAATAGGAGTTAGTGGATGGGTATGTAGTGTGGTAAGAATATTGGAGGTGAGGAAGTTTGATATTTAGTTGATATG\
GAGAGTTTAGTATTAATGTGGAGTGATAGAAAATAGTTAATAGGGAGGGAGTTAAGTAAAGATGAGTTGAGATTTGAT\
TGTTGTGTTTATGGTAGGTGATAAGTTATGGAAATAGATTGAGAATGGAAAGAAGTTATTAAGATAGTTATGAGGAAT\
GGAGTTTTTGAATTGGTGTAGTGATATTAGGTAGGTATGTGTGAAGAATGATTTGAAGTGTTAGTGAGTAAGAGTATG\
GATGGTTGTGAGAGTATTTAAGTTTGGATTGTAGAAGGTGATGTGTAATGGTAATGTATGGTGAAAGAAATTAGGGAT\
GTTGATGATTATGAGTGAATGAAGGTGGAAATTGGAGAAGATGTATTGGATAGGAGAGATTAGGATGATTGAGTAGGT\
TATTAGATGGTTATTGTTTATAAGAAGGAGAAAATGTTATTTTGGATGGATTAGTAATAGGAAGATAGGTTTTTATGG\
GTAAGAGAAATGGATTGGTTATAGGGAATTTGTAAAAAGTTGTAGGAGGAGTTGTTGAAGAAGAGAATGAATAATTGT\
AAGTGGTTATGTTATGAATATATGGGTTTGTGGATTAAGGGATGGTATGGTATAGAGAAAGATATAGTTTATGTTGGA\
ATTGTGAGTATTAGGAGGTGTAGAGATTGGGAGTAATTGAAAATGGTTGATAAAAAGGTTGTAAATAAGATAATGAAG\
ATGGGTGAGAAGGTATTGAAATGAATGATGTGAAAATATGTTAGGGTGGTTGTTATAGAGTTATAAGGTAAAAATAAA\
AATTAAAAATGAAAAATATAAAAA\"\>"], "Output",
 CellChangeTimes->{
  3.9358530127785625`*^9, {3.9358542355144615`*^9, 3.935854245317604*^9}},
 CellLabel->
  "Out[105]=",ExpressionUUID->"eccc6de5-90ec-994e-9635-c0d60132f7fa"]
}, Open  ]],

Cell["\<\
This first attempt produced a lot of runs of A at the end. I don\
\[CloseCurlyQuote]t like that. Let me try again, this time selecting the next \
base at random rather than preferring A, then T, then G.\
\>", "Text",
 CellChangeTimes->{{3.935853169214363*^9, 3.935853215943926*^9}, {
  3.9358534848172894`*^9, 
  3.9358535124077816`*^9}},ExpressionUUID->"777300fe-f8b0-bf45-943d-\
4690567254bf"],

Cell["Also, it seems like every run of 8 has at least one G in it.", "Text",
 CellChangeTimes->{{3.9358552111148376`*^9, 3.9358552186342087`*^9}, {
  3.935855501234377*^9, 
  3.9358555026834793`*^9}},ExpressionUUID->"53478d6c-0fb2-9b4a-a53b-\
d3564ca7bdba"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StringContainsQ", "[", 
  RowBox[{"\"\<AAAAAAAA\>\"", ",", "\"\<G\>\""}], "]"}]], "Input",
 CellChangeTimes->{{3.9358552933445015`*^9, 3.9358553040433216`*^9}},
 CellLabel->
  "In[128]:=",ExpressionUUID->"fb6a6f7d-b8d4-6b41-9b55-7e0a0a20ddc2"],

Cell[BoxData["False"], "Output",
 CellChangeTimes->{3.9358553045102882`*^9},
 CellLabel->
  "Out[128]=",ExpressionUUID->"49d7c222-d9a1-bc45-b697-e472ae3baa69"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StringContainsQ", "[", 
  RowBox[{"\"\<AAAAAAGA\>\"", ",", "\"\<G\>\""}], "]"}]], "Input",
 CellChangeTimes->{{3.93585530912323*^9, 3.9358553092992535`*^9}},
 CellLabel->
  "In[129]:=",ExpressionUUID->"855ec957-2c3d-3c49-9e79-d7568dfb856d"],

Cell[BoxData["True"], "Output",
 CellChangeTimes->{3.935855309577633*^9},
 CellLabel->
  "Out[129]=",ExpressionUUID->"29d0f093-f4f6-5f49-8c12-039d20e5e617"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ContainsAny", "[", "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"Table", "[", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"StringContainsQ", "[", 
      RowBox[{
       RowBox[{"allRunsOf8", "[", 
        RowBox[{"[", "i", "]"}], "]"}], ",", "\"\<G\>\""}], "]"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"{", 
      RowBox[{"i", ",", 
       RowBox[{"Length", "[", "allRunsOf8", "]"}]}], "}"}]}], "]"}], 
   "\[IndentingNewLine]", ",", 
   RowBox[{"{", "False", "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.9358552447703342`*^9, 3.9358552747869434`*^9}, {
  3.935855316393732*^9, 3.9358554705718975`*^9}},
 CellLabel->
  "In[131]:=",ExpressionUUID->"551db7b1-b190-ea43-9ed9-10cddf39dcce"],

Cell[BoxData["False"], "Output",
 CellChangeTimes->{3.9358551387265797`*^9, 3.9358554252236786`*^9, 
  3.93585547092844*^9},
 CellLabel->
  "Out[131]=",ExpressionUUID->"5dc4aabb-17c8-384c-a410-a1ce916ea2a7"]
}, Open  ]],

Cell["\<\
Yes, every run of 8 has at least one G in it. So, I will stick with this \
requirement.\
\>", "Text",
 CellChangeTimes->{{3.9358552111148376`*^9, 3.9358552186342087`*^9}, {
  3.9358554787154694`*^9, 
  3.935855525642557*^9}},ExpressionUUID->"bfae35ff-6397-1342-aacd-\
b00d50c50e6a"],

Cell[BoxData[{
 RowBox[{"baseFirstInt", "=", 
  RowBox[{"RandomInteger", "[", 
   RowBox[{"{", 
    RowBox[{"1", ",", 
     RowBox[{"Length", "[", "baseOptions", "]"}]}], "}"}], 
   "]"}]}], "\[IndentingNewLine]", 
 RowBox[{"baseFirstPick", "=", 
  RowBox[{"baseOptions", "[", 
   RowBox[{"[", "baseFirstInt", "]"}], "]"}]}], "\[IndentingNewLine]", 
 RowBox[{"baseOptionsTemp", "=", 
  RowBox[{"Drop", "[", 
   RowBox[{"baseOptions", ",", 
    RowBox[{"{", "baseFirstInt", "}"}]}], "]"}]}]}], "Input",
 CellChangeTimes->{{3.9358536249839344`*^9, 3.935853703168001*^9}},
 CellLabel->"In[90]:=",ExpressionUUID->"d03e95eb-3cd7-7446-872f-54769cc64512"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Length", "[", "baseOptionsTemp", "]"}]], "Input",
 CellChangeTimes->{{3.9358537348908825`*^9, 3.935853738912323*^9}},
 CellLabel->"In[93]:=",ExpressionUUID->"785120a0-d3da-884a-81cd-4a4ea63d6ab0"],

Cell[BoxData["2"], "Output",
 CellChangeTimes->{{3.93585362540732*^9, 3.9358536352352066`*^9}, {
   3.9358536691326313`*^9, 3.9358537035281544`*^9}, 3.9358537394013577`*^9},
 CellLabel->"Out[93]=",ExpressionUUID->"9bfc20a4-dccf-314d-8f3d-0b1a833fa9b6"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"baseFirstPick", "==", "\"\<T\>\""}]], "Input",
 CellChangeTimes->{{3.93585390540222*^9, 3.9358539114086*^9}},
 CellLabel->"In[95]:=",ExpressionUUID->"74ecc1dc-327e-e744-a4a6-366b15096ad1"],

Cell[BoxData["True"], "Output",
 CellChangeTimes->{{3.9358539082613583`*^9, 3.9358539119011745`*^9}},
 CellLabel->"Out[95]=",ExpressionUUID->"f80dba2d-c044-2e40-8365-23378c5095ea"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Length", "[", "baseOptionsTemp", "]"}], ">", "0"}]], "Input",
 CellLabel->
  "In[106]:=",ExpressionUUID->"58740e55-e355-314b-a6d6-1c28d98b1201"],

Cell[BoxData["True"], "Output",
 CellChangeTimes->{3.935854260338793*^9},
 CellLabel->
  "Out[106]=",ExpressionUUID->"92169b5f-f123-7749-82ed-b45449da6aec"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData["baseOptionsTemp"], "Input",
 CellLabel->
  "In[107]:=",ExpressionUUID->"2a9eda22-6b4f-5b41-a185-49da3c2d96b8"],

Cell[BoxData[
 RowBox[{"{", "\<\"G\"\>", "}"}]], "Output",
 CellChangeTimes->{3.9358542641804485`*^9},
 CellLabel->
  "Out[107]=",ExpressionUUID->"dd38e121-38c9-0140-9bfa-10498ecb7f06"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Length", "[", 
   RowBox[{"Drop", "[", 
    RowBox[{"baseOptionsTemp", ",", 
     RowBox[{"{", "baseInt", "}"}]}], "]"}], "]"}], ">", "0"}]], "Input",
 CellChangeTimes->{{3.9358542810423985`*^9, 3.935854288601156*^9}},
 CellLabel->
  "In[109]:=",ExpressionUUID->"78169e18-8789-8e41-a6a6-47478f3a84cd"],

Cell[BoxData["False"], "Output",
 CellChangeTimes->{{3.9358542751379566`*^9, 3.9358542888870487`*^9}},
 CellLabel->
  "Out[109]=",ExpressionUUID->"7a64946a-ebac-1046-a87e-31992f5a2200"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DuplicateFreeQ", "[", "allRunsOf8test", "]"}]], "Input",
 CellChangeTimes->{{3.935854986163063*^9, 3.9358549882269363`*^9}},
 CellLabel->
  "In[144]:=",ExpressionUUID->"1983942a-0933-194a-b761-3b239c8d8ada"],

Cell[BoxData["True"], "Output",
 CellChangeTimes->{{3.9358549602766533`*^9, 3.9358549885634365`*^9}, 
   3.935855990241726*^9},
 CellLabel->
  "Out[144]=",ExpressionUUID->"8d6a756c-11d5-6147-aecb-2c471df8913e"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"baseOptionsTemp", "=", "baseOptions"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"seqTest", "=", "kishiEtAl2017seq"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"allRunsOf8test", "=", "allRunsOf8"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"While", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Length", "[", "baseOptionsTemp", "]"}], ">", "0"}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"baseInt", "=", 
     RowBox[{"RandomInteger", "[", 
      RowBox[{"{", 
       RowBox[{"1", ",", 
        RowBox[{"Length", "[", "baseOptionsTemp", "]"}]}], "}"}], "]"}]}], 
    ";", "\[IndentingNewLine]", 
    RowBox[{"basePick", "=", 
     RowBox[{"baseOptionsTemp", "[", 
      RowBox[{"[", "baseInt", "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
    RowBox[{"seqTemp", "=", 
     RowBox[{"seqTest", "<>", "basePick"}]}], ";", "\[IndentingNewLine]", 
    RowBox[{"last8temp", "=", 
     RowBox[{"StringTake", "[", 
      RowBox[{"seqTemp", ",", 
       RowBox[{"-", "8"}]}], "]"}]}], ";", "\[IndentingNewLine]", 
    RowBox[{"If", "[", 
     RowBox[{
      RowBox[{"StringContainsQ", "[", 
       RowBox[{"last8temp", ",", "\"\<G\>\""}], "]"}], ",", 
      RowBox[{"(*", 
       RowBox[{
       "check", " ", "that", " ", "the", " ", "new", " ", "run", " ", "of", 
        " ", "8", " ", "has", " ", "at", " ", "least", " ", "one", " ", "G", 
        " ", "in", " ", "it"}], "*)"}], "\[IndentingNewLine]", 
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"basePick", "==", "\"\<A\>\""}], "||", 
          RowBox[{"basePick", "==", "\"\<T\>\""}]}], ")"}], ",", 
        RowBox[{"(*", 
         RowBox[{"if", " ", "trying", " ", "A", " ", "or", " ", "T"}], "*)"}],
         "\[IndentingNewLine]", 
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"StringTake", "[", 
              RowBox[{"seqTemp", ",", 
               RowBox[{"-", "6"}]}], "]"}], "==", "\"\<AAAAAA\>\""}], "||", 
            RowBox[{
             RowBox[{"StringTake", "[", 
              RowBox[{"seqTemp", ",", 
               RowBox[{"-", "6"}]}], "]"}], "==", "\"\<TTTTTT\>\""}]}], ")"}],
           ",", 
          RowBox[{"(*", 
           RowBox[{
           "test", " ", "whether", " ", "a", " ", "run", " ", "of", " ", 
            "greater", " ", "than", " ", "5", " ", "As", " ", "or", " ", "Ts",
             " ", "will", " ", "happen"}], "*)"}], "\[IndentingNewLine]", 
          RowBox[{"baseOptionsTemp", "=", 
           RowBox[{"Drop", "[", 
            RowBox[{"baseOptionsTemp", ",", 
             RowBox[{"{", "baseInt", "}"}]}], "]"}]}], ",", 
          RowBox[{"(*", 
           RowBox[{
            RowBox[{"if", " ", "so"}], ",", " ", 
            RowBox[{
            "then", " ", "drop", " ", "this", " ", "possibility", " ", "from",
              " ", "the", " ", "list", " ", "and", " ", "try", " ", 
             "again"}]}], "*)"}], "\[IndentingNewLine]", 
          RowBox[{"(*", 
           RowBox[{"otherwise", ",", " ", 
            RowBox[{
            "add", " ", "the", " ", "last", " ", "8", " ", "bases", " ", "to",
              " ", "allRunsOf8test"}]}], "*)"}], "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"allRunsOf8temp", "=", 
            RowBox[{"Join", "[", 
             RowBox[{"allRunsOf8test", ",", 
              RowBox[{"{", "last8temp", "}"}]}], "]"}]}], ";", 
           "\[IndentingNewLine]", 
           RowBox[{"If", "[", 
            RowBox[{
             RowBox[{"DuplicateFreeQ", "[", "allRunsOf8temp", "]"}], ",", 
             RowBox[{"(*", 
              RowBox[{
              "check", " ", "whether", " ", "a", " ", "sequence", " ", "of", 
               " ", "8", " ", "has", " ", "not", " ", "been", " ", 
               "duplicated"}], "*)"}], "\[IndentingNewLine]", 
             RowBox[{
              RowBox[{"seqTest", "=", "seqTemp"}], ";", "\[IndentingNewLine]", 
              RowBox[{"allRunsOf8test", "=", "allRunsOf8temp"}], ";", 
              "\[IndentingNewLine]", 
              RowBox[{"baseOptionsTemp", "=", "baseOptions"}]}], ",", 
             RowBox[{"(*", 
              RowBox[{
               RowBox[{"in", " ", "that", " ", "case"}], ",", " ", 
               RowBox[{"the", " ", "tests", " ", "have", " ", 
                RowBox[{"succeeded", "!"}], " ", "Add", " ", "the", " ", 
                "base", " ", "to", " ", "seqTest"}], ",", " ", 
               RowBox[{
               "permanently", " ", "add", " ", "the", " ", "last", " ", "8", 
                " ", "bases", " ", "to", " ", "the", " ", "list", " ", "of", 
                " ", "all", " ", "sequences", " ", "of", " ", "8"}], ",", " ", 
               RowBox[{
               "and", " ", "restore", " ", "all", " ", "possible", " ", 
                "next", " ", "base", " ", "options"}]}], "*)"}], 
             "\[IndentingNewLine]", 
             RowBox[{"baseOptionsTemp", "=", 
              RowBox[{"Drop", "[", 
               RowBox[{"baseOptionsTemp", ",", 
                RowBox[{"{", "baseInt", "}"}]}], "]"}]}]}], "]"}], ";"}]}], 
         RowBox[{"(*", 
          RowBox[{
           RowBox[{
           "sequence", " ", "of", " ", "8", " ", "has", " ", "been", " ", 
            "duplicated"}], ",", " ", 
           RowBox[{
           "so", " ", "drop", " ", "this", " ", "possibility", " ", "from", 
            " ", "the", " ", "list", " ", "and", " ", "try", " ", "again"}]}],
           "*)"}], "\[IndentingNewLine]", "]"}], ",", "\[IndentingNewLine]", 
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"StringTake", "[", 
             RowBox[{"seqTemp", ",", 
              RowBox[{"-", "4"}]}], "]"}], "==", "\"\<GGGG\>\""}], ")"}], ",", 
          RowBox[{"(*", 
           RowBox[{
            RowBox[{"if", " ", "trying", " ", "G"}], ",", " ", 
            RowBox[{
            "test", " ", "whether", " ", "a", " ", "run", " ", "of", " ", 
             "greater", " ", "than", " ", "3", " ", "Gs", " ", "will", " ", 
             "happen"}]}], "*)"}], "\[IndentingNewLine]", 
          RowBox[{"baseOptionsTemp", "=", 
           RowBox[{"Drop", "[", 
            RowBox[{"baseOptionsTemp", ",", 
             RowBox[{"{", "baseInt", "}"}]}], "]"}]}], ",", 
          RowBox[{"(*", 
           RowBox[{
            RowBox[{"if", " ", "so"}], ",", " ", 
            RowBox[{
            "then", " ", "drop", " ", "G", " ", "as", " ", "a", " ", 
             "possibility", " ", "and", " ", "try", " ", "again"}]}], "*)"}], 
          "\[IndentingNewLine]", 
          RowBox[{"(*", 
           RowBox[{"otherwise", ",", " ", 
            RowBox[{
            "add", " ", "the", " ", "last", " ", "8", " ", "bases", " ", "to",
              " ", "allRunsOf8test"}]}], "*)"}], "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"allRunsOf8temp", "=", 
            RowBox[{"Join", "[", 
             RowBox[{"allRunsOf8test", ",", 
              RowBox[{"{", "last8temp", "}"}]}], "]"}]}], ";", 
           "\[IndentingNewLine]", 
           RowBox[{"If", "[", 
            RowBox[{
             RowBox[{"DuplicateFreeQ", "[", "allRunsOf8temp", "]"}], ",", 
             RowBox[{"(*", 
              RowBox[{
              "check", " ", "whether", " ", "a", " ", "sequence", " ", "of", 
               " ", "8", " ", "has", " ", "not", " ", "been", " ", 
               "duplicated"}], "*)"}], "\[IndentingNewLine]", 
             RowBox[{
              RowBox[{"seqTest", "=", "seqTemp"}], ";", "\[IndentingNewLine]", 
              RowBox[{"allRunsOf8test", "=", "allRunsOf8temp"}], ";", 
              "\[IndentingNewLine]", 
              RowBox[{"baseOptionsTemp", "=", "baseOptions"}]}], ",", 
             RowBox[{"(*", 
              RowBox[{
               RowBox[{"in", " ", "that", " ", "case"}], ",", " ", 
               RowBox[{"the", " ", "tests", " ", "have", " ", 
                RowBox[{"succeeded", "!"}], " ", "Add", " ", "the", " ", 
                "base", " ", "to", " ", "seqTest"}], ",", " ", 
               RowBox[{
               "permanently", " ", "add", " ", "the", " ", "last", " ", "8", 
                " ", "bases", " ", "to", " ", "the", " ", "list", " ", "of", 
                " ", "all", " ", "sequences", " ", "of", " ", "8"}], ",", " ", 
               RowBox[{
               "and", " ", "restore", " ", "all", " ", "possible", " ", 
                "next", " ", "base", " ", "options"}]}], "*)"}], 
             "\[IndentingNewLine]", 
             RowBox[{"baseOptionsTemp", "=", 
              RowBox[{"Drop", "[", 
               RowBox[{"baseOptionsTemp", ",", 
                RowBox[{"{", "baseInt", "}"}]}], "]"}]}]}], "]"}], ";"}]}], 
         RowBox[{"(*", 
          RowBox[{
           RowBox[{
           "sequence", " ", "of", " ", "8", " ", "has", " ", "been", " ", 
            "duplicated"}], ",", " ", 
           RowBox[{
           "so", " ", "drop", " ", "this", " ", "possibility", " ", "from", 
            " ", "the", " ", "list", " ", "and", " ", "try", " ", "again"}]}],
           "*)"}], "\[IndentingNewLine]", "]"}]}], "\[IndentingNewLine]", 
       "]"}], ",", "\[IndentingNewLine]", 
      RowBox[{"baseOptionsTemp", "=", 
       RowBox[{"Drop", "[", 
        RowBox[{"baseOptionsTemp", ",", 
         RowBox[{"{", "baseInt", "}"}]}], "]"}]}]}], 
     RowBox[{"(*", 
      RowBox[{
       RowBox[{
       "the", " ", "new", " ", "run", " ", "of", " ", "8", " ", "does", " ", 
        "not", " ", "have", " ", "at", " ", "least", " ", "one", " ", "G", 
        " ", "in", " ", "it"}], ",", " ", 
       RowBox[{
       "so", " ", "drop", " ", "this", " ", "possibility", " ", "from", " ", 
        "the", " ", "list", " ", "and", " ", "try", " ", "again"}]}], "*)"}], 
     "\[IndentingNewLine]", "]"}]}]}], "\[IndentingNewLine]", 
  "]"}], "\[IndentingNewLine]", 
 RowBox[{"StringLength", "[", "seqTest", "]"}]}], "Input",
 CellChangeTimes->{{3.935850420516527*^9, 3.9358504210033636`*^9}, {
   3.935850470906772*^9, 3.9358504998200464`*^9}, {3.935850561090818*^9, 
   3.9358506013877983`*^9}, {3.9358506832747927`*^9, 3.935850719314949*^9}, {
   3.9358507813813934`*^9, 3.935850859044298*^9}, {3.9358509372225723`*^9, 
   3.9358510762364*^9}, 3.935851153554155*^9, {3.9358512519624214`*^9, 
   3.935851440541174*^9}, {3.935852471536253*^9, 3.935852823773958*^9}, {
   3.935852859131479*^9, 3.93585287806682*^9}, {3.935852910305431*^9, 
   3.935852934813767*^9}, 3.935852992132353*^9, {3.93585323797529*^9, 
   3.9358532840038176`*^9}, 3.935853427563179*^9, 3.9358535271148844`*^9, {
   3.935853574724079*^9, 3.9358536227725735`*^9}, 3.935853709753843*^9, {
   3.935853745826115*^9, 3.9358537511311703`*^9}, {3.935853811966226*^9, 
   3.935853900347082*^9}, {3.93585394927602*^9, 3.935854019639168*^9}, {
   3.9358540511521473`*^9, 3.935854164270597*^9}, {3.935854210426573*^9, 
   3.935854227473135*^9}, {3.935854338529415*^9, 3.9358544650186205`*^9}, {
   3.935854497188736*^9, 3.935854527083475*^9}, {3.935854591130541*^9, 
   3.9358546169669437`*^9}, {3.9358547700437107`*^9, 
   3.9358547925146527`*^9}, {3.935855551639583*^9, 3.93585573500769*^9}, {
   3.935856038518341*^9, 3.935856038939987*^9}, 3.93585620568942*^9, {
   3.9358564145138593`*^9, 3.9358564291188173`*^9}, {3.935856460670925*^9, 
   3.935856468662876*^9}, 3.935856538891815*^9},
 CellLabel->
  "In[191]:=",ExpressionUUID->"4723bb9f-6579-d249-ac21-5946e5697c46"],

Cell[BoxData["3038"], "Output",
 CellChangeTimes->{
  3.935852995254774*^9, 3.935853619744629*^9, 3.935854194979166*^9, 
   3.935854722517584*^9, 3.9358549422297535`*^9, 3.935855824984354*^9, 
   3.935856067330845*^9, 3.9358564802256165`*^9, {3.935856540008951*^9, 
   3.93585655108885*^9}},
 CellLabel->
  "Out[195]=",ExpressionUUID->"bbaed0e9-a35f-8d45-bacf-8a71a2457085"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData["seqTest"], "Input",
 CellLabel->
  "In[196]:=",ExpressionUUID->"dee6c526-7e0e-554e-8330-7c27492cb4d1"],

Cell[BoxData["\<\"\
TGTTAGTAGTTGGATGTGTTTGGTGATAGGTATTAAAGTAAGGTATGGAGGAGATTTTGGTGGAATAAGTAGTAAGAA\
ATGATTAGGTTTGAATGAGAGAATTGAAGAGGATGTTATAATGATAGTGAGGGATAAAATGTAATGTGAATGGGTAGA\
AGATATGTATGTGGTATTGTAAAGGATTATGGAGTGGAATTAGATATGGTGTTAGAGTTTGTAATTTAGTAAAGGTGT\
TTAATTGAGGATGGTGATGAGGTAAATAGAGGGATGATAGGATATATAGTGAAGAGATTTATAGTGGAGTTGAAAAGT\
TTTGGAAAATTAGAGTGGTGGATAGATTAGATTAAGAGGAGGTTGGATAATGTAGGATAGGTGTTATATGGATAGTAA\
ATTTGATAGAGTGTGGAATGAGGTTGTTTAGTTAGTTAAAAAGATGTTAATGAGTAATGTTGGTTGTATATAAGGAAG\
AAGGTTGAATGGATGAAAAGGAGGAATAGTGATGTTTATTTGATGTTGGGTATTTATGATTAAGTTGAAGGAGTTTAA\
TAGAATAGGAGTTAGTGGATGGGTATGTAGTGTGGTAAGAATATTGGAGGTGAGGAAGTTTGATATTTAGTTGATATG\
GAGAGTTTAGTATTAATGTGGAGTGATAGAAAATAGTTAATAGGGAGGGAGTTAAGTAAAGATGAGTTGAGATTTGAT\
TGTTGTGTTTATGGTAGGTGATAAGTTATGGAAATAGATTGAGAATGGAAAGAAGTTATTAAGATAGTTATGAGGAAT\
GGAGTTTTTGAATTGGTGTAGTGATATTAGGTAGGTATGTGTGAAGAATGATTTGAAGTGTTAGTGAGTAAGAGTATG\
GATGGTTGTGAGAGTATTTAAGTTTGGATTGTAGAAGGTGATGTGTAATGGTAATGTATGGTGAAAGAAATTAGGGAT\
GTTGATGATTATGAGTGAATGAAGGTGGAAATTGGAGAAGATGTATTGGATAGGAGAGATTAGGATGATTGAGTAGGT\
TATTAGATGGTTATTGTTTATAAGAAGGAGAAAATGTTATTTTGGATGGATTAGTAATAGGAAGATAGGTTTTTATGG\
GTAAGAGAAATGGATTGGTTATAGGGAATTTGTAAAAAGTTGTAGGAGGAGTTGTTGAAGAAGAGAATGAATAATTGT\
AAGTGGTTATGTTATGAATATATGGGTTTGTGGATTAAGGGATGGTATGGTATAGAGAAAGATATAGTTTATGTTGGA\
ATTGTGAGTATTAGGAGGTGTAGAGATTGGGAGTAATTGAAAATGGTTGATAAAAAGGTTGTAAATAAGATAATGAAG\
ATGGGTGAGAAGGTATTGAAATGAATGATGTGAAAATATGTTAGGGTGGTTGTTATAGAGTTATAAGGTAGGATTAGA\
AGAAAAATGATGGTTTTATAGAAAGTGGAAAGGGTAAATGATATATTGATTGATGAGAGTGTTATTGGTAAAGGGAAG\
GATATTGAAGGGTAGTTGTAAGGAGAGTGGGTGAATGTAAGTTGTGTGGTTAGGATAAATGGTGGTTTAGATGTAAGA\
TTAGTTGTTAGGAGAAGGATTGAATGTTGTATTATTGTGAAAGTGTTGAATTAGGTGGGAGTTTGAAGATAAGATTGA\
AGTAGTGTAGGAAAGGATAGTTGGTAAGGAAAAATAGAAGTTGAGTAAAAGGTGGTTAAATAGGGTTAAAGTTGATTA\
GAGGGTTGGGTGATTATAAGTAATGGGAATGGGAGAATGTGTAGATAGAAGAGGTGAAATAATGAGGAGTGTTGGGAA\
ATTAAGAAAGGAATTAAAGGGTTTTGGGAGGGTGAAAAATTGTGTTGTTTTGGTATTAGAGATAGGGATATGGGAAAG\
GTGAGAGAGGAAAAGGGAGTAGATTGGATTATAGGTTAGGTTGAGAAGAATTTGGGATGTATAAAAGAAAATTGGTAT\
AATGGGTGGAGTAAAGTGTAGAAATTGTATGTATTAGTTATTGAGATGTGAGAAAAGGTAGTTATATAGAGGTGGTGG\
GATTGGAAATGAGGGTATTGGTTTTGATAATTGGGTGGGAAGGGATTTAGAGAGATATATGATTTAAGAGTGGAGAAA\
GTTAGAATTGTAGTGGAAGAATAATGGTGTGTTGGATTTTTAGAAGTGAGTTAAAGGTATATAGGATTTTAGATTGTT\
TGTAGGGATTAGGGTATAGGTGGATGTTTTGTTAATTTGAAAAAGTAAATGGAGGTAAGATATTGGTGAGATGAAGAA\
AGAGAAGAGTGTAAAAGTGGGTAGTATAATTGATGTGGTGTAAATTGAGAGGGTAAGGGAAATGGTAGTGGTTTTTGT\
TTGATGAAAGATGGAGATAGTGGGATATAAGTGTAAGAAGAAGTAAAAATGTGGGTATAAATGTTTGGAGGGTAGGAA\
TGTTTAAGAAGTGGTAATATTGAGTTATGTATATTGTATAAGGGTGTGGTGATTTAGGGTTTAGGGAAAGATTTAAAG\
ATTGTGATGTAGTATGAATGGTATTTTTGATGGATGTAGATGGGAGGTGGAGGAAGAGAGAAAAAGGAAAGAGTGATT\
AGTGGTGTGAAATTGATTATTTGGGTGTTGTGGTGGTATGTTAAATGAGAATTTATGGATTTAATGTTTTATGAGAGG\
TTAGAGAATAAAAGGATGAGATATGAGTATGTTTTTAAGGGTTATTTGTTGTAGAGTGAAAAGAAGATTGGTGGTGAA\
GTTAGTAAGGATTTGGTGTGGAGGGATTGAGGGAGAGTAGTAGGGAGAAGTAGGTGTGTGAGATTGATTTTAAGTAGA\
AAGGGATAGTGTGAATAAGGATAAGGAGGTATTTGGTTGAAATAGGATGTAATTATGGGAGTGAAGGAATAAATGAAG\
TGGGAGGAAAGTGAGGTGGGTAAAGAGGAATTGGATGATGAGTGTGATATAATGTTAGTTGGGATTAATAGTAGTATT\
TTGAGAGTTGTGAAGTGATGGTGGGTGTGTATGGAATGTGGTTTGTATAGGGTGTTAAGGTAATGGATATAGGG\"\>\
"], "Output",
 CellChangeTimes->{3.9358566209343586`*^9},
 CellLabel->
  "Out[196]=",ExpressionUUID->"d4ca9ae9-8134-294c-accf-0c80f174ebd3"]
}, Open  ]],

Cell[BoxData[
 RowBox[{"(*", 
  RowBox[{
  "double", " ", "check", " ", "that", " ", "this", " ", "new", " ", 
   "scaffold", " ", "satisfies", " ", "all", " ", "requirements"}], 
  "*)"}]], "Input",
 CellChangeTimes->{{3.935856578995907*^9, 
  3.935856598988617*^9}},ExpressionUUID->"23a56538-b350-bb42-87f7-\
796b8e995c5e"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"allRunsOf8new", "=", 
    RowBox[{"Table", "[", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"StringTake", "[", 
       RowBox[{"seqTest", ",", 
        RowBox[{"{", 
         RowBox[{"i", ",", 
          RowBox[{"i", "+", "7"}]}], "}"}]}], "]"}], "\[IndentingNewLine]", 
      ",", 
      RowBox[{"{", 
       RowBox[{"i", ",", 
        RowBox[{
         RowBox[{"StringLength", "[", "seqTest", "]"}], "-", "7"}]}], "}"}]}],
      "]"}]}], ";"}], "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{
    RowBox[{
    "test", " ", "if", " ", "there", " ", "are", " ", "no", " ", "duplicated",
      " ", "runs", " ", "of", " ", "8.", " ", "If", " ", "true"}], ",", " ", 
    RowBox[{
    "then", " ", "no", " ", "run", " ", "of", " ", "8", " ", "or", " ", 
     "larger", " ", "is", " ", "duplicated", " ", "in", " ", "the", " ", 
     RowBox[{"scaffold", "."}]}]}], "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{"DuplicateFreeQ", "[", "allRunsOf8new", "]"}]}], "Input",
 CellChangeTimes->{{3.935847117144964*^9, 3.9358472661092796`*^9}, {
  3.935856616349127*^9, 3.93585664763599*^9}},
 CellLabel->
  "In[197]:=",ExpressionUUID->"2c7c67fb-bfe6-1444-9382-2aeb7edad92b"],

Cell[BoxData["True"], "Output",
 CellChangeTimes->{3.9358566485056496`*^9},
 CellLabel->
  "Out[198]=",ExpressionUUID->"64b9a522-ffb5-b346-9112-42dcd9d66785"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{
   "test", " ", "that", " ", "whether", " ", "there", " ", "is", " ", "a", 
    " ", "sequence", " ", "of", " ", "8", " ", "missing", " ", "a", " ", 
    "G"}], "*)"}], "\[IndentingNewLine]", 
  RowBox[{"ContainsAny", "[", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Table", "[", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"StringContainsQ", "[", 
       RowBox[{
        RowBox[{"allRunsOf8new", "[", 
         RowBox[{"[", "i", "]"}], "]"}], ",", "\"\<G\>\""}], "]"}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"{", 
       RowBox[{"i", ",", 
        RowBox[{"Length", "[", "allRunsOf8new", "]"}]}], "}"}]}], "]"}], 
    "\[IndentingNewLine]", ",", 
    RowBox[{"{", "False", "}"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.9358567059173527`*^9, 
  3.935856772950468*^9}},ExpressionUUID->"6b93ab3d-c62c-cd45-8c8f-\
491ad52a1b9f"],

Cell[BoxData["False"], "Output",
 CellChangeTimes->{3.935856734406372*^9},
 CellLabel->
  "Out[199]=",ExpressionUUID->"465f1477-b111-5648-9981-92fb2bc86be9"]
}, Open  ]],

Cell[BoxData[
 RowBox[{"(*", 
  RowBox[{
  "double", " ", "check", " ", "that", " ", "there", " ", "is", " ", "no", 
   " ", "run", " ", "of", " ", "4", " ", "Gs", " ", "or", " ", "6", " ", "Ts",
    " ", "or", " ", "6", " ", "As"}], "*)"}]], "Input",
 CellChangeTimes->{{3.9358568612456417`*^9, 
  3.9358568715738564`*^9}},ExpressionUUID->"c20008de-a188-b943-a8f9-\
f2c2f8fa2e7d"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StringContainsQ", "[", 
  RowBox[{"seqTest", ",", "\"\<GGGG\>\""}], "]"}]], "Input",
 CellChangeTimes->{{3.9358568302073116`*^9, 3.935856839934307*^9}},
 CellLabel->
  "In[201]:=",ExpressionUUID->"77c45fec-aba5-1a43-a19b-38979be8ba52"],

Cell[BoxData["False"], "Output",
 CellChangeTimes->{{3.9358568375587654`*^9, 3.935856840327711*^9}},
 CellLabel->
  "Out[201]=",ExpressionUUID->"dac98a0b-41f2-3744-ba50-4bf96a63d02d"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StringContainsQ", "[", 
  RowBox[{"seqTest", ",", "\"\<TTTTTT\>\""}], "]"}]], "Input",
 CellChangeTimes->{{3.935856845518242*^9, 3.9358568466694584`*^9}},
 CellLabel->
  "In[202]:=",ExpressionUUID->"1a90b965-deff-504c-a320-b243069a2aa4"],

Cell[BoxData["False"], "Output",
 CellChangeTimes->{3.935856847134163*^9},
 CellLabel->
  "Out[202]=",ExpressionUUID->"d7986af4-8de7-274e-a82f-855e94df8db0"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StringContainsQ", "[", 
  RowBox[{"seqTest", ",", "\"\<AAAAAA\>\""}], "]"}]], "Input",
 CellChangeTimes->{{3.9358568519422607`*^9, 3.9358568530382175`*^9}},
 CellLabel->
  "In[203]:=",ExpressionUUID->"fff11f24-1861-544f-911d-3e6ac7ee9fc4"],

Cell[BoxData["False"], "Output",
 CellChangeTimes->{3.9358568534641056`*^9},
 CellLabel->
  "Out[203]=",ExpressionUUID->"67659629-99c5-b644-b9c9-749602bdbce7"]
}, Open  ]],

Cell[BoxData[
 RowBox[{"(*", 
  RowBox[{
   RowBox[{
    RowBox[{"perfect", "!"}], " ", "A", " ", "sequence", " ", "which", " ", 
    "follows", " ", "these", " ", "rules"}], ",", " ", 
   RowBox[{"containing", " ", "3038", " ", "nt"}], ",", " ", 
   RowBox[{"has", " ", "been", " ", 
    RowBox[{"produced", ".", " ", "Recorded"}], " ", 
    RowBox[{"here", "."}]}]}], "*)"}]], "Input",
 CellChangeTimes->{{3.935856877416992*^9, 3.935856881253113*^9}, {
  3.935856920493622*^9, 
  3.93585693520714*^9}},ExpressionUUID->"ed156e74-9a04-a041-a23d-\
fe7c8e5b8a38"],

Cell[BoxData[
 RowBox[{
  RowBox[{"seq3038", "=", "seqTest"}], ";"}]], "Input",
 CellChangeTimes->{{3.935856943181324*^9, 3.9358569562550106`*^9}},
 CellLabel->
  "In[204]:=",ExpressionUUID->"dd2e9caf-ebc6-1241-9fe5-11d24eee21c8"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Export", "[", 
  RowBox[{"\"\<customScaffold3038.txt\>\"", ",", "seq3038"}], "]"}]], "Input",
 CellChangeTimes->{{3.935856994165474*^9, 3.935857005613905*^9}, {
  3.935857038592785*^9, 3.935857056854025*^9}, {3.935857089022356*^9, 
  3.935857093334257*^9}},
 CellLabel->
  "In[206]:=",ExpressionUUID->"09eb9329-9d94-6e47-b280-e75b29b5677e"],

Cell[BoxData["\<\"customScaffold3038.txt\"\>"], "Output",
 CellChangeTimes->{3.9358570579469547`*^9, 3.935857094927952*^9},
 CellLabel->
  "Out[206]=",ExpressionUUID->"32a51cce-1542-1846-9559-76f56af2ca32"]
}, Open  ]],

Cell[BoxData[
 RowBox[{"(*", 
  RowBox[{
   RowBox[{
   "Let", " ", "me", " ", "try", " ", "one", " ", "more", " ", "time"}], ",", 
   " ", 
   RowBox[{
   "this", " ", "time", " ", "starting", " ", "from", " ", "a", " ", 
    "randomly", " ", "generated", " ", "sequence", " ", "beginning", " ", 
    "with", " ", "a", " ", "G", " ", "and", " ", "7", " ", "randomly", " ", 
    "chosen", " ", "nt", " ", "without", " ", "a", " ", "run", " ", "of", " ",
     "too", " ", "many", " ", "Gs"}], ",", " ", "As", ",", " ", 
   RowBox[{"or", " ", "Ts", " ", "in", " ", "a", " ", 
    RowBox[{"row", "."}]}]}], "*)"}]], "Input",
 CellChangeTimes->{{3.935856877416992*^9, 3.935856881253113*^9}, {
  3.935856920493622*^9, 3.93585693520714*^9}, {3.935857647574768*^9, 
  3.935857734671295*^9}},ExpressionUUID->"33d04df1-b5f1-6e43-97dc-\
54905bcbeb19"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"seqTest", "=", "\"\<G\>\""}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"baseInt", "=", 
   RowBox[{"RandomInteger", "[", 
    RowBox[{"{", 
     RowBox[{"1", ",", 
      RowBox[{"Length", "[", "baseOptions", "]"}]}], "}"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"basePick", "=", 
   RowBox[{"baseOptions", "[", 
    RowBox[{"[", "baseInt", "]"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"seqTest", "=", 
   RowBox[{"seqTest", "<>", "basePick"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"baseInt", "=", 
   RowBox[{"RandomInteger", "[", 
    RowBox[{"{", 
     RowBox[{"1", ",", 
      RowBox[{"Length", "[", "baseOptions", "]"}]}], "}"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"basePick", "=", 
   RowBox[{"baseOptions", "[", 
    RowBox[{"[", "baseInt", "]"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"seqTest", "=", 
   RowBox[{"seqTest", "<>", "basePick"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"seqTemp", "=", 
  RowBox[{"StringTake", "[", 
   RowBox[{"seqTest", ",", 
    RowBox[{"-", "3"}]}], "]"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"baseOptionsTemp", "=", 
   RowBox[{"If", "[", 
    RowBox[{
     RowBox[{"seqTemp", "==", "\"\<GGG\>\""}], ",", 
     RowBox[{"{", 
      RowBox[{"\"\<A\>\"", ",", "\"\<T\>\""}], "}"}], ",", "baseOptions"}], 
    "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"baseInt", "=", 
   RowBox[{"RandomInteger", "[", 
    RowBox[{"{", 
     RowBox[{"1", ",", 
      RowBox[{"Length", "[", "baseOptionsTemp", "]"}]}], "}"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"basePick", "=", 
   RowBox[{"baseOptionsTemp", "[", 
    RowBox[{"[", "baseInt", "]"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"seqTest", "=", 
   RowBox[{"seqTest", "<>", "basePick"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"seqTemp", "=", 
  RowBox[{"StringTake", "[", 
   RowBox[{"seqTest", ",", 
    RowBox[{"-", "3"}]}], "]"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"baseOptionsTemp", "=", 
   RowBox[{"If", "[", 
    RowBox[{
     RowBox[{"seqTemp", "==", "\"\<GGG\>\""}], ",", 
     RowBox[{"{", 
      RowBox[{"\"\<A\>\"", ",", "\"\<T\>\""}], "}"}], ",", "baseOptions"}], 
    "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"baseInt", "=", 
   RowBox[{"RandomInteger", "[", 
    RowBox[{"{", 
     RowBox[{"1", ",", 
      RowBox[{"Length", "[", "baseOptionsTemp", "]"}]}], "}"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"basePick", "=", 
   RowBox[{"baseOptionsTemp", "[", 
    RowBox[{"[", "baseInt", "]"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"seqTest", "=", 
   RowBox[{"seqTest", "<>", "basePick"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"Do", "[", "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"seqTemp", "=", 
     RowBox[{"StringTake", "[", 
      RowBox[{"seqTest", ",", 
       RowBox[{"-", "3"}]}], "]"}]}], ";", "\[IndentingNewLine]", 
    RowBox[{"baseOptionsTemp", "=", 
     RowBox[{"If", "[", 
      RowBox[{
       RowBox[{"seqTemp", "==", "\"\<GGG\>\""}], ",", 
       RowBox[{"{", 
        RowBox[{"\"\<A\>\"", ",", "\"\<T\>\""}], "}"}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"If", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"StringTake", "[", 
           RowBox[{"seqTest", ",", 
            RowBox[{"-", "5"}]}], "]"}], "==", "\"\<AAAAA\>\""}], ",", 
         RowBox[{"{", 
          RowBox[{"\"\<G\>\"", ",", "\"\<T\>\""}], "}"}], ",", 
         "\[IndentingNewLine]", 
         RowBox[{"If", "[", 
          RowBox[{
           RowBox[{
            RowBox[{"StringTake", "[", 
             RowBox[{"seqTest", ",", 
              RowBox[{"-", "5"}]}], "]"}], "==", "\"\<TTTTT\>\""}], ",", 
           RowBox[{"{", 
            RowBox[{"\"\<A\>\"", ",", "\"\<G\>\""}], "}"}], ",", 
           "baseOptions"}], "]"}]}], "\[IndentingNewLine]", "]"}]}], 
      "\[IndentingNewLine]", "]"}]}], ";", "\[IndentingNewLine]", 
    RowBox[{"baseInt", "=", 
     RowBox[{"RandomInteger", "[", 
      RowBox[{"{", 
       RowBox[{"1", ",", 
        RowBox[{"Length", "[", "baseOptionsTemp", "]"}]}], "}"}], "]"}]}], 
    ";", "\[IndentingNewLine]", 
    RowBox[{"basePick", "=", 
     RowBox[{"baseOptionsTemp", "[", 
      RowBox[{"[", "baseInt", "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
    RowBox[{"seqTest", "=", 
     RowBox[{"seqTest", "<>", "basePick"}]}]}], "\[IndentingNewLine]", ",", 
   RowBox[{"{", 
    RowBox[{"i", ",", "3"}], "}"}]}], 
  "]"}], "\[IndentingNewLine]", "seqTest", "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"baseOptionsTemp", "=", "baseOptions"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"allRunsOf8test", "=", 
   RowBox[{"{", "seqTest", "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"While", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Length", "[", "baseOptionsTemp", "]"}], ">", "0"}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"baseInt", "=", 
     RowBox[{"RandomInteger", "[", 
      RowBox[{"{", 
       RowBox[{"1", ",", 
        RowBox[{"Length", "[", "baseOptionsTemp", "]"}]}], "}"}], "]"}]}], 
    ";", "\[IndentingNewLine]", 
    RowBox[{"basePick", "=", 
     RowBox[{"baseOptionsTemp", "[", 
      RowBox[{"[", "baseInt", "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
    RowBox[{"seqTemp", "=", 
     RowBox[{"seqTest", "<>", "basePick"}]}], ";", "\[IndentingNewLine]", 
    RowBox[{"last8temp", "=", 
     RowBox[{"StringTake", "[", 
      RowBox[{"seqTemp", ",", 
       RowBox[{"-", "8"}]}], "]"}]}], ";", "\[IndentingNewLine]", 
    RowBox[{"If", "[", 
     RowBox[{
      RowBox[{"StringContainsQ", "[", 
       RowBox[{"last8temp", ",", "\"\<G\>\""}], "]"}], ",", 
      RowBox[{"(*", 
       RowBox[{
       "check", " ", "that", " ", "the", " ", "new", " ", "run", " ", "of", 
        " ", "8", " ", "has", " ", "at", " ", "least", " ", "one", " ", "G", 
        " ", "in", " ", "it"}], "*)"}], "\[IndentingNewLine]", 
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"basePick", "==", "\"\<A\>\""}], "||", 
          RowBox[{"basePick", "==", "\"\<T\>\""}]}], ")"}], ",", 
        RowBox[{"(*", 
         RowBox[{"if", " ", "trying", " ", "A", " ", "or", " ", "T"}], "*)"}],
         "\[IndentingNewLine]", 
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"StringTake", "[", 
              RowBox[{"seqTemp", ",", 
               RowBox[{"-", "6"}]}], "]"}], "==", "\"\<AAAAAA\>\""}], "||", 
            RowBox[{
             RowBox[{"StringTake", "[", 
              RowBox[{"seqTemp", ",", 
               RowBox[{"-", "6"}]}], "]"}], "==", "\"\<TTTTTT\>\""}]}], ")"}],
           ",", 
          RowBox[{"(*", 
           RowBox[{
           "test", " ", "whether", " ", "a", " ", "run", " ", "of", " ", 
            "greater", " ", "than", " ", "5", " ", "As", " ", "or", " ", "Ts",
             " ", "will", " ", "happen"}], "*)"}], "\[IndentingNewLine]", 
          RowBox[{"baseOptionsTemp", "=", 
           RowBox[{"Drop", "[", 
            RowBox[{"baseOptionsTemp", ",", 
             RowBox[{"{", "baseInt", "}"}]}], "]"}]}], ",", 
          RowBox[{"(*", 
           RowBox[{
            RowBox[{"if", " ", "so"}], ",", " ", 
            RowBox[{
            "then", " ", "drop", " ", "this", " ", "possibility", " ", "from",
              " ", "the", " ", "list", " ", "and", " ", "try", " ", 
             "again"}]}], "*)"}], "\[IndentingNewLine]", 
          RowBox[{"(*", 
           RowBox[{"otherwise", ",", " ", 
            RowBox[{
            "add", " ", "the", " ", "last", " ", "8", " ", "bases", " ", "to",
              " ", "allRunsOf8test"}]}], "*)"}], "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"allRunsOf8temp", "=", 
            RowBox[{"Join", "[", 
             RowBox[{"allRunsOf8test", ",", 
              RowBox[{"{", "last8temp", "}"}]}], "]"}]}], ";", 
           "\[IndentingNewLine]", 
           RowBox[{"If", "[", 
            RowBox[{
             RowBox[{"DuplicateFreeQ", "[", "allRunsOf8temp", "]"}], ",", 
             RowBox[{"(*", 
              RowBox[{
              "check", " ", "whether", " ", "a", " ", "sequence", " ", "of", 
               " ", "8", " ", "has", " ", "not", " ", "been", " ", 
               "duplicated"}], "*)"}], "\[IndentingNewLine]", 
             RowBox[{
              RowBox[{"seqTest", "=", "seqTemp"}], ";", "\[IndentingNewLine]", 
              RowBox[{"allRunsOf8test", "=", "allRunsOf8temp"}], ";", 
              "\[IndentingNewLine]", 
              RowBox[{"baseOptionsTemp", "=", "baseOptions"}]}], ",", 
             RowBox[{"(*", 
              RowBox[{
               RowBox[{"in", " ", "that", " ", "case"}], ",", " ", 
               RowBox[{"the", " ", "tests", " ", "have", " ", 
                RowBox[{"succeeded", "!"}], " ", "Add", " ", "the", " ", 
                "base", " ", "to", " ", "seqTest"}], ",", " ", 
               RowBox[{
               "permanently", " ", "add", " ", "the", " ", "last", " ", "8", 
                " ", "bases", " ", "to", " ", "the", " ", "list", " ", "of", 
                " ", "all", " ", "sequences", " ", "of", " ", "8"}], ",", " ", 
               RowBox[{
               "and", " ", "restore", " ", "all", " ", "possible", " ", 
                "next", " ", "base", " ", "options"}]}], "*)"}], 
             "\[IndentingNewLine]", 
             RowBox[{"baseOptionsTemp", "=", 
              RowBox[{"Drop", "[", 
               RowBox[{"baseOptionsTemp", ",", 
                RowBox[{"{", "baseInt", "}"}]}], "]"}]}]}], "]"}], ";"}]}], 
         RowBox[{"(*", 
          RowBox[{
           RowBox[{
           "sequence", " ", "of", " ", "8", " ", "has", " ", "been", " ", 
            "duplicated"}], ",", " ", 
           RowBox[{
           "so", " ", "drop", " ", "this", " ", "possibility", " ", "from", 
            " ", "the", " ", "list", " ", "and", " ", "try", " ", "again"}]}],
           "*)"}], "\[IndentingNewLine]", "]"}], ",", "\[IndentingNewLine]", 
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"StringTake", "[", 
             RowBox[{"seqTemp", ",", 
              RowBox[{"-", "4"}]}], "]"}], "==", "\"\<GGGG\>\""}], ")"}], ",", 
          RowBox[{"(*", 
           RowBox[{
            RowBox[{"if", " ", "trying", " ", "G"}], ",", " ", 
            RowBox[{
            "test", " ", "whether", " ", "a", " ", "run", " ", "of", " ", 
             "greater", " ", "than", " ", "3", " ", "Gs", " ", "will", " ", 
             "happen"}]}], "*)"}], "\[IndentingNewLine]", 
          RowBox[{"baseOptionsTemp", "=", 
           RowBox[{"Drop", "[", 
            RowBox[{"baseOptionsTemp", ",", 
             RowBox[{"{", "baseInt", "}"}]}], "]"}]}], ",", 
          RowBox[{"(*", 
           RowBox[{
            RowBox[{"if", " ", "so"}], ",", " ", 
            RowBox[{
            "then", " ", "drop", " ", "G", " ", "as", " ", "a", " ", 
             "possibility", " ", "and", " ", "try", " ", "again"}]}], "*)"}], 
          "\[IndentingNewLine]", 
          RowBox[{"(*", 
           RowBox[{"otherwise", ",", " ", 
            RowBox[{
            "add", " ", "the", " ", "last", " ", "8", " ", "bases", " ", "to",
              " ", "allRunsOf8test"}]}], "*)"}], "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"allRunsOf8temp", "=", 
            RowBox[{"Join", "[", 
             RowBox[{"allRunsOf8test", ",", 
              RowBox[{"{", "last8temp", "}"}]}], "]"}]}], ";", 
           "\[IndentingNewLine]", 
           RowBox[{"If", "[", 
            RowBox[{
             RowBox[{"DuplicateFreeQ", "[", "allRunsOf8temp", "]"}], ",", 
             RowBox[{"(*", 
              RowBox[{
              "check", " ", "whether", " ", "a", " ", "sequence", " ", "of", 
               " ", "8", " ", "has", " ", "not", " ", "been", " ", 
               "duplicated"}], "*)"}], "\[IndentingNewLine]", 
             RowBox[{
              RowBox[{"seqTest", "=", "seqTemp"}], ";", "\[IndentingNewLine]", 
              RowBox[{"allRunsOf8test", "=", "allRunsOf8temp"}], ";", 
              "\[IndentingNewLine]", 
              RowBox[{"baseOptionsTemp", "=", "baseOptions"}]}], ",", 
             RowBox[{"(*", 
              RowBox[{
               RowBox[{"in", " ", "that", " ", "case"}], ",", " ", 
               RowBox[{"the", " ", "tests", " ", "have", " ", 
                RowBox[{"succeeded", "!"}], " ", "Add", " ", "the", " ", 
                "base", " ", "to", " ", "seqTest"}], ",", " ", 
               RowBox[{
               "permanently", " ", "add", " ", "the", " ", "last", " ", "8", 
                " ", "bases", " ", "to", " ", "the", " ", "list", " ", "of", 
                " ", "all", " ", "sequences", " ", "of", " ", "8"}], ",", " ", 
               RowBox[{
               "and", " ", "restore", " ", "all", " ", "possible", " ", 
                "next", " ", "base", " ", "options"}]}], "*)"}], 
             "\[IndentingNewLine]", 
             RowBox[{"baseOptionsTemp", "=", 
              RowBox[{"Drop", "[", 
               RowBox[{"baseOptionsTemp", ",", 
                RowBox[{"{", "baseInt", "}"}]}], "]"}]}]}], "]"}], ";"}]}], 
         RowBox[{"(*", 
          RowBox[{
           RowBox[{
           "sequence", " ", "of", " ", "8", " ", "has", " ", "been", " ", 
            "duplicated"}], ",", " ", 
           RowBox[{
           "so", " ", "drop", " ", "this", " ", "possibility", " ", "from", 
            " ", "the", " ", "list", " ", "and", " ", "try", " ", "again"}]}],
           "*)"}], "\[IndentingNewLine]", "]"}]}], "\[IndentingNewLine]", 
       "]"}], ",", "\[IndentingNewLine]", 
      RowBox[{"baseOptionsTemp", "=", 
       RowBox[{"Drop", "[", 
        RowBox[{"baseOptionsTemp", ",", 
         RowBox[{"{", "baseInt", "}"}]}], "]"}]}]}], 
     RowBox[{"(*", 
      RowBox[{
       RowBox[{
       "the", " ", "new", " ", "run", " ", "of", " ", "8", " ", "does", " ", 
        "not", " ", "have", " ", "at", " ", "least", " ", "one", " ", "G", 
        " ", "in", " ", "it"}], ",", " ", 
       RowBox[{
       "so", " ", "drop", " ", "this", " ", "possibility", " ", "from", " ", 
        "the", " ", "list", " ", "and", " ", "try", " ", "again"}]}], "*)"}], 
     "\[IndentingNewLine]", "]"}]}]}], "\[IndentingNewLine]", 
  "]"}], "\[IndentingNewLine]", 
 RowBox[{"StringLength", "[", "seqTest", "]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"allRunsOf8new", "=", 
    RowBox[{"Table", "[", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"StringTake", "[", 
       RowBox[{"seqTest", ",", 
        RowBox[{"{", 
         RowBox[{"i", ",", 
          RowBox[{"i", "+", "7"}]}], "}"}]}], "]"}], "\[IndentingNewLine]", 
      ",", 
      RowBox[{"{", 
       RowBox[{"i", ",", 
        RowBox[{
         RowBox[{"StringLength", "[", "seqTest", "]"}], "-", "7"}]}], "}"}]}],
      "]"}]}], ";"}], "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{
    RowBox[{
    "test", " ", "if", " ", "there", " ", "are", " ", "no", " ", "duplicated",
      " ", "runs", " ", "of", " ", "8.", " ", "If", " ", "true"}], ",", " ", 
    RowBox[{
    "then", " ", "no", " ", "run", " ", "of", " ", "8", " ", "or", " ", 
     "larger", " ", "is", " ", "duplicated", " ", "in", " ", "the", " ", 
     RowBox[{"scaffold", "."}]}]}], "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{"DuplicateFreeQ", "[", "allRunsOf8new", "]"}], "\[IndentingNewLine]", 
 RowBox[{"ContainsAny", "[", "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"Table", "[", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"StringContainsQ", "[", 
      RowBox[{
       RowBox[{"allRunsOf8new", "[", 
        RowBox[{"[", "i", "]"}], "]"}], ",", "\"\<G\>\""}], "]"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"{", 
      RowBox[{"i", ",", 
       RowBox[{"Length", "[", "allRunsOf8new", "]"}]}], "}"}]}], "]"}], 
   "\[IndentingNewLine]", ",", 
   RowBox[{"{", "False", "}"}]}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"StringContainsQ", "[", 
  RowBox[{"seqTest", ",", "\"\<GGGG\>\""}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"StringContainsQ", "[", 
  RowBox[{"seqTest", ",", "\"\<TTTTTT\>\""}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"StringContainsQ", "[", 
  RowBox[{"seqTest", ",", "\"\<AAAAAA\>\""}], "]"}]}], "Input",
 CellChangeTimes->{{3.935850420516527*^9, 3.9358504210033646`*^9}, {
   3.9358504709067726`*^9, 3.9358504998200474`*^9}, {3.9358505610908184`*^9, 
   3.9358506013877983`*^9}, {3.9358506832747936`*^9, 3.935850719314949*^9}, {
   3.9358507813813934`*^9, 3.935850859044298*^9}, {3.9358509372225723`*^9, 
   3.9358510762364006`*^9}, 3.9358511535541553`*^9, {3.9358512519624214`*^9, 
   3.935851440541174*^9}, {3.935852471536253*^9, 3.935852823773958*^9}, {
   3.9358528591314793`*^9, 3.93585287806682*^9}, {3.9358529103054314`*^9, 
   3.9358529348137684`*^9}, 3.935852992132353*^9, {3.9358532379752903`*^9, 
   3.9358532840038185`*^9}, 3.935853427563179*^9, 3.9358535271148853`*^9, {
   3.935853574724079*^9, 3.9358536227725735`*^9}, 3.9358537097538433`*^9, {
   3.9358537458261147`*^9, 3.9358537511311703`*^9}, {3.9358538119662266`*^9, 
   3.935853900347082*^9}, {3.93585394927602*^9, 3.935854019639168*^9}, {
   3.9358540511521473`*^9, 3.9358541642705975`*^9}, {3.935854210426573*^9, 
   3.935854227473135*^9}, {3.935854338529415*^9, 3.9358544650186214`*^9}, {
   3.935854497188736*^9, 3.935854527083475*^9}, {3.935854591130541*^9, 
   3.9358546169669437`*^9}, {3.9358547700437107`*^9, 
   3.9358547925146523`*^9}, {3.9358555516395836`*^9, 
   3.9358557350076904`*^9}, {3.935856038518341*^9, 3.935856038939987*^9}, 
   3.9358562056894207`*^9, {3.9358564145138607`*^9, 3.9358564291188183`*^9}, {
   3.935856460670925*^9, 3.935856468662876*^9}, 3.935856538891815*^9, {
   3.935857670521282*^9, 3.935857671162119*^9}, {3.9358583446172295`*^9, 
   3.935858363761894*^9}, {3.935858484786644*^9, 3.9358585164654064`*^9}, {
   3.935858549814764*^9, 3.9358585506827297`*^9}, {3.9358586061568527`*^9, 
   3.9358586169640846`*^9}, {3.935858650421362*^9, 3.9358586784895687`*^9}, {
   3.9358587626962433`*^9, 3.9358588072919464`*^9}},
 CellLabel->
  "In[1581]:=",ExpressionUUID->"a8a3205b-845b-9d45-a628-10fd4c65de6a"],

Cell[BoxData["\<\"GGA\"\>"], "Output",
 CellChangeTimes->{
  3.935852995254774*^9, 3.935853619744629*^9, 3.935854194979166*^9, 
   3.935854722517584*^9, 3.9358549422297535`*^9, 3.935855824984354*^9, 
   3.935856067330845*^9, 3.9358564802256165`*^9, {3.935856540008951*^9, 
   3.93585655108885*^9}, {3.935858379281349*^9, 3.935858383537985*^9}, 
   3.935858493146536*^9, 3.9358585258731346`*^9, {3.935858559355341*^9, 
   3.9358586231364384`*^9}, {3.9358586971151524`*^9, 3.9358587177165318`*^9}, 
   3.935858749484827*^9, {3.9358588089143295`*^9, 3.9358588106155376`*^9}},
 CellLabel->
  "Out[1588]=",ExpressionUUID->"b3c900a2-8634-a84f-8230-0086963d22c5"],

Cell[BoxData["\<\"GAG\"\>"], "Output",
 CellChangeTimes->{
  3.935852995254774*^9, 3.935853619744629*^9, 3.935854194979166*^9, 
   3.935854722517584*^9, 3.9358549422297535`*^9, 3.935855824984354*^9, 
   3.935856067330845*^9, 3.9358564802256165`*^9, {3.935856540008951*^9, 
   3.93585655108885*^9}, {3.935858379281349*^9, 3.935858383537985*^9}, 
   3.935858493146536*^9, 3.9358585258731346`*^9, {3.935858559355341*^9, 
   3.9358586231364384`*^9}, {3.9358586971151524`*^9, 3.9358587177165318`*^9}, 
   3.935858749484827*^9, {3.9358588089143295`*^9, 3.935858810622473*^9}},
 CellLabel->
  "Out[1593]=",ExpressionUUID->"17a69da8-f9e9-dc46-893b-800f5ed81ddf"],

Cell[BoxData["\<\"GGAGGAAG\"\>"], "Output",
 CellChangeTimes->{
  3.935852995254774*^9, 3.935853619744629*^9, 3.935854194979166*^9, 
   3.935854722517584*^9, 3.9358549422297535`*^9, 3.935855824984354*^9, 
   3.935856067330845*^9, 3.9358564802256165`*^9, {3.935856540008951*^9, 
   3.93585655108885*^9}, {3.935858379281349*^9, 3.935858383537985*^9}, 
   3.935858493146536*^9, 3.9358585258731346`*^9, {3.935858559355341*^9, 
   3.9358586231364384`*^9}, {3.9358586971151524`*^9, 3.9358587177165318`*^9}, 
   3.935858749484827*^9, {3.9358588089143295`*^9, 3.935858810628456*^9}},
 CellLabel->
  "Out[1599]=",ExpressionUUID->"1d7a6810-1566-8d45-862b-4342d1437b8e"],

Cell[BoxData["1771"], "Output",
 CellChangeTimes->{
  3.935852995254774*^9, 3.935853619744629*^9, 3.935854194979166*^9, 
   3.935854722517584*^9, 3.9358549422297535`*^9, 3.935855824984354*^9, 
   3.935856067330845*^9, 3.9358564802256165`*^9, {3.935856540008951*^9, 
   3.93585655108885*^9}, {3.935858379281349*^9, 3.935858383537985*^9}, 
   3.935858493146536*^9, 3.9358585258731346`*^9, {3.935858559355341*^9, 
   3.9358586231364384`*^9}, {3.9358586971151524`*^9, 3.9358587177165318`*^9}, 
   3.935858749484827*^9, {3.9358588089143295`*^9, 3.9358588108019943`*^9}},
 CellLabel->
  "Out[1603]=",ExpressionUUID->"7d38d238-fc37-0043-80d7-cd2081531d20"],

Cell[BoxData["True"], "Output",
 CellChangeTimes->{
  3.935852995254774*^9, 3.935853619744629*^9, 3.935854194979166*^9, 
   3.935854722517584*^9, 3.9358549422297535`*^9, 3.935855824984354*^9, 
   3.935856067330845*^9, 3.9358564802256165`*^9, {3.935856540008951*^9, 
   3.93585655108885*^9}, {3.935858379281349*^9, 3.935858383537985*^9}, 
   3.935858493146536*^9, 3.9358585258731346`*^9, {3.935858559355341*^9, 
   3.9358586231364384`*^9}, {3.9358586971151524`*^9, 3.9358587177165318`*^9}, 
   3.935858749484827*^9, {3.9358588089143295`*^9, 3.93585881080698*^9}},
 CellLabel->
  "Out[1605]=",ExpressionUUID->"99f200fc-bfd2-1542-9f7f-2878df2e2483"],

Cell[BoxData["False"], "Output",
 CellChangeTimes->{
  3.935852995254774*^9, 3.935853619744629*^9, 3.935854194979166*^9, 
   3.935854722517584*^9, 3.9358549422297535`*^9, 3.935855824984354*^9, 
   3.935856067330845*^9, 3.9358564802256165`*^9, {3.935856540008951*^9, 
   3.93585655108885*^9}, {3.935858379281349*^9, 3.935858383537985*^9}, 
   3.935858493146536*^9, 3.9358585258731346`*^9, {3.935858559355341*^9, 
   3.9358586231364384`*^9}, {3.9358586971151524`*^9, 3.9358587177165318`*^9}, 
   3.935858749484827*^9, {3.9358588089143295`*^9, 3.9358588108130264`*^9}},
 CellLabel->
  "Out[1606]=",ExpressionUUID->"66fef8ca-6bfa-794c-aa0f-78f8cd71b682"],

Cell[BoxData["False"], "Output",
 CellChangeTimes->{
  3.935852995254774*^9, 3.935853619744629*^9, 3.935854194979166*^9, 
   3.935854722517584*^9, 3.9358549422297535`*^9, 3.935855824984354*^9, 
   3.935856067330845*^9, 3.9358564802256165`*^9, {3.935856540008951*^9, 
   3.93585655108885*^9}, {3.935858379281349*^9, 3.935858383537985*^9}, 
   3.935858493146536*^9, 3.9358585258731346`*^9, {3.935858559355341*^9, 
   3.9358586231364384`*^9}, {3.9358586971151524`*^9, 3.9358587177165318`*^9}, 
   3.935858749484827*^9, {3.9358588089143295`*^9, 3.9358588108190117`*^9}},
 CellLabel->
  "Out[1607]=",ExpressionUUID->"827ac773-f95b-eb4a-83c0-784cb72f0fc0"],

Cell[BoxData["False"], "Output",
 CellChangeTimes->{
  3.935852995254774*^9, 3.935853619744629*^9, 3.935854194979166*^9, 
   3.935854722517584*^9, 3.9358549422297535`*^9, 3.935855824984354*^9, 
   3.935856067330845*^9, 3.9358564802256165`*^9, {3.935856540008951*^9, 
   3.93585655108885*^9}, {3.935858379281349*^9, 3.935858383537985*^9}, 
   3.935858493146536*^9, 3.9358585258731346`*^9, {3.935858559355341*^9, 
   3.9358586231364384`*^9}, {3.9358586971151524`*^9, 3.9358587177165318`*^9}, 
   3.935858749484827*^9, {3.9358588089143295`*^9, 3.935858810824974*^9}},
 CellLabel->
  "Out[1608]=",ExpressionUUID->"e495e5cc-21ff-fa48-b63f-6186c662bd34"],

Cell[BoxData["False"], "Output",
 CellChangeTimes->{
  3.935852995254774*^9, 3.935853619744629*^9, 3.935854194979166*^9, 
   3.935854722517584*^9, 3.9358549422297535`*^9, 3.935855824984354*^9, 
   3.935856067330845*^9, 3.9358564802256165`*^9, {3.935856540008951*^9, 
   3.93585655108885*^9}, {3.935858379281349*^9, 3.935858383537985*^9}, 
   3.935858493146536*^9, 3.9358585258731346`*^9, {3.935858559355341*^9, 
   3.9358586231364384`*^9}, {3.9358586971151524`*^9, 3.9358587177165318`*^9}, 
   3.935858749484827*^9, {3.9358588089143295`*^9, 3.9358588108299427`*^9}},
 CellLabel->
  "Out[1609]=",ExpressionUUID->"cfa7ca25-3f0d-4849-b534-c03c49dab3e7"]
}, Open  ]],

Cell[BoxData[
 RowBox[{"(*", 
  RowBox[{
   RowBox[{"desired", " ", 
    RowBox[{"output", ":", " ", 
     RowBox[{"1", " ", "True"}]}]}], ",", " ", 
   RowBox[{"4", " ", "False"}]}], "*)"}]], "Input",
 CellChangeTimes->{{3.9358586883152924`*^9, 
  3.935858695888809*^9}},ExpressionUUID->"6b01f376-efbe-1749-893a-\
5e3d9b8ae944"],

Cell[BoxData[
 RowBox[{"(*", 
  RowBox[{
   RowBox[{"It", " ", "worked"}], ",", " ", 
   RowBox[{
    RowBox[{
    "but", " ", "the", " ", "resulting", " ", "scaffold", " ", "was", " ", 
     "shorter", " ", "than", " ", 
     RowBox[{"desired", ".", " ", "Re"}]}], "-", 
    RowBox[{
    "running", " ", "produces", " ", "a", " ", "different", " ", "length", 
     " ", "each", " ", 
     RowBox[{"time", ".", " ", "I"}], " ", "do", " ", "not", " ", "know", " ",
      "what", " ", "the", " ", "longest", " ", "possible", " ", "sequence", 
     " ", "is"}]}], ",", " ", 
   RowBox[{
    RowBox[{"but", " ", "let", " ", "me", " ", "re"}], "-", 
    RowBox[{
    "run", " ", "it", " ", "until", " ", "we", " ", "at", " ", "least", " ", 
     "improve", " ", "on", " ", "the", " ", "last", " ", "scaffold", " ", 
     "that", " ", "I", " ", "thought", " ", "was", " ", "worth", " ", 
     RowBox[{"saving", "."}]}]}]}], "*)"}]], "Input",
 CellChangeTimes->{{3.935856877416992*^9, 3.935856881253113*^9}, {
  3.935856920493622*^9, 3.93585693520714*^9}, {3.935857647574768*^9, 
  3.935857734671295*^9}, {3.9358590291294136`*^9, 
  3.935859083977455*^9}},ExpressionUUID->"d8c7008c-ee18-7f43-b6f6-\
b8fa0739c699"],

Cell[BoxData[
 RowBox[{"While", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"StringLength", "[", "seqTest", "]"}], "<", "3039"}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"seqTest", "=", "\"\<G\>\""}], ";", "\[IndentingNewLine]", 
    RowBox[{"baseInt", "=", 
     RowBox[{"RandomInteger", "[", 
      RowBox[{"{", 
       RowBox[{"1", ",", 
        RowBox[{"Length", "[", "baseOptions", "]"}]}], "}"}], "]"}]}], ";", 
    "\[IndentingNewLine]", 
    RowBox[{"basePick", "=", 
     RowBox[{"baseOptions", "[", 
      RowBox[{"[", "baseInt", "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
    RowBox[{"seqTest", "=", 
     RowBox[{"seqTest", "<>", "basePick"}]}], ";", "\[IndentingNewLine]", 
    RowBox[{"baseInt", "=", 
     RowBox[{"RandomInteger", "[", 
      RowBox[{"{", 
       RowBox[{"1", ",", 
        RowBox[{"Length", "[", "baseOptions", "]"}]}], "}"}], "]"}]}], ";", 
    "\[IndentingNewLine]", 
    RowBox[{"basePick", "=", 
     RowBox[{"baseOptions", "[", 
      RowBox[{"[", "baseInt", "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
    RowBox[{"seqTest", "=", 
     RowBox[{"seqTest", "<>", "basePick"}]}], ";", "\[IndentingNewLine]", 
    RowBox[{"seqTemp", "=", 
     RowBox[{"StringTake", "[", 
      RowBox[{"seqTest", ",", 
       RowBox[{"-", "3"}]}], "]"}]}], ";", "\[IndentingNewLine]", 
    RowBox[{"baseOptionsTemp", "=", 
     RowBox[{"If", "[", 
      RowBox[{
       RowBox[{"seqTemp", "==", "\"\<GGG\>\""}], ",", 
       RowBox[{"{", 
        RowBox[{"\"\<A\>\"", ",", "\"\<T\>\""}], "}"}], ",", "baseOptions"}], 
      "]"}]}], ";", "\[IndentingNewLine]", 
    RowBox[{"baseInt", "=", 
     RowBox[{"RandomInteger", "[", 
      RowBox[{"{", 
       RowBox[{"1", ",", 
        RowBox[{"Length", "[", "baseOptionsTemp", "]"}]}], "}"}], "]"}]}], 
    ";", "\[IndentingNewLine]", 
    RowBox[{"basePick", "=", 
     RowBox[{"baseOptionsTemp", "[", 
      RowBox[{"[", "baseInt", "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
    RowBox[{"seqTest", "=", 
     RowBox[{"seqTest", "<>", "basePick"}]}], ";", "\[IndentingNewLine]", 
    RowBox[{"seqTemp", "=", 
     RowBox[{"StringTake", "[", 
      RowBox[{"seqTest", ",", 
       RowBox[{"-", "3"}]}], "]"}]}], ";", "\[IndentingNewLine]", 
    RowBox[{"baseOptionsTemp", "=", 
     RowBox[{"If", "[", 
      RowBox[{
       RowBox[{"seqTemp", "==", "\"\<GGG\>\""}], ",", 
       RowBox[{"{", 
        RowBox[{"\"\<A\>\"", ",", "\"\<T\>\""}], "}"}], ",", "baseOptions"}], 
      "]"}]}], ";", "\[IndentingNewLine]", 
    RowBox[{"baseInt", "=", 
     RowBox[{"RandomInteger", "[", 
      RowBox[{"{", 
       RowBox[{"1", ",", 
        RowBox[{"Length", "[", "baseOptionsTemp", "]"}]}], "}"}], "]"}]}], 
    ";", "\[IndentingNewLine]", 
    RowBox[{"basePick", "=", 
     RowBox[{"baseOptionsTemp", "[", 
      RowBox[{"[", "baseInt", "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
    RowBox[{"seqTest", "=", 
     RowBox[{"seqTest", "<>", "basePick"}]}], ";", "\[IndentingNewLine]", 
    RowBox[{"Do", "[", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{
       RowBox[{"seqTemp", "=", 
        RowBox[{"StringTake", "[", 
         RowBox[{"seqTest", ",", 
          RowBox[{"-", "3"}]}], "]"}]}], ";", "\[IndentingNewLine]", 
       RowBox[{"baseOptionsTemp", "=", 
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{"seqTemp", "==", "\"\<GGG\>\""}], ",", 
          RowBox[{"{", 
           RowBox[{"\"\<A\>\"", ",", "\"\<T\>\""}], "}"}], ",", 
          "\[IndentingNewLine]", 
          RowBox[{"If", "[", 
           RowBox[{
            RowBox[{
             RowBox[{"StringTake", "[", 
              RowBox[{"seqTest", ",", 
               RowBox[{"-", "5"}]}], "]"}], "==", "\"\<AAAAA\>\""}], ",", 
            RowBox[{"{", 
             RowBox[{"\"\<G\>\"", ",", "\"\<T\>\""}], "}"}], ",", 
            "\[IndentingNewLine]", 
            RowBox[{"If", "[", 
             RowBox[{
              RowBox[{
               RowBox[{"StringTake", "[", 
                RowBox[{"seqTest", ",", 
                 RowBox[{"-", "5"}]}], "]"}], "==", "\"\<TTTTT\>\""}], ",", 
              RowBox[{"{", 
               RowBox[{"\"\<A\>\"", ",", "\"\<G\>\""}], "}"}], ",", 
              "baseOptions"}], "]"}]}], "\[IndentingNewLine]", "]"}]}], 
         "\[IndentingNewLine]", "]"}]}], ";", "\[IndentingNewLine]", 
       RowBox[{"baseInt", "=", 
        RowBox[{"RandomInteger", "[", 
         RowBox[{"{", 
          RowBox[{"1", ",", 
           RowBox[{"Length", "[", "baseOptionsTemp", "]"}]}], "}"}], "]"}]}], 
       ";", "\[IndentingNewLine]", 
       RowBox[{"basePick", "=", 
        RowBox[{"baseOptionsTemp", "[", 
         RowBox[{"[", "baseInt", "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
       RowBox[{"seqTest", "=", 
        RowBox[{"seqTest", "<>", "basePick"}]}]}], "\[IndentingNewLine]", ",", 
      RowBox[{"{", 
       RowBox[{"i", ",", "3"}], "}"}]}], "]"}], ";", "\[IndentingNewLine]", 
    "seqTest", ";", "\[IndentingNewLine]", 
    RowBox[{"baseOptionsTemp", "=", "baseOptions"}], ";", 
    "\[IndentingNewLine]", 
    RowBox[{"allRunsOf8test", "=", 
     RowBox[{"{", "seqTest", "}"}]}], ";", "\[IndentingNewLine]", 
    RowBox[{"While", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"Length", "[", "baseOptionsTemp", "]"}], ">", "0"}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"baseInt", "=", 
        RowBox[{"RandomInteger", "[", 
         RowBox[{"{", 
          RowBox[{"1", ",", 
           RowBox[{"Length", "[", "baseOptionsTemp", "]"}]}], "}"}], "]"}]}], 
       ";", "\[IndentingNewLine]", 
       RowBox[{"basePick", "=", 
        RowBox[{"baseOptionsTemp", "[", 
         RowBox[{"[", "baseInt", "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
       RowBox[{"seqTemp", "=", 
        RowBox[{"seqTest", "<>", "basePick"}]}], ";", "\[IndentingNewLine]", 
       RowBox[{"last8temp", "=", 
        RowBox[{"StringTake", "[", 
         RowBox[{"seqTemp", ",", 
          RowBox[{"-", "8"}]}], "]"}]}], ";", "\[IndentingNewLine]", 
       RowBox[{"If", "[", 
        RowBox[{
         RowBox[{"StringContainsQ", "[", 
          RowBox[{"last8temp", ",", "\"\<G\>\""}], "]"}], ",", 
         RowBox[{"(*", 
          RowBox[{
          "check", " ", "that", " ", "the", " ", "new", " ", "run", " ", "of",
            " ", "8", " ", "has", " ", "at", " ", "least", " ", "one", " ", 
           "G", " ", "in", " ", "it"}], "*)"}], "\[IndentingNewLine]", 
         RowBox[{"If", "[", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{
             RowBox[{"basePick", "==", "\"\<A\>\""}], "||", 
             RowBox[{"basePick", "==", "\"\<T\>\""}]}], ")"}], ",", 
           RowBox[{"(*", 
            RowBox[{"if", " ", "trying", " ", "A", " ", "or", " ", "T"}], 
            "*)"}], "\[IndentingNewLine]", 
           RowBox[{"If", "[", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{
                RowBox[{"StringTake", "[", 
                 RowBox[{"seqTemp", ",", 
                  RowBox[{"-", "6"}]}], "]"}], "==", "\"\<AAAAAA\>\""}], "||", 
               RowBox[{
                RowBox[{"StringTake", "[", 
                 RowBox[{"seqTemp", ",", 
                  RowBox[{"-", "6"}]}], "]"}], "==", "\"\<TTTTTT\>\""}]}], 
              ")"}], ",", 
             RowBox[{"(*", 
              RowBox[{
              "test", " ", "whether", " ", "a", " ", "run", " ", "of", " ", 
               "greater", " ", "than", " ", "5", " ", "As", " ", "or", " ", 
               "Ts", " ", "will", " ", "happen"}], "*)"}], 
             "\[IndentingNewLine]", 
             RowBox[{"baseOptionsTemp", "=", 
              RowBox[{"Drop", "[", 
               RowBox[{"baseOptionsTemp", ",", 
                RowBox[{"{", "baseInt", "}"}]}], "]"}]}], ",", 
             RowBox[{"(*", 
              RowBox[{
               RowBox[{"if", " ", "so"}], ",", " ", 
               RowBox[{
               "then", " ", "drop", " ", "this", " ", "possibility", " ", 
                "from", " ", "the", " ", "list", " ", "and", " ", "try", " ", 
                "again"}]}], "*)"}], "\[IndentingNewLine]", 
             RowBox[{"(*", 
              RowBox[{"otherwise", ",", " ", 
               RowBox[{
               "add", " ", "the", " ", "last", " ", "8", " ", "bases", " ", 
                "to", " ", "allRunsOf8test"}]}], "*)"}], 
             "\[IndentingNewLine]", 
             RowBox[{
              RowBox[{"allRunsOf8temp", "=", 
               RowBox[{"Join", "[", 
                RowBox[{"allRunsOf8test", ",", 
                 RowBox[{"{", "last8temp", "}"}]}], "]"}]}], ";", 
              "\[IndentingNewLine]", 
              RowBox[{"If", "[", 
               RowBox[{
                RowBox[{"DuplicateFreeQ", "[", "allRunsOf8temp", "]"}], ",", 
                RowBox[{"(*", 
                 RowBox[{
                 "check", " ", "whether", " ", "a", " ", "sequence", " ", 
                  "of", " ", "8", " ", "has", " ", "not", " ", "been", " ", 
                  "duplicated"}], "*)"}], "\[IndentingNewLine]", 
                RowBox[{
                 RowBox[{"seqTest", "=", "seqTemp"}], ";", 
                 "\[IndentingNewLine]", 
                 RowBox[{"allRunsOf8test", "=", "allRunsOf8temp"}], ";", 
                 "\[IndentingNewLine]", 
                 RowBox[{"baseOptionsTemp", "=", "baseOptions"}]}], ",", 
                RowBox[{"(*", 
                 RowBox[{
                  RowBox[{"in", " ", "that", " ", "case"}], ",", " ", 
                  RowBox[{"the", " ", "tests", " ", "have", " ", 
                   RowBox[{"succeeded", "!"}], " ", "Add", " ", "the", " ", 
                   "base", " ", "to", " ", "seqTest"}], ",", " ", 
                  RowBox[{
                  "permanently", " ", "add", " ", "the", " ", "last", " ", 
                   "8", " ", "bases", " ", "to", " ", "the", " ", "list", " ",
                    "of", " ", "all", " ", "sequences", " ", "of", " ", "8"}],
                   ",", " ", 
                  RowBox[{
                  "and", " ", "restore", " ", "all", " ", "possible", " ", 
                   "next", " ", "base", " ", "options"}]}], "*)"}], 
                "\[IndentingNewLine]", 
                RowBox[{"baseOptionsTemp", "=", 
                 RowBox[{"Drop", "[", 
                  RowBox[{"baseOptionsTemp", ",", 
                   RowBox[{"{", "baseInt", "}"}]}], "]"}]}]}], "]"}], ";"}]}], 
            RowBox[{"(*", 
             RowBox[{
              RowBox[{
              "sequence", " ", "of", " ", "8", " ", "has", " ", "been", " ", 
               "duplicated"}], ",", " ", 
              RowBox[{
              "so", " ", "drop", " ", "this", " ", "possibility", " ", "from",
                " ", "the", " ", "list", " ", "and", " ", "try", " ", 
               "again"}]}], "*)"}], "\[IndentingNewLine]", "]"}], ",", 
           "\[IndentingNewLine]", 
           RowBox[{"If", "[", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{"StringTake", "[", 
                RowBox[{"seqTemp", ",", 
                 RowBox[{"-", "4"}]}], "]"}], "==", "\"\<GGGG\>\""}], ")"}], 
             ",", 
             RowBox[{"(*", 
              RowBox[{
               RowBox[{"if", " ", "trying", " ", "G"}], ",", " ", 
               RowBox[{
               "test", " ", "whether", " ", "a", " ", "run", " ", "of", " ", 
                "greater", " ", "than", " ", "3", " ", "Gs", " ", "will", " ",
                 "happen"}]}], "*)"}], "\[IndentingNewLine]", 
             RowBox[{"baseOptionsTemp", "=", 
              RowBox[{"Drop", "[", 
               RowBox[{"baseOptionsTemp", ",", 
                RowBox[{"{", "baseInt", "}"}]}], "]"}]}], ",", 
             RowBox[{"(*", 
              RowBox[{
               RowBox[{"if", " ", "so"}], ",", " ", 
               RowBox[{
               "then", " ", "drop", " ", "G", " ", "as", " ", "a", " ", 
                "possibility", " ", "and", " ", "try", " ", "again"}]}], 
              "*)"}], "\[IndentingNewLine]", 
             RowBox[{"(*", 
              RowBox[{"otherwise", ",", " ", 
               RowBox[{
               "add", " ", "the", " ", "last", " ", "8", " ", "bases", " ", 
                "to", " ", "allRunsOf8test"}]}], "*)"}], 
             "\[IndentingNewLine]", 
             RowBox[{
              RowBox[{"allRunsOf8temp", "=", 
               RowBox[{"Join", "[", 
                RowBox[{"allRunsOf8test", ",", 
                 RowBox[{"{", "last8temp", "}"}]}], "]"}]}], ";", 
              "\[IndentingNewLine]", 
              RowBox[{"If", "[", 
               RowBox[{
                RowBox[{"DuplicateFreeQ", "[", "allRunsOf8temp", "]"}], ",", 
                RowBox[{"(*", 
                 RowBox[{
                 "check", " ", "whether", " ", "a", " ", "sequence", " ", 
                  "of", " ", "8", " ", "has", " ", "not", " ", "been", " ", 
                  "duplicated"}], "*)"}], "\[IndentingNewLine]", 
                RowBox[{
                 RowBox[{"seqTest", "=", "seqTemp"}], ";", 
                 "\[IndentingNewLine]", 
                 RowBox[{"allRunsOf8test", "=", "allRunsOf8temp"}], ";", 
                 "\[IndentingNewLine]", 
                 RowBox[{"baseOptionsTemp", "=", "baseOptions"}]}], ",", 
                RowBox[{"(*", 
                 RowBox[{
                  RowBox[{"in", " ", "that", " ", "case"}], ",", " ", 
                  RowBox[{"the", " ", "tests", " ", "have", " ", 
                   RowBox[{"succeeded", "!"}], " ", "Add", " ", "the", " ", 
                   "base", " ", "to", " ", "seqTest"}], ",", " ", 
                  RowBox[{
                  "permanently", " ", "add", " ", "the", " ", "last", " ", 
                   "8", " ", "bases", " ", "to", " ", "the", " ", "list", " ",
                    "of", " ", "all", " ", "sequences", " ", "of", " ", "8"}],
                   ",", " ", 
                  RowBox[{
                  "and", " ", "restore", " ", "all", " ", "possible", " ", 
                   "next", " ", "base", " ", "options"}]}], "*)"}], 
                "\[IndentingNewLine]", 
                RowBox[{"baseOptionsTemp", "=", 
                 RowBox[{"Drop", "[", 
                  RowBox[{"baseOptionsTemp", ",", 
                   RowBox[{"{", "baseInt", "}"}]}], "]"}]}]}], "]"}], ";"}]}], 
            RowBox[{"(*", 
             RowBox[{
              RowBox[{
              "sequence", " ", "of", " ", "8", " ", "has", " ", "been", " ", 
               "duplicated"}], ",", " ", 
              RowBox[{
              "so", " ", "drop", " ", "this", " ", "possibility", " ", "from",
                " ", "the", " ", "list", " ", "and", " ", "try", " ", 
               "again"}]}], "*)"}], "\[IndentingNewLine]", "]"}]}], 
          "\[IndentingNewLine]", "]"}], ",", "\[IndentingNewLine]", 
         RowBox[{"baseOptionsTemp", "=", 
          RowBox[{"Drop", "[", 
           RowBox[{"baseOptionsTemp", ",", 
            RowBox[{"{", "baseInt", "}"}]}], "]"}]}]}], 
        RowBox[{"(*", 
         RowBox[{
          RowBox[{
          "the", " ", "new", " ", "run", " ", "of", " ", "8", " ", "does", 
           " ", "not", " ", "have", " ", "at", " ", "least", " ", "one", " ", 
           "G", " ", "in", " ", "it"}], ",", " ", 
          RowBox[{
          "so", " ", "drop", " ", "this", " ", "possibility", " ", "from", 
           " ", "the", " ", "list", " ", "and", " ", "try", " ", "again"}]}], 
         "*)"}], "\[IndentingNewLine]", "]"}]}]}], "\[IndentingNewLine]", 
     "]"}]}]}], "\[IndentingNewLine]", "]"}]], "Input",
 CellChangeTimes->{{3.9358588372430296`*^9, 3.935858865939829*^9}},
 CellLabel->
  "In[1610]:=",ExpressionUUID->"903f0598-2094-8d4e-a808-9418d607e15c"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"StringLength", "[", "seqTest", "]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"allRunsOf8new", "=", 
    RowBox[{"Table", "[", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"StringTake", "[", 
       RowBox[{"seqTest", ",", 
        RowBox[{"{", 
         RowBox[{"i", ",", 
          RowBox[{"i", "+", "7"}]}], "}"}]}], "]"}], "\[IndentingNewLine]", 
      ",", 
      RowBox[{"{", 
       RowBox[{"i", ",", 
        RowBox[{
         RowBox[{"StringLength", "[", "seqTest", "]"}], "-", "7"}]}], "}"}]}],
      "]"}]}], ";"}], "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{
    RowBox[{
    "test", " ", "if", " ", "there", " ", "are", " ", "no", " ", "duplicated",
      " ", "runs", " ", "of", " ", "8.", " ", "If", " ", "true"}], ",", " ", 
    RowBox[{
    "then", " ", "no", " ", "run", " ", "of", " ", "8", " ", "or", " ", 
     "larger", " ", "is", " ", "duplicated", " ", "in", " ", "the", " ", 
     RowBox[{"scaffold", "."}]}]}], "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{"DuplicateFreeQ", "[", "allRunsOf8new", "]"}], "\[IndentingNewLine]", 
 RowBox[{"ContainsAny", "[", "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"Table", "[", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"StringContainsQ", "[", 
      RowBox[{
       RowBox[{"allRunsOf8new", "[", 
        RowBox[{"[", "i", "]"}], "]"}], ",", "\"\<G\>\""}], "]"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"{", 
      RowBox[{"i", ",", 
       RowBox[{"Length", "[", "allRunsOf8new", "]"}]}], "}"}]}], "]"}], 
   "\[IndentingNewLine]", ",", 
   RowBox[{"{", "False", "}"}]}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"StringContainsQ", "[", 
  RowBox[{"seqTest", ",", "\"\<GGGG\>\""}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"StringContainsQ", "[", 
  RowBox[{"seqTest", ",", "\"\<TTTTTT\>\""}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"StringContainsQ", "[", 
  RowBox[{"seqTest", ",", "\"\<AAAAAA\>\""}], "]"}]}], "Input",
 CellLabel->
  "In[1611]:=",ExpressionUUID->"6549c09b-7596-3d47-bb8e-103883cd34f2"],

Cell[BoxData["3206"], "Output",
 CellChangeTimes->{3.935858950358204*^9},
 CellLabel->
  "Out[1611]=",ExpressionUUID->"63b78cf5-f468-be40-87d8-8ea34bb483ab"],

Cell[BoxData["True"], "Output",
 CellChangeTimes->{3.935858950365185*^9},
 CellLabel->
  "Out[1613]=",ExpressionUUID->"9b9c63b4-3c08-3a4c-b769-681f8ddb65be"],

Cell[BoxData["False"], "Output",
 CellChangeTimes->{3.9358589503701687`*^9},
 CellLabel->
  "Out[1614]=",ExpressionUUID->"00e3d9af-0f65-9246-bdd6-bfff0e627f02"],

Cell[BoxData["False"], "Output",
 CellChangeTimes->{3.9358589503771496`*^9},
 CellLabel->
  "Out[1615]=",ExpressionUUID->"929ddf5b-bb4e-a247-a010-447fe08a02d3"],

Cell[BoxData["False"], "Output",
 CellChangeTimes->{3.9358589503821373`*^9},
 CellLabel->
  "Out[1616]=",ExpressionUUID->"c00c94cb-efca-d241-acd0-0c15e914c169"],

Cell[BoxData["False"], "Output",
 CellChangeTimes->{3.9358589503881207`*^9},
 CellLabel->
  "Out[1617]=",ExpressionUUID->"5f77f6d0-2e48-534c-9e58-85df01ffa72a"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"seq3206", "=", "seqTest"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"Export", "[", 
  RowBox[{"\"\<customScaffold3206.txt\>\"", ",", "seq3206"}], "]"}]}], "Input",
 CellChangeTimes->{{3.9358583876583805`*^9, 3.93585839916177*^9}, {
  3.9358584996163387`*^9, 3.9358585003759174`*^9}, {3.935858971537445*^9, 
  3.93585898968087*^9}},
 CellLabel->
  "In[1618]:=",ExpressionUUID->"b346d986-b1b3-504d-9c4c-0e57e6738aed"],

Cell[BoxData["\<\"customScaffold3206.txt\"\>"], "Output",
 CellChangeTimes->{3.935859003357378*^9},
 CellLabel->
  "Out[1619]=",ExpressionUUID->"21b84a5a-1139-d340-b9d9-72d4b2596af0"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Code to investigate custom scaffolds based on Wu et al 2024", "Section",
 CellChangeTimes->{{3.924369042160002*^9, 3.924369043144348*^9}, {
  3.935846860605377*^9, 3.935846865915739*^9}, {3.9361276687572823`*^9, 
  3.936127674834921*^9}, {3.9361277518435383`*^9, 
  3.93612775362661*^9}},ExpressionUUID->"6dcb580c-4241-b84d-b8c7-\
1b8b86092557"],

Cell[BoxData[
 RowBox[{
  RowBox[{
  "wuEtAl2024seq", "=", 
   "\"\<CACAATTAATCTTCACCTAAATCAACCACTCAACACCCATCACATATTACTTACATCCCCCTTTAAACAC\
TAACACATACAACCCCCTCCTTACCACTTCACCTCTACCCCTATCAACACCCACTCATTTTAATTCAACTTTATTAAC\
TACTTTATCCATATTTAAAACTTATCCTTACAATAATTTACCCACTTAATACAACCTCTTCTCTCCTTCATATATATC\
ACACCATACTCCCTTCCCCCAATAAATTTATTTCCTTTCACATATTTCCCATCAATACTAAATTAACTATCCTATACC\
ACCCCCATATCCCTACTACTATATTCTACCCCACCATCAAACAATTTATATATTTTCACTTTTTAACATCCATTTCTA\
AAATTCTCCAATATCTATTACTATACACTTTCACATAATTATACTAAACTCCTTATCTCCATATAAACTATCACTTTA\
CTTACTCCCATATTCTAAATCTCCTCTATCAACCCCACAACCTCCATCTTCTATAATCACAACACATACCATTAATCT\
CCTTTTCCCATAAATCTTCTCTCCCCTTCTTAATCCTCCTCAATCAACCTATCTATATCAATCATACCCTTTATTCAC\
TAATCATTTCTTCTTCATACAAAATAAAACCTCTCACAATTTCTCATAAACATTAACCCTCTCTCTCCATCACTATTA\
ACTCAATTTCAATTTCACATTTTCCCCTATTATCCTCCTATACTTACACTTAATCCTTCCTAACACTACTAATCCCCT\
ACTTAATAAATCACCTCTTTCTACTATCTCTAACCCCAAACTTAATTCTAACTATCCTCAACTAACAACCACAATTTC\
TCCAAAAAATCATCCCTCACTTCCTTTTCTTAACATCTTATCACAACTTCATCTACCTCTCTAACCCAATTCTAATTC\
ATTACAAATAATCTTACACCATACAACTAACTACCAAATATCTAATACTCATATCTTTCACTCACCACTCATATCCTT\
TAATTTTAATCCTATCTCCCCTTATCAATTTTTCTTCATCTATTAAATTTCTTCAATAATTACACCCCCCTCACACTT\
TAAATAACAATACAATTAATTTTCTACTCTAACCATCTCTCTACCACATTATTCCTCTTCATTACATCTTCCTCACCC\
ATTTCATCTACACCAACTTATCCTCCTCATCATATTTATCCCTTCTTTTTCTCTAATATACACATTACATACTACCTC\
TCTTACCTATCCTCTCATCTCCTCTAATCCTACTCAATTATAACCTACTTTATTACAACTCTCTAACACCCCATTCTT\
CACACTACTATTTTCAAACATTCAAAAACTCCCACTCTTCTTACTTCCCCCCCCCCATTTATTAACCAACTACTCTAT\
CCACTTTCATTCTCTTACTACCACCTTTTTTATCATCCTCTATTTAATCCTTCCAACCAATAAACAATATTTTACCTA\
CCTATCCCTTTTTACAAAACCCTCTTTACCTATTTTCTCCTTAAACTCTTATCATCTTACCCTCTACATTTAAACATA\
ACTCCCCACCATCTCATTATTTTTTATTCCCATATACTATAACTCTATCACCCCCATTTCCCTACACTTCCATCATTT\
CTTTCCAACTTCTTACCTCTTCTATAATAATATTCACCCCACCTCATACTTTCCTAACCTAAAAAACTAATATTATAT\
ATACCCTTACTCAATCAAACCACTTTTATTTTCATAAATATACTATCCTACTTAACAATTCACAACAATCACCTATAA\
ATCCTCTATACAATTCCCATCAACATAACTTCCACCATATATCAACCTCACCTCACTTCTACCCCACACCCAAACACA\
CTTCCACACTTTCTCTACATCCAACATATTCCCTTATATCCCATCTTACTTCATAAATATTAATCCAACACCACTTCT\
AATACAACCTTTTCACACTCCCATCTAACAACCACCAAATACAATCATAACCAACCTACAACACCATACAAATTCACT\
CCACAAATAATACAATCCCACTAAATCCTCTTACTCTATCAATTTAACTATACTTAACCCATTCAATAACCCAACACT\
ACCATAACATACTACTTATTAACACACAACTCTCCAATTCACTATTAACTCCCAAAATAAACTACCTTTAAACCATAA\
CAATCCCCTCCCCTCACAATTTCATATTAAATTCTACACTACATCTTCCTCAACTTTTCCCAACACCAATCTTACTAT\
TTTCTTACACAACCTCTCATCTTAAACTATACTTACTAACAACTATTATTTAATAATCCTTTATCACTCCTCCCACAT\
ACCCAAACTCCACACAACATTAAACAAAAATTATATACTAATTCTCATCAAATATTACATATTAATTAACATCTACTC\
TACAAATTCCAACTAATAAATCATCCCTTAATTCATATCTTCATAATCCATTTTAATCTATATACTTTCACTATCACT\
TCTTAACTACCTCCACTACCTACTATCCAACCTCTCCTAATATACATTACAATTCCAAACAACTACCCTTTCCATATA\
TTAACTAAAAATCCAACAATCCCCTCTACTTCCTTTTACCAAAAACATCTATATCATTCCCATTCTCATAAAATATCT\
TACATTATTCTTCCCCCATTCATCCATCCAACTCACATTATTTCTCATATCTTCTCATAAAATATAATCCCACCCTTC\
CACCCTTACATAACTATAATACTAAAATAAATATTTACCTTATAACTAATCATCATTATTCATTAACTCTCTTTATTA\
CTCCTTACCTACACCTACTACCTTTCCAACATCATCAATCTTTTTTATCAATAAATTAAAATACCCAATTCTACATAC\
CCTCATCTCCATTCAAATTCCCCCATCCCTCACCATCACACCAATCACCCAATCCTTCCAACCTTCTAATCTCATTTT\
AATAAACTCCTCTCAACAAAACTCACTATATAATACCTATATACTATCCAATCATCATACCAATTACACCTTTCACAT\
TTTCCACATCCTCATACACAATATTCTCCTTAACATCACAACACTCTTCCAACAATCTTTCATATAATTACCCTTCTT\
ATACTTCCTCTCCCACTCTCTCTCCCCACCATTATACCATCTCCTTACCAATCATATTATCCCAAATAATTCCCTAAT\
TCCATTTTTACTACTTAAACCTATACCTCACATAAAATAACTAATTACCTAATTTATCACATCCTTCATCCCTACTAC\
CTCACAAATCTCCCATACTTAAATTATAACCCAATTTTACTACTTAATTTACACCTACTAAATACCATTTTATATAAA\
TATATCACTTAATTAACAACCACCCCTCAAAACTCAAATTTCAAACTATATCTTACATTACTAAAATACAATCAACTT\
TAAACTTCAACAAACATACCTCTTTATTCACAACACTTTAAATACACAACATTAATAATCCAAAAACTAAATTCAATC\
TTTTACTACACCCCCCTCATCACAAATTCTCTTCATCTTTCACTAATCCTTACTACAATACAAAACACATCCTCCAAT\
TCTTCAACAAAACCACAAAACAAACCATAATACTTTACTATAACATAAAATTTCACATCCACCTACCTACTATTACAA\
TTCACCCAAATATACCCCTACTTAAACATATCAACATTTTCCCAATTCCCACTATTCACTCATTATACCCCTCCAACT\
TCCTTAAATCACTACTCTTATACCTTACATCTTATACAAACCTCCAAATCAATCTTCCATACTAATCCCTCCACCCCC\
ACAATTTAAAATTTTCCTCCTTCCATCTACCTCATCCAAATTAATCACCTATCCTCAAACAATCACTTATAATACTCC\
CACCCTACTAATTTCACCTAACTCCCTAACTCCTCCTACACTCCTAACATCCCAAAAACCCTCCACTTCCCTCTAAAT\
TCAACTCACTACTCTTTACCCTTCTCTTTTATTCCAAATCCCCTCTATCTACTAAACTTCTTCAACAATATTACATCC\
CTTTTCCTTTCTTCTCAACCACATCTCCCCACATTTTAACACCCACTATCCTTAACTCATTAATACCATAAACCCCTC\
TTCTCACAAATATCTTCCCCTTTCATAATTACCCTTATCCCCAACACACTCTAAATATACTACAACAACATTCTTATC\
ACCCCCCACTAATCCTCAAAATCAAAACTCTCACACTAACATTACACCCAAACTCTCATCCTATTTCAAACCCTCTCA\
AACTTTCAAACCCTACAATTAACTATCCTAACTCATCCATACTATTACACTCTTCTATTACATCATTTCTCCCATAAT\
CTACCATAACATTATCTAATTAAATTCCACCACATCCCTCTTAAACATCACCCTTCCTTAACCCCCACTAATTATAAC\
ACCTTTTACTATTCATCCCACAAACCCTACACATTACACACCACAAAACCTCACTACCACCAAAACCCTTTCCTTTAC\
CATCTTACTCCCATCTTACCCAACCCATTTATTATCATAAAACATTTCATTATATTTTTCATACTCCCTACCTCTCTC\
CATTCTCTAACCTACACATCATAAACCCACACCTATTACCATAATTATCCTACCCTCCTAAATCACACCACCTCCCTT\
TTCCTCCCCTACTCAACCCTATACACTACTATCACAAAATTTCCCCAATCATAATACCAACCTAATTCTCTTTAACAA\
CTCCCTCACCCACCCAACCATCTACACTAACCTCCCTTTTCTTTCCTCCACTCAATTATTTTCAACTCCTATTCAAAA\
CTTAACATAACCAAACTTCTCCCACTATCCTCTACCTCTATCACTCTCCTTAACTCACTTACCCACTATCCCTATACA\
ACCATAATATTTTCAAAACTTTCAATCATCTACTTTTACTCAACTAACCACACCTTCAATAATCCTCTTTTACTACCT\
TCTCTCCCATCCAAACCTTACCTTTATTTACCCCCATAACTAACTTTAATTCACACACCTTATATCATTTAATCTAAC\
AAAAACCTAAACTTACAATAAACCCTATTACCATTTCTCACCCTTTCACCTTTAAACTAAATCATAAACCTCAATATC\
TCCCTATAACAACTTTTTTTAAACACATCACATTTAACCCTACCACCCTTTCCTCCTCTTTCATTCTCAAAATTTATA\
TATCAATCTTCTCCCCTACAATCACAACCTCACTCCCTTCAAATTCTACATATCTTTTCCCCTATTATAAAACTATCT\
CCCTCAATCTCCTACTCAAATCACTATTTTCATTTTATCCTATAACTATTAATACCCCATTAATTTAAACTCTCAAAT\
CTCTCACCAATTTCCACCACTCTCAAAAAAAAAATTAAATTCATAACAAACTAATTCTCAAATCCCTTTTCCACACCT\
ACTTACCAAACCAAATCAACCCACCTCTC\>\""}], ";"}]], "Input",
 CellChangeTimes->{{3.7581383519210596`*^9, 3.758138365087669*^9}, {
   3.758138421972631*^9, 3.758138458494304*^9}, {3.758144640291236*^9, 
   3.758144677267056*^9}, {3.7581450878637714`*^9, 3.758145088182493*^9}, {
   3.7581621361243477`*^9, 3.758162136330942*^9}, {3.758162916048702*^9, 
   3.758162939801607*^9}, {3.758163001403411*^9, 3.758163002051878*^9}, {
   3.7581631106199546`*^9, 3.7581631235705347`*^9}, {3.75816335157658*^9, 
   3.758163366798649*^9}, {3.758163843408934*^9, 3.758163885249323*^9}, {
   3.772921731046179*^9, 3.772921762082611*^9}, {3.7729219525442715`*^9, 
   3.772921953776592*^9}, {3.7729220195100183`*^9, 3.772922055178544*^9}, {
   3.772922110173753*^9, 3.772922173527481*^9}, 3.7729246150511694`*^9, 
   3.772924706091136*^9, {3.779574309427428*^9, 3.779574316290487*^9}, 
   3.7795746230545535`*^9, {3.779575008787421*^9, 3.779575035935748*^9}, {
   3.7795766095632963`*^9, 3.779576610758606*^9}, {3.779576712974715*^9, 
   3.779576715106503*^9}, {3.781987771733875*^9, 3.781987866018653*^9}, {
   3.781990953478853*^9, 3.781991003886821*^9}, 3.78199566330191*^9, {
   3.7819985782427616`*^9, 3.781998603569629*^9}, {3.781998927317541*^9, 
   3.781999005603068*^9}, {3.781999041220385*^9, 3.781999110768229*^9}, {
   3.78560827227256*^9, 3.7856083129767604`*^9}, {3.785608410891939*^9, 
   3.785608445961857*^9}, {3.7856090372104053`*^9, 3.785609048213865*^9}, {
   3.785610345605743*^9, 3.78561035455167*^9}, {3.785610400847374*^9, 
   3.7856104009653053`*^9}, 3.785610487432907*^9, {3.785610570821191*^9, 
   3.785610578960161*^9}, {3.785610928638017*^9, 3.78561095715207*^9}, {
   3.785611171912294*^9, 3.7856111799485717`*^9}, {3.785623433103546*^9, 
   3.785623476107887*^9}, {3.7856235200320196`*^9, 3.785623543021994*^9}, {
   3.785623668474419*^9, 3.785623840693098*^9}, {3.785624221559183*^9, 
   3.785624280099887*^9}, {3.785624443124299*^9, 3.7856244497812786`*^9}, {
   3.785624681216499*^9, 3.785624705733576*^9}, {3.7857165451783767`*^9, 
   3.785716578272333*^9}, {3.785716791419263*^9, 3.785716848691844*^9}, {
   3.7884841289634256`*^9, 3.788484157935116*^9}, {3.788484203538827*^9, 
   3.788484251147502*^9}, {3.788484290271343*^9, 3.788484310779481*^9}, {
   3.789839033078313*^9, 3.789839066350301*^9}, {3.789839218973988*^9, 
   3.789839222465055*^9}, {3.789839550604729*^9, 3.789839559076761*^9}, {
   3.789840180219336*^9, 3.789840185570382*^9}, 3.789840249499923*^9, {
   3.7898409087610044`*^9, 3.78984095631785*^9}, {3.7898410276722116`*^9, 
   3.789841077286061*^9}, {3.789841119493724*^9, 3.7898411227414675`*^9}, {
   3.789842175439259*^9, 3.7898421759179854`*^9}, {3.7904572330020647`*^9, 
   3.790457233506774*^9}, {3.790457322951396*^9, 3.790457323531063*^9}, {
   3.790457555112909*^9, 3.790457555299801*^9}, {3.790457718863064*^9, 
   3.7904577265096345`*^9}, {3.790457758550213*^9, 3.7904577933422194`*^9}, 
   3.7924495059555273`*^9, {3.8105916357845044`*^9, 3.81059166149145*^9}, {
   3.81116315627317*^9, 3.811163157949651*^9}, {3.812925589687284*^9, 
   3.8129256246618366`*^9}, {3.81292582385061*^9, 3.812925830728222*^9}, {
   3.8130889781614447`*^9, 3.813088994005149*^9}, {3.813089038138145*^9, 
   3.813089039798421*^9}, {3.813092446413688*^9, 3.813092448892329*^9}, {
   3.8141939685613832`*^9, 3.814194015049949*^9}, {3.814194062184141*^9, 
   3.814194093289145*^9}, {3.814195311071409*^9, 3.8141953280721617`*^9}, {
   3.814196844829958*^9, 3.8141970752798877`*^9}, {3.814298665533497*^9, 
   3.814298725144079*^9}, {3.814802932821034*^9, 3.814803010498905*^9}, {
   3.814803124060303*^9, 3.814803124508325*^9}, {3.81489999127813*^9, 
   3.814899996905958*^9}, 3.815404928047578*^9, {3.815407438842252*^9, 
   3.8154074566667137`*^9}, {3.8154111775911427`*^9, 3.815411181486781*^9}, {
   3.815411211743915*^9, 3.815411229429171*^9}, {3.815411403503518*^9, 
   3.815411406423817*^9}, {3.815411474569274*^9, 3.81541152829084*^9}, {
   3.8154116029927077`*^9, 3.8154116061924257`*^9}, {3.8154116489685235`*^9, 
   3.815411651559085*^9}, {3.81541174027281*^9, 3.815411749296831*^9}, {
   3.8154117940971336`*^9, 3.815411796424507*^9}, {3.815411864257127*^9, 
   3.815411910714528*^9}, {3.815412018313276*^9, 3.815412019168705*^9}, {
   3.815412634330262*^9, 3.8154126583213835`*^9}, {3.8154127275301175`*^9, 
   3.815412744098688*^9}, {3.8394197909514165`*^9, 3.839419861950676*^9}, {
   3.839427057273093*^9, 3.8394270576636934`*^9}, {3.839598520512124*^9, 
   3.839598566228878*^9}, 3.839598745054049*^9, {3.839598791589449*^9, 
   3.839598820501132*^9}, 3.8395995310212603`*^9, 3.839602450311784*^9, {
   3.840382435503076*^9, 3.8403824419685645`*^9}, 3.8403826056406507`*^9, {
   3.840820660273511*^9, 3.8408206814844756`*^9}, {3.8408216614791355`*^9, 
   3.8408217094697065`*^9}, {3.840821756138236*^9, 3.840821762647195*^9}, 
   3.840821796696235*^9, {3.8416012014732533`*^9, 3.8416012376622095`*^9}, 
   3.8416770020472145`*^9, 3.841684012966519*^9, {3.842618856891288*^9, 
   3.842618878969818*^9}, {3.842618997418752*^9, 3.842619053795145*^9}, 
   3.842619115217287*^9, 3.8428887145808187`*^9, 3.8428891429235435`*^9, 
   3.8437482569410205`*^9, 3.843748386963147*^9, {3.844353275518691*^9, 
   3.844353295002845*^9}, {3.846285264244522*^9, 3.846285264940296*^9}, {
   3.846285363245897*^9, 3.846285421414618*^9}, 3.846285586658688*^9, 
   3.846286030461997*^9, {3.84633223719346*^9, 3.8463322761925836`*^9}, 
   3.846332398959625*^9, {3.846863982363276*^9, 3.8468640435745087`*^9}, {
   3.8607586964265037`*^9, 3.860758697138793*^9}, {3.860763636036413*^9, 
   3.860763640387326*^9}, {3.861733837656307*^9, 3.8617338402713203`*^9}, 
   3.861733888789778*^9, {3.873995476287822*^9, 3.873995550432909*^9}, {
   3.873997221232993*^9, 3.873997221352814*^9}, {3.873997261951968*^9, 
   3.873997295027814*^9}, 3.873997349596678*^9, 3.873997536363335*^9, 
   3.8741531843405943`*^9, {3.874154630960103*^9, 3.874154652063835*^9}, {
   3.874154711243784*^9, 3.87415471173296*^9}, 3.874154774452851*^9, {
   3.874154830727339*^9, 3.874154830852636*^9}, 3.8741548788097706`*^9, 
   3.8741549934375677`*^9, 3.874263489069142*^9, {3.874693916490527*^9, 
   3.874693952740455*^9}, {3.874694023113165*^9, 3.8746940262397633`*^9}, {
   3.8746943989387994`*^9, 3.874694444343599*^9}, {3.874694484624583*^9, 
   3.874694528314595*^9}, {3.874694561832472*^9, 3.874694562146199*^9}, {
   3.874778333655243*^9, 3.8747783624067497`*^9}, {3.875268638405132*^9, 
   3.875268644615415*^9}, 3.875269977720329*^9, {3.875270029210743*^9, 
   3.875270032211097*^9}, {3.8752741540103145`*^9, 3.875274174946559*^9}, 
   3.875274411336403*^9, 3.8752745319954443`*^9, {3.8752745847278566`*^9, 
   3.875274605195095*^9}, {3.876589837253355*^9, 3.87658985303408*^9}, 
   3.876671772106908*^9, 3.8791078047683306`*^9, {3.887658782499086*^9, 
   3.887658873956455*^9}, {3.887658922661704*^9, 3.8876589248698025`*^9}, {
   3.887660703837455*^9, 3.8876607090745726`*^9}, {3.887824347286295*^9, 
   3.8878243714635897`*^9}, 3.887824501032691*^9, 3.8878251787287025`*^9, {
   3.935846884089372*^9, 3.935846945175926*^9}, {3.9361277749616127`*^9, 
   3.936127787234873*^9}},
 CellLabel->"In[22]:=",ExpressionUUID->"603ec9d6-9cf6-ef42-8b4a-8020b42e14b3"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StringLength", "[", "wuEtAl2024seq", "]"}]], "Input",
 CellChangeTimes->{{3.935846953135256*^9, 3.935846965446548*^9}, {
   3.935847013622289*^9, 3.9358470142379413`*^9}, 3.9361278092478523`*^9},
 CellLabel->"In[23]:=",ExpressionUUID->"3417e37b-00f8-fc41-bf86-62b92b7c71d5"],

Cell[BoxData["5481"], "Output",
 CellChangeTimes->{3.935846966053932*^9, 3.9358470145529823`*^9, 
  3.936127809709175*^9},
 CellLabel->"Out[23]=",ExpressionUUID->"b1c4739e-84e0-a34a-b03b-95b55d9dae8b"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"x", "=", "9"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"While", "[", 
  RowBox[{
   RowBox[{"!", 
    RowBox[{"DuplicateFreeQ", "[", "allRunsOfX", "]"}]}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"allRunsOfX", "=", 
     RowBox[{"Table", "[", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"StringTake", "[", 
        RowBox[{"wuEtAl2024seq", ",", 
         RowBox[{"{", 
          RowBox[{"i", ",", 
           RowBox[{"i", "+", "x"}]}], "}"}]}], "]"}], "\[IndentingNewLine]", 
       ",", 
       RowBox[{"{", 
        RowBox[{"i", ",", 
         RowBox[{
          RowBox[{"StringLength", "[", "wuEtAl2024seq", "]"}], "-", "x"}]}], 
        "}"}]}], "]"}]}], ";", "\[IndentingNewLine]", 
    RowBox[{"x", "++"}]}]}], "\[IndentingNewLine]", 
  "]"}], "\[IndentingNewLine]", 
 RowBox[{"Print", "[", "x", "]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"(*", 
   RowBox[{
    RowBox[{
     RowBox[{
     "test", " ", "if", " ", "there", " ", "are", " ", "no", " ", 
      "duplicated", " ", "runs", " ", "of", " ", "x"}], "+", 
     RowBox[{"1", " ", "length", " ", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
        "false", " ", "for", " ", "8", " ", "and", " ", "9", " ", "so", " ", 
         "far"}], ")"}], ".", " ", "If"}], " ", "true"}]}], ",", " ", 
    RowBox[{
     RowBox[{"then", " ", "no", " ", "run", " ", "of", " ", "x"}], "+", 
     RowBox[{
     "1", " ", "or", " ", "larger", " ", "is", " ", "duplicated", " ", "in", 
      " ", "the", " ", 
      RowBox[{"scaffold", "."}]}]}]}], "*)"}]}]}], "Input",
 CellChangeTimes->{{3.935847117144964*^9, 3.935847266109279*^9}, {
  3.936127893382536*^9, 3.9361278961594276`*^9}, {3.9361281651998005`*^9, 
  3.936128303708317*^9}, {3.9361293562350903`*^9, 
  3.9361293594271374`*^9}},ExpressionUUID->"3c20d298-8a28-a849-8b7f-\
7644ef910380"],

Cell[BoxData["15"], "Print",
 CellChangeTimes->{3.9361283052255096`*^9},
 CellLabel->
  "During evaluation of \
In[63]:=",ExpressionUUID->"b9096bd4-59c2-2341-ab9a-8d1f8f33ba9a"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"allRunsOf14", "=", 
   RowBox[{"Table", "[", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"StringTake", "[", 
      RowBox[{"wuEtAl2024seq", ",", 
       RowBox[{"{", 
        RowBox[{"i", ",", 
         RowBox[{"i", "+", "13"}]}], "}"}]}], "]"}], "\[IndentingNewLine]", 
     ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", 
       RowBox[{
        RowBox[{"StringLength", "[", "wuEtAl2024seq", "]"}], "-", "13"}]}], 
      "}"}]}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"DuplicateFreeQ", "[", "allRunsOf14", "]"}]}], "Input",
 CellChangeTimes->{{3.936128324108494*^9, 3.9361283627082653`*^9}, {
  3.936129367468355*^9, 3.9361293812363415`*^9}},
 CellLabel->"In[78]:=",ExpressionUUID->"4a7985ff-4420-fe45-a7f1-1482b619be36"],

Cell[BoxData["False"], "Output",
 CellChangeTimes->{{3.936128339707016*^9, 3.936128363364191*^9}, {
  3.9361293717123013`*^9, 3.9361293823068275`*^9}},
 CellLabel->"Out[79]=",ExpressionUUID->"9a1303b0-d482-7644-beb0-b2066d445f8f"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"allRunsOf15", "=", 
   RowBox[{"Table", "[", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"StringTake", "[", 
      RowBox[{"wuEtAl2024seq", ",", 
       RowBox[{"{", 
        RowBox[{"i", ",", 
         RowBox[{"i", "+", "14"}]}], "}"}]}], "]"}], "\[IndentingNewLine]", 
     ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", 
       RowBox[{
        RowBox[{"StringLength", "[", "wuEtAl2024seq", "]"}], "-", "14"}]}], 
      "}"}]}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"DuplicateFreeQ", "[", "allRunsOf15", "]"}]}], "Input",
 CellChangeTimes->{{3.936128324108494*^9, 3.9361283386920776`*^9}, {
  3.9361293694223995`*^9, 3.93612938004854*^9}},
 CellLabel->"In[80]:=",ExpressionUUID->"bffb6f23-c8c6-7f4a-87be-d0b06ee7a0a7"],

Cell[BoxData["True"], "Output",
 CellChangeTimes->{
  3.936128339707016*^9, {3.9361293727562313`*^9, 3.9361293832675514`*^9}},
 CellLabel->"Out[81]=",ExpressionUUID->"00e6773e-2a7f-a246-8557-719833bc13f4"]
}, Open  ]],

Cell["\<\
This sequence contains at least one duplicated subsequence up to length 14.\
\>", "Text",
 CellChangeTimes->{{3.936128056234846*^9, 3.9361280913708935`*^9}, {
  3.9361281357381935`*^9, 3.9361281513713856`*^9}, {3.936128389706993*^9, 
  3.936128396987488*^9}, {3.936129385778099*^9, 
  3.936129385874897*^9}},ExpressionUUID->"35a08403-49fc-a749-8c45-\
e3baa2c36a0e"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"StringContainsQ", "[", 
  RowBox[{"wuEtAl2024seq", ",", "\"\<CCCCCCCCCCC\>\""}], 
  "]"}], "\[IndentingNewLine]", 
 RowBox[{"StringContainsQ", "[", 
  RowBox[{"wuEtAl2024seq", ",", "\"\<TTTTTTTT\>\""}], 
  "]"}], "\[IndentingNewLine]", 
 RowBox[{"StringContainsQ", "[", 
  RowBox[{"wuEtAl2024seq", ",", "\"\<AAAAAAAAAAA\>\""}], "]"}]}], "Input",
 CellChangeTimes->{{3.936127883637226*^9, 3.9361279461885815`*^9}, {
  3.936127983587929*^9, 3.936127995283327*^9}},
 CellLabel->"In[56]:=",ExpressionUUID->"20085780-127d-8a48-b765-47ea2f910ac6"],

Cell[BoxData["False"], "Output",
 CellChangeTimes->{{3.936127915425131*^9, 3.9361279468795624`*^9}, {
  3.936127986042137*^9, 3.936128023462761*^9}},
 CellLabel->"Out[56]=",ExpressionUUID->"d8977030-2f5a-4840-ab85-88add9d54053"],

Cell[BoxData["False"], "Output",
 CellChangeTimes->{{3.936127915425131*^9, 3.9361279468795624`*^9}, {
  3.936127986042137*^9, 3.9361280234687424`*^9}},
 CellLabel->"Out[57]=",ExpressionUUID->"3f20bddc-b775-6740-8a8a-6cb3c3ab381a"],

Cell[BoxData["False"], "Output",
 CellChangeTimes->{{3.936127915425131*^9, 3.9361279468795624`*^9}, {
  3.936127986042137*^9, 3.936128023472727*^9}},
 CellLabel->"Out[58]=",ExpressionUUID->"05a9416f-ec22-284d-92fd-43a355da02a9"]
}, Open  ]],

Cell["\<\
This sequence contains at least one run of: Cs up to 10, Ts up to 7, and As \
up to 10.

Inspired by this, I now aim to make a scaffold sequence longer than M13 \
(7249nt) while following the requirements of Kishi et al, except that I will \
require no duplicated subsequences of length x (starting with 9) rather than \
8. I will continue using G. I believe Wu et al could have avoided issues with \
G quadruplexes if they disallowed runs of G longer than 3.\
\>", "Text",
 CellChangeTimes->{{3.936128056234846*^9, 3.9361280913708935`*^9}, {
  3.9361281357381935`*^9, 3.9361281513713856`*^9}, {3.9361287246482887`*^9, 
  3.9361287984834137`*^9}, {3.936128837195486*^9, 3.9361289685953255`*^9}, {
  3.936129769978361*^9, 
  3.9361297752360516`*^9}},ExpressionUUID->"4ba4a0fe-a460-fa41-a44a-\
5ebe7983eacd"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"baseOptions", "=", 
  RowBox[{"{", 
   RowBox[{"\"\<A\>\"", ",", "\"\<T\>\"", ",", "\"\<G\>\""}], 
   "}"}]}]], "Input",
 CellChangeTimes->{{3.935847473849245*^9, 3.935847488605108*^9}, {
  3.936128478593403*^9, 3.9361284902667885`*^9}, {3.9361290128441067`*^9, 
  3.9361290177640095`*^9}},
 CellLabel->"In[71]:=",ExpressionUUID->"62af1af7-6500-9e47-9a2a-40426e32e4c2"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"A\"\>", ",", "\<\"T\"\>", ",", "\<\"G\"\>"}], "}"}]], "Output",
 CellChangeTimes->{3.935847490262148*^9, 3.9361290191820602`*^9},
 CellLabel->"Out[71]=",ExpressionUUID->"2e8d59f8-d30b-f64f-866f-e8c1c4c8db5e"]
}, Open  ]],

Cell[BoxData[
 RowBox[{"(*", 
  RowBox[{
  "runs", " ", "of", " ", "G", " ", "longer", " ", "than", " ", "3", " ", 
   "are", " ", "not", " ", 
   RowBox[{"allowed", ".", " ", "Runs"}], " ", "of", " ", "A", " ", "or", " ",
    "T", " ", "longer", " ", "than", " ", "5", " ", "are", " ", "not", " ", 
   RowBox[{"allowed", "."}]}], "*)"}]], "Input",
 CellChangeTimes->{{3.9358503706563187`*^9, 
  3.9358503849313293`*^9}},ExpressionUUID->"5e94a817-53e8-5d45-99db-\
e34838a30a2f"],

Cell["\<\
I\[CloseCurlyQuote]ll try 100 at a time to start. x=9 and x=10 failed. x=11 \
got close, with a max at 6195, so I will try running the while loop to beat \
M13.\
\>", "Text",
 CellChangeTimes->{{3.936128056234846*^9, 3.9361280913708935`*^9}, {
  3.9361281357381935`*^9, 3.9361281513713856`*^9}, {3.9361287246482887`*^9, 
  3.9361287984834137`*^9}, {3.936128837195486*^9, 3.9361289685953255`*^9}, {
  3.936129769978361*^9, 3.9361297752360516`*^9}, {3.9361300035219555`*^9, 
  3.936130018970579*^9}, {3.936130775754011*^9, 3.9361307932592087`*^9}, {
  3.936130941873949*^9, 3.9361309657948627`*^9}, {3.9361310957069397`*^9, 
  3.9361311121223965`*^9}},ExpressionUUID->"d09f69c3-1ee9-374f-a855-\
1ac164c88230"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"seqTest", "=", "\"\<\>\""}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"seqTestList", "=", 
   RowBox[{"{", "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"x", "=", "11"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"n", "=", "0"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"While", "[", 
  RowBox[{"(*", 
   RowBox[{
    RowBox[{"StringLength", "[", "seqTest", "]"}], "<", "7249"}], "*)"}], 
  RowBox[{
   RowBox[{"n", "<", "10000"}], ",", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"n", "++"}], ";", "\[IndentingNewLine]", 
    RowBox[{"seqTest", "=", "\"\<G\>\""}], ";", "\[IndentingNewLine]", 
    RowBox[{"baseInt", "=", 
     RowBox[{"RandomInteger", "[", 
      RowBox[{"{", 
       RowBox[{"1", ",", 
        RowBox[{"Length", "[", "baseOptions", "]"}]}], "}"}], "]"}]}], ";", 
    "\[IndentingNewLine]", 
    RowBox[{"basePick", "=", 
     RowBox[{"baseOptions", "[", 
      RowBox[{"[", "baseInt", "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
    RowBox[{"seqTest", "=", 
     RowBox[{"seqTest", "<>", "basePick"}]}], ";", "\[IndentingNewLine]", 
    RowBox[{"baseInt", "=", 
     RowBox[{"RandomInteger", "[", 
      RowBox[{"{", 
       RowBox[{"1", ",", 
        RowBox[{"Length", "[", "baseOptions", "]"}]}], "}"}], "]"}]}], ";", 
    "\[IndentingNewLine]", 
    RowBox[{"basePick", "=", 
     RowBox[{"baseOptions", "[", 
      RowBox[{"[", "baseInt", "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
    RowBox[{"seqTest", "=", 
     RowBox[{"seqTest", "<>", "basePick"}]}], ";", "\[IndentingNewLine]", 
    RowBox[{"seqTemp", "=", 
     RowBox[{"StringTake", "[", 
      RowBox[{"seqTest", ",", 
       RowBox[{"-", "3"}]}], "]"}]}], ";", "\[IndentingNewLine]", 
    RowBox[{"baseOptionsTemp", "=", 
     RowBox[{"If", "[", 
      RowBox[{
       RowBox[{"seqTemp", "==", "\"\<GGG\>\""}], ",", 
       RowBox[{"{", 
        RowBox[{"\"\<A\>\"", ",", "\"\<T\>\""}], "}"}], ",", "baseOptions"}], 
      "]"}]}], ";", "\[IndentingNewLine]", 
    RowBox[{"baseInt", "=", 
     RowBox[{"RandomInteger", "[", 
      RowBox[{"{", 
       RowBox[{"1", ",", 
        RowBox[{"Length", "[", "baseOptionsTemp", "]"}]}], "}"}], "]"}]}], 
    ";", "\[IndentingNewLine]", 
    RowBox[{"basePick", "=", 
     RowBox[{"baseOptionsTemp", "[", 
      RowBox[{"[", "baseInt", "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
    RowBox[{"seqTest", "=", 
     RowBox[{"seqTest", "<>", "basePick"}]}], ";", "\[IndentingNewLine]", 
    RowBox[{"seqTemp", "=", 
     RowBox[{"StringTake", "[", 
      RowBox[{"seqTest", ",", 
       RowBox[{"-", "3"}]}], "]"}]}], ";", "\[IndentingNewLine]", 
    RowBox[{"baseOptionsTemp", "=", 
     RowBox[{"If", "[", 
      RowBox[{
       RowBox[{"seqTemp", "==", "\"\<GGG\>\""}], ",", 
       RowBox[{"{", 
        RowBox[{"\"\<A\>\"", ",", "\"\<T\>\""}], "}"}], ",", "baseOptions"}], 
      "]"}]}], ";", "\[IndentingNewLine]", 
    RowBox[{"baseInt", "=", 
     RowBox[{"RandomInteger", "[", 
      RowBox[{"{", 
       RowBox[{"1", ",", 
        RowBox[{"Length", "[", "baseOptionsTemp", "]"}]}], "}"}], "]"}]}], 
    ";", "\[IndentingNewLine]", 
    RowBox[{"basePick", "=", 
     RowBox[{"baseOptionsTemp", "[", 
      RowBox[{"[", "baseInt", "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
    RowBox[{"seqTest", "=", 
     RowBox[{"seqTest", "<>", "basePick"}]}], ";", "\[IndentingNewLine]", 
    RowBox[{"Do", "[", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{
       RowBox[{"seqTemp", "=", 
        RowBox[{"StringTake", "[", 
         RowBox[{"seqTest", ",", 
          RowBox[{"-", "3"}]}], "]"}]}], ";", "\[IndentingNewLine]", 
       RowBox[{"baseOptionsTemp", "=", 
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{"seqTemp", "==", "\"\<GGG\>\""}], ",", 
          RowBox[{"{", 
           RowBox[{"\"\<A\>\"", ",", "\"\<T\>\""}], "}"}], ",", 
          "\[IndentingNewLine]", 
          RowBox[{"If", "[", 
           RowBox[{
            RowBox[{
             RowBox[{"StringTake", "[", 
              RowBox[{"seqTest", ",", 
               RowBox[{"-", "5"}]}], "]"}], "==", "\"\<AAAAA\>\""}], ",", 
            RowBox[{"{", 
             RowBox[{"\"\<G\>\"", ",", "\"\<T\>\""}], "}"}], ",", 
            "\[IndentingNewLine]", 
            RowBox[{"If", "[", 
             RowBox[{
              RowBox[{
               RowBox[{"StringTake", "[", 
                RowBox[{"seqTest", ",", 
                 RowBox[{"-", "5"}]}], "]"}], "==", "\"\<TTTTT\>\""}], ",", 
              RowBox[{"{", 
               RowBox[{"\"\<A\>\"", ",", "\"\<G\>\""}], "}"}], ",", 
              "baseOptions"}], "]"}]}], "\[IndentingNewLine]", "]"}]}], 
         "\[IndentingNewLine]", "]"}]}], ";", "\[IndentingNewLine]", 
       RowBox[{"baseInt", "=", 
        RowBox[{"RandomInteger", "[", 
         RowBox[{"{", 
          RowBox[{"1", ",", 
           RowBox[{"Length", "[", "baseOptionsTemp", "]"}]}], "}"}], "]"}]}], 
       ";", "\[IndentingNewLine]", 
       RowBox[{"basePick", "=", 
        RowBox[{"baseOptionsTemp", "[", 
         RowBox[{"[", "baseInt", "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
       RowBox[{"seqTest", "=", 
        RowBox[{"seqTest", "<>", "basePick"}]}]}], "\[IndentingNewLine]", ",", 
      RowBox[{"{", 
       RowBox[{"i", ",", 
        RowBox[{"x", "-", "5"}]}], "}"}]}], "]"}], ";", "\[IndentingNewLine]",
     "seqTest", ";", "\[IndentingNewLine]", 
    RowBox[{"baseOptionsTemp", "=", "baseOptions"}], ";", 
    "\[IndentingNewLine]", 
    RowBox[{"allRunsOfXtest", "=", 
     RowBox[{"{", "seqTest", "}"}]}], ";", "\[IndentingNewLine]", 
    RowBox[{"While", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"Length", "[", "baseOptionsTemp", "]"}], ">", "0"}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"baseInt", "=", 
        RowBox[{"RandomInteger", "[", 
         RowBox[{"{", 
          RowBox[{"1", ",", 
           RowBox[{"Length", "[", "baseOptionsTemp", "]"}]}], "}"}], "]"}]}], 
       ";", "\[IndentingNewLine]", 
       RowBox[{"basePick", "=", 
        RowBox[{"baseOptionsTemp", "[", 
         RowBox[{"[", "baseInt", "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
       RowBox[{"seqTemp", "=", 
        RowBox[{"seqTest", "<>", "basePick"}]}], ";", "\[IndentingNewLine]", 
       RowBox[{"last8temp", "=", 
        RowBox[{"StringTake", "[", 
         RowBox[{"seqTemp", ",", 
          RowBox[{"-", "8"}]}], "]"}]}], ";", "\[IndentingNewLine]", 
       RowBox[{"lastXtemp", "=", 
        RowBox[{"StringTake", "[", 
         RowBox[{"seqTemp", ",", 
          RowBox[{"-", "x"}]}], "]"}]}], ";", "\[IndentingNewLine]", 
       RowBox[{"If", "[", 
        RowBox[{
         RowBox[{"StringContainsQ", "[", 
          RowBox[{"last8temp", ",", "\"\<G\>\""}], "]"}], ",", 
         RowBox[{"(*", 
          RowBox[{
          "check", " ", "that", " ", "the", " ", "new", " ", "run", " ", "of",
            " ", "8", " ", "has", " ", "at", " ", "least", " ", "one", " ", 
           "G", " ", "in", " ", "it"}], "*)"}], "\[IndentingNewLine]", 
         RowBox[{"If", "[", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{
             RowBox[{"basePick", "==", "\"\<A\>\""}], "||", 
             RowBox[{"basePick", "==", "\"\<T\>\""}]}], ")"}], ",", 
           RowBox[{"(*", 
            RowBox[{"if", " ", "trying", " ", "A", " ", "or", " ", "T"}], 
            "*)"}], "\[IndentingNewLine]", 
           RowBox[{"If", "[", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{
                RowBox[{"StringTake", "[", 
                 RowBox[{"seqTemp", ",", 
                  RowBox[{"-", "6"}]}], "]"}], "==", "\"\<AAAAAA\>\""}], "||", 
               RowBox[{
                RowBox[{"StringTake", "[", 
                 RowBox[{"seqTemp", ",", 
                  RowBox[{"-", "6"}]}], "]"}], "==", "\"\<TTTTTT\>\""}]}], 
              ")"}], ",", 
             RowBox[{"(*", 
              RowBox[{
              "test", " ", "whether", " ", "a", " ", "run", " ", "of", " ", 
               "greater", " ", "than", " ", "5", " ", "As", " ", "or", " ", 
               "Ts", " ", "will", " ", "happen"}], "*)"}], 
             "\[IndentingNewLine]", 
             RowBox[{"baseOptionsTemp", "=", 
              RowBox[{"Drop", "[", 
               RowBox[{"baseOptionsTemp", ",", 
                RowBox[{"{", "baseInt", "}"}]}], "]"}]}], ",", 
             RowBox[{"(*", 
              RowBox[{
               RowBox[{"if", " ", "so"}], ",", " ", 
               RowBox[{
               "then", " ", "drop", " ", "this", " ", "possibility", " ", 
                "from", " ", "the", " ", "list", " ", "and", " ", "try", " ", 
                "again"}]}], "*)"}], "\[IndentingNewLine]", 
             RowBox[{"(*", 
              RowBox[{"otherwise", ",", " ", 
               RowBox[{
               "add", " ", "the", " ", "last", " ", "x", " ", "bases", " ", 
                "to", " ", "allRunsOfxtest"}]}], "*)"}], 
             "\[IndentingNewLine]", 
             RowBox[{
              RowBox[{"allRunsOfXtemp", "=", 
               RowBox[{"Join", "[", 
                RowBox[{"allRunsOfXtest", ",", 
                 RowBox[{"{", "lastXtemp", "}"}]}], "]"}]}], ";", 
              "\[IndentingNewLine]", 
              RowBox[{"If", "[", 
               RowBox[{
                RowBox[{"DuplicateFreeQ", "[", "allRunsOfXtemp", "]"}], ",", 
                RowBox[{"(*", 
                 RowBox[{
                 "check", " ", "whether", " ", "a", " ", "sequence", " ", 
                  "of", " ", "x", " ", "has", " ", "not", " ", "been", " ", 
                  "duplicated"}], "*)"}], "\[IndentingNewLine]", 
                RowBox[{
                 RowBox[{"seqTest", "=", "seqTemp"}], ";", 
                 "\[IndentingNewLine]", 
                 RowBox[{"allRunsOfXtest", "=", "allRunsOfXtemp"}], ";", 
                 "\[IndentingNewLine]", 
                 RowBox[{"baseOptionsTemp", "=", "baseOptions"}]}], ",", 
                RowBox[{"(*", 
                 RowBox[{
                  RowBox[{"in", " ", "that", " ", "case"}], ",", " ", 
                  RowBox[{"the", " ", "tests", " ", "have", " ", 
                   RowBox[{"succeeded", "!"}], " ", "Add", " ", "the", " ", 
                   "base", " ", "to", " ", "seqTest"}], ",", " ", 
                  RowBox[{
                  "permanently", " ", "add", " ", "the", " ", "last", " ", 
                   "x", " ", "bases", " ", "to", " ", "the", " ", "list", " ",
                    "of", " ", "all", " ", "sequences", " ", "of", " ", "x"}],
                   ",", " ", 
                  RowBox[{
                  "and", " ", "restore", " ", "all", " ", "possible", " ", 
                   "next", " ", "base", " ", "options"}]}], "*)"}], 
                "\[IndentingNewLine]", 
                RowBox[{"baseOptionsTemp", "=", 
                 RowBox[{"Drop", "[", 
                  RowBox[{"baseOptionsTemp", ",", 
                   RowBox[{"{", "baseInt", "}"}]}], "]"}]}]}], "]"}], ";"}]}], 
            RowBox[{"(*", 
             RowBox[{
              RowBox[{
              "sequence", " ", "of", " ", "x", " ", "has", " ", "been", " ", 
               "duplicated"}], ",", " ", 
              RowBox[{
              "so", " ", "drop", " ", "this", " ", "possibility", " ", "from",
                " ", "the", " ", "list", " ", "and", " ", "try", " ", 
               "again"}]}], "*)"}], "\[IndentingNewLine]", "]"}], ",", 
           "\[IndentingNewLine]", 
           RowBox[{"If", "[", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{"StringTake", "[", 
                RowBox[{"seqTemp", ",", 
                 RowBox[{"-", "4"}]}], "]"}], "==", "\"\<GGGG\>\""}], ")"}], 
             ",", 
             RowBox[{"(*", 
              RowBox[{
               RowBox[{"if", " ", "trying", " ", "G"}], ",", " ", 
               RowBox[{
               "test", " ", "whether", " ", "a", " ", "run", " ", "of", " ", 
                "greater", " ", "than", " ", "3", " ", "Gs", " ", "will", " ",
                 "happen"}]}], "*)"}], "\[IndentingNewLine]", 
             RowBox[{"baseOptionsTemp", "=", 
              RowBox[{"Drop", "[", 
               RowBox[{"baseOptionsTemp", ",", 
                RowBox[{"{", "baseInt", "}"}]}], "]"}]}], ",", 
             RowBox[{"(*", 
              RowBox[{
               RowBox[{"if", " ", "so"}], ",", " ", 
               RowBox[{
               "then", " ", "drop", " ", "G", " ", "as", " ", "a", " ", 
                "possibility", " ", "and", " ", "try", " ", "again"}]}], 
              "*)"}], "\[IndentingNewLine]", 
             RowBox[{"(*", 
              RowBox[{"otherwise", ",", " ", 
               RowBox[{
               "add", " ", "the", " ", "last", " ", "x", " ", "bases", " ", 
                "to", " ", "allRunsOfxtest"}]}], "*)"}], 
             "\[IndentingNewLine]", 
             RowBox[{
              RowBox[{"allRunsOfXtemp", "=", 
               RowBox[{"Join", "[", 
                RowBox[{"allRunsOfXtest", ",", 
                 RowBox[{"{", "lastXtemp", "}"}]}], "]"}]}], ";", 
              "\[IndentingNewLine]", 
              RowBox[{"If", "[", 
               RowBox[{
                RowBox[{"DuplicateFreeQ", "[", "allRunsOfXtemp", "]"}], ",", 
                RowBox[{"(*", 
                 RowBox[{
                 "check", " ", "whether", " ", "a", " ", "sequence", " ", 
                  "of", " ", "x", " ", "has", " ", "not", " ", "been", " ", 
                  "duplicated"}], "*)"}], "\[IndentingNewLine]", 
                RowBox[{
                 RowBox[{"seqTest", "=", "seqTemp"}], ";", 
                 "\[IndentingNewLine]", 
                 RowBox[{"allRunsOfXtest", "=", "allRunsOfXtemp"}], ";", 
                 "\[IndentingNewLine]", 
                 RowBox[{"baseOptionsTemp", "=", "baseOptions"}]}], ",", 
                RowBox[{"(*", 
                 RowBox[{
                  RowBox[{"in", " ", "that", " ", "case"}], ",", " ", 
                  RowBox[{"the", " ", "tests", " ", "have", " ", 
                   RowBox[{"succeeded", "!"}], " ", "Add", " ", "the", " ", 
                   "base", " ", "to", " ", "seqTest"}], ",", " ", 
                  RowBox[{
                  "permanently", " ", "add", " ", "the", " ", "last", " ", 
                   "x", " ", "bases", " ", "to", " ", "the", " ", "list", " ",
                    "of", " ", "all", " ", "sequences", " ", "of", " ", "x"}],
                   ",", " ", 
                  RowBox[{
                  "and", " ", "restore", " ", "all", " ", "possible", " ", 
                   "next", " ", "base", " ", "options"}]}], "*)"}], 
                "\[IndentingNewLine]", 
                RowBox[{"baseOptionsTemp", "=", 
                 RowBox[{"Drop", "[", 
                  RowBox[{"baseOptionsTemp", ",", 
                   RowBox[{"{", "baseInt", "}"}]}], "]"}]}]}], "]"}], ";"}]}], 
            RowBox[{"(*", 
             RowBox[{
              RowBox[{
              "sequence", " ", "of", " ", "x", " ", "has", " ", "been", " ", 
               "duplicated"}], ",", " ", 
              RowBox[{
              "so", " ", "drop", " ", "this", " ", "possibility", " ", "from",
                " ", "the", " ", "list", " ", "and", " ", "try", " ", 
               "again"}]}], "*)"}], "\[IndentingNewLine]", "]"}]}], 
          "\[IndentingNewLine]", "]"}], ",", "\[IndentingNewLine]", 
         RowBox[{"baseOptionsTemp", "=", 
          RowBox[{"Drop", "[", 
           RowBox[{"baseOptionsTemp", ",", 
            RowBox[{"{", "baseInt", "}"}]}], "]"}]}]}], 
        RowBox[{"(*", 
         RowBox[{
          RowBox[{
          "the", " ", "new", " ", "run", " ", "of", " ", "8", " ", "does", 
           " ", "not", " ", "have", " ", "at", " ", "least", " ", "one", " ", 
           "G", " ", "in", " ", "it"}], ",", " ", 
          RowBox[{
          "so", " ", "drop", " ", "this", " ", "possibility", " ", "from", 
           " ", "the", " ", "list", " ", "and", " ", "try", " ", "again"}]}], 
         "*)"}], "\[IndentingNewLine]", "]"}]}]}], "\[IndentingNewLine]", 
     "]"}], ";", "\[IndentingNewLine]", 
    RowBox[{"seqTestList", "=", 
     RowBox[{"Join", "[", 
      RowBox[{"seqTestList", ",", 
       RowBox[{"{", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"If", "[", 
           RowBox[{
            RowBox[{
             RowBox[{"StringLength", "[", "seqTest", "]"}], ">", "7067"}], 
            ",", "seqTest", ",", "\"\<short\>\""}], "]"}], ",", 
          RowBox[{"StringLength", "[", "seqTest", "]"}]}], "}"}], "}"}]}], 
      "]"}]}], ";"}]}], "\[IndentingNewLine]", "]"}]}], "Input",
 CellChangeTimes->{{3.9358588372430296`*^9, 3.935858865939829*^9}, {
  3.9361290328472366`*^9, 3.936129055329468*^9}, {3.936129103818989*^9, 
  3.9361291106777477`*^9}, {3.9361291436190796`*^9, 3.936129148329033*^9}, {
  3.9361291832080727`*^9, 3.936129186536705*^9}, {3.936129229731844*^9, 
  3.9361292335094204`*^9}, {3.9361293055566387`*^9, 3.9361293085344734`*^9}, {
  3.9361297875407295`*^9, 3.9361299444758797`*^9}, {3.9361304272969055`*^9, 
  3.936130484839205*^9}, {3.93613055537591*^9, 3.936130639911043*^9}, {
  3.9361306865267124`*^9, 3.9361306895815945`*^9}, {3.9361308021508617`*^9, 
  3.936130802279623*^9}, {3.9361311230725613`*^9, 3.9361311383349724`*^9}, {
  3.9361321447903805`*^9, 3.936132223151129*^9}, {3.936132376894802*^9, 
  3.936132377285776*^9}},
 CellLabel->
  "In[145]:=",ExpressionUUID->"fb8ddbc7-fee9-a345-9f4e-4e9b1be59a44"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{"size", " ", "of", " ", "list", " ", "in", " ", "MB"}], "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"ByteCount", "[", "seqTestList", "]"}], "/", "1024"}], "/", 
   "1024"}]}]], "Input",
 CellChangeTimes->{{3.9361319861497097`*^9, 3.936132015697975*^9}, {
  3.9361321166780186`*^9, 3.936132123466509*^9}, {3.936132324298752*^9, 
  3.936132351084179*^9}, {3.936141400569109*^9, 
  3.936141419087801*^9}},ExpressionUUID->"7cec1fd7-fbc6-654b-93c8-\
92dc1648af83"],

Cell[BoxData[
 FractionBox["81971", "65536"]], "Output",
 CellChangeTimes->{
  3.9361320160117817`*^9, {3.93613233438743*^9, 3.9361323515381165`*^9}, {
   3.9361413943718605`*^9, 3.936141409957941*^9}},
 CellLabel->
  "Out[151]=",ExpressionUUID->"dc7dbf21-386f-2444-9425-4d8fce975aca"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"Histogram", "[", 
  RowBox[{
   RowBox[{"seqTestList", "[", 
    RowBox[{"[", 
     RowBox[{"All", ",", "2"}], "]"}], "]"}], ",", "100"}], 
  "]"}], "\[IndentingNewLine]", 
 RowBox[{"Max", "[", 
  RowBox[{"seqTestList", "[", 
   RowBox[{"[", 
    RowBox[{"All", ",", "2"}], "]"}], "]"}], "]"}]}], "Input",
 CellChangeTimes->{{3.936130879469963*^9, 3.9361309180508156`*^9}},
 CellLabel->
  "In[152]:=",ExpressionUUID->"ead68483-5920-e344-953b-2bc2329e3bdc"],

Cell[BoxData[
 GraphicsBox[{
   {RGBColor[0.987148, 0.8073604000000001, 0.49470040000000004`], EdgeForm[{
    Opacity[0.041999999999999996`], Thickness[Small]}], {}, 
    {RGBColor[0.987148, 0.8073604000000001, 0.49470040000000004`], EdgeForm[{
     Opacity[0.041999999999999996`], Thickness[Small]}], 
     RectangleBox[{0., 0}, {100., 9.},
      RoundingRadius->0], RectangleBox[{100., 0}, {200., 30.},
      RoundingRadius->0], RectangleBox[{200., 0}, {300., 43.},
      RoundingRadius->0], RectangleBox[{300., 0}, {400., 82.},
      RoundingRadius->0], RectangleBox[{400., 0}, {500., 104.},
      RoundingRadius->0], RectangleBox[{500., 0}, {600., 143.},
      RoundingRadius->0], RectangleBox[{600., 0}, {700., 151.},
      RoundingRadius->0], RectangleBox[{700., 0}, {800., 177.},
      RoundingRadius->0], RectangleBox[{800., 0}, {900., 197.},
      RoundingRadius->0], RectangleBox[{900., 0}, {1000., 191.},
      RoundingRadius->0], RectangleBox[{1000., 0}, {1100., 204.},
      RoundingRadius->0], RectangleBox[{1100., 0}, {1200., 247.},
      RoundingRadius->0], RectangleBox[{1200., 0}, {1300., 261.},
      RoundingRadius->0], RectangleBox[{1300., 0}, {1400., 269.},
      RoundingRadius->0], RectangleBox[{1400., 0}, {1500., 275.},
      RoundingRadius->0], RectangleBox[{1500., 0}, {1600., 275.},
      RoundingRadius->0], RectangleBox[{1600., 0}, {1700., 252.},
      RoundingRadius->0], RectangleBox[{1700., 0}, {1800., 278.},
      RoundingRadius->0], RectangleBox[{1800., 0}, {1900., 300.},
      RoundingRadius->0], RectangleBox[{1900., 0}, {2000., 295.},
      RoundingRadius->0], RectangleBox[{2000., 0}, {2100., 283.},
      RoundingRadius->0], RectangleBox[{2100., 0}, {2200., 320.},
      RoundingRadius->0], RectangleBox[{2200., 0}, {2300., 303.},
      RoundingRadius->0], RectangleBox[{2300., 0}, {2400., 288.},
      RoundingRadius->0], RectangleBox[{2400., 0}, {2500., 308.},
      RoundingRadius->0], RectangleBox[{2500., 0}, {2600., 288.},
      RoundingRadius->0], RectangleBox[{2600., 0}, {2700., 273.},
      RoundingRadius->0], RectangleBox[{2700., 0}, {2800., 270.},
      RoundingRadius->0], RectangleBox[{2800., 0}, {2900., 253.},
      RoundingRadius->0], RectangleBox[{2900., 0}, {3000., 241.},
      RoundingRadius->0], RectangleBox[{3000., 0}, {3100., 261.},
      RoundingRadius->0], RectangleBox[{3100., 0}, {3200., 210.},
      RoundingRadius->0], RectangleBox[{3200., 0}, {3300., 240.},
      RoundingRadius->0], RectangleBox[{3300., 0}, {3400., 221.},
      RoundingRadius->0], RectangleBox[{3400., 0}, {3500., 196.},
      RoundingRadius->0], RectangleBox[{3500., 0}, {3600., 182.},
      RoundingRadius->0], RectangleBox[{3600., 0}, {3700., 175.},
      RoundingRadius->0], RectangleBox[{3700., 0}, {3800., 182.},
      RoundingRadius->0], RectangleBox[{3800., 0}, {3900., 172.},
      RoundingRadius->0], RectangleBox[{3900., 0}, {4000., 163.},
      RoundingRadius->0], RectangleBox[{4000., 0}, {4100., 144.},
      RoundingRadius->0], RectangleBox[{4100., 0}, {4200., 117.},
      RoundingRadius->0], RectangleBox[{4200., 0}, {4300., 96.},
      RoundingRadius->0], RectangleBox[{4300., 0}, {4400., 97.},
      RoundingRadius->0], RectangleBox[{4400., 0}, {4500., 111.},
      RoundingRadius->0], RectangleBox[{4500., 0}, {4600., 84.},
      RoundingRadius->0], RectangleBox[{4600., 0}, {4700., 70.},
      RoundingRadius->0], RectangleBox[{4700., 0}, {4800., 56.},
      RoundingRadius->0], RectangleBox[{4800., 0}, {4900., 71.},
      RoundingRadius->0], RectangleBox[{4900., 0}, {5000., 55.},
      RoundingRadius->0], RectangleBox[{5000., 0}, {5100., 47.},
      RoundingRadius->0], RectangleBox[{5100., 0}, {5200., 43.},
      RoundingRadius->0], RectangleBox[{5200., 0}, {5300., 55.},
      RoundingRadius->0], RectangleBox[{5300., 0}, {5400., 44.},
      RoundingRadius->0], RectangleBox[{5400., 0}, {5500., 33.},
      RoundingRadius->0], RectangleBox[{5500., 0}, {5600., 45.},
      RoundingRadius->0], RectangleBox[{5600., 0}, {5700., 24.},
      RoundingRadius->0], RectangleBox[{5700., 0}, {5800., 28.},
      RoundingRadius->0], RectangleBox[{5800., 0}, {5900., 22.},
      RoundingRadius->0], RectangleBox[{5900., 0}, {6000., 16.},
      RoundingRadius->0], RectangleBox[{6000., 0}, {6100., 18.},
      RoundingRadius->0], RectangleBox[{6100., 0}, {6200., 16.},
      RoundingRadius->0], RectangleBox[{6200., 0}, {6300., 9.},
      RoundingRadius->0], RectangleBox[{6300., 0}, {6400., 11.},
      RoundingRadius->0], RectangleBox[{6400., 0}, {6500., 11.},
      RoundingRadius->0], RectangleBox[{6500., 0}, {6600., 13.},
      RoundingRadius->0], RectangleBox[{6600., 0}, {6700., 8.},
      RoundingRadius->0], RectangleBox[{6700., 0}, {6800., 9.},
      RoundingRadius->0], RectangleBox[{6800., 0}, {6900., 4.},
      RoundingRadius->0], RectangleBox[{6900., 0}, {7000., 2.},
      RoundingRadius->0], RectangleBox[{7000., 0}, {7100., 5.},
      RoundingRadius->0], RectangleBox[{7100., 0}, {7200., 3.},
      RoundingRadius->0], RectangleBox[{7200., 0}, {7300., 6.},
      RoundingRadius->0], RectangleBox[{7300., 0}, {7400., 5.},
      RoundingRadius->0], RectangleBox[{7400., 0}, {7500., 3.},
      RoundingRadius->0], RectangleBox[{7500., 0}, {7600., 1.},
      RoundingRadius->0], RectangleBox[{7600., 0}, {7700., 1.},
      RoundingRadius->0], RectangleBox[{7700., 0}, {7800., 1.},
      RoundingRadius->0], RectangleBox[{8100., 0}, {8200., 1.},
      RoundingRadius->0], RectangleBox[{8200., 0}, {8300., 1.},
      RoundingRadius->0], RectangleBox[{8400., 0}, {8500., 1.},
      RoundingRadius->0], RectangleBox[{9100., 0}, {9200., 1.},
      RoundingRadius->
       0]}, {}, {}}, {{}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, \
{}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, \
{}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, \
{}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, \
{}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{-184., 0},
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  PlotRange->{{0., 9200.}, {All, All}},
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.02], 
     Scaled[0.05]}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{{3.9361308913736687`*^9, 3.936130919779007*^9}, 
   3.9361315301919804`*^9, 3.9361323371192436`*^9, 3.936141427279497*^9},
 CellLabel->
  "Out[152]=",ExpressionUUID->"0eaf96eb-f093-e340-b46d-abf2cb2abd59"],

Cell[BoxData["9151"], "Output",
 CellChangeTimes->{{3.9361308913736687`*^9, 3.936130919779007*^9}, 
   3.9361315301919804`*^9, 3.9361323371192436`*^9, 3.936141427374222*^9},
 CellLabel->
  "Out[153]=",ExpressionUUID->"134fe57f-4b58-bf40-87cc-77322cd01f61"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Length", "[", "seqTestList", "]"}]], "Input",
 CellChangeTimes->{{3.9361316749080734`*^9, 3.936131680274925*^9}},
 CellLabel->
  "In[154]:=",ExpressionUUID->"101716b0-4ab0-ed45-8aba-3b0ef9ff1b48"],

Cell[BoxData["10000"], "Output",
 CellChangeTimes->{3.93613168054521*^9, 3.936141457872854*^9},
 CellLabel->
  "Out[154]=",ExpressionUUID->"dd84b26f-3053-b844-ae5b-f640ff772d40"]
}, Open  ]],

Cell["\<\
Got pretty close after running 605 times (max: 7067nt). 7067<7249 but at \
least it\[CloseCurlyQuote]s on the same order of \
magnitude.\[LineSeparator]Ran it 10,000 times and got a nice sequence of \
9151nt. \
\>", "Text",
 CellChangeTimes->{{3.936128056234846*^9, 3.9361280913708935`*^9}, {
  3.9361281357381935`*^9, 3.9361281513713856`*^9}, {3.9361287246482887`*^9, 
  3.9361287984834137`*^9}, {3.936128837195486*^9, 3.9361289685953255`*^9}, {
  3.936129769978361*^9, 3.9361297752360516`*^9}, {3.9361300035219555`*^9, 
  3.936130018970579*^9}, {3.936130775754011*^9, 3.9361307932592087`*^9}, {
  3.936130941873949*^9, 3.9361309657948627`*^9}, {3.9361310957069397`*^9, 
  3.9361311121223965`*^9}, {3.936131615977625*^9, 3.9361316399297447`*^9}, {
  3.9361316856571255`*^9, 3.936131690634609*^9}, {3.9361414736769047`*^9, 
  3.9361415211894894`*^9}},ExpressionUUID->"dcb5b1e4-492a-144b-ab14-\
dd754a43d20c"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Position", "[", 
  RowBox[{
   RowBox[{"seqTestList", "[", 
    RowBox[{"[", 
     RowBox[{"All", ",", "2"}], "]"}], "]"}], ",", 
   RowBox[{"Max", "[", 
    RowBox[{"seqTestList", "[", 
     RowBox[{"[", 
      RowBox[{"All", ",", "2"}], "]"}], "]"}], "]"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.936130985962368*^9, 3.936131011522928*^9}},
 CellLabel->
  "In[155]:=",ExpressionUUID->"8942df68-2ccf-ea4d-a975-b80ce20957c2"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", "3592", "}"}], "}"}]], "Output",
 CellChangeTimes->{3.936131011917322*^9, 3.936131752552555*^9, 
  3.936141526571903*^9},
 CellLabel->
  "Out[155]=",ExpressionUUID->"43cee33b-da98-3d4c-adbc-f746b3b98225"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"seq9151withNoDuplicatesOf11", "=", 
  RowBox[{"seqTestList", "[", 
   RowBox[{"[", 
    RowBox[{"3592", ",", "1"}], "]"}], "]"}]}]], "Input",
 CellChangeTimes->{{3.936131018684902*^9, 3.936131073908346*^9}, 
   3.936131661214052*^9, 3.936131801467045*^9, {3.936141599145689*^9, 
   3.9361416145905094`*^9}},
 CellLabel->
  "In[156]:=",ExpressionUUID->"0ba6118b-bc74-0d40-bb40-0f5ab822128c"],

Cell[BoxData["\<\"\
GGTGAATGAAGGTTATGTTGAAGATTTAAAGGTGGGATATATGTATAGGAAGTTTTTGGGTGGAAATTTGAAAGGGTG\
AAATTAGATGGTTTGTTAGTGATAAAAGGGTTTATGTAAGTGTATGGGAGTGGGAGATAGGTAGGTAAAATTGGATAG\
TAGATAGATGGGTGAAATAATGATATAGTGTTTGTAAATGAGAAAGTGGTTAGATAATATGTTAGGGTATAAGGTTGG\
GAGGGAGGGTGATATAGAGGAGTGTGTTTAGAGTAGGGTTATGGTAGGAATAAGTGTGTAAGAGGAAGAAGATATTTG\
AGATGGGTTTTGTAGTTGTGTATGAGATGGGAAGGGTGTAGTTGGAAGTAAAGTGATGAGTTAGTTGAAGAAGATAGA\
GTGTAAGGAATTTTAGAGAGGAATGGTTTTAATGTAAGTGTGGGTGTTTAGGTGTGTGATTTTTGTTTGAAGGTTATT\
GAGGTTTATAAGGGATGAATTAGAAGGATATGTAGGGTGTGATAGAGATAAGTTTGAAAAATTGTGTGAAGGGAGGTT\
TGGGAGAGATAGAATTGAGTTTTATTGTAGAGATGGAGGAGTTTTATAGGTTATAGGTTTTTAGTTTTAGGGTGTTAA\
GTTGAGAGTAGAGGGTATGGTAAAGGAGTGGAGTATTGTAATGTAGAATTGTGGGATTAATTGGTTTAGGGTGTGAGT\
GATTGGATGAATTGTTGGGTTGGGTTTGTGGGATATAAAGTGTGAATATGTAGGGATTGGAGGTATTAAAGATATTTG\
TAATAAAGTGAGAATTTAAGGTATAAGAATATGGTTGGTAGGATATGTATATAGTTTTGGATATGGAGGAGAAATATG\
TGAATATGGATGAATATTTGATTGAATGAGAGAGAGGTATTAAGGATAAGAATAAAAGGATTGATAGATTGGAGTGGT\
AGTAGTTTAGTAGGTTAGAAGGGTAATGATTGGAAAGGGTGAGATAATGAGGTTAGTTGAGTAAGGATTGTTGAGAGA\
GAAGTTTGTTAAAGATTTGGGATGAGAAAATAAGAGTGTGGTTTGGTGGGAATGAGTGTGGTTGGTAGAGTTTGAGAG\
TGAATGATGGGTTTTTGAAATGATTTTATGGTGATGTTAGTATAGAAATGGATAGAATTGTGTAAAAAGTTATGAGAA\
GATTGATGGTGGTGGATGTTTGAGAAGGGTATTTAAGAGGAAGTATGAAAATATGTAGTGGGTAGGGAAAGGATTGTT\
ATTATGTGGGAGAAGAAGGTTAATAGAGAAAGTAGTATTGGTGTAATAGGTATGTTATGTTATAGTTTGGTGTTATAA\
AGATGTAGGGATGGTATGTTGGTATGGTAGTTTGTGAAATTAAGTGTAATATTGGATGTGGTTAAAAGGTGGGAAGTG\
GAATAAGTAGTGGGTAATTAGTTGGAGTTGATGAAGATGAATGATGAAATTGGTAATGGTTAAAAGTGGTAAATAAGT\
AATAGTGTAGTGGGAGGTTTTTGTGGGTAAATGTGATAAGGTATGTATGAGATAAAGTTGGGTTTATTGTATATTGGT\
TGGTAGTATGTATAGGTTATTTAGTAAAGAAAGTTATGAAGTTATGAATAATGTATTGTGGATAATAAGGGAAAGATT\
AGGGTGAAATATAGTGTAGATAGGAATAAAAGTTTAAAGAGAAAGAATTGAAGGAGGTTTGTTATAAAGGGTATTTTG\
AAGAGGTTTGAGTTGTAAATGGGAATTGTTAATTGTAATTAGGATAGAAATTATGGAAGGGTTAGGTGTGAGTATATA\
TGGAATTATAGGATAATAAGAAGTAGTGTTAGGGTTTTGTTAGATAAATTGATTTGTAGATGTATATGAAAATGTGAG\
GATTGAAATGATGAATTGATGAGGTGGTGTTAGAGTTTAGTGGGATTGAATGTTATGATGATTTTAAGGATTGAGTAG\
GGTTGTTGGTTGAGTTGAGAGTGGTAGATGGGTATAGGTTGGGAAGAGGAAGTGTATGTGTTAATAGGTAGAAAAGAT\
TATGATGATGGGTATGAATAGTGTATAAATGAAGTTTAGAAAGAAATAATGTTTGGAGGAATATGGGTATATGGGATG\
TTGTGAAATGAATGATTTTGTAAGAGATAAAAGGTTTTAGATTTGTTTGGTGGGTGATGGGTTTAGTAAGATAAGGGT\
AAATGATTTTGGGAGAAATGAATAGTATTTGAGGGTGGGAAGTAAGGAGAGGAGAAGAGGTGGATGGGTTTAATTGTA\
TTTGGGAAGGAAGAGGATGAGAGAGTGTAATGTGTATGTTAGATGAGGTTTTGATATAATGTGTGTAATAATGTATGG\
TTTGTATTGTTGTTAGTAGATGGAAGTTTTGAGTTTTGTGTAGGGAAATGGATATAGTGAATTATGATGAAATATGAT\
GGTGGTTTTGAGAGTTGTTGAATTGGGATGATATTATGGTTGAGTTAATGATTATGTGGGTTAGTGTAATTAAGAAAA\
TGAAATGGAAGTATTGTGTAATAGTGGAGGTGGGAATTTGTAGTAAATTAGTAAAAAGGAGTATGGTGTGAGGAAAAG\
TGATAAAGTAATATTGTGAGATGAATAAGGGTAGAGGAAAGTAAAGTTTGTGTTGTAATAAGTTATGATGAAGGTGGT\
GATTATTTGGGAAAGAGAGGAGTTGGTAGTGTTATAATGTGAATAGGGTTTGGGAGGGAAGTTTGGATAATATGAGTA\
GAGGTTATATGAGAGGAGATGAGAGATGATGAATTTTTGGGAGTAGTATGTAGAATGTTTGATAGGAAGTTGGTGATG\
GGAGTGTGGAGTGGGAAGAGGTTATTAGATTAAGGAGAGTATTAGATTAGAAAGGAAGGGATAAGGATAAAGGGAGTT\
GAGTTAAGAATAGAGTATGAGGTTAGGAAAAGTTAAGTTGGTAGTAAATTGAAATTGAATTGTGTTTTTAAGTAGTGG\
AAATTGGTGTATTGTTTAAAAGTAGGATAGGTTTAATGATGGTTGAATAGAGTAAGAATTGGATTTTTGTTGATATTT\
GTGGTATTGAGAATAGGTGGAAGTTGGTTGAATATTTGGGTGTGAGGATGGATGATGTGGGTATTATTGTTATGTAGA\
AATTGTTAAGGTGTTATTTTGATTGTTTTATAGATAGAAAGAAGGTTGATATAAAGATGAGGAGAGATAATTGTATGG\
AGGGTGTGAAATTTAGGTAGTTGGTATTAGAAGTAAAGAGGTTTGTGGGTTATGGAATGGTTTGGGATGGGTTATTTG\
AATGATTGTGGGAGGTATGTTAAAAAGGAGATATAGGGTAAGTAGTTTATTTGTGGATTATGGGATAAAGGGTGGGTT\
GGTTAAATAGGAGGTTGGATAAGGTAGTAAAGAATAAGTTGGTTTATAGGGTAGTTGGAATTTTGTGAATGAGGGAGG\
ATTATTTGATATGTAGTTTTTGGGAATGTTGATAAAATGAGGTATTTAAGTTTATTTGGAGGAAGTAAGTAGTAAATA\
TGGGTGAATGAGATTGGTTTAATGTGATAGTTGGGTTTTTGGTGAGGAAATGGGTTGTGAAGAAGTAGAGATGGTAGG\
GAAGGTAATGTGTTATTAGAAAAGTTGTTAAGATTTTAAGATATGTTAGATAGTGGTTGGAAGTGTATTATGAGAGTA\
AATTGAGAAAAGTAGAAATGTGAAAATTGTTAGATTGTGTAGTTGGGTAATGAAGTTTTTGATAGTGGTGAGGGAATA\
GGTAATGATAGGTGAAGAAGTGGTAGTGGAGAAAATGGAGGAGGTTAGTATAGGAGGTAGGAGAAAGATGAGATAGGG\
TGAGATGGTTGGGTGTATATAGAAGAGGTGAGGTTGTTTTATGTTTATATGATGAAGAAATTTAGAAAGTGAAAAAGA\
GGAAAAATAGATAGTAGTGAAAGAGAAGATAGATTGGGAAGGGTAAAATGAGTTGGTAGGGTTAGTATAATTGGGAGG\
AATTGAAGTTTGTGGTTGTATGAGTATTTATGGTAATTGGAAAGTGAGAGGGATTTTGGTAGAGATGGGAAAGGTGGG\
TATTTATGGGATTGTTAGTTTGATATTGGAAAGTTGAAGTTATTTAGGTATTGTTAAAGTAGAGTGTTGAGAGAAGGT\
ATTTTGTTTAGGTTATGAGATTGTAGGTTTGGGTGTAAGGTGTTTGAAATTGTAATTTAGAGGAGGATTTTGTTGGAT\
GTAGATGTAGGGTATTAGTTGAGTTGATTGTTGGTAAAGTAAATAAGATTAGTTAGGTTATAGTTGTAGGGTAAAAAT\
GTTGTTATAGGTAATGGGATTTTTGGATGGAAAATTGAATAAGGGAAGTAGTTTAAGATGGTTTGGAAGATTTAGATA\
GGGATTGTTTAGGGTGAGAGTTTGGGATATTTGTTGGTGATAATTTGTATTTAGGTAGGGTAATTGGATTGGAGGAAG\
AGGAGATGGAGTAGTAAGAGTGAAGTGTAATTTAGTTTAATGAGTAAAAGAAGTGGGAGTGTAAGGGATGTTAGGGAA\
AGTGGGATTAAGTGATTGAATGGAAGTGAGGAGTGTGAAAAAGATTAGTATTTAGGGTAAAATAGGTGATTGTGGTAG\
GGTAGTTTATAAGTGAATAGTAATTTTGATAAGTTATGGATAAATTGGATTAGAGGAGTAGATGAGGAGGTAGGGTAT\
ATTAGGTTGGTATGGAGAAATAAAGTAGGGTTAGAAATGTGGTGAATAGGGAGTATGGAGTTAGTGAGGGTAGTAGAT\
AGGAGAGGTATGTGATGGAGTAGGTTGAAAGTTTTGTGATAAGATATATAGTGGGTTATGATTGAATTGTTATAATGA\
TTGGGAATTGGTTGAGAATTGTAGTGATAGGTAGATTAGATTAATGTGGGATGGTTTAAGGTGTTGTTGTTTATTAGT\
TAATGTTTTATGTATTGATAAAGATGATTGTGTTAAGTGGGAGGATAGGGTAGGGATATTGTGGAGTTGTGAGTGTGT\
TTGTGGAGGGATAGATTAGGGTTGAGGAATTAGGGAAAGGGTTATAATGAGATATAGTGATGAAAGTGTAAAGTGGGT\
TATTTTGTTGATGGTGGAGAGGTTTAAGGGAAATTGGTAGGATGTGGTATAAAGGAGAGGAATAATTGTATAGGGATT\
ATATGGGAAATATAGTATAGTGGTATGAGGGAATGTTGGGATAATGAGTGATAAAAAGATGGTAATGGAGAGGAATGA\
AGAAGGGAAGGATGGGTATTGGGTATAAATGATTGTTGGAGAAGTGGGTGTGATGTGTGAGTAAAATGGAGGGATTTG\
GTATAGAAAGGGATTTTGAATAGTTAAATTGGTGTTTAAAGAATGATTAGTTAAGGATGATTATAAGGGTGTTGAGGG\
AGATGAAGGAGTGAGAAGTTAGAAGGGATGTGAGTGAGATAAGGTGATGATGTAGTATATAAGAAAAGTAATAAGTAG\
ATGGAGAAGAATTAGTGGATAATGAGGAAATTAAGGATAGAAGGGTTGTTGAATGGGAAGAAGATTATTTGGTGAAGG\
AGAGGGAGGGAGTAAGAGTGTTTTAAAGAATTAGTTTAAATGGATGTGAGGGTAAGGAGGGATTATTAGTTATTTAGA\
AAGATAAGAAGGTGGAGTGATATGGATGATAAATTGTATGGGAATTGATTGTGATAGGTGGATGGAGATTAATTGATT\
AAATGGAGGATTGTAAGTATGGGTTGGGTGTTGGTTAGTAATAATGGGAAAAGAGGAAGGTGGGATGTGGAAGGTAAG\
TTGTAATATAGGGTATGGGTAGGAAGTTTGGTTGTTGTGGAGGGTAGTGATTGATGTTAGAGTGTGATATATAGAATG\
AAGGGAGGAAGTTTGTTTATAAGGATTGAAGTAAGAGTGGGAGGGATTAATGTATGTTTATAGTGGGAAATAAGTATA\
TGAGAAGGTGTGTTGGATAGAGAAAAGGAAGTGAGGTGTATGAGTAAGAGATGGTGAGAGAATAATGTTAGGGTGGGA\
GTTGAGAATGTGTGTTATGGGTGTGAGAGAAATGTGGGATTTGGGTAGAGGGATTGTGTTATGTTGATTATAAGTAGA\
ATAATGGTTTTGGTTAGTGAAATGGAGAGTGTATTTAGGGATAGGAGATTATATGATGTTTGTGTTTGTAAGATGTAA\
AGAGAAGTTTTGTAATAAGGGATATGAGGTGGGTTAAAGGTGTTAAATGAAGAGAGTATAGTATTTAAGATAGGTGAT\
GTGTGTATATGTTAGAGAAGATGGTGGGAAAGAAAAATAGGAAGGTAAATAAGAGTTGTGAATGTATGTAGAAAATAA\
GTGGTAGGATTGATGGTTGATGTGTTTTGGTTGGAGAAAAGTAAGGGTGTAGAAGTTAATAGGAGTGTTGATGAAGGG\
TATAGTGAATGTTTTTAGTTGATAATTGGGAAGGTAGTGGAAGAAGTAAAGGGATTGATGGGTTTGAAAAGGGAAAAG\
GATAAATTGAAAAGGTGATGTAAATTAGAGATTTGTGATAGATAGAGAGGTTGTAATAGTGTTAAGGGATAAGAGGTA\
GGGTGATTAATTGGGTAGGAAAGTTGGATGGAATATTAGTAAGAAATGGGAAGGGAAGGGTTGTGGAAGGAGGTATGA\
GTGTTGTAAGTTTATTGTAGTGGAATTAAGGTATGTGGTAAGTTAGAGTATGTATATTGGGATATATTGGGTTGTTTG\
AGTGTGTTAGTGAGTGGTTGGTTTTTGGGAGGAAGAATATAAGATTGTTATTTAGATTGTGATGTGTTATGAAAGAGG\
GATAGGATTGTGAATTATTGATATAGTTTGATAATATGAAAGTAATTAAGAGATTTTTAGTTATTGATGGGTATAAAA\
GAAGTTGATTGATGTGAGGAGTGAAAGAAAAGGGATGTGTATGAAGGGTTATATAGTATAAGATGTGGGTAGGAGGTA\
TTGGGAAAGTAAATTAGGGTTATAAAGAATTGTTAGAAGTAGAATAGTGATGGATATGGTGGTTTAATTGGGAGAGGA\
TGTGTAAGAAAGGGTAGAAAATATGAATTGTGTATGAATATTGTGAAAAGTGGTATTGTTATTGATTGTAGAGGTAAG\
TAATGAGGTAGTATTGTTTGTTTTGGGTTAGGTAATGTAGAGTGAGTATGAATAAAAGGGTAAGAAGTAGAAGGTGAT\
AAGAAAAAGGAATGGTGATGGATTGATTTGGTTGAATGTTTTGAGGTTTAAAAGATTATAGGATTTTAAGTGTTTTGT\
TTTAGGTTATATGGTGTGGTTTATTAGGATGGTTGGGATAGTAAGTTTGTATATTAGATAGATAAAGAGGTTGGAAGA\
TAATATGGGAAGGTAAGATGTGTTTTAGTTGAGGGTTTGTTTAGGGAAGTTAAGGTGGGAGAGAGAAGGGTAAATAGT\
AGGGAAGGAGAATTATAGGGTTGGGTTATAGATAATTAGAAAGGGTTAATATGTAAAAATGTAAATGAATGTTTATAA\
GATGTATGAATTATGAATATTAGAATTAAGTTATATGTTATGTATTAGTATATGTTTTGGTAAGTGTAGAGGGTAATT\
TAGTGTTAAGTGAGTAATTATGAAGGGAAATTTTGGGTTTTGGGAAAGTGGAGAGAATAGGAGAAGTAAAGTATGGTA\
GGAGAGTGAAGTATATAAGGAATGATATGGGTTTAAGGAGTGTAATGATGGAATATGTAGTTGATTTTATGAAAGGGA\
TATGGTTTAAGATGTAGGTAATAGGAGAATTTGGTAAAAGAATTTTGTAGAATTAAAGTAGTATGTTTGAAGGAATTT\
AAGTGTGTTGAAATGTAATTGGAGGAGGTGATAAAGTTTTTATGTTGATAATGGGTAAAGTTGGATTAAAAGGAAGAG\
TAGTAGAATAAATGTTAATTGAGGAAGGGATTGTAGAAGTGTTGATGGTTAATTGGGTGTAGATGTGGGTGAATGTGG\
ATGAAGGTTTGATGGAATAGTAATGTGTAGTTTTATAGAATGGATTGTAAAAGAGAGAGTAGTAAGGATATTAAGTTG\
AAGAGATTAGTATATTGTGATAATAGAAGTTAAGTATAGTGGAATAGTATAAATGTTATATGGGATTGGTAGGAAGTG\
AAGAAGATGATAAATAGGGTAGGTAAATGATATATTGAAAGAAGATGTTAGGGTTAGATGGTGTTTGGGTAAAAGGAT\
TATGAGTATTATTGAGGAAGTGGGTTGTTAGAGGTATGGAGTAAAATAGTTGATGAATATGGGATGGAGAGTTGTGGA\
GTGGAAAGTTTTTGTAATAGGGTGGATGTTGTGGGTAGATGTTTAGAGTTTTGGTATGTGAAAATGGGTATAGAGAAA\
GAAAGTGGTAGATTAAGAGGGATGAATATATGGAAAGTGGAATATAAGAAGAGTTAGTGTTATAGTTAGAATGGAGAT\
GTGTGTAAAGGGAATAGGGAATTGTTTGTTAGGGAGAGGGAGAAGTAAGGGTTTGGTTTAAGGAATTTATGTGAATTA\
GTATTGATGAAGGATGTAGGAAATGTAGTAGAAAAAGTATAAAGGATTGTAGGAAGTAGAAGTTAGGGAGAATTGTGA\
AGAATGAATGGGTATGTGATAAGAAGGGAGTATTGGTAAAAGGAGGGTGGTTATATGTTTAAAAGAGTTGGAAGATTA\
TATGGAAAATAGGAGGGTTTATTAGAATATGGTGAATGTGAAAGGTGGTTATGGTATTAGGAGGAGTTGAAGAATTTG\
GGTAATGTAGTGGTGGTGGTGTAGGTGAGTTGTGGGTTAGGGAAGAAGAGGGTGTGGTGATAAGGTGTGAGGAGGAGG\
AGAATAAAAGTGGAAATAGTAGAAAATTAGAGGGAAAAGATAAAGTATTTTTGTTGTTGGGATTGTGGTGAAAAGTGT\
GAGTAGAGTAGGTTTGGAATAGTTGATATTAAGAAATATAGGAAAAGAATATTAGGTGTGGGAGTTTATATGAGTTAA\
AGGGAGTGGATGTGTATATATGTAATTTGAGGGTATATAGTAAATGTAGTTATAGTAGGAGTTGAGTATAGGTGGAGG\
AGAGTTAGAAGATAAGATGGGTGTGAATGTAATTAGAAGAGGGTATTTTTGGGTAAGAGGGTGATAGGGTTGAGTTTG\
AGATGAATTAGGTTTAAGATTATTT\"\>"], "Output",
 CellChangeTimes->{3.9361416603264637`*^9},
 CellLabel->
  "Out[156]=",ExpressionUUID->"9be707fb-903c-1a4a-93e6-0f5fbc10abdb"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"StringLength", "[", "seq9151withNoDuplicatesOf11", 
  "]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"allRunsOfXnew", "=", 
    RowBox[{"Table", "[", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"StringTake", "[", 
       RowBox[{"seqTest", ",", 
        RowBox[{"{", 
         RowBox[{"i", ",", 
          RowBox[{"i", "+", 
           RowBox[{"(", 
            RowBox[{"x", "-", "1"}], ")"}]}]}], "}"}]}], "]"}], 
      "\[IndentingNewLine]", ",", 
      RowBox[{"{", 
       RowBox[{"i", ",", 
        RowBox[{
         RowBox[{"StringLength", "[", "seqTest", "]"}], "-", 
         RowBox[{"(", 
          RowBox[{"x", "-", "1"}], ")"}]}]}], "}"}]}], "]"}]}], ";"}], 
  "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{
    RowBox[{
    "test", " ", "if", " ", "there", " ", "are", " ", "no", " ", "duplicated",
      " ", "runs", " ", "of", " ", 
     RowBox[{"x", ".", " ", "If"}], " ", "true"}], ",", " ", 
    RowBox[{
    "then", " ", "no", " ", "run", " ", "of", " ", "x", " ", "or", " ", 
     "larger", " ", "is", " ", "duplicated", " ", "in", " ", "the", " ", 
     RowBox[{"scaffold", "."}]}]}], "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"DuplicateFreeQ", "[", "allRunsOfXnew", "]"}], 
  "\[IndentingNewLine]", "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{
   "double", " ", "check", " ", "that", " ", "there", " ", "is", " ", "no", 
    " ", "run", " ", "of", " ", "8", " ", 
    RowBox[{"that", "'"}], "s", " ", "missing", " ", "a", " ", "G", " ", 
    RowBox[{"(", 
     RowBox[{"desired", " ", 
      RowBox[{"output", ":", " ", "false"}]}], ")"}]}], 
   "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"allRunsOf8new", "=", 
   RowBox[{"Table", "[", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"StringTake", "[", 
      RowBox[{"seq9151withNoDuplicatesOf11", ",", 
       RowBox[{"{", 
        RowBox[{"i", ",", 
         RowBox[{"i", "+", "7"}]}], "}"}]}], "]"}], "\[IndentingNewLine]", 
     ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", 
       RowBox[{
        RowBox[{"StringLength", "[", "seq9151withNoDuplicatesOf11", "]"}], 
        "-", "7"}]}], "}"}]}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ContainsAny", "[", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Table", "[", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"StringContainsQ", "[", 
       RowBox[{
        RowBox[{"allRunsOf8new", "[", 
         RowBox[{"[", "i", "]"}], "]"}], ",", "\"\<G\>\""}], "]"}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"{", 
       RowBox[{"i", ",", 
        RowBox[{"Length", "[", "allRunsOf8new", "]"}]}], "}"}]}], "]"}], 
    "\[IndentingNewLine]", ",", 
    RowBox[{"{", "False", "}"}]}], "]"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{"StringContainsQ", "[", 
  RowBox[{"seq9151withNoDuplicatesOf11", ",", "\"\<GGGG\>\""}], 
  "]"}], "\[IndentingNewLine]", 
 RowBox[{"StringContainsQ", "[", 
  RowBox[{"seq9151withNoDuplicatesOf11", ",", "\"\<TTTTTT\>\""}], 
  "]"}], "\[IndentingNewLine]", 
 RowBox[{"StringContainsQ", "[", 
  RowBox[{"seq9151withNoDuplicatesOf11", ",", "\"\<AAAAAA\>\""}], 
  "]"}]}], "Input",
 CellChangeTimes->{{3.9361294008058357`*^9, 3.936129490954731*^9}, {
   3.9361299516522713`*^9, 3.936129981819483*^9}, 3.9361318169395046`*^9, {
   3.936141623595232*^9, 3.9361416500037174`*^9}},
 CellLabel->
  "In[157]:=",ExpressionUUID->"8991869b-66f2-e144-ba44-e040b24d6ac0"],

Cell[BoxData["9151"], "Output",
 CellChangeTimes->{3.935858950358204*^9, 3.9361318247545414`*^9, 
  3.936141679341879*^9},
 CellLabel->
  "Out[157]=",ExpressionUUID->"1ef0b655-683a-744a-a2a7-8f9e2eabd9aa"],

Cell[BoxData["True"], "Output",
 CellChangeTimes->{3.935858950358204*^9, 3.9361318247545414`*^9, 
  3.9361416794126873`*^9},
 CellLabel->
  "Out[159]=",ExpressionUUID->"cb5a5f4b-5e51-404d-aa48-2dcb21dfd9d3"],

Cell[BoxData["False"], "Output",
 CellChangeTimes->{3.935858950358204*^9, 3.9361318247545414`*^9, 
  3.936141679519699*^9},
 CellLabel->
  "Out[161]=",ExpressionUUID->"e58db4d5-e461-6f46-a340-6514c034dcdf"],

Cell[BoxData["False"], "Output",
 CellChangeTimes->{3.935858950358204*^9, 3.9361318247545414`*^9, 
  3.9361416795311127`*^9},
 CellLabel->
  "Out[162]=",ExpressionUUID->"c6f49d1f-15e4-9c4c-8b2e-e0915891afe7"],

Cell[BoxData["False"], "Output",
 CellChangeTimes->{3.935858950358204*^9, 3.9361318247545414`*^9, 
  3.936141679536066*^9},
 CellLabel->
  "Out[163]=",ExpressionUUID->"76b77e06-3546-f24a-91a3-c700a63216b9"],

Cell[BoxData["False"], "Output",
 CellChangeTimes->{3.935858950358204*^9, 3.9361318247545414`*^9, 
  3.9361416795400543`*^9},
 CellLabel->
  "Out[164]=",ExpressionUUID->"ec643bb1-4711-3746-bc55-c7f0d6d2c30c"]
}, Open  ]],

Cell[BoxData[
 RowBox[{"(*", 
  RowBox[{"want", " ", "to", " ", 
   RowBox[{"see", ":", " ", 
    RowBox[{"1", "T", " ", "and", " ", "4", "F"}]}]}], "*)"}]], "Input",
 CellChangeTimes->{{3.9361294966626797`*^9, 
  3.9361295054745464`*^9}},ExpressionUUID->"2f320592-c2a1-0049-8e06-\
e3147142d743"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Export", "[", 
  RowBox[{
  "\"\<9151ntScaffold_No11Duplicates.txt\>\"", ",", 
   "seq9151withNoDuplicatesOf11"}], "]"}]], "Input",
 CellChangeTimes->{{3.9358583876583796`*^9, 3.93585839916177*^9}, {
  3.9358584996163383`*^9, 3.9358585003759174`*^9}, {3.935858971537445*^9, 
  3.93585898968087*^9}, {3.9361318504267426`*^9, 3.93613185993832*^9}, {
  3.936131907813116*^9, 3.936131951867687*^9}, {3.936141705933964*^9, 
  3.936141712010023*^9}},
 CellLabel->
  "In[165]:=",ExpressionUUID->"746e505b-f4bc-674d-ac58-083b1aae4f02"],

Cell[BoxData["\<\"9151ntScaffold_No11Duplicates.txt\"\>"], "Output",
 CellChangeTimes->{3.935859003357378*^9, 3.936131953949127*^9, 
  3.936141715488579*^9},
 CellLabel->
  "Out[165]=",ExpressionUUID->"d6645e60-8f2d-f848-91f9-49282c3a75db"]
}, Open  ]]
}, Open  ]]
},
WindowSize->{1440, 738},
WindowMargins->{{-6, Automatic}, {Automatic, -6}},
FrontEndVersion->"14.0 for Microsoft Windows (64-bit) (December 12, 2023)",
StyleDefinitions->"Default.nb",
ExpressionUUID->"f748dfd1-1462-427b-b3cf-873a365b8d73"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[580, 22, 297, 4, 67, "Section",ExpressionUUID->"ece40f48-955f-47ee-90f3-9470b66cfeb8"],
Cell[CellGroupData[{
Cell[902, 30, 1923, 45, 216, "Input",ExpressionUUID->"c2ab329e-e807-4f13-b606-835b629b7ac9",
 InitializationCell->True],
Cell[2828, 77, 212, 3, 70, "Output",ExpressionUUID->"014d385c-cd3c-4741-8296-9ce67eed13fd"],
Cell[3043, 82, 212, 3, 70, "Output",ExpressionUUID->"51127a0c-26e3-1c4d-ab80-03fcdeab9a18"]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[3304, 91, 320, 6, 53, "Section",ExpressionUUID->"0a9bea59-79d3-4a6a-8cf8-3bb90b06c8b9"],
Cell[3627, 99, 1188, 28, 71, "Code",ExpressionUUID->"5fb56a93-f9e1-4b58-bb61-efe1c638abda",
 InitializationCell->True],
Cell[4818, 129, 1323, 31, 71, "Code",ExpressionUUID->"65f439cf-e12b-4f42-8769-59bb4ebb6cb1",
 InitializationCell->True]
}, Closed]],
Cell[CellGroupData[{
Cell[6178, 165, 253, 4, 53, "Section",ExpressionUUID->"8a16aae6-f49f-4bf9-b248-1c1e6ac475af"],
Cell[CellGroupData[{
Cell[6456, 173, 211, 4, 54, "Subsection",ExpressionUUID->"30ce7645-a04f-ed4d-97d3-2c424db8b4e5"],
Cell[6670, 179, 1781, 44, 147, "Code",ExpressionUUID->"68c09fbf-c325-4d43-9508-455cf09718ba",
 InitializationCell->True],
Cell[8454, 225, 1907, 46, 166, "Code",ExpressionUUID->"c5815f88-e0eb-1141-935c-1006228999df",
 InitializationCell->True]
}, Open  ]],
Cell[CellGroupData[{
Cell[10398, 276, 214, 4, 54, "Subsection",ExpressionUUID->"a826c335-5bbe-4387-9ae1-f5f85437684c"],
Cell[CellGroupData[{
Cell[10637, 284, 481, 9, 32, "Item",ExpressionUUID->"573f50af-f317-4d43-98db-4b2c5f310e12"],
Cell[11121, 295, 5982, 134, 242, "Code",ExpressionUUID->"0ee6b9a6-74c7-4f5f-845c-d52e6215fb79",
 InitializationCell->True],
Cell[CellGroupData[{
Cell[17128, 433, 8001, 118, 162, "Input",ExpressionUUID->"4d1b2512-31cd-4ced-8d2b-b381db598d32"],
Cell[25132, 553, 2182, 41, 119, "Output",ExpressionUUID->"f28a7272-d765-4c12-a897-86882d2d463c"]
}, Open  ]],
Cell[27329, 597, 3805, 72, 185, "Code",ExpressionUUID->"8bd5fc50-dcd4-40ec-a340-0fda945aa2b9",
 InitializationCell->True],
Cell[CellGroupData[{
Cell[31159, 673, 13394, 203, 219, "Input",ExpressionUUID->"0f95397c-34ee-423d-86ea-addc57f072f1"],
Cell[44556, 878, 8117, 142, 243, "Output",ExpressionUUID->"535272c1-effd-4c18-b250-a575bb92190a"]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[52746, 1028, 204, 4, 53, "Section",ExpressionUUID->"c439379f-067a-49f8-bbc1-fce1c87a5254"],
Cell[52953, 1034, 2209, 50, 159, "Input",ExpressionUUID->"04e67471-2be8-4690-a4ee-c9ea38a1761b",
 InitializationCell->True],
Cell[CellGroupData[{
Cell[55187, 1088, 244, 6, 32, "Item",ExpressionUUID->"e2ed1d67-5dd2-4ce2-a994-20df87efa9bf"],
Cell[CellGroupData[{
Cell[55456, 1098, 604, 17, 48, "Input",ExpressionUUID->"b5152b60-3f1a-4b1e-be49-62313cde631a"],
Cell[56063, 1117, 2015, 43, 32, "Output",ExpressionUUID->"880e0c45-e247-4be1-ac7b-b328edefe8d2"]
}, Open  ]],
Cell[CellGroupData[{
Cell[58115, 1165, 250, 5, 28, "Input",ExpressionUUID->"0dd06e87-670c-4ab7-8ed0-1d055b2f8105"],
Cell[58368, 1172, 604, 10, 32, "Output",ExpressionUUID->"ca5ac353-8a8b-48a8-875c-ab44ab432b8a"]
}, Open  ]]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[59033, 1189, 253, 4, 53, "Section",ExpressionUUID->"cf545185-d947-4099-b228-6b815151aadd"],
Cell[59289, 1195, 473, 9, 35, "Text",ExpressionUUID->"93894566-9390-4167-b5f8-1d0a35a76a65"],
Cell[59765, 1206, 1558, 38, 109, "Code",ExpressionUUID->"4460f267-6800-4e2f-beec-4edd56c77d92",
 InitializationCell->True],
Cell[61326, 1246, 1579, 39, 109, "Code",ExpressionUUID->"8ec7e1f2-789c-4af8-8143-164887f04488",
 InitializationCell->True],
Cell[62908, 1287, 15639, 342, 604, "Code",ExpressionUUID->"1a13e859-87f0-417e-b16a-f3bfc09d9c93"],
Cell[78550, 1631, 16349, 357, 565, "Code",ExpressionUUID->"ee221cf4-5f65-4417-8577-92d48a22d195"],
Cell[94902, 1990, 2119, 33, 86, "Input",ExpressionUUID->"feaa2ab5-97eb-47e0-ab3a-da681cb6b6bb"],
Cell[CellGroupData[{
Cell[97046, 2027, 671, 14, 28, "Input",ExpressionUUID->"dfef0933-1d6e-4410-b53d-d431f28e03c9"],
Cell[97720, 2043, 65409, 2063, 338, "Output",ExpressionUUID->"ca1984f2-eab7-487a-9cd2-cf9854faf9dc"]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[163178, 4112, 252, 4, 53, "Section",ExpressionUUID->"74d3c32d-f2a3-4c8a-ac1a-9d14e83a006f"],
Cell[163433, 4118, 4590, 89, 368, "Input",ExpressionUUID->"c9d52fa5-455e-4abe-b5c0-f71bdd9049b7",
 InitializationCell->True],
Cell[168026, 4209, 516, 13, 127, "Text",ExpressionUUID->"62e2828d-d6d5-401d-a217-c8332c62f6bf"],
Cell[CellGroupData[{
Cell[168567, 4226, 1148, 29, 86, "Input",ExpressionUUID->"97f47666-8558-4e24-8403-8cfb730773ec"],
Cell[169718, 4257, 226, 4, 32, "Output",ExpressionUUID->"6b005b8a-fb00-4bdd-9139-edc60e8cb579"]
}, Open  ]],
Cell[169959, 4264, 3753, 78, 299, "Code",ExpressionUUID->"ef366b8b-f70a-46ba-bbe5-72af37f86340",
 InitializationCell->True]
}, Closed]],
Cell[CellGroupData[{
Cell[173749, 4347, 150, 3, 53, "Section",ExpressionUUID->"ce2e8387-16d2-bd40-9014-84dbcc8d6114"],
Cell[173902, 4352, 1270, 26, 121, "Input",ExpressionUUID->"eb91e2f2-1612-f64f-b8ab-b666785e25c8",
 InitializationCell->True],
Cell[CellGroupData[{
Cell[175197, 4382, 232, 4, 28, "Input",ExpressionUUID->"19387961-9cf5-0148-93eb-c6873a326920"],
Cell[175432, 4388, 192, 3, 32, "Output",ExpressionUUID->"25a3012b-467c-1b4c-9789-f7796df802d5"]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[175673, 4397, 312, 6, 53, "Section",ExpressionUUID->"f2bcfabb-0e98-9342-996c-fb3b28684c03"],
Cell[175988, 4405, 8686, 119, 181, "Input",ExpressionUUID->"0e3a42cc-c5c2-0541-8848-d37091d22a6d"],
Cell[CellGroupData[{
Cell[184699, 4528, 280, 4, 28, "Input",ExpressionUUID->"aa3d043f-f7f4-c448-9e6e-2f0c7d46204b"],
Cell[184982, 4534, 176, 2, 32, "Output",ExpressionUUID->"0430d1fd-f837-a54a-bf5b-31933111c0b4"]
}, Open  ]],
Cell[185173, 4539, 650, 17, 67, "Input",ExpressionUUID->"a4d80476-a7f3-804b-9b0e-bcf568582930"],
Cell[CellGroupData[{
Cell[185848, 4560, 644, 14, 48, "Input",ExpressionUUID->"f327b70d-cca5-f940-b095-f6351597d5a2"],
Cell[186495, 4576, 178, 2, 32, "Output",ExpressionUUID->"c9e6381a-9d28-e14b-8218-839d5e5552c5"]
}, Open  ]],
Cell[CellGroupData[{
Cell[186710, 4583, 291, 6, 28, "Input",ExpressionUUID->"efb55aca-0f3b-9148-b8ea-9620dd428bc4"],
Cell[187004, 4591, 228, 4, 32, "Output",ExpressionUUID->"feec4601-0c05-134c-af1f-60da335b6289"]
}, Open  ]],
Cell[CellGroupData[{
Cell[187269, 4600, 205, 3, 28, "Input",ExpressionUUID->"d414cc67-77c7-6949-8bec-b035ab384a3f"],
Cell[187477, 4605, 177, 2, 32, "Output",ExpressionUUID->"e0ac13fb-8549-2147-99ff-cf62e70e1fb6"]
}, Open  ]],
Cell[CellGroupData[{
Cell[187691, 4612, 267, 5, 28, "Input",ExpressionUUID->"ace0c477-f8d4-f741-be6c-dfeb34797736"],
Cell[187961, 4619, 186, 2, 32, "Output",ExpressionUUID->"8077c8cc-aceb-5647-9ebc-3dc3f48e84dd"]
}, Open  ]],
Cell[CellGroupData[{
Cell[188184, 4626, 223, 3, 28, "Input",ExpressionUUID->"b9dfe33c-f41e-964f-ba8a-c61615db06eb"],
Cell[188410, 4631, 180, 2, 32, "Output",ExpressionUUID->"1fcf3d06-b597-5c4e-87c4-3f0013a6e90f"]
}, Open  ]],
Cell[188605, 4636, 478, 10, 28, "Input",ExpressionUUID->"16848f5a-7f7b-0d48-85bc-a1d5229db834"],
Cell[CellGroupData[{
Cell[189108, 4650, 7936, 180, 581, "Input",ExpressionUUID->"6bff7f64-14f1-054d-ba46-e6066301ecad"],
Cell[197047, 4832, 180, 3, 32, "Output",ExpressionUUID->"4b7d2a9a-c489-f949-b049-9f782679ab97"]
}, Open  ]],
Cell[CellGroupData[{
Cell[197264, 4840, 217, 4, 28, "Input",ExpressionUUID->"8be4534e-bf47-9e4b-b7eb-8335f368482b"],
Cell[197484, 4846, 1679, 23, 166, "Output",ExpressionUUID->"eccc6de5-90ec-994e-9635-c0d60132f7fa"]
}, Open  ]],
Cell[199178, 4872, 405, 8, 35, "Text",ExpressionUUID->"777300fe-f8b0-bf45-943d-4690567254bf"],
Cell[199586, 4882, 257, 4, 35, "Text",ExpressionUUID->"53478d6c-0fb2-9b4a-a53b-d3564ca7bdba"],
Cell[CellGroupData[{
Cell[199868, 4890, 267, 5, 28, "Input",ExpressionUUID->"fb6a6f7d-b8d4-6b41-9b55-7e0a0a20ddc2"],
Cell[200138, 4897, 159, 3, 32, "Output",ExpressionUUID->"49d7c222-d9a1-bc45-b697-e472ae3baa69"]
}, Open  ]],
Cell[CellGroupData[{
Cell[200334, 4905, 264, 5, 28, "Input",ExpressionUUID->"855ec957-2c3d-3c49-9e79-d7568dfb856d"],
Cell[200601, 4912, 156, 3, 32, "Output",ExpressionUUID->"29d0f093-f4f6-5f49-8c12-039d20e5e617"]
}, Open  ]],
Cell[CellGroupData[{
Cell[200794, 4920, 730, 18, 105, "Input",ExpressionUUID->"551db7b1-b190-ea43-9ed9-10cddf39dcce"],
Cell[201527, 4940, 207, 4, 32, "Output",ExpressionUUID->"5dc4aabb-17c8-384c-a410-a1ce916ea2a7"]
}, Open  ]],
Cell[201749, 4947, 292, 7, 35, "Text",ExpressionUUID->"bfae35ff-6397-1342-aacd-b00d50c50e6a"],
Cell[202044, 4956, 648, 15, 67, "Input",ExpressionUUID->"d03e95eb-3cd7-7446-872f-54769cc64512"],
Cell[CellGroupData[{
Cell[202717, 4975, 220, 3, 28, "Input",ExpressionUUID->"785120a0-d3da-884a-81cd-4a4ea63d6ab0"],
Cell[202940, 4980, 252, 3, 32, "Output",ExpressionUUID->"9bfc20a4-dccf-314d-8f3d-0b1a833fa9b6"]
}, Open  ]],
Cell[CellGroupData[{
Cell[203229, 4988, 212, 3, 28, "Input",ExpressionUUID->"74ecc1dc-327e-e744-a4a6-366b15096ad1"],
Cell[203444, 4993, 180, 2, 32, "Output",ExpressionUUID->"f80dba2d-c044-2e40-8365-23378c5095ea"]
}, Open  ]],
Cell[CellGroupData[{
Cell[203661, 5000, 179, 4, 28, "Input",ExpressionUUID->"58740e55-e355-314b-a6d6-1c28d98b1201"],
Cell[203843, 5006, 156, 3, 32, "Output",ExpressionUUID->"92169b5f-f123-7749-82ed-b45449da6aec"]
}, Open  ]],
Cell[CellGroupData[{
Cell[204036, 5014, 124, 2, 28, "Input",ExpressionUUID->"2a9eda22-6b4f-5b41-a185-49da3c2d96b8"],
Cell[204163, 5018, 185, 4, 32, "Output",ExpressionUUID->"dd38e121-38c9-0140-9bfa-10498ecb7f06"]
}, Open  ]],
Cell[CellGroupData[{
Cell[204385, 5027, 336, 8, 28, "Input",ExpressionUUID->"78169e18-8789-8e41-a6a6-47478f3a84cd"],
Cell[204724, 5037, 185, 3, 32, "Output",ExpressionUUID->"7a64946a-ebac-1046-a87e-31992f5a2200"]
}, Open  ]],
Cell[CellGroupData[{
Cell[204946, 5045, 231, 4, 28, "Input",ExpressionUUID->"1983942a-0933-194a-b761-3b239c8d8ada"],
Cell[205180, 5051, 210, 4, 32, "Output",ExpressionUUID->"8d6a756c-11d5-6147-aecb-2c471df8913e"]
}, Open  ]],
Cell[CellGroupData[{
Cell[205427, 5060, 11548, 241, 714, "Input",ExpressionUUID->"4723bb9f-6579-d249-ac21-5946e5697c46"],
Cell[216978, 5303, 374, 7, 32, "Output",ExpressionUUID->"bbaed0e9-a35f-8d45-bacf-8a71a2457085"]
}, Open  ]],
Cell[CellGroupData[{
Cell[217389, 5315, 116, 2, 28, "Input",ExpressionUUID->"dee6c526-7e0e-554e-8330-7c27492cb4d1"],
Cell[217508, 5319, 3280, 43, 337, "Output",ExpressionUUID->"d4ca9ae9-8134-294c-accf-0c80f174ebd3"]
}, Open  ]],
Cell[220803, 5365, 325, 8, 28, "Input",ExpressionUUID->"23a56538-b350-bb42-87f7-796b8e995c5e"],
Cell[CellGroupData[{
Cell[221153, 5377, 1221, 30, 105, "Input",ExpressionUUID->"2c7c67fb-bfe6-1444-9382-2aeb7edad92b"],
Cell[222377, 5409, 158, 3, 32, "Output",ExpressionUUID->"64b9a522-ffb5-b346-9112-42dcd9d66785"]
}, Open  ]],
Cell[CellGroupData[{
Cell[222572, 5417, 908, 23, 124, "Input",ExpressionUUID->"6b93ab3d-c62c-cd45-8c8f-491ad52a1b9f"],
Cell[223483, 5442, 157, 3, 32, "Output",ExpressionUUID->"465f1477-b111-5648-9981-92fb2bc86be9"]
}, Open  ]],
Cell[223655, 5448, 381, 8, 28, "Input",ExpressionUUID->"c20008de-a188-b943-a8f9-f2c2f8fa2e7d"],
Cell[CellGroupData[{
Cell[224061, 5460, 259, 5, 28, "Input",ExpressionUUID->"77c45fec-aba5-1a43-a19b-38979be8ba52"],
Cell[224323, 5467, 183, 3, 32, "Output",ExpressionUUID->"dac98a0b-41f2-3744-ba50-4bf96a63d02d"]
}, Open  ]],
Cell[CellGroupData[{
Cell[224543, 5475, 261, 5, 28, "Input",ExpressionUUID->"1a90b965-deff-504c-a320-b243069a2aa4"],
Cell[224807, 5482, 157, 3, 32, "Output",ExpressionUUID->"d7986af4-8de7-274e-a82f-855e94df8db0"]
}, Open  ]],
Cell[CellGroupData[{
Cell[225001, 5490, 263, 5, 28, "Input",ExpressionUUID->"fff11f24-1861-544f-911d-3e6ac7ee9fc4"],
Cell[225267, 5497, 159, 3, 32, "Output",ExpressionUUID->"67659629-99c5-b644-b9c9-749602bdbce7"]
}, Open  ]],
Cell[225441, 5503, 561, 13, 28, "Input",ExpressionUUID->"ed156e74-9a04-a041-a23d-fe7c8e5b8a38"],
Cell[226005, 5518, 230, 5, 28, "Input",ExpressionUUID->"dd2e9caf-ebc6-1241-9fe5-11d24eee21c8"],
Cell[CellGroupData[{
Cell[226260, 5527, 364, 7, 28, "Input",ExpressionUUID->"09eb9329-9d94-6e47-b280-e75b29b5677e"],
Cell[226627, 5536, 206, 3, 32, "Output",ExpressionUUID->"32a51cce-1542-1846-9559-76f56af2ca32"]
}, Open  ]],
Cell[226848, 5542, 841, 17, 28, "Input",ExpressionUUID->"33d04df1-b5f1-6e43-97dc-54905bcbeb19"],
Cell[CellGroupData[{
Cell[227714, 5563, 18424, 420, 1494, "Input",ExpressionUUID->"a8a3205b-845b-9d45-a628-10fd4c65de6a"],
Cell[246141, 5985, 656, 10, 32, "Output",ExpressionUUID->"b3c900a2-8634-a84f-8230-0086963d22c5"],
Cell[246800, 5997, 654, 10, 32, "Output",ExpressionUUID->"17a69da8-f9e9-dc46-893b-800f5ed81ddf"],
Cell[247457, 6009, 659, 10, 32, "Output",ExpressionUUID->"1d7a6810-1566-8d45-862b-4342d1437b8e"],
Cell[248119, 6021, 649, 10, 32, "Output",ExpressionUUID->"7d38d238-fc37-0043-80d7-cd2081531d20"],
Cell[248771, 6033, 646, 10, 32, "Output",ExpressionUUID->"99f200fc-bfd2-1542-9f7f-2878df2e2483"],
Cell[249420, 6045, 650, 10, 32, "Output",ExpressionUUID->"66fef8ca-6bfa-794c-aa0f-78f8cd71b682"],
Cell[250073, 6057, 650, 10, 32, "Output",ExpressionUUID->"827ac773-f95b-eb4a-83c0-784cb72f0fc0"],
Cell[250726, 6069, 648, 10, 32, "Output",ExpressionUUID->"e495e5cc-21ff-fa48-b63f-6186c662bd34"],
Cell[251377, 6081, 650, 10, 32, "Output",ExpressionUUID->"cfa7ca25-3f0d-4849-b534-c03c49dab3e7"]
}, Open  ]],
Cell[252042, 6094, 329, 9, 28, "Input",ExpressionUUID->"6b01f376-efbe-1749-893a-5e3d9b8ae944"],
Cell[252374, 6105, 1206, 26, 48, "Input",ExpressionUUID->"d8c7008c-ee18-7f43-b6f6-b8fa0739c699"],
Cell[253583, 6133, 15792, 347, 1265, "Input",ExpressionUUID->"903f0598-2094-8d4e-a808-9418d607e15c"],
Cell[CellGroupData[{
Cell[269400, 6484, 2042, 49, 276, "Input",ExpressionUUID->"6549c09b-7596-3d47-bb8e-103883cd34f2"],
Cell[271445, 6535, 157, 3, 32, "Output",ExpressionUUID->"63b78cf5-f468-be40-87d8-8ea34bb483ab"],
Cell[271605, 6540, 157, 3, 32, "Output",ExpressionUUID->"9b9c63b4-3c08-3a4c-b769-681f8ddb65be"],
Cell[271765, 6545, 160, 3, 32, "Output",ExpressionUUID->"00e3d9af-0f65-9246-bdd6-bfff0e627f02"],
Cell[271928, 6550, 160, 3, 32, "Output",ExpressionUUID->"929ddf5b-bb4e-a247-a010-447fe08a02d3"],
Cell[272091, 6555, 160, 3, 32, "Output",ExpressionUUID->"c00c94cb-efca-d241-acd0-0c15e914c169"],
Cell[272254, 6560, 160, 3, 32, "Output",ExpressionUUID->"5f77f6d0-2e48-534c-9e58-85df01ffa72a"]
}, Open  ]],
Cell[CellGroupData[{
Cell[272451, 6568, 451, 9, 48, "Input",ExpressionUUID->"b346d986-b1b3-504d-9c4c-0e57e6738aed"],
Cell[272905, 6579, 183, 3, 32, "Output",ExpressionUUID->"21b84a5a-1139-d340-b9d9-72d4b2596af0"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[273137, 6588, 351, 5, 67, "Section",ExpressionUUID->"6dcb580c-4241-b84d-b8c7-1b8b86092557"],
Cell[273491, 6595, 12916, 172, 619, "Input",ExpressionUUID->"603ec9d6-9cf6-ef42-8b4a-8020b42e14b3"],
Cell[CellGroupData[{
Cell[286432, 6771, 298, 4, 28, "Input",ExpressionUUID->"3417e37b-00f8-fc41-bf86-62b92b7c71d5"],
Cell[286733, 6777, 201, 3, 32, "Output",ExpressionUUID->"b1c4739e-84e0-a34a-b03b-95b55d9dae8b"]
}, Open  ]],
Cell[CellGroupData[{
Cell[286971, 6785, 1872, 49, 200, "Input",ExpressionUUID->"3c20d298-8a28-a849-8b7f-7644ef910380"],
Cell[288846, 6836, 177, 4, 36, "Print",ExpressionUUID->"b9096bd4-59c2-2341-ab9a-8d1f8f33ba9a"]
}, Open  ]],
Cell[CellGroupData[{
Cell[289060, 6845, 778, 19, 86, "Input",ExpressionUUID->"4a7985ff-4420-fe45-a7f1-1482b619be36"],
Cell[289841, 6866, 230, 3, 32, "Output",ExpressionUUID->"9a1303b0-d482-7644-beb0-b2066d445f8f"]
}, Open  ]],
Cell[CellGroupData[{
Cell[290108, 6874, 777, 19, 86, "Input",ExpressionUUID->"bffb6f23-c8c6-7f4a-87be-d0b06ee7a0a7"],
Cell[290888, 6895, 205, 3, 32, "Output",ExpressionUUID->"00e6773e-2a7f-a246-8557-719833bc13f4"]
}, Open  ]],
Cell[291108, 6901, 375, 7, 35, "Text",ExpressionUUID->"35a08403-49fc-a749-8c45-e3baa2c36a0e"],
Cell[CellGroupData[{
Cell[291508, 6912, 566, 11, 67, "Input",ExpressionUUID->"20085780-127d-8a48-b765-47ea2f910ac6"],
Cell[292077, 6925, 228, 3, 32, "Output",ExpressionUUID->"d8977030-2f5a-4840-ab85-88add9d54053"],
Cell[292308, 6930, 230, 3, 32, "Output",ExpressionUUID->"3f20bddc-b775-6740-8a8a-6cb3c3ab381a"],
Cell[292541, 6935, 228, 3, 32, "Output",ExpressionUUID->"05a9416f-ec22-284d-92fd-43a355da02a9"]
}, Open  ]],
Cell[292784, 6941, 816, 15, 104, "Text",ExpressionUUID->"4ba4a0fe-a460-fa41-a44a-5ebe7983eacd"],
Cell[CellGroupData[{
Cell[293625, 6960, 393, 8, 28, "Input",ExpressionUUID->"62af1af7-6500-9e47-9a2a-40426e32e4c2"],
Cell[294021, 6970, 252, 4, 32, "Output",ExpressionUUID->"2e8d59f8-d30b-f64f-866f-e8c1c4c8db5e"]
}, Open  ]],
Cell[294288, 6977, 478, 10, 28, "Input",ExpressionUUID->"5e94a817-53e8-5d45-99db-e34838a30a2f"],
Cell[294769, 6989, 717, 12, 35, "Text",ExpressionUUID->"d09f69c3-1ee9-374f-a855-1ac164c88230"],
Cell[295489, 7003, 17617, 386, 1399, "Input",ExpressionUUID->"fb8ddbc7-fee9-a345-9f4e-4e9b1be59a44"],
Cell[CellGroupData[{
Cell[313131, 7393, 537, 13, 48, "Input",ExpressionUUID->"7cec1fd7-fbc6-654b-93c8-92dc1648af83"],
Cell[313671, 7408, 285, 6, 48, "Output",ExpressionUUID->"dc7dbf21-386f-2444-9425-4d8fce975aca"]
}, Open  ]],
Cell[CellGroupData[{
Cell[313993, 7419, 481, 13, 48, "Input",ExpressionUUID->"ead68483-5920-e344-953b-2bc2329e3bdc"],
Cell[314477, 7434, 6736, 113, 237, "Output",ExpressionUUID->"0eaf96eb-f093-e340-b46d-abf2cb2abd59"],
Cell[321216, 7549, 256, 4, 32, "Output",ExpressionUUID->"134fe57f-4b58-bf40-87cc-77322cd01f61"]
}, Open  ]],
Cell[CellGroupData[{
Cell[321509, 7558, 220, 4, 28, "Input",ExpressionUUID->"101716b0-4ab0-ed45-8aba-3b0ef9ff1b48"],
Cell[321732, 7564, 178, 3, 32, "Output",ExpressionUUID->"dd84b26f-3053-b844-ae5b-f640ff772d40"]
}, Open  ]],
Cell[321925, 7570, 918, 15, 58, "Text",ExpressionUUID->"dcb5b1e4-492a-144b-ab14-dd754a43d20c"],
Cell[CellGroupData[{
Cell[322868, 7589, 451, 12, 28, "Input",ExpressionUUID->"8942df68-2ccf-ea4d-a975-b80ce20957c2"],
Cell[323322, 7603, 248, 6, 32, "Output",ExpressionUUID->"43cee33b-da98-3d4c-adbc-f746b3b98225"]
}, Open  ]],
Cell[CellGroupData[{
Cell[323607, 7614, 414, 9, 28, "Input",ExpressionUUID->"0ba6118b-bc74-0d40-bb40-0f5ab822128c"],
Cell[324024, 7625, 9549, 121, 984, "Output",ExpressionUUID->"9be707fb-903c-1a4a-93e6-0f5fbc10abdb"]
}, Open  ]],
Cell[CellGroupData[{
Cell[333610, 7751, 3457, 89, 390, "Input",ExpressionUUID->"8991869b-66f2-e144-ba44-e040b24d6ac0"],
Cell[337070, 7842, 205, 4, 32, "Output",ExpressionUUID->"1ef0b655-683a-744a-a2a7-8f9e2eabd9aa"],
Cell[337278, 7848, 207, 4, 32, "Output",ExpressionUUID->"cb5a5f4b-5e51-404d-aa48-2dcb21dfd9d3"],
Cell[337488, 7854, 206, 4, 32, "Output",ExpressionUUID->"e58db4d5-e461-6f46-a340-6514c034dcdf"],
Cell[337697, 7860, 208, 4, 32, "Output",ExpressionUUID->"c6f49d1f-15e4-9c4c-8b2e-e0915891afe7"],
Cell[337908, 7866, 206, 4, 32, "Output",ExpressionUUID->"76b77e06-3546-f24a-91a3-c700a63216b9"],
Cell[338117, 7872, 208, 4, 32, "Output",ExpressionUUID->"ec643bb1-4711-3746-bc55-c7f0d6d2c30c"]
}, Open  ]],
Cell[338340, 7879, 296, 7, 28, "Input",ExpressionUUID->"2f320592-c2a1-0049-8e06-e3147142d743"],
Cell[CellGroupData[{
Cell[338661, 7890, 551, 11, 28, "Input",ExpressionUUID->"746e505b-f4bc-674d-ac58-083b1aae4f02"],
Cell[339215, 7903, 240, 4, 79, "Output",ExpressionUUID->"d6645e60-8f2d-f848-91f9-49282c3a75db"]
}, Open  ]]
}, Open  ]]
}
]
*)

